/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.contract.openapi3;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.vertx.ext.web.api.contract.openapi3.impl.OpenAPI3PathResolver;
import io.vertx.ext.web.api.contract.openapi3.impl.OpenApi3Utils;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExternalResource;

public class OpenAPI3PathResolverTest {
    OpenAPI testSpec;
    @Rule
    public ExternalResource res = new ExternalResource(){

        private OpenAPI loadSwagger(String filename) {
            return new OpenAPIV3Parser().readLocation(filename, null, OpenApi3Utils.getParseOptions()).getOpenAPI();
        }

        protected void before() {
            OpenAPI3PathResolverTest.this.testSpec = this.loadSwagger("src/test/resources/swaggers/path_resolver_test.yaml");
        }

        protected void after() {
        }
    };

    private Operation getOperation(String operationId) {
        return this.testSpec.getPaths().values().stream().flatMap(e -> e.readOperations().stream()).filter(e -> e.getOperationId().equals(operationId)).findFirst().orElse(null);
    }

    private String getPath(String operationId) {
        return this.testSpec.getPaths().entrySet().stream().flatMap(e -> ((PathItem)e.getValue()).readOperations().stream().map(e2 -> new AbstractMap.SimpleImmutableEntry(e.getKey(), (Operation)e2))).filter(e -> ((Operation)e.getValue()).getOperationId().equals(operationId)).map(AbstractMap.SimpleImmutableEntry::getKey).findFirst().orElse(null);
    }

    private OpenAPI3PathResolver instantiatePathResolver(String operationId) {
        return new OpenAPI3PathResolver(this.getPath(operationId), this.getOperation(operationId).getParameters());
    }

    private void shouldMatchParameter(OpenAPI3PathResolver resolver, String path, String parameterName, String parameterValue) {
        Optional optional = resolver.solve();
        Assert.assertTrue((boolean)optional.isPresent());
        Pattern p = (Pattern)optional.get();
        Matcher m = p.matcher(path);
        Assert.assertTrue((boolean)m.lookingAt());
        String value = m.group(resolver.getMappedGroups().entrySet().stream().filter(e -> ((String)e.getValue()).equals(parameterName)).map(Map.Entry::getKey).findFirst().get());
        String decoded = this.decode(value);
        Assert.assertEquals((Object)parameterValue, (Object)decoded);
    }

    private String encode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8").replaceAll("\\.", "%2E");
        }
        catch (Exception e) {
            return null;
        }
    }

    private String decode(String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (Exception e) {
            return null;
        }
    }

    @Test
    public void shouldNotGenerateRegex() {
        OpenAPI3PathResolver resolver = this.instantiatePathResolver("listPets");
        Assert.assertFalse((boolean)resolver.solve().isPresent());
    }

    @Test
    public void complexEncodingMultiSimpleLabelMixed() {
        OpenAPI3PathResolver resolver = this.instantiatePathResolver("path_multi_simple_label");
        String path = "/path/multi/" + this.encode("admin@vertx.io") + "." + this.encode("user@vertx.io") + "." + this.encode("committer@vertx.io") + "/test";
        this.shouldMatchParameter(resolver, path, "color_simple", "admin@vertx.io");
        this.shouldMatchParameter(resolver, path, "color_label", "user@vertx.io.committer@vertx.io");
        Optional optional = resolver.solve();
        Pattern p = (Pattern)optional.get();
    }

    @Test
    public void shouldNotHaveEmptyStringQuoting() {
        OpenAPI3PathResolver resolver = this.instantiatePathResolver("path_multi_simple_label");
        Optional optional = resolver.solve();
        Pattern p = (Pattern)optional.get();
        String pattern = p.toString();
        Assert.assertFalse((boolean)pattern.contains("\\Q\\E"));
    }

    @Test
    public void complexMatrixArrayNotExploded() {
        OpenAPI3PathResolver resolver = this.instantiatePathResolver("path_array_matrix");
        String path = "/path/;matrix=" + this.encode("admin@vertx.io") + "," + this.encode("user@vertx.io") + "," + this.encode("committer@vertx.io") + "/test";
        this.shouldMatchParameter(resolver, path, "matrix", "admin@vertx.io,user@vertx.io,committer@vertx.io");
        String withoutDotEncoded = "/path/;matrix=" + this.encode("admin@vertx") + ".io," + this.encode("user@vertx") + ".io," + this.encode("committer@vertx") + ".io/test";
        this.shouldMatchParameter(resolver, withoutDotEncoded, "matrix", "admin@vertx.io,user@vertx.io,committer@vertx.io");
    }

    @Test
    public void dotInASimplePathParam() {
        OpenAPI3PathResolver resolver = this.instantiatePathResolver("path_simple");
        String path = "/path/bla.bla.bla/test";
        this.shouldMatchParameter(resolver, path, "simple", "bla.bla.bla");
    }

    @Test
    public void semicolonInASimplePathParam() {
        OpenAPI3PathResolver resolver = this.instantiatePathResolver("path_simple");
        String path = "/path/bla:bla:bla/test";
        this.shouldMatchParameter(resolver, path, "simple", "bla:bla:bla");
    }

    @Test
    public void matrixWithSemicolon() {
        OpenAPI3PathResolver resolver = this.instantiatePathResolver("path_matrix_id_email");
        String path = "/path/;id=bla:bla;email=" + this.encode("user@vertx.io") + "/test";
        this.shouldMatchParameter(resolver, path, "id", "bla:bla");
        this.shouldMatchParameter(resolver, path, "email", "user@vertx.io");
    }
}

