/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.contract.openapi3;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.ResolverCache;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.api.RequestParameter;
import io.vertx.ext.web.api.RequestParameters;
import io.vertx.ext.web.api.contract.RouterFactoryOptions;
import io.vertx.ext.web.api.contract.openapi3.ApiClient;
import io.vertx.ext.web.api.contract.openapi3.OpenAPI3RouterFactory;
import io.vertx.ext.web.api.contract.openapi3.impl.OpenAPI3RouterFactoryImpl;
import io.vertx.ext.web.api.validation.WebTestValidationBase;
import io.vertx.ext.web.client.HttpResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExternalResource;

public class OpenAPI3ParametersUnitTest
extends WebTestValidationBase {
    OpenAPI spec;
    ApiClient apiClient;
    OpenAPI3RouterFactory routerFactory;
    public static final String SPEC_URL = "./src/test/resources/swaggers/openapi_parameters_compatibility_spec.yaml";
    @Rule
    public ExternalResource resource = new ExternalResource(){

        protected void before() throws Throwable {
            OpenAPI3ParametersUnitTest.this.spec = OpenAPI3ParametersUnitTest.this.loadSwagger(OpenAPI3ParametersUnitTest.SPEC_URL);
        }

        protected void after() {
        }
    };

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.stopServer();
        this.apiClient = new ApiClient(this.webClient);
        this.routerFactory = new OpenAPI3RouterFactoryImpl(this.vertx, this.spec, new ResolverCache(this.spec, null, SPEC_URL));
        this.routerFactory.setOptions(new RouterFactoryOptions().setRequireSecurityHandlers(false).setMountValidationFailureHandler(true).setMountNotImplementedHandler(false));
        this.routerFactory.setValidationFailureHandler(this.generateFailureHandler());
    }

    @Override
    public void tearDown() throws Exception {
        if (this.apiClient != null) {
            try {
                this.apiClient.close();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this.stopServer();
        super.tearDown();
    }

    @Test
    public void testPathMatrixNoexplodeString() throws Exception {
        this.routerFactory.addHandlerByOperationId("path_matrix_noexplode_string", routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            JsonObject res = new JsonObject();
            RequestParameter color_path = params.pathParameter("color");
            this.assertNotNull(color_path);
            this.assertTrue(color_path.isString());
            this.assertEquals(color_path.getString(), "blue");
            res.put("color", color_path.getString());
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json; charset=utf-8").end(res.encode());
        });
        CountDownLatch latch = new CountDownLatch(1);
        String color_path = "blue";
        this.startServer();
        this.apiClient.pathMatrixNoexplodeString(color_path, (Handler<AsyncResult<HttpResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.assertEquals(200L, ((HttpResponse)ar.result()).statusCode());
                this.assertTrue("Expected: " + new JsonObject("{\"color\":\"blue\"}").encode() + " Actual: " + ((HttpResponse)ar.result()).bodyAsJsonObject().encode(), new JsonObject("{\"color\":\"blue\"}").equals((Object)((HttpResponse)ar.result()).bodyAsJsonObject()));
            } else {
                this.assertTrue(ar.cause().getMessage(), false);
            }
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testPathMatrixNoexplodeArray() throws Exception {
        this.routerFactory.addHandlerByOperationId("path_matrix_noexplode_array", routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            JsonObject res = new JsonObject();
            RequestParameter color_path = params.pathParameter("color");
            this.assertNotNull(color_path);
            this.assertTrue(color_path.isArray());
            res.put("color", new JsonArray(color_path.getArray().stream().map(RequestParameter::getString).collect(Collectors.toList())));
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json; charset=utf-8").end(res.encode());
        });
        CountDownLatch latch = new CountDownLatch(1);
        ArrayList<Object> color_path = new ArrayList<Object>();
        color_path.add("blue");
        color_path.add("black");
        color_path.add("brown");
        this.startServer();
        this.apiClient.pathMatrixNoexplodeArray(color_path, (Handler<AsyncResult<HttpResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.assertEquals(200L, ((HttpResponse)ar.result()).statusCode());
                this.assertTrue("Expected: " + new JsonObject("{\"color\":[\"blue\",\"black\",\"brown\"]}").encode() + " Actual: " + ((HttpResponse)ar.result()).bodyAsJsonObject().encode(), new JsonObject("{\"color\":[\"blue\",\"black\",\"brown\"]}").equals((Object)((HttpResponse)ar.result()).bodyAsJsonObject()));
            } else {
                this.assertTrue(ar.cause().getMessage(), false);
            }
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testPathMatrixNoexplodeObject() throws Exception {
        this.routerFactory.addHandlerByOperationId("path_matrix_noexplode_object", routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            JsonObject res = new JsonObject();
            RequestParameter color_path = params.pathParameter("color");
            this.assertNotNull(color_path);
            this.assertTrue(color_path.isObject());
            HashMap<String, String> map = new HashMap<String, String>();
            for (String key : color_path.getObjectKeys()) {
                map.put(key, color_path.getObjectValue(key).getString());
            }
            res.put("color", map);
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json; charset=utf-8").end(res.encode());
        });
        CountDownLatch latch = new CountDownLatch(1);
        HashMap<String, Object> color_path = new HashMap<String, Object>();
        color_path.put("R", "100");
        color_path.put("G", "200");
        color_path.put("B", "150");
        this.startServer();
        this.apiClient.pathMatrixNoexplodeObject(color_path, (Handler<AsyncResult<HttpResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.assertEquals(200L, ((HttpResponse)ar.result()).statusCode());
                this.assertTrue("Expected: " + new JsonObject("{\"color\":{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\"}}").encode() + " Actual: " + ((HttpResponse)ar.result()).bodyAsJsonObject().encode(), new JsonObject("{\"color\":{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\"}}").equals((Object)((HttpResponse)ar.result()).bodyAsJsonObject()));
            } else {
                this.assertTrue(ar.cause().getMessage(), false);
            }
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testPathMatrixExplodeString() throws Exception {
        this.routerFactory.addHandlerByOperationId("path_matrix_explode_string", routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            JsonObject res = new JsonObject();
            RequestParameter color_path = params.pathParameter("color");
            this.assertNotNull(color_path);
            this.assertTrue(color_path.isString());
            this.assertEquals(color_path.getString(), "blue");
            res.put("color", color_path.getString());
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json; charset=utf-8").end(res.encode());
        });
        CountDownLatch latch = new CountDownLatch(1);
        String color_path = "blue";
        this.startServer();
        this.apiClient.pathMatrixExplodeString(color_path, (Handler<AsyncResult<HttpResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.assertEquals(200L, ((HttpResponse)ar.result()).statusCode());
                this.assertTrue("Expected: " + new JsonObject("{\"color\":\"blue\"}").encode() + " Actual: " + ((HttpResponse)ar.result()).bodyAsJsonObject().encode(), new JsonObject("{\"color\":\"blue\"}").equals((Object)((HttpResponse)ar.result()).bodyAsJsonObject()));
            } else {
                this.assertTrue(ar.cause().getMessage(), false);
            }
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testPathMatrixExplodeArray() throws Exception {
        this.routerFactory.addHandlerByOperationId("path_matrix_explode_array", routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            JsonObject res = new JsonObject();
            RequestParameter color_path = params.pathParameter("color");
            this.assertNotNull(color_path);
            this.assertTrue(color_path.isArray());
            res.put("color", new JsonArray(color_path.getArray().stream().map(RequestParameter::getString).collect(Collectors.toList())));
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json; charset=utf-8").end(res.encode());
        });
        CountDownLatch latch = new CountDownLatch(1);
        ArrayList<Object> color_path = new ArrayList<Object>();
        color_path.add("blue");
        color_path.add("black");
        color_path.add("brown");
        this.startServer();
        this.apiClient.pathMatrixExplodeArray(color_path, (Handler<AsyncResult<HttpResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.assertEquals(200L, ((HttpResponse)ar.result()).statusCode());
                this.assertTrue("Expected: " + new JsonObject("{\"color\":[\"blue\",\"black\",\"brown\"]}").encode() + " Actual: " + ((HttpResponse)ar.result()).bodyAsJsonObject().encode(), new JsonObject("{\"color\":[\"blue\",\"black\",\"brown\"]}").equals((Object)((HttpResponse)ar.result()).bodyAsJsonObject()));
            } else {
                this.assertTrue(ar.cause().getMessage(), false);
            }
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testPathMatrixExplodeObject() throws Exception {
        this.routerFactory.addHandlerByOperationId("path_matrix_explode_object", routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            JsonObject res = new JsonObject();
            RequestParameter color_path = params.pathParameter("color");
            this.assertNotNull(color_path);
            this.assertTrue(color_path.isObject());
            HashMap<String, String> map = new HashMap<String, String>();
            for (String key : color_path.getObjectKeys()) {
                map.put(key, color_path.getObjectValue(key).getString());
            }
            res.put("color", map);
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json; charset=utf-8").end(res.encode());
        });
        CountDownLatch latch = new CountDownLatch(1);
        HashMap<String, Object> color_path = new HashMap<String, Object>();
        color_path.put("R", "100");
        color_path.put("G", "200");
        color_path.put("B", "150");
        this.startServer();
        this.apiClient.pathMatrixExplodeObject(color_path, (Handler<AsyncResult<HttpResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.assertEquals(200L, ((HttpResponse)ar.result()).statusCode());
                this.assertTrue("Expected: " + new JsonObject("{\"color\":{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\"}}").encode() + " Actual: " + ((HttpResponse)ar.result()).bodyAsJsonObject().encode(), new JsonObject("{\"color\":{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\"}}").equals((Object)((HttpResponse)ar.result()).bodyAsJsonObject()));
            } else {
                this.assertTrue(ar.cause().getMessage(), false);
            }
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testPathLabelNoexplodeString() throws Exception {
        this.routerFactory.addHandlerByOperationId("path_label_noexplode_string", routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            JsonObject res = new JsonObject();
            RequestParameter color_path = params.pathParameter("color");
            this.assertNotNull(color_path);
            this.assertTrue(color_path.isString());
            this.assertEquals(color_path.getString(), "blue");
            res.put("color", color_path.getString());
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json; charset=utf-8").end(res.encode());
        });
        CountDownLatch latch = new CountDownLatch(1);
        String color_path = "blue";
        this.startServer();
        this.apiClient.pathLabelNoexplodeString(color_path, (Handler<AsyncResult<HttpResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.assertEquals(200L, ((HttpResponse)ar.result()).statusCode());
                this.assertTrue("Expected: " + new JsonObject("{\"color\":\"blue\"}").encode() + " Actual: " + ((HttpResponse)ar.result()).bodyAsJsonObject().encode(), new JsonObject("{\"color\":\"blue\"}").equals((Object)((HttpResponse)ar.result()).bodyAsJsonObject()));
            } else {
                this.assertTrue(ar.cause().getMessage(), false);
            }
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testPathLabelNoexplodeArray() throws Exception {
        this.routerFactory.addHandlerByOperationId("path_label_noexplode_array", routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            JsonObject res = new JsonObject();
            RequestParameter color_path = params.pathParameter("color");
            this.assertNotNull(color_path);
            this.assertTrue(color_path.isArray());
            res.put("color", new JsonArray(color_path.getArray().stream().map(RequestParameter::getString).collect(Collectors.toList())));
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json; charset=utf-8").end(res.encode());
        });
        CountDownLatch latch = new CountDownLatch(1);
        ArrayList<Object> color_path = new ArrayList<Object>();
        color_path.add("blue");
        color_path.add("black");
        color_path.add("brown");
        this.startServer();
        this.apiClient.pathLabelNoexplodeArray(color_path, (Handler<AsyncResult<HttpResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.assertEquals(200L, ((HttpResponse)ar.result()).statusCode());
                this.assertTrue("Expected: " + new JsonObject("{\"color\":[\"blue\",\"black\",\"brown\"]}").encode() + " Actual: " + ((HttpResponse)ar.result()).bodyAsJsonObject().encode(), new JsonObject("{\"color\":[\"blue\",\"black\",\"brown\"]}").equals((Object)((HttpResponse)ar.result()).bodyAsJsonObject()));
            } else {
                this.assertTrue(ar.cause().getMessage(), false);
            }
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testPathLabelNoexplodeObject() throws Exception {
        this.routerFactory.addHandlerByOperationId("path_label_noexplode_object", routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            JsonObject res = new JsonObject();
            RequestParameter color_path = params.pathParameter("color");
            this.assertNotNull(color_path);
            this.assertTrue(color_path.isObject());
            HashMap<String, String> map = new HashMap<String, String>();
            for (String key : color_path.getObjectKeys()) {
                map.put(key, color_path.getObjectValue(key).getString());
            }
            res.put("color", map);
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json; charset=utf-8").end(res.encode());
        });
        CountDownLatch latch = new CountDownLatch(1);
        HashMap<String, Object> color_path = new HashMap<String, Object>();
        color_path.put("R", "100");
        color_path.put("G", "200");
        color_path.put("B", "150");
        this.startServer();
        this.apiClient.pathLabelNoexplodeObject(color_path, (Handler<AsyncResult<HttpResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.assertEquals(200L, ((HttpResponse)ar.result()).statusCode());
                this.assertTrue("Expected: " + new JsonObject("{\"color\":{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\"}}").encode() + " Actual: " + ((HttpResponse)ar.result()).bodyAsJsonObject().encode(), new JsonObject("{\"color\":{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\"}}").equals((Object)((HttpResponse)ar.result()).bodyAsJsonObject()));
            } else {
                this.assertTrue(ar.cause().getMessage(), false);
            }
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testPathLabelExplodeString() throws Exception {
        this.routerFactory.addHandlerByOperationId("path_label_explode_string", routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            JsonObject res = new JsonObject();
            RequestParameter color_path = params.pathParameter("color");
            this.assertNotNull(color_path);
            this.assertTrue(color_path.isString());
            this.assertEquals(color_path.getString(), "blue");
            res.put("color", color_path.getString());
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json; charset=utf-8").end(res.encode());
        });
        CountDownLatch latch = new CountDownLatch(1);
        String color_path = "blue";
        this.startServer();
        this.apiClient.pathLabelExplodeString(color_path, (Handler<AsyncResult<HttpResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.assertEquals(200L, ((HttpResponse)ar.result()).statusCode());
                this.assertTrue("Expected: " + new JsonObject("{\"color\":\"blue\"}").encode() + " Actual: " + ((HttpResponse)ar.result()).bodyAsJsonObject().encode(), new JsonObject("{\"color\":\"blue\"}").equals((Object)((HttpResponse)ar.result()).bodyAsJsonObject()));
            } else {
                this.assertTrue(ar.cause().getMessage(), false);
            }
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testPathLabelExplodeArray() throws Exception {
        this.routerFactory.addHandlerByOperationId("path_label_explode_array", routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            JsonObject res = new JsonObject();
            RequestParameter color_path = params.pathParameter("color");
            this.assertNotNull(color_path);
            this.assertTrue(color_path.isArray());
            res.put("color", new JsonArray(color_path.getArray().stream().map(RequestParameter::getString).collect(Collectors.toList())));
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json; charset=utf-8").end(res.encode());
        });
        CountDownLatch latch = new CountDownLatch(1);
        ArrayList<Object> color_path = new ArrayList<Object>();
        color_path.add("blue");
        color_path.add("black");
        color_path.add("brown");
        this.startServer();
        this.apiClient.pathLabelExplodeArray(color_path, (Handler<AsyncResult<HttpResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.assertEquals(200L, ((HttpResponse)ar.result()).statusCode());
                this.assertTrue("Expected: " + new JsonObject("{\"color\":[\"blue\",\"black\",\"brown\"]}").encode() + " Actual: " + ((HttpResponse)ar.result()).bodyAsJsonObject().encode(), new JsonObject("{\"color\":[\"blue\",\"black\",\"brown\"]}").equals((Object)((HttpResponse)ar.result()).bodyAsJsonObject()));
            } else {
                this.assertTrue(ar.cause().getMessage(), false);
            }
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testPathLabelExplodeObject() throws Exception {
        this.routerFactory.addHandlerByOperationId("path_label_explode_object", routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            JsonObject res = new JsonObject();
            RequestParameter color_path = params.pathParameter("color");
            this.assertNotNull(color_path);
            this.assertTrue(color_path.isObject());
            HashMap<String, String> map = new HashMap<String, String>();
            for (String key : color_path.getObjectKeys()) {
                map.put(key, color_path.getObjectValue(key).getString());
            }
            res.put("color", map);
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json; charset=utf-8").end(res.encode());
        });
        CountDownLatch latch = new CountDownLatch(1);
        HashMap<String, Object> color_path = new HashMap<String, Object>();
        color_path.put("R", "100");
        color_path.put("G", "200");
        color_path.put("B", "150");
        this.startServer();
        this.apiClient.pathLabelExplodeObject(color_path, (Handler<AsyncResult<HttpResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.assertEquals(200L, ((HttpResponse)ar.result()).statusCode());
                this.assertTrue("Expected: " + new JsonObject("{\"color\":{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\"}}").encode() + " Actual: " + ((HttpResponse)ar.result()).bodyAsJsonObject().encode(), new JsonObject("{\"color\":{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\"}}").equals((Object)((HttpResponse)ar.result()).bodyAsJsonObject()));
            } else {
                this.assertTrue(ar.cause().getMessage(), false);
            }
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testPathSimpleNoexplodeString() throws Exception {
        this.routerFactory.addHandlerByOperationId("path_simple_noexplode_string", routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            JsonObject res = new JsonObject();
            RequestParameter color_path = params.pathParameter("color");
            this.assertNotNull(color_path);
            this.assertTrue(color_path.isString());
            this.assertEquals(color_path.getString(), "blue");
            res.put("color", color_path.getString());
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json; charset=utf-8").end(res.encode());
        });
        CountDownLatch latch = new CountDownLatch(1);
        String color_path = "blue";
        this.startServer();
        this.apiClient.pathSimpleNoexplodeString(color_path, (Handler<AsyncResult<HttpResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.assertEquals(200L, ((HttpResponse)ar.result()).statusCode());
                this.assertTrue("Expected: " + new JsonObject("{\"color\":\"blue\"}").encode() + " Actual: " + ((HttpResponse)ar.result()).bodyAsJsonObject().encode(), new JsonObject("{\"color\":\"blue\"}").equals((Object)((HttpResponse)ar.result()).bodyAsJsonObject()));
            } else {
                this.assertTrue(ar.cause().getMessage(), false);
            }
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testPathSimpleNoexplodeArray() throws Exception {
        this.routerFactory.addHandlerByOperationId("path_simple_noexplode_array", routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            JsonObject res = new JsonObject();
            RequestParameter color_path = params.pathParameter("color");
            this.assertNotNull(color_path);
            this.assertTrue(color_path.isArray());
            res.put("color", new JsonArray(color_path.getArray().stream().map(RequestParameter::getString).collect(Collectors.toList())));
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json; charset=utf-8").end(res.encode());
        });
        CountDownLatch latch = new CountDownLatch(1);
        ArrayList<Object> color_path = new ArrayList<Object>();
        color_path.add("blue");
        color_path.add("black");
        color_path.add("brown");
        this.startServer();
        this.apiClient.pathSimpleNoexplodeArray(color_path, (Handler<AsyncResult<HttpResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.assertEquals(200L, ((HttpResponse)ar.result()).statusCode());
                this.assertTrue("Expected: " + new JsonObject("{\"color\":[\"blue\",\"black\",\"brown\"]}").encode() + " Actual: " + ((HttpResponse)ar.result()).bodyAsJsonObject().encode(), new JsonObject("{\"color\":[\"blue\",\"black\",\"brown\"]}").equals((Object)((HttpResponse)ar.result()).bodyAsJsonObject()));
            } else {
                this.assertTrue(ar.cause().getMessage(), false);
            }
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testPathSimpleNoexplodeObject() throws Exception {
        this.routerFactory.addHandlerByOperationId("path_simple_noexplode_object", routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            JsonObject res = new JsonObject();
            RequestParameter color_path = params.pathParameter("color");
            this.assertNotNull(color_path);
            this.assertTrue(color_path.isObject());
            HashMap<String, String> map = new HashMap<String, String>();
            for (String key : color_path.getObjectKeys()) {
                map.put(key, color_path.getObjectValue(key).getString());
            }
            res.put("color", map);
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json; charset=utf-8").end(res.encode());
        });
        CountDownLatch latch = new CountDownLatch(1);
        HashMap<String, Object> color_path = new HashMap<String, Object>();
        color_path.put("R", "100");
        color_path.put("G", "200");
        color_path.put("B", "150");
        this.startServer();
        this.apiClient.pathSimpleNoexplodeObject(color_path, (Handler<AsyncResult<HttpResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.assertEquals(200L, ((HttpResponse)ar.result()).statusCode());
                this.assertTrue("Expected: " + new JsonObject("{\"color\":{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\"}}").encode() + " Actual: " + ((HttpResponse)ar.result()).bodyAsJsonObject().encode(), new JsonObject("{\"color\":{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\"}}").equals((Object)((HttpResponse)ar.result()).bodyAsJsonObject()));
            } else {
                this.assertTrue(ar.cause().getMessage(), false);
            }
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testPathSimpleExplodeString() throws Exception {
        this.routerFactory.addHandlerByOperationId("path_simple_explode_string", routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            JsonObject res = new JsonObject();
            RequestParameter color_path = params.pathParameter("color");
            this.assertNotNull(color_path);
            this.assertTrue(color_path.isString());
            this.assertEquals(color_path.getString(), "blue");
            res.put("color", color_path.getString());
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json; charset=utf-8").end(res.encode());
        });
        CountDownLatch latch = new CountDownLatch(1);
        String color_path = "blue";
        this.startServer();
        this.apiClient.pathSimpleExplodeString(color_path, (Handler<AsyncResult<HttpResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.assertEquals(200L, ((HttpResponse)ar.result()).statusCode());
                this.assertTrue("Expected: " + new JsonObject("{\"color\":\"blue\"}").encode() + " Actual: " + ((HttpResponse)ar.result()).bodyAsJsonObject().encode(), new JsonObject("{\"color\":\"blue\"}").equals((Object)((HttpResponse)ar.result()).bodyAsJsonObject()));
            } else {
                this.assertTrue(ar.cause().getMessage(), false);
            }
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testPathSimpleExplodeArray() throws Exception {
        this.routerFactory.addHandlerByOperationId("path_simple_explode_array", routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            JsonObject res = new JsonObject();
            RequestParameter color_path = params.pathParameter("color");
            this.assertNotNull(color_path);
            this.assertTrue(color_path.isArray());
            res.put("color", new JsonArray(color_path.getArray().stream().map(RequestParameter::getString).collect(Collectors.toList())));
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json; charset=utf-8").end(res.encode());
        });
        CountDownLatch latch = new CountDownLatch(1);
        ArrayList<Object> color_path = new ArrayList<Object>();
        color_path.add("blue");
        color_path.add("black");
        color_path.add("brown");
        this.startServer();
        this.apiClient.pathSimpleExplodeArray(color_path, (Handler<AsyncResult<HttpResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.assertEquals(200L, ((HttpResponse)ar.result()).statusCode());
                this.assertTrue("Expected: " + new JsonObject("{\"color\":[\"blue\",\"black\",\"brown\"]}").encode() + " Actual: " + ((HttpResponse)ar.result()).bodyAsJsonObject().encode(), new JsonObject("{\"color\":[\"blue\",\"black\",\"brown\"]}").equals((Object)((HttpResponse)ar.result()).bodyAsJsonObject()));
            } else {
                this.assertTrue(ar.cause().getMessage(), false);
            }
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testPathSimpleExplodeObject() throws Exception {
        this.routerFactory.addHandlerByOperationId("path_simple_explode_object", routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            JsonObject res = new JsonObject();
            RequestParameter color_path = params.pathParameter("color");
            this.assertNotNull(color_path);
            this.assertTrue(color_path.isObject());
            HashMap<String, String> map = new HashMap<String, String>();
            for (String key : color_path.getObjectKeys()) {
                map.put(key, color_path.getObjectValue(key).getString());
            }
            res.put("color", map);
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json; charset=utf-8").end(res.encode());
        });
        CountDownLatch latch = new CountDownLatch(1);
        HashMap<String, Object> color_path = new HashMap<String, Object>();
        color_path.put("R", "100");
        color_path.put("G", "200");
        color_path.put("B", "150");
        this.startServer();
        this.apiClient.pathSimpleExplodeObject(color_path, (Handler<AsyncResult<HttpResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.assertEquals(200L, ((HttpResponse)ar.result()).statusCode());
                this.assertTrue("Expected: " + new JsonObject("{\"color\":{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\"}}").encode() + " Actual: " + ((HttpResponse)ar.result()).bodyAsJsonObject().encode(), new JsonObject("{\"color\":{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\"}}").equals((Object)((HttpResponse)ar.result()).bodyAsJsonObject()));
            } else {
                this.assertTrue(ar.cause().getMessage(), false);
            }
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testPathMultiSimpleLabel() throws Exception {
        this.routerFactory.addHandlerByOperationId("path_multi_simple_label", routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            JsonObject res = new JsonObject();
            RequestParameter colorSimple_path = params.pathParameter("color_simple");
            this.assertNotNull(colorSimple_path);
            this.assertTrue(colorSimple_path.isString());
            this.assertEquals(colorSimple_path.getString(), "blue");
            res.put("color_simple", colorSimple_path.getString());
            RequestParameter colorLabel_path = params.pathParameter("color_label");
            this.assertNotNull(colorLabel_path);
            this.assertTrue(colorLabel_path.isArray());
            res.put("color_label", new JsonArray(colorLabel_path.getArray().stream().map(RequestParameter::getString).collect(Collectors.toList())));
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json; charset=utf-8").end(res.encode());
        });
        CountDownLatch latch = new CountDownLatch(1);
        String colorSimple_path = "blue";
        ArrayList<Object> colorLabel_path = new ArrayList<Object>();
        colorLabel_path.add("blue");
        colorLabel_path.add("black");
        colorLabel_path.add("brown");
        this.startServer();
        this.apiClient.pathMultiSimpleLabel(colorSimple_path, colorLabel_path, (Handler<AsyncResult<HttpResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.assertEquals(200L, ((HttpResponse)ar.result()).statusCode());
                this.assertTrue("Expected: " + new JsonObject("{\"color_simple\":\"blue\",\"color_label\":[\"blue\",\"black\",\"brown\"]}").encode() + " Actual: " + ((HttpResponse)ar.result()).bodyAsJsonObject().encode(), new JsonObject("{\"color_simple\":\"blue\",\"color_label\":[\"blue\",\"black\",\"brown\"]}").equals((Object)((HttpResponse)ar.result()).bodyAsJsonObject()));
            } else {
                this.assertTrue(ar.cause().getMessage(), false);
            }
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testPathMultiSimpleMatrix() throws Exception {
        this.routerFactory.addHandlerByOperationId("path_multi_simple_matrix", routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            JsonObject res = new JsonObject();
            RequestParameter colorSimple_path = params.pathParameter("color_simple");
            this.assertNotNull(colorSimple_path);
            this.assertTrue(colorSimple_path.isString());
            this.assertEquals(colorSimple_path.getString(), "blue");
            res.put("color_simple", colorSimple_path.getString());
            RequestParameter colorMatrix_path = params.pathParameter("color_matrix");
            this.assertNotNull(colorMatrix_path);
            this.assertTrue(colorMatrix_path.isArray());
            res.put("color_matrix", new JsonArray(colorMatrix_path.getArray().stream().map(RequestParameter::getString).collect(Collectors.toList())));
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json; charset=utf-8").end(res.encode());
        });
        CountDownLatch latch = new CountDownLatch(1);
        String colorSimple_path = "blue";
        ArrayList<Object> colorMatrix_path = new ArrayList<Object>();
        colorMatrix_path.add("blue");
        colorMatrix_path.add("black");
        colorMatrix_path.add("brown");
        this.startServer();
        this.apiClient.pathMultiSimpleMatrix(colorSimple_path, colorMatrix_path, (Handler<AsyncResult<HttpResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.assertEquals(200L, ((HttpResponse)ar.result()).statusCode());
                this.assertTrue("Expected: " + new JsonObject("{\"color_simple\":\"blue\",\"color_matrix\":[\"blue\",\"black\",\"brown\"]}").encode() + " Actual: " + ((HttpResponse)ar.result()).bodyAsJsonObject().encode(), new JsonObject("{\"color_simple\":\"blue\",\"color_matrix\":[\"blue\",\"black\",\"brown\"]}").equals((Object)((HttpResponse)ar.result()).bodyAsJsonObject()));
            } else {
                this.assertTrue(ar.cause().getMessage(), false);
            }
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testPathMultiLabelMatrix() throws Exception {
        this.routerFactory.addHandlerByOperationId("path_multi_label_matrix", routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            JsonObject res = new JsonObject();
            RequestParameter colorLabel_path = params.pathParameter("color_label");
            this.assertNotNull(colorLabel_path);
            this.assertTrue(colorLabel_path.isArray());
            res.put("color_label", new JsonArray(colorLabel_path.getArray().stream().map(RequestParameter::getString).collect(Collectors.toList())));
            RequestParameter colorMatrix_path = params.pathParameter("color_matrix");
            this.assertNotNull(colorMatrix_path);
            this.assertTrue(colorMatrix_path.isObject());
            HashMap<String, String> map = new HashMap<String, String>();
            for (String key : colorMatrix_path.getObjectKeys()) {
                map.put(key, colorMatrix_path.getObjectValue(key).getString());
            }
            res.put("color_matrix", map);
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json; charset=utf-8").end(res.encode());
        });
        CountDownLatch latch = new CountDownLatch(1);
        ArrayList<Object> colorLabel_path = new ArrayList<Object>();
        colorLabel_path.add("blue");
        colorLabel_path.add("black");
        colorLabel_path.add("brown");
        HashMap<String, Object> colorMatrix_path = new HashMap<String, Object>();
        colorMatrix_path.put("R", "100");
        colorMatrix_path.put("G", "200");
        colorMatrix_path.put("B", "150");
        this.startServer();
        this.apiClient.pathMultiLabelMatrix(colorLabel_path, colorMatrix_path, (Handler<AsyncResult<HttpResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.assertEquals(200L, ((HttpResponse)ar.result()).statusCode());
                this.assertTrue("Expected: " + new JsonObject("{\"color_label\":[\"blue\",\"black\",\"brown\"],\"color_matrix\":{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\"}}").encode() + " Actual: " + ((HttpResponse)ar.result()).bodyAsJsonObject().encode(), new JsonObject("{\"color_label\":[\"blue\",\"black\",\"brown\"],\"color_matrix\":{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\"}}").equals((Object)((HttpResponse)ar.result()).bodyAsJsonObject()));
            } else {
                this.assertTrue(ar.cause().getMessage(), false);
            }
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testQueryFormNoexplodeEmpty() throws Exception {
        this.routerFactory.addHandlerByOperationId("query_form_noexplode_empty", routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            JsonObject res = new JsonObject();
            RequestParameter color_query = params.queryParameter("color");
            this.assertNotNull(color_query.getString());
            this.assertTrue(color_query.getString().isEmpty());
            res.putNull("color");
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json; charset=utf-8").end(res.encode());
        });
        CountDownLatch latch = new CountDownLatch(1);
        String color_query = "";
        this.startServer();
        this.apiClient.queryFormNoexplodeEmpty(color_query, (Handler<AsyncResult<HttpResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.assertEquals(200L, ((HttpResponse)ar.result()).statusCode());
                this.assertTrue("Expected: " + new JsonObject("{\"color\":null}").encode() + " Actual: " + ((HttpResponse)ar.result()).bodyAsJsonObject().encode(), new JsonObject("{\"color\":null}").equals((Object)((HttpResponse)ar.result()).bodyAsJsonObject()));
            } else {
                this.assertTrue(ar.cause().getMessage(), false);
            }
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testQueryFormNoexplodeString() throws Exception {
        this.routerFactory.addHandlerByOperationId("query_form_noexplode_string", routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            JsonObject res = new JsonObject();
            RequestParameter color_query = params.queryParameter("color");
            this.assertNotNull(color_query);
            this.assertTrue(color_query.isString());
            this.assertEquals(color_query.getString(), "blue");
            res.put("color", color_query.getString());
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json; charset=utf-8").end(res.encode());
        });
        CountDownLatch latch = new CountDownLatch(1);
        String color_query = "blue";
        this.startServer();
        this.apiClient.queryFormNoexplodeString(color_query, (Handler<AsyncResult<HttpResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.assertEquals(200L, ((HttpResponse)ar.result()).statusCode());
                this.assertTrue("Expected: " + new JsonObject("{\"color\":\"blue\"}").encode() + " Actual: " + ((HttpResponse)ar.result()).bodyAsJsonObject().encode(), new JsonObject("{\"color\":\"blue\"}").equals((Object)((HttpResponse)ar.result()).bodyAsJsonObject()));
            } else {
                this.assertTrue(ar.cause().getMessage(), false);
            }
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testQueryFormNoexplodeArray() throws Exception {
        this.routerFactory.addHandlerByOperationId("query_form_noexplode_array", routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            JsonObject res = new JsonObject();
            RequestParameter color_query = params.queryParameter("color");
            this.assertNotNull(color_query);
            this.assertTrue(color_query.isArray());
            res.put("color", new JsonArray(color_query.getArray().stream().map(RequestParameter::getString).collect(Collectors.toList())));
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json; charset=utf-8").end(res.encode());
        });
        CountDownLatch latch = new CountDownLatch(1);
        ArrayList<Object> color_query = new ArrayList<Object>();
        color_query.add("blue");
        color_query.add("black");
        color_query.add("brown");
        this.startServer();
        this.apiClient.queryFormNoexplodeArray(color_query, (Handler<AsyncResult<HttpResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.assertEquals(200L, ((HttpResponse)ar.result()).statusCode());
                this.assertTrue("Expected: " + new JsonObject("{\"color\":[\"blue\",\"black\",\"brown\"]}").encode() + " Actual: " + ((HttpResponse)ar.result()).bodyAsJsonObject().encode(), new JsonObject("{\"color\":[\"blue\",\"black\",\"brown\"]}").equals((Object)((HttpResponse)ar.result()).bodyAsJsonObject()));
            } else {
                this.assertTrue(ar.cause().getMessage(), false);
            }
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testQueryFormNoexplodeObject() throws Exception {
        this.routerFactory.addHandlerByOperationId("query_form_noexplode_object", routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            JsonObject res = new JsonObject();
            RequestParameter color_query = params.queryParameter("color");
            this.assertNotNull(color_query);
            this.assertTrue(color_query.isObject());
            HashMap<String, String> map = new HashMap<String, String>();
            for (String key : color_query.getObjectKeys()) {
                map.put(key, color_query.getObjectValue(key).getString());
            }
            res.put("color", map);
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json; charset=utf-8").end(res.encode());
        });
        CountDownLatch latch = new CountDownLatch(1);
        HashMap<String, Object> color_query = new HashMap<String, Object>();
        color_query.put("R", "100");
        color_query.put("G", "200");
        color_query.put("B", "150");
        this.startServer();
        this.apiClient.queryFormNoexplodeObject(color_query, (Handler<AsyncResult<HttpResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.assertEquals(200L, ((HttpResponse)ar.result()).statusCode());
                this.assertTrue("Expected: " + new JsonObject("{\"color\":{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\"}}").encode() + " Actual: " + ((HttpResponse)ar.result()).bodyAsJsonObject().encode(), new JsonObject("{\"color\":{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\"}}").equals((Object)((HttpResponse)ar.result()).bodyAsJsonObject()));
            } else {
                this.assertTrue(ar.cause().getMessage(), false);
            }
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testQueryFormExplodeEmpty() throws Exception {
        this.routerFactory.addHandlerByOperationId("query_form_explode_empty", routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            JsonObject res = new JsonObject();
            RequestParameter color_query = params.queryParameter("color");
            this.assertNotNull(color_query.getString());
            this.assertTrue(color_query.getString().isEmpty());
            res.putNull("color");
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json; charset=utf-8").end(res.encode());
        });
        CountDownLatch latch = new CountDownLatch(1);
        String color_query = "";
        this.startServer();
        this.apiClient.queryFormExplodeEmpty(color_query, (Handler<AsyncResult<HttpResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.assertEquals(200L, ((HttpResponse)ar.result()).statusCode());
                this.assertTrue("Expected: " + new JsonObject("{\"color\":null}").encode() + " Actual: " + ((HttpResponse)ar.result()).bodyAsJsonObject().encode(), new JsonObject("{\"color\":null}").equals((Object)((HttpResponse)ar.result()).bodyAsJsonObject()));
            } else {
                this.assertTrue(ar.cause().getMessage(), false);
            }
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testQueryFormExplodeString() throws Exception {
        this.routerFactory.addHandlerByOperationId("query_form_explode_string", routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            JsonObject res = new JsonObject();
            RequestParameter color_query = params.queryParameter("color");
            this.assertNotNull(color_query);
            this.assertTrue(color_query.isString());
            this.assertEquals(color_query.getString(), "blue");
            res.put("color", color_query.getString());
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json; charset=utf-8").end(res.encode());
        });
        CountDownLatch latch = new CountDownLatch(1);
        String color_query = "blue";
        this.startServer();
        this.apiClient.queryFormExplodeString(color_query, (Handler<AsyncResult<HttpResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.assertEquals(200L, ((HttpResponse)ar.result()).statusCode());
                this.assertTrue("Expected: " + new JsonObject("{\"color\":\"blue\"}").encode() + " Actual: " + ((HttpResponse)ar.result()).bodyAsJsonObject().encode(), new JsonObject("{\"color\":\"blue\"}").equals((Object)((HttpResponse)ar.result()).bodyAsJsonObject()));
            } else {
                this.assertTrue(ar.cause().getMessage(), false);
            }
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testQueryFormExplodeArray() throws Exception {
        this.routerFactory.addHandlerByOperationId("query_form_explode_array", routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            JsonObject res = new JsonObject();
            RequestParameter color_query = params.queryParameter("color");
            this.assertNotNull(color_query);
            this.assertTrue(color_query.isArray());
            res.put("color", new JsonArray(color_query.getArray().stream().map(RequestParameter::getString).collect(Collectors.toList())));
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json; charset=utf-8").end(res.encode());
        });
        CountDownLatch latch = new CountDownLatch(1);
        ArrayList<Object> color_query = new ArrayList<Object>();
        color_query.add("blue");
        color_query.add("black");
        color_query.add("brown");
        this.startServer();
        this.apiClient.queryFormExplodeArray(color_query, (Handler<AsyncResult<HttpResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.assertEquals(200L, ((HttpResponse)ar.result()).statusCode());
                this.assertTrue("Expected: " + new JsonObject("{\"color\":[\"blue\",\"black\",\"brown\"]}").encode() + " Actual: " + ((HttpResponse)ar.result()).bodyAsJsonObject().encode(), new JsonObject("{\"color\":[\"blue\",\"black\",\"brown\"]}").equals((Object)((HttpResponse)ar.result()).bodyAsJsonObject()));
            } else {
                this.assertTrue(ar.cause().getMessage(), false);
            }
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testQueryFormExplodeObject() throws Exception {
        this.routerFactory.addHandlerByOperationId("query_form_explode_object", routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            JsonObject res = new JsonObject();
            RequestParameter color_query = params.queryParameter("color");
            this.assertNotNull(color_query);
            this.assertTrue(color_query.isObject());
            HashMap<String, String> map = new HashMap<String, String>();
            for (String key : color_query.getObjectKeys()) {
                map.put(key, color_query.getObjectValue(key).getString());
            }
            res.put("color", map);
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json; charset=utf-8").end(res.encode());
        });
        CountDownLatch latch = new CountDownLatch(1);
        HashMap<String, Object> color_query = new HashMap<String, Object>();
        color_query.put("R", "100");
        color_query.put("G", "200");
        color_query.put("B", "150");
        this.startServer();
        this.apiClient.queryFormExplodeObject(color_query, (Handler<AsyncResult<HttpResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.assertEquals(200L, ((HttpResponse)ar.result()).statusCode());
                this.assertTrue("Expected: " + new JsonObject("{\"color\":{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\"}}").encode() + " Actual: " + ((HttpResponse)ar.result()).bodyAsJsonObject().encode(), new JsonObject("{\"color\":{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\"}}").equals((Object)((HttpResponse)ar.result()).bodyAsJsonObject()));
            } else {
                this.assertTrue(ar.cause().getMessage(), false);
            }
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testQuerySpaceDelimitedNoexplodeArray() throws Exception {
        this.routerFactory.addHandlerByOperationId("query_spaceDelimited_noexplode_array", routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            JsonObject res = new JsonObject();
            RequestParameter color_query = params.queryParameter("color");
            this.assertNotNull(color_query);
            this.assertTrue(color_query.isArray());
            res.put("color", new JsonArray(color_query.getArray().stream().map(RequestParameter::getString).collect(Collectors.toList())));
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json; charset=utf-8").end(res.encode());
        });
        CountDownLatch latch = new CountDownLatch(1);
        ArrayList<Object> color_query = new ArrayList<Object>();
        color_query.add("blue");
        color_query.add("black");
        color_query.add("brown");
        this.startServer();
        this.apiClient.querySpaceDelimitedNoexplodeArray(color_query, (Handler<AsyncResult<HttpResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.assertEquals(200L, ((HttpResponse)ar.result()).statusCode());
                this.assertTrue("Expected: " + new JsonObject("{\"color\":[\"blue\",\"black\",\"brown\"]}").encode() + " Actual: " + ((HttpResponse)ar.result()).bodyAsJsonObject().encode(), new JsonObject("{\"color\":[\"blue\",\"black\",\"brown\"]}").equals((Object)((HttpResponse)ar.result()).bodyAsJsonObject()));
            } else {
                this.assertTrue(ar.cause().getMessage(), false);
            }
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testQuerySpaceDelimitedNoexplodeObject() throws Exception {
        this.routerFactory.addHandlerByOperationId("query_spaceDelimited_noexplode_object", routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            JsonObject res = new JsonObject();
            RequestParameter color_query = params.queryParameter("color");
            this.assertNotNull(color_query);
            this.assertTrue(color_query.isObject());
            HashMap<String, String> map = new HashMap<String, String>();
            for (String key : color_query.getObjectKeys()) {
                map.put(key, color_query.getObjectValue(key).getString());
            }
            res.put("color", map);
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json; charset=utf-8").end(res.encode());
        });
        CountDownLatch latch = new CountDownLatch(1);
        HashMap<String, Object> color_query = new HashMap<String, Object>();
        color_query.put("R", "100");
        color_query.put("G", "200");
        color_query.put("B", "150");
        this.startServer();
        this.apiClient.querySpaceDelimitedNoexplodeObject(color_query, (Handler<AsyncResult<HttpResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.assertEquals(200L, ((HttpResponse)ar.result()).statusCode());
                this.assertTrue("Expected: " + new JsonObject("{\"color\":{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\"}}").encode() + " Actual: " + ((HttpResponse)ar.result()).bodyAsJsonObject().encode(), new JsonObject("{\"color\":{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\"}}").equals((Object)((HttpResponse)ar.result()).bodyAsJsonObject()));
            } else {
                this.assertTrue(ar.cause().getMessage(), false);
            }
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testQueryPipeDelimitedNoexplodeArray() throws Exception {
        this.routerFactory.addHandlerByOperationId("query_pipeDelimited_noexplode_array", routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            JsonObject res = new JsonObject();
            RequestParameter color_query = params.queryParameter("color");
            this.assertNotNull(color_query);
            this.assertTrue(color_query.isArray());
            res.put("color", new JsonArray(color_query.getArray().stream().map(RequestParameter::getString).collect(Collectors.toList())));
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json; charset=utf-8").end(res.encode());
        });
        CountDownLatch latch = new CountDownLatch(1);
        ArrayList<Object> color_query = new ArrayList<Object>();
        color_query.add("blue");
        color_query.add("black");
        color_query.add("brown");
        this.startServer();
        this.apiClient.queryPipeDelimitedNoexplodeArray(color_query, (Handler<AsyncResult<HttpResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.assertEquals(200L, ((HttpResponse)ar.result()).statusCode());
                this.assertTrue("Expected: " + new JsonObject("{\"color\":[\"blue\",\"black\",\"brown\"]}").encode() + " Actual: " + ((HttpResponse)ar.result()).bodyAsJsonObject().encode(), new JsonObject("{\"color\":[\"blue\",\"black\",\"brown\"]}").equals((Object)((HttpResponse)ar.result()).bodyAsJsonObject()));
            } else {
                this.assertTrue(ar.cause().getMessage(), false);
            }
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testQueryPipeDelimitedNoexplodeObject() throws Exception {
        this.routerFactory.addHandlerByOperationId("query_pipeDelimited_noexplode_object", routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            JsonObject res = new JsonObject();
            RequestParameter color_query = params.queryParameter("color");
            this.assertNotNull(color_query);
            this.assertTrue(color_query.isObject());
            HashMap<String, String> map = new HashMap<String, String>();
            for (String key : color_query.getObjectKeys()) {
                map.put(key, color_query.getObjectValue(key).getString());
            }
            res.put("color", map);
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json; charset=utf-8").end(res.encode());
        });
        CountDownLatch latch = new CountDownLatch(1);
        HashMap<String, Object> color_query = new HashMap<String, Object>();
        color_query.put("R", "100");
        color_query.put("G", "200");
        color_query.put("B", "150");
        this.startServer();
        this.apiClient.queryPipeDelimitedNoexplodeObject(color_query, (Handler<AsyncResult<HttpResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.assertEquals(200L, ((HttpResponse)ar.result()).statusCode());
                this.assertTrue("Expected: " + new JsonObject("{\"color\":{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\"}}").encode() + " Actual: " + ((HttpResponse)ar.result()).bodyAsJsonObject().encode(), new JsonObject("{\"color\":{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\"}}").equals((Object)((HttpResponse)ar.result()).bodyAsJsonObject()));
            } else {
                this.assertTrue(ar.cause().getMessage(), false);
            }
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testQueryDeepObjectExplodeObject() throws Exception {
        this.routerFactory.addHandlerByOperationId("query_deepObject_explode_object", routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            JsonObject res = new JsonObject();
            RequestParameter color_query = params.queryParameter("color");
            this.assertNotNull(color_query);
            this.assertTrue(color_query.isObject());
            HashMap<String, String> map = new HashMap<String, String>();
            for (String key : color_query.getObjectKeys()) {
                map.put(key, color_query.getObjectValue(key).getString());
            }
            res.put("color", map);
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json; charset=utf-8").end(res.encode());
        });
        CountDownLatch latch = new CountDownLatch(1);
        HashMap<String, Object> color_query = new HashMap<String, Object>();
        color_query.put("R", "100");
        color_query.put("G", "200");
        color_query.put("B", "150");
        this.startServer();
        this.apiClient.queryDeepObjectExplodeObject(color_query, (Handler<AsyncResult<HttpResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.assertEquals(200L, ((HttpResponse)ar.result()).statusCode());
                this.assertTrue("Expected: " + new JsonObject("{\"color\":{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\"}}").encode() + " Actual: " + ((HttpResponse)ar.result()).bodyAsJsonObject().encode(), new JsonObject("{\"color\":{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\"}}").equals((Object)((HttpResponse)ar.result()).bodyAsJsonObject()));
            } else {
                this.assertTrue(ar.cause().getMessage(), false);
            }
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testCookieFormNoexplodeEmpty() throws Exception {
        this.routerFactory.addHandlerByOperationId("cookie_form_noexplode_empty", routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            JsonObject res = new JsonObject();
            RequestParameter color_cookie = params.cookieParameter("color");
            this.assertNotNull(color_cookie.getString());
            this.assertTrue(color_cookie.getString().isEmpty());
            res.putNull("color");
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json; charset=utf-8").end(res.encode());
        });
        CountDownLatch latch = new CountDownLatch(1);
        String color_cookie = "";
        this.startServer();
        this.apiClient.cookieFormNoexplodeEmpty(color_cookie, (Handler<AsyncResult<HttpResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.assertEquals(200L, ((HttpResponse)ar.result()).statusCode());
                this.assertTrue("Expected: " + new JsonObject("{\"color\":null}").encode() + " Actual: " + ((HttpResponse)ar.result()).bodyAsJsonObject().encode(), new JsonObject("{\"color\":null}").equals((Object)((HttpResponse)ar.result()).bodyAsJsonObject()));
            } else {
                this.assertTrue(ar.cause().getMessage(), false);
            }
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testCookieFormNoexplodeString() throws Exception {
        this.routerFactory.addHandlerByOperationId("cookie_form_noexplode_string", routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            JsonObject res = new JsonObject();
            RequestParameter color_cookie = params.cookieParameter("color");
            this.assertNotNull(color_cookie);
            this.assertTrue(color_cookie.isString());
            this.assertEquals(color_cookie.getString(), "blue");
            res.put("color", color_cookie.getString());
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json; charset=utf-8").end(res.encode());
        });
        CountDownLatch latch = new CountDownLatch(1);
        String color_cookie = "blue";
        this.startServer();
        this.apiClient.cookieFormNoexplodeString(color_cookie, (Handler<AsyncResult<HttpResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.assertEquals(200L, ((HttpResponse)ar.result()).statusCode());
                this.assertTrue("Expected: " + new JsonObject("{\"color\":\"blue\"}").encode() + " Actual: " + ((HttpResponse)ar.result()).bodyAsJsonObject().encode(), new JsonObject("{\"color\":\"blue\"}").equals((Object)((HttpResponse)ar.result()).bodyAsJsonObject()));
            } else {
                this.assertTrue(ar.cause().getMessage(), false);
            }
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testCookieFormNoexplodeArray() throws Exception {
        this.routerFactory.addHandlerByOperationId("cookie_form_noexplode_array", routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            JsonObject res = new JsonObject();
            RequestParameter color_cookie = params.cookieParameter("color");
            this.assertNotNull(color_cookie);
            this.assertTrue(color_cookie.isArray());
            res.put("color", new JsonArray(color_cookie.getArray().stream().map(RequestParameter::getString).collect(Collectors.toList())));
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json; charset=utf-8").end(res.encode());
        });
        CountDownLatch latch = new CountDownLatch(1);
        ArrayList<Object> color_cookie = new ArrayList<Object>();
        color_cookie.add("blue");
        color_cookie.add("black");
        color_cookie.add("brown");
        this.startServer();
        this.apiClient.cookieFormNoexplodeArray(color_cookie, (Handler<AsyncResult<HttpResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.assertEquals(200L, ((HttpResponse)ar.result()).statusCode());
                this.assertTrue("Expected: " + new JsonObject("{\"color\":[\"blue\",\"black\",\"brown\"]}").encode() + " Actual: " + ((HttpResponse)ar.result()).bodyAsJsonObject().encode(), new JsonObject("{\"color\":[\"blue\",\"black\",\"brown\"]}").equals((Object)((HttpResponse)ar.result()).bodyAsJsonObject()));
            } else {
                this.assertTrue(ar.cause().getMessage(), false);
            }
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testCookieFormNoexplodeObject() throws Exception {
        this.routerFactory.addHandlerByOperationId("cookie_form_noexplode_object", routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            JsonObject res = new JsonObject();
            RequestParameter color_cookie = params.cookieParameter("color");
            this.assertNotNull(color_cookie);
            this.assertTrue(color_cookie.isObject());
            HashMap<String, String> map = new HashMap<String, String>();
            for (String key : color_cookie.getObjectKeys()) {
                map.put(key, color_cookie.getObjectValue(key).getString());
            }
            res.put("color", map);
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json; charset=utf-8").end(res.encode());
        });
        CountDownLatch latch = new CountDownLatch(1);
        HashMap<String, Object> color_cookie = new HashMap<String, Object>();
        color_cookie.put("R", "100");
        color_cookie.put("G", "200");
        color_cookie.put("B", "150");
        this.startServer();
        this.apiClient.cookieFormNoexplodeObject(color_cookie, (Handler<AsyncResult<HttpResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.assertEquals(200L, ((HttpResponse)ar.result()).statusCode());
                this.assertTrue("Expected: " + new JsonObject("{\"color\":{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\"}}").encode() + " Actual: " + ((HttpResponse)ar.result()).bodyAsJsonObject().encode(), new JsonObject("{\"color\":{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\"}}").equals((Object)((HttpResponse)ar.result()).bodyAsJsonObject()));
            } else {
                this.assertTrue(ar.cause().getMessage(), false);
            }
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testCookieFormExplodeEmpty() throws Exception {
        this.routerFactory.addHandlerByOperationId("cookie_form_explode_empty", routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            JsonObject res = new JsonObject();
            RequestParameter color_cookie = params.cookieParameter("color");
            this.assertNotNull(color_cookie.getString());
            this.assertTrue(color_cookie.getString().isEmpty());
            res.putNull("color");
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json; charset=utf-8").end(res.encode());
        });
        CountDownLatch latch = new CountDownLatch(1);
        String color_cookie = "";
        this.startServer();
        this.apiClient.cookieFormExplodeEmpty(color_cookie, (Handler<AsyncResult<HttpResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.assertEquals(200L, ((HttpResponse)ar.result()).statusCode());
                this.assertTrue("Expected: " + new JsonObject("{\"color\":null}").encode() + " Actual: " + ((HttpResponse)ar.result()).bodyAsJsonObject().encode(), new JsonObject("{\"color\":null}").equals((Object)((HttpResponse)ar.result()).bodyAsJsonObject()));
            } else {
                this.assertTrue(ar.cause().getMessage(), false);
            }
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testCookieFormExplodeString() throws Exception {
        this.routerFactory.addHandlerByOperationId("cookie_form_explode_string", routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            JsonObject res = new JsonObject();
            RequestParameter color_cookie = params.cookieParameter("color");
            this.assertNotNull(color_cookie);
            this.assertTrue(color_cookie.isString());
            this.assertEquals(color_cookie.getString(), "blue");
            res.put("color", color_cookie.getString());
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json; charset=utf-8").end(res.encode());
        });
        CountDownLatch latch = new CountDownLatch(1);
        String color_cookie = "blue";
        this.startServer();
        this.apiClient.cookieFormExplodeString(color_cookie, (Handler<AsyncResult<HttpResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.assertEquals(200L, ((HttpResponse)ar.result()).statusCode());
                this.assertTrue("Expected: " + new JsonObject("{\"color\":\"blue\"}").encode() + " Actual: " + ((HttpResponse)ar.result()).bodyAsJsonObject().encode(), new JsonObject("{\"color\":\"blue\"}").equals((Object)((HttpResponse)ar.result()).bodyAsJsonObject()));
            } else {
                this.assertTrue(ar.cause().getMessage(), false);
            }
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testCookieFormExplodeArray() throws Exception {
        this.routerFactory.addHandlerByOperationId("cookie_form_explode_array", routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            JsonObject res = new JsonObject();
            RequestParameter color_cookie = params.cookieParameter("color");
            this.assertNotNull(color_cookie);
            this.assertTrue(color_cookie.isArray());
            res.put("color", new JsonArray(color_cookie.getArray().stream().map(RequestParameter::getString).collect(Collectors.toList())));
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json; charset=utf-8").end(res.encode());
        });
        CountDownLatch latch = new CountDownLatch(1);
        ArrayList<Object> color_cookie = new ArrayList<Object>();
        color_cookie.add("blue");
        color_cookie.add("black");
        color_cookie.add("brown");
        this.startServer();
        this.apiClient.cookieFormExplodeArray(color_cookie, (Handler<AsyncResult<HttpResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.assertEquals(200L, ((HttpResponse)ar.result()).statusCode());
                this.assertTrue("Expected: " + new JsonObject("{\"color\":[\"blue\",\"black\",\"brown\"]}").encode() + " Actual: " + ((HttpResponse)ar.result()).bodyAsJsonObject().encode(), new JsonObject("{\"color\":[\"blue\",\"black\",\"brown\"]}").equals((Object)((HttpResponse)ar.result()).bodyAsJsonObject()));
            } else {
                this.assertTrue(ar.cause().getMessage(), false);
            }
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testCookieFormExplodeObject() throws Exception {
        this.routerFactory.addHandlerByOperationId("cookie_form_explode_object", routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            JsonObject res = new JsonObject();
            RequestParameter color_cookie = params.cookieParameter("color");
            this.assertNotNull(color_cookie);
            this.assertTrue(color_cookie.isObject());
            HashMap<String, String> map = new HashMap<String, String>();
            for (String key : color_cookie.getObjectKeys()) {
                map.put(key, color_cookie.getObjectValue(key).getString());
            }
            res.put("color", map);
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json; charset=utf-8").end(res.encode());
        });
        CountDownLatch latch = new CountDownLatch(1);
        HashMap<String, Object> color_cookie = new HashMap<String, Object>();
        color_cookie.put("R", "100");
        color_cookie.put("G", "200");
        color_cookie.put("B", "150");
        this.startServer();
        this.apiClient.cookieFormExplodeObject(color_cookie, (Handler<AsyncResult<HttpResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.assertEquals(200L, ((HttpResponse)ar.result()).statusCode());
                this.assertTrue("Expected: " + new JsonObject("{\"color\":{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\"}}").encode() + " Actual: " + ((HttpResponse)ar.result()).bodyAsJsonObject().encode(), new JsonObject("{\"color\":{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\"}}").equals((Object)((HttpResponse)ar.result()).bodyAsJsonObject()));
            } else {
                this.assertTrue(ar.cause().getMessage(), false);
            }
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testHeaderSimpleNoexplodeString() throws Exception {
        this.routerFactory.addHandlerByOperationId("header_simple_noexplode_string", routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            JsonObject res = new JsonObject();
            RequestParameter color_header = params.headerParameter("color");
            this.assertNotNull(color_header);
            this.assertTrue(color_header.isString());
            this.assertEquals(color_header.getString(), "blue");
            res.put("color", color_header.getString());
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json; charset=utf-8").end(res.encode());
        });
        CountDownLatch latch = new CountDownLatch(1);
        String color_header = "blue";
        this.startServer();
        this.apiClient.headerSimpleNoexplodeString(color_header, (Handler<AsyncResult<HttpResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.assertEquals(200L, ((HttpResponse)ar.result()).statusCode());
                this.assertTrue("Expected: " + new JsonObject("{\"color\":\"blue\"}").encode() + " Actual: " + ((HttpResponse)ar.result()).bodyAsJsonObject().encode(), new JsonObject("{\"color\":\"blue\"}").equals((Object)((HttpResponse)ar.result()).bodyAsJsonObject()));
            } else {
                this.assertTrue(ar.cause().getMessage(), false);
            }
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testHeaderSimpleNoexplodeArray() throws Exception {
        this.routerFactory.addHandlerByOperationId("header_simple_noexplode_array", routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            JsonObject res = new JsonObject();
            RequestParameter color_header = params.headerParameter("color");
            this.assertNotNull(color_header);
            this.assertTrue(color_header.isArray());
            res.put("color", new JsonArray(color_header.getArray().stream().map(RequestParameter::getString).collect(Collectors.toList())));
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json; charset=utf-8").end(res.encode());
        });
        CountDownLatch latch = new CountDownLatch(1);
        ArrayList<Object> color_header = new ArrayList<Object>();
        color_header.add("blue");
        color_header.add("black");
        color_header.add("brown");
        this.startServer();
        this.apiClient.headerSimpleNoexplodeArray(color_header, (Handler<AsyncResult<HttpResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.assertEquals(200L, ((HttpResponse)ar.result()).statusCode());
                this.assertTrue("Expected: " + new JsonObject("{\"color\":[\"blue\",\"black\",\"brown\"]}").encode() + " Actual: " + ((HttpResponse)ar.result()).bodyAsJsonObject().encode(), new JsonObject("{\"color\":[\"blue\",\"black\",\"brown\"]}").equals((Object)((HttpResponse)ar.result()).bodyAsJsonObject()));
            } else {
                this.assertTrue(ar.cause().getMessage(), false);
            }
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testHeaderSimpleNoexplodeObject() throws Exception {
        this.routerFactory.addHandlerByOperationId("header_simple_noexplode_object", routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            JsonObject res = new JsonObject();
            RequestParameter color_header = params.headerParameter("color");
            this.assertNotNull(color_header);
            this.assertTrue(color_header.isObject());
            HashMap<String, String> map = new HashMap<String, String>();
            for (String key : color_header.getObjectKeys()) {
                map.put(key, color_header.getObjectValue(key).getString());
            }
            res.put("color", map);
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json; charset=utf-8").end(res.encode());
        });
        CountDownLatch latch = new CountDownLatch(1);
        HashMap<String, Object> color_header = new HashMap<String, Object>();
        color_header.put("R", "100");
        color_header.put("G", "200");
        color_header.put("B", "150");
        this.startServer();
        this.apiClient.headerSimpleNoexplodeObject(color_header, (Handler<AsyncResult<HttpResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.assertEquals(200L, ((HttpResponse)ar.result()).statusCode());
                this.assertTrue("Expected: " + new JsonObject("{\"color\":{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\"}}").encode() + " Actual: " + ((HttpResponse)ar.result()).bodyAsJsonObject().encode(), new JsonObject("{\"color\":{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\"}}").equals((Object)((HttpResponse)ar.result()).bodyAsJsonObject()));
            } else {
                this.assertTrue(ar.cause().getMessage(), false);
            }
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testHeaderSimpleExplodeString() throws Exception {
        this.routerFactory.addHandlerByOperationId("header_simple_explode_string", routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            JsonObject res = new JsonObject();
            RequestParameter color_header = params.headerParameter("color");
            this.assertNotNull(color_header);
            this.assertTrue(color_header.isString());
            this.assertEquals(color_header.getString(), "blue");
            res.put("color", color_header.getString());
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json; charset=utf-8").end(res.encode());
        });
        CountDownLatch latch = new CountDownLatch(1);
        String color_header = "blue";
        this.startServer();
        this.apiClient.headerSimpleExplodeString(color_header, (Handler<AsyncResult<HttpResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.assertEquals(200L, ((HttpResponse)ar.result()).statusCode());
                this.assertTrue("Expected: " + new JsonObject("{\"color\":\"blue\"}").encode() + " Actual: " + ((HttpResponse)ar.result()).bodyAsJsonObject().encode(), new JsonObject("{\"color\":\"blue\"}").equals((Object)((HttpResponse)ar.result()).bodyAsJsonObject()));
            } else {
                this.assertTrue(ar.cause().getMessage(), false);
            }
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testHeaderSimpleExplodeArray() throws Exception {
        this.routerFactory.addHandlerByOperationId("header_simple_explode_array", routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            JsonObject res = new JsonObject();
            RequestParameter color_header = params.headerParameter("color");
            this.assertNotNull(color_header);
            this.assertTrue(color_header.isArray());
            res.put("color", new JsonArray(color_header.getArray().stream().map(RequestParameter::getString).collect(Collectors.toList())));
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json; charset=utf-8").end(res.encode());
        });
        CountDownLatch latch = new CountDownLatch(1);
        ArrayList<Object> color_header = new ArrayList<Object>();
        color_header.add("blue");
        color_header.add("black");
        color_header.add("brown");
        this.startServer();
        this.apiClient.headerSimpleExplodeArray(color_header, (Handler<AsyncResult<HttpResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.assertEquals(200L, ((HttpResponse)ar.result()).statusCode());
                this.assertTrue("Expected: " + new JsonObject("{\"color\":[\"blue\",\"black\",\"brown\"]}").encode() + " Actual: " + ((HttpResponse)ar.result()).bodyAsJsonObject().encode(), new JsonObject("{\"color\":[\"blue\",\"black\",\"brown\"]}").equals((Object)((HttpResponse)ar.result()).bodyAsJsonObject()));
            } else {
                this.assertTrue(ar.cause().getMessage(), false);
            }
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testHeaderSimpleExplodeObject() throws Exception {
        this.routerFactory.addHandlerByOperationId("header_simple_explode_object", routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            JsonObject res = new JsonObject();
            RequestParameter color_header = params.headerParameter("color");
            this.assertNotNull(color_header);
            this.assertTrue(color_header.isObject());
            HashMap<String, String> map = new HashMap<String, String>();
            for (String key : color_header.getObjectKeys()) {
                map.put(key, color_header.getObjectValue(key).getString());
            }
            res.put("color", map);
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json; charset=utf-8").end(res.encode());
        });
        CountDownLatch latch = new CountDownLatch(1);
        HashMap<String, Object> color_header = new HashMap<String, Object>();
        color_header.put("R", "100");
        color_header.put("G", "200");
        color_header.put("B", "150");
        this.startServer();
        this.apiClient.headerSimpleExplodeObject(color_header, (Handler<AsyncResult<HttpResponse>>)((Handler)ar -> {
            if (ar.succeeded()) {
                this.assertEquals(200L, ((HttpResponse)ar.result()).statusCode());
                this.assertTrue("Expected: " + new JsonObject("{\"color\":{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\"}}").encode() + " Actual: " + ((HttpResponse)ar.result()).bodyAsJsonObject().encode(), new JsonObject("{\"color\":{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\"}}").equals((Object)((HttpResponse)ar.result()).bodyAsJsonObject()));
            } else {
                this.assertTrue(ar.cause().getMessage(), false);
            }
            latch.countDown();
        }));
        this.awaitLatch(latch);
    }

    private OpenAPI loadSwagger(String filename) throws IOException {
        ParseOptions options = new ParseOptions();
        options.setResolve(true);
        options.setResolveCombinators(false);
        options.setResolveFully(true);
        return new OpenAPIV3Parser().readContents(String.join((CharSequence)"\n", Files.readAllLines(Paths.get(filename, new String[0]), StandardCharsets.UTF_8)), null, options).getOpenAPI();
    }

    public Handler<RoutingContext> generateFailureHandler() {
        return routingContext -> {
            Throwable failure = routingContext.failure();
            failure.printStackTrace();
            this.assertTrue(failure.getMessage(), false);
        };
    }

    private void startServer() throws Exception {
        this.router = this.routerFactory.getRouter();
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080).setHost("localhost"));
        while (true) {
            try {
                CountDownLatch latch = new CountDownLatch(1);
                this.server.requestHandler((Handler)this.router).listen(this.onSuccess(res -> latch.countDown()));
                this.awaitLatch(latch);
                return;
            }
            catch (AssertionError assertionError) {
                continue;
            }
            break;
        }
    }

    private void stopServer() throws Exception {
        if (this.server != null) {
            CountDownLatch latch = new CountDownLatch(1);
            this.server.close(this.onSuccess(v -> latch.countDown()));
            this.awaitLatch(latch);
        }
    }
}

