/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.validation.impl;

import io.vertx.ext.web.api.validation.ValidationException;
import io.vertx.ext.web.api.validation.impl.StringTypeValidator;
import org.junit.Test;

public class StringTypeValidatorTest {
    @Test
    public void isValidPattern() {
        StringTypeValidator validator = new StringTypeValidator("^(?:[\\w!#\\$%&'\\*\\+\\-/=\\?\\^`\\{\\|\\}~]+\\.)*[\\w!#\\$%&'\\*\\+\\-/=\\?\\^`\\{\\|\\}~]+@(?:(?:(?:[a-zA-Z0-9](?:[a-zA-Z0-9\\-](?!\\.)){0,61}[a-zA-Z0-9]?\\.)+[a-zA-Z0-9](?:[a-zA-Z0-9\\-](?!$)){0,61}[a-zA-Z0-9]?)|(?:\\[(?:(?:[01]?\\d{1,2}|2[0-4]\\d|25[0-5])\\.){3}(?:[01]?\\d{1,2}|2[0-4]\\d|25[0-5])\\]))$");
        validator.isValid("admin@vertx.io");
    }

    @Test(expected=ValidationException.class)
    public void isNotValidPattern() {
        StringTypeValidator validator = new StringTypeValidator("^(?:[\\w!#\\$%&'\\*\\+\\-/=\\?\\^`\\{\\|\\}~]+\\.)*[\\w!#\\$%&'\\*\\+\\-/=\\?\\^`\\{\\|\\}~]+@(?:(?:(?:[a-zA-Z0-9](?:[a-zA-Z0-9\\-](?!\\.)){0,61}[a-zA-Z0-9]?\\.)+[a-zA-Z0-9](?:[a-zA-Z0-9\\-](?!$)){0,61}[a-zA-Z0-9]?)|(?:\\[(?:(?:[01]?\\d{1,2}|2[0-4]\\d|25[0-5])\\.){3}(?:[01]?\\d{1,2}|2[0-4]\\d|25[0-5])\\]))$");
        validator.isValid("admin.vertx.io");
    }

    @Test
    public void isValidMaxLength() {
        StringTypeValidator validator = new StringTypeValidator(null, null, Integer.valueOf(3), null);
        validator.isValid("aaa");
    }

    @Test(expected=ValidationException.class)
    public void isNotValidMaxLength() {
        StringTypeValidator validator = new StringTypeValidator(null, null, Integer.valueOf(3), null);
        validator.isValid("aaaa");
    }

    @Test
    public void isValidMinLength() {
        StringTypeValidator validator = new StringTypeValidator(null, Integer.valueOf(2), null, null);
        validator.isValid("aaa");
    }

    @Test(expected=ValidationException.class)
    public void isNotValidMinLength() {
        StringTypeValidator validator = new StringTypeValidator(null, Integer.valueOf(2), null, null);
        validator.isValid("a");
    }
}

