/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.validation;

import io.netty.handler.codec.http.QueryStringEncoder;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.WebTestWithWebClientBase;
import io.vertx.ext.web.api.RequestParameters;
import io.vertx.ext.web.api.validation.HTTPRequestValidationHandler;
import io.vertx.ext.web.api.validation.ParameterType;
import io.vertx.ext.web.api.validation.WebTestValidationBase;
import io.vertx.ext.web.handler.BodyHandler;
import java.net.URLEncoder;
import org.junit.Test;

public class HTTPRequestValidationTest
extends WebTestValidationBase {
    @Test
    public void testBoolValidation() {
        this.testPrimitiveParameterType(ParameterType.BOOL);
    }

    @Test
    public void testEmailValidation() {
        this.testPrimitiveParameterType(ParameterType.EMAIL);
    }

    @Test
    public void testURIValidation() {
        this.testPrimitiveParameterType(ParameterType.URI);
    }

    @Test
    public void testIntegerValidation() {
        this.testPrimitiveParameterType(ParameterType.INT);
    }

    @Test
    public void testFloatValidation() {
        this.testPrimitiveParameterType(ParameterType.FLOAT);
    }

    @Test
    public void testDoubleValidation() {
        this.testPrimitiveParameterType(ParameterType.DOUBLE);
    }

    @Test
    public void testDateValidation() {
        this.testPrimitiveParameterType(ParameterType.DATE);
    }

    @Test
    public void testDateTimeValidation() {
        this.testPrimitiveParameterType(ParameterType.DATETIME);
    }

    @Test
    public void testTimeValidation() {
        this.testPrimitiveParameterType(ParameterType.TIME);
    }

    @Test
    public void testBase64Validation() {
        this.testPrimitiveParameterType(ParameterType.BASE64);
    }

    @Test
    public void testPathParamsWithIncludedTypes() throws Exception {
        HTTPRequestValidationHandler validationHandler = HTTPRequestValidationHandler.create().addPathParam("a", ParameterType.GENERIC_STRING).addPathParam("b", ParameterType.BOOL).addPathParam("c", ParameterType.INT);
        this.router.get("/testPathParams/:a/:b/:c").handler((Handler)validationHandler);
        this.router.get("/testPathParams/:a/:b/:c").handler(routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            routingContext.response().setStatusMessage(params.pathParameter("a").getString() + params.pathParameter("b").getBoolean() + params.pathParameter("c").getInteger()).end();
        }).failureHandler(this.generateFailureHandler(false));
        String value1 = this.getSuccessSample(ParameterType.BOOL).getBoolean().toString();
        String value2 = this.getSuccessSample(ParameterType.INT).getInteger().toString();
        String path = "/testPathParams/hello/" + URLEncoder.encode(value1, "UTF-8") + "/" + URLEncoder.encode(value2, "UTF-8");
        this.testRequest(HttpMethod.GET, path, 200, "hello" + value1 + value2);
    }

    @Test
    public void testPathParamsFailureWithIncludedTypes() throws Exception {
        HTTPRequestValidationHandler validationHandler = HTTPRequestValidationHandler.create().addPathParam("a", ParameterType.GENERIC_STRING).addPathParam("b", ParameterType.BOOL).addPathParam("c", ParameterType.INT);
        this.router.get("/testPathParams/:a/:b/:c").handler((Handler)validationHandler);
        this.router.get("/testPathParams/:a/:b/:c").handler(routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            routingContext.response().setStatusMessage(params.pathParameter("a").getString() + params.pathParameter("b").getBoolean() + params.pathParameter("c").getInteger()).end();
        }).failureHandler(this.generateFailureHandler(true));
        String path = "/testPathParams/hello/" + URLEncoder.encode(this.getFailureSample(ParameterType.BOOL), "UTF-8") + "/" + URLEncoder.encode(this.getFailureSample(ParameterType.INT) + "/", "UTF-8");
        this.testRequest(HttpMethod.GET, path, 400, "failure:NO_MATCH");
    }

    @Test
    public void testQueryParamsWithIncludedTypes() throws Exception {
        HTTPRequestValidationHandler validationHandler = HTTPRequestValidationHandler.create().addQueryParam("param1", ParameterType.BOOL, true).addQueryParam("param2", ParameterType.INT, true);
        this.router.get("/testQueryParams").handler((Handler)validationHandler);
        this.router.get("/testQueryParams").handler(routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            routingContext.response().setStatusMessage(params.queryParameter("param1").getBoolean().toString() + params.queryParameter("param2").getInteger().toString()).end();
        }).failureHandler(this.generateFailureHandler(false));
        QueryStringEncoder encoder = new QueryStringEncoder("/testQueryParams");
        String param1 = this.getSuccessSample(ParameterType.BOOL).getBoolean().toString();
        String param2 = this.getSuccessSample(ParameterType.INT).getInteger().toString();
        encoder.addParam("param1", param1);
        encoder.addParam("param2", param2);
        this.testRequest(HttpMethod.GET, encoder.toString(), 200, param1 + param2);
    }

    @Test
    public void testQueryParamsFailureWithIncludedTypes() throws Exception {
        HTTPRequestValidationHandler validationHandler = HTTPRequestValidationHandler.create().addQueryParam("param1", ParameterType.BOOL, true).addQueryParam("param2", ParameterType.INT, true);
        this.router.get("/testQueryParams").handler((Handler)validationHandler);
        this.router.get("/testQueryParams").handler(routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            routingContext.response().setStatusMessage(params.queryParameter("param1").getBoolean().toString() + params.queryParameter("param2").getInteger().toString());
        }).failureHandler(this.generateFailureHandler(true));
        QueryStringEncoder encoder = new QueryStringEncoder("/testQueryParams");
        encoder.addParam("param1", this.getFailureSample(ParameterType.BOOL));
        encoder.addParam("param2", this.getFailureSample(ParameterType.INT));
        this.testRequest(HttpMethod.GET, encoder.toString(), 400, "failure:NO_MATCH");
    }

    @Test
    public void testQueryParamsArrayAndPathParamsWithIncludedTypes() throws Exception {
        HTTPRequestValidationHandler validationHandler = HTTPRequestValidationHandler.create().addPathParam("pathParam1", ParameterType.INT).addQueryParamsArray("awesomeArray", ParameterType.EMAIL, true).addQueryParam("anotherParam", ParameterType.DOUBLE, true);
        this.router.get("/testQueryParams/:pathParam1").handler((Handler)validationHandler);
        this.router.get("/testQueryParams/:pathParam1").handler(routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            routingContext.response().setStatusMessage(params.pathParameter("pathParam1").getInteger().toString() + params.queryParameter("awesomeArray").getArray().size() + params.queryParameter("anotherParam").getDouble().toString()).end();
        }).failureHandler(this.generateFailureHandler(false));
        String pathParam = this.getSuccessSample(ParameterType.INT).getInteger().toString();
        String arrayValue1 = this.getSuccessSample(ParameterType.EMAIL).getString();
        String arrayValue2 = this.getSuccessSample(ParameterType.EMAIL).getString();
        String anotherParam = this.getSuccessSample(ParameterType.DOUBLE).getDouble().toString();
        QueryStringEncoder encoder = new QueryStringEncoder("/testQueryParams/" + URLEncoder.encode(pathParam, "UTF-8"));
        encoder.addParam("awesomeArray", arrayValue1);
        encoder.addParam("awesomeArray", arrayValue2);
        encoder.addParam("anotherParam", anotherParam);
        this.testRequest(HttpMethod.GET, encoder.toString(), 200, pathParam + "2" + anotherParam);
    }

    @Test
    public void testQueryParamsArrayAndPathParamsFailureWithIncludedTypes() throws Exception {
        HTTPRequestValidationHandler validationHandler = HTTPRequestValidationHandler.create().addPathParam("pathParam1", ParameterType.INT).addQueryParamsArray("awesomeArray", ParameterType.EMAIL, true).addQueryParam("anotherParam", ParameterType.DOUBLE, true);
        this.router.get("/testQueryParams/:pathParam1").handler((Handler)validationHandler);
        this.router.get("/testQueryParams/:pathParam1").handler(routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            routingContext.response().setStatusMessage(params.pathParameter("pathParam1").getInteger().toString() + params.queryParameter("awesomeArray").getArray().size() + params.queryParameter("anotherParam").getDouble().toString()).end();
        }).failureHandler(this.generateFailureHandler(true));
        String pathParam = this.getSuccessSample(ParameterType.INT).getInteger().toString();
        String arrayValue1 = this.getFailureSample(ParameterType.EMAIL);
        String arrayValue2 = this.getSuccessSample(ParameterType.EMAIL).getString();
        String anotherParam = this.getSuccessSample(ParameterType.DOUBLE).getDouble().toString();
        QueryStringEncoder encoder = new QueryStringEncoder("/testQueryParams/" + URLEncoder.encode(pathParam, "UTF-8"));
        encoder.addParam("awesomeArray", arrayValue1);
        encoder.addParam("awesomeArray", arrayValue2);
        encoder.addParam("anotherParam", anotherParam);
        this.testRequest(HttpMethod.GET, encoder.toString(), 400, "failure:NO_MATCH");
    }

    @Test
    public void testFormURLEncodedParamWithIncludedTypes() throws Exception {
        HTTPRequestValidationHandler validationHandler = HTTPRequestValidationHandler.create().addFormParam("parameter", ParameterType.INT, true);
        this.router.route().handler((Handler)BodyHandler.create());
        this.router.post("/testFormParam").handler((Handler)validationHandler);
        this.router.post("/testFormParam").handler(routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            routingContext.response().setStatusMessage(params.formParameter("parameter").getInteger().toString()).end();
        }).failureHandler(this.generateFailureHandler(false));
        String formParam = this.getSuccessSample(ParameterType.INT).getInteger().toString();
        MultiMap form = MultiMap.caseInsensitiveMultiMap();
        form.add("parameter", formParam);
        this.testRequestWithForm(HttpMethod.POST, "/testFormParam", WebTestWithWebClientBase.FormType.FORM_URLENCODED, form, 200, formParam);
    }

    @Test
    public void testFormMultipartParamWithIncludedTypes() throws Exception {
        HTTPRequestValidationHandler validationHandler = HTTPRequestValidationHandler.create().addFormParam("parameter", ParameterType.INT, true);
        this.router.route().handler((Handler)BodyHandler.create());
        this.router.post("/testFormParam").handler((Handler)validationHandler);
        this.router.post("/testFormParam").handler(routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            routingContext.response().setStatusMessage(params.formParameter("parameter").getInteger().toString()).end();
        }).failureHandler(this.generateFailureHandler(false));
        String formParam = this.getSuccessSample(ParameterType.INT).getInteger().toString();
        MultiMap form = MultiMap.caseInsensitiveMultiMap();
        form.add("parameter", formParam);
        this.testRequestWithForm(HttpMethod.POST, "/testFormParam", WebTestWithWebClientBase.FormType.MULTIPART, form, 200, formParam);
    }

    @Test
    public void testFormURLEncodedOverrideWithIncludedTypes() throws Exception {
        HTTPRequestValidationHandler validationHandler = HTTPRequestValidationHandler.create().addFormParam("parameter", ParameterType.INT, true).addQueryParam("parameter", ParameterType.INT, true);
        this.router.route().handler((Handler)BodyHandler.create());
        this.router.post("/testFormParam").handler((Handler)validationHandler);
        this.router.post("/testFormParam").handler(routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            routingContext.response().setStatusMessage(params.formParameter("parameter").getInteger().toString()).end();
        }).failureHandler(this.generateFailureHandler(false));
        String formParam = this.getSuccessSample(ParameterType.INT).getInteger().toString();
        String queryParam = this.getSuccessSample(ParameterType.INT).getInteger().toString();
        MultiMap form = MultiMap.caseInsensitiveMultiMap();
        form.add("parameter", formParam);
        this.testRequestWithForm(HttpMethod.POST, "/testFormParam?parameter=" + queryParam, WebTestWithWebClientBase.FormType.FORM_URLENCODED, form, 200, formParam);
    }

    @Test
    public void testValidationHandlerChaining() throws Exception {
        HTTPRequestValidationHandler validationHandler1 = HTTPRequestValidationHandler.create().addQueryParam("param1", ParameterType.INT, true);
        HTTPRequestValidationHandler validationHandler2 = HTTPRequestValidationHandler.create().addQueryParam("param2", ParameterType.BOOL, true);
        this.router.route().handler((Handler)BodyHandler.create());
        this.router.get("/testHandlersChaining").handler((Handler)validationHandler1).handler((Handler)validationHandler2).handler(routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            this.assertNotNull(params.queryParameter("param1"));
            this.assertNotNull(params.queryParameter("param2"));
            routingContext.response().setStatusMessage(params.queryParameter("param1").getInteger().toString() + params.queryParameter("param2").getBoolean()).end();
        }).failureHandler(this.generateFailureHandler(false));
        String param1 = this.getSuccessSample(ParameterType.INT).getInteger().toString();
        String param2 = this.getSuccessSample(ParameterType.BOOL).getBoolean().toString();
        this.testRequest(HttpMethod.GET, "/testHandlersChaining?param1=10&param2=true", 200, "10true");
    }
}

