/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.contract.openapi3;

import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.WebTestWithWebClientBase;
import io.vertx.ext.web.api.RequestParameters;
import io.vertx.ext.web.api.contract.RouterFactoryException;
import io.vertx.ext.web.api.contract.RouterFactoryOptions;
import io.vertx.ext.web.api.contract.openapi3.OpenAPI3RouterFactory;
import io.vertx.ext.web.api.validation.ValidationException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Test;

public class OpenAPI3RouterFactoryTest
extends WebTestWithWebClientBase {
    private OpenAPI3RouterFactory routerFactory;
    private RouterFactoryOptions HANDLERS_TESTS_OPTIONS = new RouterFactoryOptions().setRequireSecurityHandlers(false);

    private Handler<RoutingContext> generateFailureHandler(boolean expected) {
        return routingContext -> {
            Throwable failure = routingContext.failure();
            if (failure instanceof ValidationException) {
                if (!expected) {
                    failure.printStackTrace();
                }
                routingContext.response().setStatusCode(400).setStatusMessage("failure:" + ((ValidationException)failure).type().name()).end();
            } else {
                failure.printStackTrace();
                routingContext.response().setStatusCode(500).setStatusMessage("unknownfailure:" + failure.toString()).end();
            }
        };
    }

    private void startServer() throws InterruptedException {
        Router router = this.routerFactory.getRouter();
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080).setHost("localhost"));
        CountDownLatch latch = new CountDownLatch(1);
        this.server.requestHandler(arg_0 -> ((Router)router).accept(arg_0)).listen(this.onSuccess(res -> latch.countDown()));
        this.awaitLatch(latch);
    }

    private void stopServer() throws Exception {
        this.routerFactory = null;
        if (this.server != null) {
            CountDownLatch latch = new CountDownLatch(1);
            this.server.close(asyncResult -> {
                this.assertTrue(asyncResult.succeeded());
                latch.countDown();
            });
            this.awaitLatch(latch);
        }
    }

    private void assertThrow(Runnable r, Class exception) {
        try {
            r.run();
            this.assertTrue(exception.getName() + " not thrown", false);
        }
        catch (Exception e) {
            this.assertTrue(exception.getName() + " not thrown. Thrown: " + e.getClass().getName(), e.getClass().equals(exception));
        }
    }

    private void assertNotThrow(Runnable r, Class exception) {
        try {
            r.run();
        }
        catch (Exception e) {
            this.assertFalse(exception.getName() + " not thrown. Thrown: " + e.getClass().getName(), e.getClass().equals(exception));
        }
    }

    private void assertNotThrow(Runnable r) {
        try {
            r.run();
        }
        catch (Exception e) {
            this.assertTrue("Exception " + e + " is thrown", false);
        }
    }

    public void setUp() throws Exception {
        super.setUp();
        this.stopServer();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setDefaultPort(8080));
    }

    public void tearDown() throws Exception {
        this.stopServer();
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        super.tearDown();
    }

    @Test
    public void loadSpecFromFile() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        OpenAPI3RouterFactory.create((Vertx)this.vertx, (String)"src/test/resources/swaggers/router_factory_test.yaml", openAPI3RouterFactoryAsyncResult -> {
            this.assertTrue(openAPI3RouterFactoryAsyncResult.succeeded());
            this.assertNotNull(openAPI3RouterFactoryAsyncResult.result());
            latch.countDown();
        });
        this.awaitLatch(latch);
    }

    @Test
    public void failLoadSpecFromFile() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        OpenAPI3RouterFactory.create((Vertx)this.vertx, (String)"src/test/resources/swaggers/aaa.yaml", openAPI3RouterFactoryAsyncResult -> {
            this.assertTrue(openAPI3RouterFactoryAsyncResult.failed());
            this.assertEquals(RouterFactoryException.class, openAPI3RouterFactoryAsyncResult.cause().getClass());
            this.assertEquals(RouterFactoryException.ErrorType.INVALID_SPEC_PATH, ((RouterFactoryException)openAPI3RouterFactoryAsyncResult.cause()).type());
            latch.countDown();
        });
        this.awaitLatch(latch);
    }

    @Test
    public void loadWrongSpecFromFile() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        OpenAPI3RouterFactory.create((Vertx)this.vertx, (String)"src/test/resources/swaggers/bad_spec.yaml", openAPI3RouterFactoryAsyncResult -> {
            this.assertTrue(openAPI3RouterFactoryAsyncResult.failed());
            this.assertEquals(RouterFactoryException.class, openAPI3RouterFactoryAsyncResult.cause().getClass());
            this.assertEquals(RouterFactoryException.ErrorType.SPEC_INVALID, ((RouterFactoryException)openAPI3RouterFactoryAsyncResult.cause()).type());
            latch.countDown();
        });
        this.awaitLatch(latch);
    }

    @Test
    public void loadSpecFromURL() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        OpenAPI3RouterFactory.create((Vertx)this.vertx, (String)"https://raw.githubusercontent.com/OAI/OpenAPI-Specification/master/examples/v3.0/petstore.yaml", openAPI3RouterFactoryAsyncResult -> {
            this.assertTrue(openAPI3RouterFactoryAsyncResult.succeeded());
            this.assertNotNull(openAPI3RouterFactoryAsyncResult.result());
            latch.countDown();
        });
        this.awaitLatch(latch);
    }

    @Test
    public void failLoadSpecFromURL() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        OpenAPI3RouterFactory.create((Vertx)this.vertx, (String)"https://helloworld.com/spec.yaml", openAPI3RouterFactoryAsyncResult -> {
            this.assertTrue(openAPI3RouterFactoryAsyncResult.failed());
            this.assertEquals(RouterFactoryException.class, openAPI3RouterFactoryAsyncResult.cause().getClass());
            this.assertEquals(RouterFactoryException.ErrorType.INVALID_SPEC_PATH, ((RouterFactoryException)openAPI3RouterFactoryAsyncResult.cause()).type());
            latch.countDown();
        });
        this.awaitLatch(latch);
    }

    @Test
    public void mountHandlerTest() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        OpenAPI3RouterFactory.create((Vertx)this.vertx, (String)"src/test/resources/swaggers/router_factory_test.yaml", openAPI3RouterFactoryAsyncResult -> {
            this.routerFactory = (OpenAPI3RouterFactory)openAPI3RouterFactoryAsyncResult.result();
            this.routerFactory.setOptions(this.HANDLERS_TESTS_OPTIONS);
            this.routerFactory.addHandlerByOperationId("listPets", routingContext -> routingContext.response().setStatusCode(200).setStatusMessage("OK").end());
            latch.countDown();
        });
        this.awaitLatch(latch);
        this.startServer();
        this.testRequest(HttpMethod.GET, "/pets", 200, "OK");
    }

    @Test
    public void mountFailureHandlerTest() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        OpenAPI3RouterFactory.create((Vertx)this.vertx, (String)"src/test/resources/swaggers/router_factory_test.yaml", openAPI3RouterFactoryAsyncResult -> {
            this.routerFactory = (OpenAPI3RouterFactory)openAPI3RouterFactoryAsyncResult.result();
            this.routerFactory.setOptions(this.HANDLERS_TESTS_OPTIONS);
            this.routerFactory.addHandlerByOperationId("listPets", routingContext -> routingContext.fail(null)).addFailureHandlerByOperationId("listPets", routingContext -> routingContext.response().setStatusCode(500).setStatusMessage("ERROR").end());
            latch.countDown();
        });
        this.awaitLatch(latch);
        this.startServer();
        this.testRequest(HttpMethod.GET, "/pets", 500, "ERROR");
    }

    @Test
    public void mountMultipleHandlers() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        OpenAPI3RouterFactory.create((Vertx)this.vertx, (String)"src/test/resources/swaggers/router_factory_test.yaml", openAPI3RouterFactoryAsyncResult -> {
            this.routerFactory = (OpenAPI3RouterFactory)openAPI3RouterFactoryAsyncResult.result();
            this.routerFactory.setOptions(this.HANDLERS_TESTS_OPTIONS);
            this.routerFactory.addHandlerByOperationId("listPets", routingContext -> routingContext.put("message", (Object)"A").next()).addHandlerByOperationId("listPets", routingContext -> {
                routingContext.put("message", (Object)(routingContext.get("message") + "B"));
                routingContext.fail(500);
            }).addFailureHandlerByOperationId("listPets", routingContext -> routingContext.put("message", (Object)(routingContext.get("message") + "E")).next()).addFailureHandlerByOperationId("listPets", routingContext -> routingContext.response().setStatusCode(500).setStatusMessage((String)routingContext.get("message")).end());
            latch.countDown();
        });
        this.awaitLatch(latch);
        this.startServer();
        this.testRequest(HttpMethod.GET, "/pets", 500, "ABE");
    }

    @Test
    public void mountSecurityHandlers() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        OpenAPI3RouterFactory.create((Vertx)this.vertx, (String)"src/test/resources/swaggers/router_factory_test.yaml", openAPI3RouterFactoryAsyncResult -> {
            this.routerFactory = (OpenAPI3RouterFactory)openAPI3RouterFactoryAsyncResult.result();
            this.routerFactory.setOptions(new RouterFactoryOptions().setRequireSecurityHandlers(true));
            this.routerFactory.addHandlerByOperationId("listPetsSecurity", routingContext -> routingContext.response().setStatusCode(200).setStatusMessage(routingContext.get("first_level") + "-" + routingContext.get("second_level") + "-" + routingContext.get("third_level_one") + "-" + routingContext.get("third_level_two") + "-Done").end());
            this.routerFactory.addSecurityHandler("api_key", routingContext -> routingContext.put("first_level", (Object)"User").next());
            this.routerFactory.addSecuritySchemaScopeValidator("second_api_key", "moderator", routingContext -> routingContext.put("second_level", (Object)"Moderator").next());
            this.routerFactory.addSecuritySchemaScopeValidator("third_api_key", "admin", routingContext -> routingContext.put("third_level_one", (Object)"Admin").next());
            this.routerFactory.addSecuritySchemaScopeValidator("third_api_key", "useless", routingContext -> routingContext.put("third_level_one", (Object)"Wrong!").next());
            this.routerFactory.addSecuritySchemaScopeValidator("third_api_key", "super_admin", routingContext -> routingContext.put("third_level_two", (Object)"SuperAdmin").next());
            latch.countDown();
        });
        this.awaitLatch(latch);
        this.startServer();
        this.testRequest(HttpMethod.GET, "/pets_security_test", 200, "User-Moderator-Admin-SuperAdmin-Done");
    }

    @Test
    public void requireSecurityHandler() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        OpenAPI3RouterFactory.create((Vertx)this.vertx, (String)"src/test/resources/swaggers/router_factory_test.yaml", openAPI3RouterFactoryAsyncResult -> {
            this.routerFactory = (OpenAPI3RouterFactory)openAPI3RouterFactoryAsyncResult.result();
            this.routerFactory.setOptions(new RouterFactoryOptions().setRequireSecurityHandlers(true));
            this.routerFactory.addHandlerByOperationId("listPets", routingContext -> routingContext.response().setStatusCode(200).setStatusMessage(routingContext.get("message") + "OK").end());
            latch.countDown();
        });
        this.awaitLatch(latch);
        this.assertThrow(() -> ((OpenAPI3RouterFactory)this.routerFactory).getRouter(), RouterFactoryException.class);
        this.routerFactory.addSecurityHandler("api_key", routingContext -> routingContext.next());
        this.routerFactory.addSecurityHandler("second_api_key", routingContext -> routingContext.next());
        this.routerFactory.addSecurityHandler("third_api_key", routingContext -> routingContext.next());
        this.assertNotThrow(() -> ((OpenAPI3RouterFactory)this.routerFactory).getRouter(), RouterFactoryException.class);
    }

    @Test
    public void requireGlobalSecurityHandler() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        OpenAPI3RouterFactory.create((Vertx)this.vertx, (String)"src/test/resources/swaggers/global_security_test.yaml", openAPI3RouterFactoryAsyncResult -> {
            this.routerFactory = (OpenAPI3RouterFactory)openAPI3RouterFactoryAsyncResult.result();
            this.routerFactory.setOptions(new RouterFactoryOptions().setRequireSecurityHandlers(true));
            this.routerFactory.addHandlerByOperationId("listPets", routingContext -> routingContext.response().setStatusCode(200).setStatusMessage(routingContext.get("message") + "-OK").end());
            latch.countDown();
        });
        this.awaitLatch(latch);
        this.assertThrow(() -> ((OpenAPI3RouterFactory)this.routerFactory).getRouter(), RouterFactoryException.class);
        this.routerFactory.addSecurityHandler("global_api_key", routingContext -> routingContext.put("message", (Object)"Global").next());
        this.routerFactory.addSecurityHandler("api_key", routingContext -> routingContext.put("message", (Object)(routingContext.get("message") + "-Local")).next());
        this.startServer();
        this.testRequest(HttpMethod.GET, "/pets", 200, "Global-Local-OK");
    }

    @Test
    public void notRequireSecurityHandler() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        OpenAPI3RouterFactory.create((Vertx)this.vertx, (String)"src/test/resources/swaggers/router_factory_test.yaml", openAPI3RouterFactoryAsyncResult -> {
            this.routerFactory = (OpenAPI3RouterFactory)openAPI3RouterFactoryAsyncResult.result();
            this.routerFactory.setOptions(new RouterFactoryOptions().setRequireSecurityHandlers(false));
            this.routerFactory.addHandlerByOperationId("listPets", routingContext -> routingContext.response().setStatusCode(200).setStatusMessage(routingContext.get("message") + "OK").end());
            latch.countDown();
        });
        this.awaitLatch(latch);
        this.assertNotThrow(() -> this.routerFactory.getRouter(), RouterFactoryException.class);
    }

    @Test
    public void mountValidationFailureHandler() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        OpenAPI3RouterFactory.create((Vertx)this.vertx, (String)"src/test/resources/swaggers/router_factory_test.yaml", openAPI3RouterFactoryAsyncResult -> {
            this.routerFactory = (OpenAPI3RouterFactory)openAPI3RouterFactoryAsyncResult.result();
            this.routerFactory.setOptions(this.HANDLERS_TESTS_OPTIONS);
            this.routerFactory.addHandlerByOperationId("listPets", routingContext -> routingContext.response().setStatusCode(200).setStatusMessage(((RequestParameters)routingContext.get("parsedParameters")).queryParameter("limit").toString()).end());
            latch.countDown();
        });
        this.awaitLatch(latch);
        this.startServer();
        this.testRequest(HttpMethod.GET, "/pets?limit=hello", 400, "Bad Request");
        this.testRequest(HttpMethod.GET, "/pets?limit=10", 200, "10");
    }

    @Test
    public void mountCustomValidationFailureHandler() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        OpenAPI3RouterFactory.create((Vertx)this.vertx, (String)"src/test/resources/swaggers/router_factory_test.yaml", openAPI3RouterFactoryAsyncResult -> {
            this.routerFactory = (OpenAPI3RouterFactory)openAPI3RouterFactoryAsyncResult.result();
            this.routerFactory.setOptions(this.HANDLERS_TESTS_OPTIONS.setValidationFailureHandler(routingContext -> routingContext.response().setStatusCode(400).setStatusMessage("Very very Bad Request").end()));
            this.routerFactory.addHandlerByOperationId("listPets", routingContext -> routingContext.response().setStatusCode(200).setStatusMessage(((RequestParameters)routingContext.get("parsedParameters")).queryParameter("limit").toString()).end());
            latch.countDown();
        });
        this.awaitLatch(latch);
        this.startServer();
        this.testRequest(HttpMethod.GET, "/pets?limit=hello", 400, "Very very Bad Request");
        this.testRequest(HttpMethod.GET, "/pets?limit=10", 200, "10");
    }

    @Test
    public void notMountValidationFailureHandler() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        OpenAPI3RouterFactory.create((Vertx)this.vertx, (String)"src/test/resources/swaggers/router_factory_test.yaml", openAPI3RouterFactoryAsyncResult -> {
            this.routerFactory = (OpenAPI3RouterFactory)openAPI3RouterFactoryAsyncResult.result();
            this.routerFactory.setOptions(new RouterFactoryOptions().setRequireSecurityHandlers(false).setMountValidationFailureHandler(false));
            this.routerFactory.addHandlerByOperationId("listPets", routingContext -> routingContext.response().setStatusCode(200).setStatusMessage(((RequestParameters)routingContext.get("parsedParameters")).queryParameter("limit").toString()).end());
            this.routerFactory.addFailureHandlerByOperationId("listPets", routingContext -> routingContext.response().setStatusCode(routingContext.failure() instanceof ValidationException ? 400 : 500).setStatusMessage(routingContext.failure() instanceof ValidationException ? "Very very Bad Request" : "Error").end());
            latch.countDown();
        });
        this.awaitLatch(latch);
        this.startServer();
        this.testRequest(HttpMethod.GET, "/pets?limit=hello", 400, "Very very Bad Request");
        this.testRequest(HttpMethod.GET, "/pets?limit=10", 200, "10");
    }

    @Test
    public void mountNotImplementedHandler() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        OpenAPI3RouterFactory.create((Vertx)this.vertx, (String)"src/test/resources/swaggers/router_factory_test.yaml", openAPI3RouterFactoryAsyncResult -> {
            this.routerFactory = (OpenAPI3RouterFactory)openAPI3RouterFactoryAsyncResult.result();
            this.routerFactory.setOptions(new RouterFactoryOptions().setRequireSecurityHandlers(false).setMountNotImplementedHandler(true));
            latch.countDown();
        });
        this.awaitLatch(latch);
        this.startServer();
        this.testRequest(HttpMethod.GET, "/pets", 501, "Not Implemented");
    }

    @Test
    public void mountCustomNotImplementedHandler() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        OpenAPI3RouterFactory.create((Vertx)this.vertx, (String)"src/test/resources/swaggers/router_factory_test.yaml", openAPI3RouterFactoryAsyncResult -> {
            this.routerFactory = (OpenAPI3RouterFactory)openAPI3RouterFactoryAsyncResult.result();
            this.routerFactory.setOptions(new RouterFactoryOptions().setMountNotImplementedHandler(true).setRequireSecurityHandlers(false).setNotImplementedFailureHandler(routingContext -> routingContext.response().setStatusCode(501).setStatusMessage("We are too lazy to implement this operation").end()));
            latch.countDown();
        });
        this.awaitLatch(latch);
        this.startServer();
        this.testRequest(HttpMethod.GET, "/pets", 501, "We are too lazy to implement this operation");
    }

    @Test
    public void notMountNotImplementedHandler() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        OpenAPI3RouterFactory.create((Vertx)this.vertx, (String)"src/test/resources/swaggers/router_factory_test.yaml", openAPI3RouterFactoryAsyncResult -> {
            this.routerFactory = (OpenAPI3RouterFactory)openAPI3RouterFactoryAsyncResult.result();
            this.routerFactory.setOptions(new RouterFactoryOptions().setMountNotImplementedHandler(false));
            latch.countDown();
        });
        this.awaitLatch(latch);
        this.startServer();
        this.testRequest(HttpMethod.GET, "/pets", 404, "Not Found");
    }

    @Test
    public void consumesTest() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        OpenAPI3RouterFactory.create((Vertx)this.vertx, (String)"src/test/resources/swaggers/produces_consumes_test.yaml", openAPI3RouterFactoryAsyncResult -> {
            this.routerFactory = (OpenAPI3RouterFactory)openAPI3RouterFactoryAsyncResult.result();
            this.routerFactory.setOptions(new RouterFactoryOptions().setMountNotImplementedHandler(false));
            this.routerFactory.addHandlerByOperationId("consumesTest", routingContext -> {
                RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
                if (params.body() != null && params.body().isJsonObject()) {
                    routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("Content-Type", "application/json").end(params.body().getJsonObject().encode());
                } else {
                    routingContext.response().setStatusCode(200).setStatusMessage("OK").end();
                }
            });
            latch.countDown();
        });
        this.awaitLatch(latch);
        this.startServer();
        JsonObject obj = new JsonObject("{\"name\":\"francesco\"}");
        this.testRequestWithJSON(HttpMethod.POST, "/consumesTest", obj, 200, "OK", obj);
        MultiMap form = MultiMap.caseInsensitiveMultiMap();
        form.add("name", "francesco");
        this.testRequestWithForm(HttpMethod.POST, "/consumesTest", WebTestWithWebClientBase.FormType.FORM_URLENCODED, form, 200, "OK");
        this.testRequestWithForm(HttpMethod.POST, "/consumesTest", WebTestWithWebClientBase.FormType.MULTIPART, form, 404, "Not Found");
    }

    @Test
    public void producesTest() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        OpenAPI3RouterFactory.create((Vertx)this.vertx, (String)"src/test/resources/swaggers/produces_consumes_test.yaml", openAPI3RouterFactoryAsyncResult -> {
            this.routerFactory = (OpenAPI3RouterFactory)openAPI3RouterFactoryAsyncResult.result();
            this.routerFactory.setOptions(new RouterFactoryOptions().setMountNotImplementedHandler(false));
            this.routerFactory.addHandlerByOperationId("producesTest", routingContext -> {
                if (((RequestParameters)routingContext.get("parsedParameters")).queryParameter("fail").getBoolean().booleanValue()) {
                    routingContext.response().putHeader("content-type", "text/plain").setStatusCode(500).end("Hate it");
                } else {
                    routingContext.response().setStatusCode(200).end("{}");
                }
            });
            latch.countDown();
        });
        this.awaitLatch(latch);
        this.startServer();
        List acceptableContentTypes = Stream.of("application/json", "text/plain").collect(Collectors.toList());
        this.testRequestWithResponseContentTypeCheck(HttpMethod.GET, "/producesTest", 200, "application/json", acceptableContentTypes);
        this.testRequestWithResponseContentTypeCheck(HttpMethod.GET, "/producesTest?fail=true", 500, "text/plain", acceptableContentTypes);
    }

    @Test
    public void mountHandlersOrderTest() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        OpenAPI3RouterFactory.create((Vertx)this.vertx, (String)"src/test/resources/swaggers/test_order_spec.yaml", openAPI3RouterFactoryAsyncResult -> {
            this.assertTrue(openAPI3RouterFactoryAsyncResult.succeeded());
            this.routerFactory = (OpenAPI3RouterFactory)openAPI3RouterFactoryAsyncResult.result();
            this.routerFactory.setOptions(new RouterFactoryOptions().setMountNotImplementedHandler(false));
            this.routerFactory.addHandlerByOperationId("showSpecialProduct", routingContext -> routingContext.response().setStatusMessage("special").end());
            this.routerFactory.addFailureHandlerByOperationId("showSpecialProduct", this.generateFailureHandler(false));
            this.routerFactory.addHandlerByOperationId("showProductById", routingContext -> {
                RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
                routingContext.response().setStatusMessage(params.pathParameter("id").getInteger().toString()).end();
            });
            this.routerFactory.addFailureHandlerByOperationId("showProductById", this.generateFailureHandler(false));
            latch.countDown();
        });
        this.awaitLatch(latch);
        this.startServer();
        this.testRequest(HttpMethod.GET, "/product/special", 200, "special");
        this.testRequest(HttpMethod.GET, "/product/123", 200, "123");
        this.stopServer();
    }
}

