/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.tests;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.core.http.HttpClient;
import io.vertx.reactivex.core.http.HttpClientResponse;
import io.vertx.reactivex.core.http.HttpServer;
import io.vertx.reactivex.ext.web.Router;
import io.vertx.reactivex.reactivex.tests.web.TestRouteHandler;
import io.vertx.test.core.VertxTestBase;
import org.junit.Test;

public class WebTest
extends VertxTestBase {
    private Vertx vertx;
    private Router router;
    private HttpServer server;
    private HttpClient client;

    public void setUp() throws Exception {
        super.setUp();
        this.vertx = new Vertx(((VertxTestBase)this).vertx);
        this.router = Router.router((Vertx)this.vertx);
        this.server = (HttpServer)this.vertx.createHttpServer().requestHandler((Handler)this.router).rxListen(8080, "localhost").blockingGet();
        this.client = this.vertx.createHttpClient();
    }

    @Test
    public void testOrderListenerIsInvoked() {
        this.router.get().handler((Handler)TestRouteHandler.create());
        int statusCode = (Integer)this.client.rxRequest(HttpMethod.GET, 8080, "localhost", "/").flatMap(request -> request.rxSend().map(HttpClientResponse::statusCode)).blockingGet();
        this.assertEquals(200L, statusCode);
    }

    public void tearDown() throws Exception {
        if (this.client != null) {
            this.client.rxClose().onErrorComplete().blockingAwait();
        }
        if (this.server != null) {
            this.server.rxClose().onErrorComplete().blockingAwait();
        }
        super.tearDown();
    }
}

