/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.test;

import io.reactivex.Flowable;
import io.reactivex.Single;
import io.vertx.core.Verticle;
import io.vertx.core.file.OpenOptions;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.reactivex.core.AbstractVerticle;
import io.vertx.reactivex.core.RxHelper;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.core.buffer.Buffer;
import io.vertx.reactivex.core.http.HttpClient;
import io.vertx.reactivex.core.http.WebSocket;
import io.vertx.reactivex.core.parsetools.RecordParser;
import io.vertx.test.core.VertxTestBase;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Test;

public class CoreApiTest
extends VertxTestBase {
    private Vertx vertx;

    public void setUp() throws Exception {
        super.setUp();
        this.vertx = new Vertx(((VertxTestBase)this).vertx);
    }

    @Test
    public void testDeployVerticle() throws Exception {
        final CountDownLatch deployLatch = new CountDownLatch(2);
        RxHelper.deployVerticle((Vertx)this.vertx, (Verticle)new AbstractVerticle(){

            public void start() {
                deployLatch.countDown();
            }
        }).subscribe(resp -> deployLatch.countDown());
        this.awaitLatch(deployLatch);
    }

    @Test
    public void testWebSocket() {
        this.waitFor(2);
        AtomicLong serverReceived = new AtomicLong();
        this.vertx.createHttpServer(new HttpServerOptions().setIdleTimeout(2)).webSocketHandler(ws -> ws.toFlowable().subscribe(msg -> {
            serverReceived.incrementAndGet();
            ws.writeTextMessage("pong");
        }, err -> {
            this.assertEquals(1L, serverReceived.get());
            this.complete();
        }, () -> ((CoreApiTest)this).fail())).rxListen(8080, "localhost").blockingGet();
        HttpClient client = this.vertx.createHttpClient();
        AtomicLong clientReceived = new AtomicLong();
        client.rxWebSocket(8080, "localhost", "/").doAfterSuccess(ws -> ws.writeTextMessage("ping")).flatMapPublisher(WebSocket::toFlowable).subscribe(msg -> clientReceived.incrementAndGet(), err -> {
            this.assertEquals(1L, clientReceived.get());
            this.complete();
        }, () -> ((CoreApiTest)this).fail());
        this.await();
    }

    @Test
    public void testPipeFailureShouldUnsubscribe() throws Exception {
        this.vertx.createHttpServer().requestHandler(req -> {
            Flowable f = Flowable.generate(() -> 0L, (state, emitter) -> {
                emitter.onNext((Object)Buffer.buffer((String)("Chunk " + state + "\n")));
                return state + 1L;
            }).delay(100L, TimeUnit.MILLISECONDS).rebatchRequests(1).doOnCancel(() -> ((CoreApiTest)this).testComplete());
            req.response().send(f);
        }).rxListen(8080, "localhost").blockingGet();
        HttpClient client = this.vertx.createHttpClient();
        client.request(HttpMethod.GET, 8080, "localhost", "/", this.onSuccess(req -> req.send(this.onSuccess(resp -> {
            AtomicInteger count = new AtomicInteger();
            resp.handler(buff -> {
                if (count.incrementAndGet() > 5) {
                    resp.request().reset();
                }
            });
        }))));
        this.await();
    }

    @Test
    public void testRecordParser() {
        Single source = this.vertx.fileSystem().rxOpen("src/test/resources/test.txt", new OpenOptions());
        this.waitFor(5);
        source.map(file -> RecordParser.newDelimited((String)"\n", (Flowable)file.toFlowable())).flatMapObservable(RecordParser::toObservable).doOnNext(v -> this.complete()).doOnComplete(() -> this.complete()).ignoreElements().subscribe(() -> this.complete(), arg_0 -> ((CoreApiTest)this).fail(arg_0));
        this.await();
    }
}

