/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.sqlclient;

import io.reactivex.Maybe;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.reactivex.pgclient.PgPool;
import io.vertx.reactivex.sqlclient.Tuple;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.test.core.VertxTestBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.ClassRule;
import org.junit.Test;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.utility.DockerImageName;

public class SqlClientTest
extends VertxTestBase {
    protected static final List<String> NAMES = Arrays.asList("John", "Paul", "Peter", "Andrew", "Peter", "Steven");
    @ClassRule
    public static final PostgreSQLContainer<?> container = new PostgreSQLContainer(DockerImageName.parse((String)"postgres:10.10"));
    protected PgPool pool;

    public void setUp() throws Exception {
        super.setUp();
        PgConnectOptions connectOptions = new PgConnectOptions();
        connectOptions.setHost(container.getHost());
        connectOptions.setPort(container.getMappedPort(5432).intValue());
        connectOptions.setDatabase(container.getDatabaseName());
        connectOptions.setUser(container.getUsername());
        connectOptions.setPassword(container.getPassword());
        this.pool = PgPool.newInstance((io.vertx.pgclient.PgPool)io.vertx.pgclient.PgPool.pool((PgConnectOptions)connectOptions, (PoolOptions)new PoolOptions()));
        this.pool.query("drop table if exists folks").rxExecute().flatMap(res -> this.pool.query("create table folks (firstname varchar(255) not null)").rxExecute()).flatMap(res -> this.pool.preparedQuery("insert into folks (firstname) values ($1)").rxExecuteBatch(NAMES.stream().map(Tuple::of).collect(Collectors.toList()))).blockingGet();
    }

    public void tearDown() throws Exception {
        this.pool.close();
    }

    @Test
    public void testStream() {
        Maybe single = this.pool.rxWithTransaction(conn -> conn.rxPrepare("SELECT * FROM folks").flatMapPublisher(pq -> pq.createStream(2).toFlowable()).collect(ArrayList::new, (l, r) -> l.add(r.getString(0))).toMaybe());
        single.subscribe(list -> {
            this.assertEquals(list, NAMES);
            this.testComplete();
        }, arg_0 -> ((SqlClientTest)this).fail(arg_0));
        this.await();
    }
}

