/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.jdbcclient;

import io.reactivex.Flowable;
import io.reactivex.Maybe;
import io.reactivex.Single;
import io.reactivex.observers.TestObserver;
import io.reactivex.subscribers.TestSubscriber;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.reactivex.jdbcclient.JDBCPool;
import io.vertx.reactivex.sqlclient.Row;
import io.vertx.reactivex.sqlclient.RowSet;
import io.vertx.reactivex.sqlclient.SqlClient;
import io.vertx.reactivex.sqlclient.SqlConnection;
import io.vertx.test.core.VertxTestBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Test;

public class JDBCTest
extends VertxTestBase {
    protected static final List<String> NAMES = Arrays.asList("John", "Paul", "Peter", "Andrew", "Peter", "Steven");
    protected static final String UNIQUE_NAMES_SQL = "select distinct firstname from folks order by firstname asc";
    protected static final String INSERT_FOLK_SQL = "insert into folks (firstname) values ('%s')";
    private static final JsonObject config = new JsonObject().put("driver_class", (Object)"org.hsqldb.jdbcDriver").put("url", (Object)"jdbc:hsqldb:mem:test?shutdown=true");
    protected JDBCPool client;

    public void setUp() throws Exception {
        super.setUp();
        this.client = JDBCPool.pool((io.vertx.reactivex.core.Vertx)io.vertx.reactivex.core.Vertx.newInstance((Vertx)this.vertx), (JsonObject)config);
        this.client.rxGetConnection().flatMapCompletable(conn -> {
            Single setup = conn.query("drop table folks if exists").rxExecute().flatMap(res -> conn.query("create table folks (firstname varchar(255) not null)").rxExecute());
            for (String name : NAMES) {
                setup = setup.flatMap(res -> conn.query(String.format(INSERT_FOLK_SQL, name)).rxExecute());
            }
            return setup.ignoreElement().doFinally(() -> ((SqlConnection)conn).close());
        }).blockingAwait();
    }

    @Test
    public void testWithTransactionSuccess() throws Exception {
        ((TestObserver)this.withTransaction(null).test().await()).assertValue(this.namesWithExtraFolks());
    }

    @Test
    public void testWithTransactionFailure() throws Exception {
        Exception error = new Exception();
        ((TestObserver)this.withTransaction(error).test().await()).assertFailure(err -> error == err, (Object[])new List[0]);
        this.assertTableContainsInitDataOnly();
    }

    private Maybe<List<String>> withTransaction(Exception e) {
        return this.client.rxWithTransaction(sqlClient -> this.rxInsertExtraFolks((SqlClient)sqlClient).flatMapPublisher(res -> this.uniqueNames((SqlClient)sqlClient)).collect(ArrayList::new, List::add).compose(upstream -> e == null ? upstream : upstream.flatMap(names -> Single.error((Throwable)e))).toMaybe());
    }

    protected Single<RowSet<Row>> rxInsertExtraFolks(SqlClient conn) {
        return conn.query(String.format(INSERT_FOLK_SQL, "Georges")).rxExecute().flatMap(res -> conn.query(String.format(INSERT_FOLK_SQL, "Henry")).rxExecute());
    }

    protected Flowable<String> uniqueNames(SqlClient conn) {
        return conn.query(UNIQUE_NAMES_SQL).rxExecute().flatMapPublisher(Flowable::fromIterable).map(row -> row.getString(0));
    }

    protected void assertTableContainsInitDataOnly() throws Exception {
        ((TestSubscriber)((TestSubscriber)this.client.rxGetConnection().flatMapPublisher(conn -> this.uniqueNames((SqlClient)conn).doFinally(() -> ((SqlConnection)conn).close())).test().await()).assertComplete()).assertValueSequence((Iterable)NAMES.stream().sorted().distinct().collect(Collectors.toList()));
    }

    protected List<String> namesWithExtraFolks() {
        return Stream.concat(NAMES.stream(), Stream.of("Georges", "Henry")).sorted().distinct().collect(Collectors.toList());
    }

    public void tearDown() throws Exception {
        this.client.rxClose().blockingAwait();
    }
}

