/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.ext.sql;

import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.Flowable;
import io.reactivex.subscribers.TestSubscriber;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.reactivex.ext.jdbc.JDBCClient;
import io.vertx.reactivex.ext.sql.SQLClient;
import io.vertx.reactivex.ext.sql.SQLConnection;
import io.vertx.test.core.VertxTestBase;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;

public abstract class SQLTestBase
extends VertxTestBase {
    protected static final List<String> NAMES = Arrays.asList("John", "Paul", "Peter", "Andrew", "Peter", "Steven");
    protected static final String UNIQUE_NAMES_SQL = "select distinct firstname from folks order by firstname asc";
    protected static final String INSERT_FOLK_SQL = "insert into folks (firstname) values ('%s')";
    private static final JsonObject config = new JsonObject().put("driver_class", (Object)"org.hsqldb.jdbcDriver").put("url", (Object)"jdbc:hsqldb:mem:test?shutdown=true");
    protected SQLClient client;

    public void setUp() throws Exception {
        super.setUp();
        this.client = new JDBCClient(io.vertx.ext.jdbc.JDBCClient.create((Vertx)this.vertx, (JsonObject)config));
        this.client.rxGetConnection().flatMapCompletable(conn -> {
            Completable setup = conn.rxExecute("drop table folks if exists").andThen((CompletableSource)conn.rxExecute("create table folks (firstname varchar(255) not null)"));
            for (String name : NAMES) {
                setup = setup.andThen((CompletableSource)conn.rxExecute(String.format(INSERT_FOLK_SQL, name)));
            }
            return setup.doFinally(() -> ((SQLConnection)conn).close());
        }).blockingAwait();
    }

    protected void assertTableContainsInitDataOnly() throws Exception {
        ((TestSubscriber)((TestSubscriber)this.client.rxGetConnection().flatMapPublisher(conn -> this.uniqueNames((SQLConnection)conn).doFinally(() -> ((SQLConnection)conn).close())).test().await()).assertComplete()).assertValueSequence((Iterable)NAMES.stream().sorted().distinct().collect(Collectors.toList()));
    }

    protected Flowable<String> uniqueNames(SQLConnection conn) {
        return conn.rxQuery(UNIQUE_NAMES_SQL).flatMapPublisher(resultSet -> Flowable.fromIterable((Iterable)resultSet.getResults())).map(row -> row.getString(0));
    }

    protected Completable rxInsertExtraFolks(SQLConnection conn) {
        return conn.rxExecute(String.format(INSERT_FOLK_SQL, "Georges")).andThen((CompletableSource)conn.rxExecute(String.format(INSERT_FOLK_SQL, "Henry")));
    }

    protected List<String> namesWithExtraFolks() {
        return Stream.concat(NAMES.stream(), Stream.of("Georges", "Henry")).sorted().distinct().collect(Collectors.toList());
    }

    protected Completable rxAssertEquals(Object expected, Object actual) {
        Completable completable;
        try {
            Assert.assertEquals((Object)expected, (Object)actual);
            completable = Completable.complete();
        }
        catch (AssertionError error) {
            completable = Completable.error((Throwable)((Object)error));
        }
        return completable;
    }

    protected Completable rxAssertAutoCommit(SQLConnection conn) {
        String testName = UUID.randomUUID().toString();
        return conn.rxExecute(String.format(INSERT_FOLK_SQL, testName)).andThen((CompletableSource)this.client.rxGetConnection().flatMapCompletable(other -> this.uniqueNames((SQLConnection)other).contains((Object)testName).flatMapCompletable(contains -> {
            if (contains.booleanValue()) {
                return Completable.complete();
            }
            return Completable.error((Throwable)((Object)new AssertionError((Object)"Connection should be back in autocommit mode")));
        }).doFinally(() -> ((SQLConnection)other).close())));
    }

    public void tearDown() throws Exception {
        this.client.rxClose().blockingAwait();
    }
}

