/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.it.discovery;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.it.discovery.ServiceDiscoveryTest;
import io.vertx.reactivex.core.AbstractVerticle;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.core.eventbus.EventBus;
import io.vertx.reactivex.core.eventbus.MessageConsumer;
import io.vertx.reactivex.core.http.HttpClient;
import io.vertx.reactivex.ext.jdbc.JDBCClient;
import io.vertx.reactivex.ext.mongo.MongoClient;
import io.vertx.reactivex.ext.web.client.WebClient;
import io.vertx.reactivex.it.discovery.service.HelloService;
import io.vertx.reactivex.redis.client.Redis;
import io.vertx.reactivex.servicediscovery.ServiceDiscovery;
import io.vertx.reactivex.servicediscovery.ServiceReference;
import io.vertx.reactivex.servicediscovery.types.EventBusService;
import io.vertx.reactivex.servicediscovery.types.HttpEndpoint;
import io.vertx.reactivex.servicediscovery.types.JDBCDataSource;
import io.vertx.reactivex.servicediscovery.types.MessageSource;
import io.vertx.reactivex.servicediscovery.types.MongoDataSource;
import io.vertx.reactivex.servicediscovery.types.RedisDataSource;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscoveryOptions;

public class MyRX2Verticle
extends AbstractVerticle {
    public void start() {
        ServiceDiscovery discovery = ServiceDiscovery.create((Vertx)this.vertx, (ServiceDiscoveryOptions)ServiceDiscoveryTest.DISCOVERY_OPTIONS);
        EventBus eb = this.vertx.eventBus();
        eb.consumer("http-ref", message -> discovery.getRecord(rec -> rec.getName().equalsIgnoreCase("my-http-service"), ar -> {
            if (ar.failed()) {
                message.fail(0, "FAIL - No service");
            } else {
                JsonObject result = new JsonObject();
                ServiceReference reference = discovery.getReference((Record)ar.result());
                if (reference == null) {
                    message.fail(0, "FAIL - reference is null");
                } else {
                    HttpClient client = (HttpClient)reference.getAs(HttpClient.class);
                    result.put("client", (Object)client.getClass().toString());
                    reference.release();
                    result.put("bindings", (Object)this.getBindings(discovery));
                    message.reply((Object)result);
                }
            }
        }));
        eb.consumer("http-sugar", message -> {
            JsonObject result = new JsonObject();
            HttpEndpoint.getClient((ServiceDiscovery)discovery, record -> record.getName().equalsIgnoreCase("my-http-service"), ar -> {
                if (ar.failed()) {
                    message.fail(0, "FAIL - no service");
                } else {
                    HttpClient client = (HttpClient)ar.result();
                    result.put("client", (Object)client.getClass().toString());
                    ServiceDiscovery.releaseServiceObject((ServiceDiscovery)discovery, (Object)client);
                    result.put("bindings", (Object)this.getBindings(discovery));
                    message.reply((Object)result);
                }
            });
        });
        eb.consumer("web-ref", message -> discovery.getRecord(rec -> rec.getName().equalsIgnoreCase("my-http-service"), ar -> {
            if (ar.failed()) {
                message.fail(0, "FAIL - No service");
            } else {
                JsonObject result = new JsonObject();
                ServiceReference reference = discovery.getReference((Record)ar.result());
                if (reference == null) {
                    message.fail(0, "FAIL - reference is null");
                } else {
                    WebClient client = (WebClient)reference.getAs(WebClient.class);
                    result.put("client", (Object)client.getClass().toString());
                    reference.release();
                    result.put("bindings", (Object)this.getBindings(discovery));
                    message.reply((Object)result);
                }
            }
        }));
        eb.consumer("web-sugar", message -> {
            JsonObject result = new JsonObject();
            HttpEndpoint.getWebClient((ServiceDiscovery)discovery, record -> record.getName().equalsIgnoreCase("my-http-service"), ar -> {
                if (ar.failed()) {
                    message.fail(0, "FAIL - no service");
                } else {
                    WebClient client = (WebClient)ar.result();
                    result.put("client", (Object)client.getClass().toString());
                    ServiceDiscovery.releaseServiceObject((ServiceDiscovery)discovery, (Object)client);
                    result.put("bindings", (Object)this.getBindings(discovery));
                    message.reply((Object)result);
                }
            });
        });
        eb.consumer("service-ref", message -> discovery.getRecord(rec -> rec.getName().equalsIgnoreCase("my-service"), ar -> {
            if (ar.failed()) {
                message.fail(0, "FAIL - No service");
            } else {
                JsonObject result = new JsonObject();
                ServiceReference reference = discovery.getReference((Record)ar.result());
                if (reference == null) {
                    message.fail(0, "FAIL - reference is null");
                } else {
                    HelloService client = (HelloService)reference.getAs(HelloService.class);
                    result.put("client", (Object)client.getClass().toString());
                    reference.release();
                    result.put("bindings", (Object)this.getBindings(discovery));
                    message.reply((Object)result);
                }
            }
        }));
        eb.consumer("service-sugar", message -> {
            JsonObject result = new JsonObject();
            EventBusService.getServiceProxy((ServiceDiscovery)discovery, record -> record.getName().equalsIgnoreCase("my-service"), HelloService.class, ar -> {
                if (ar.failed()) {
                    message.fail(0, "FAIL - no service");
                } else {
                    HelloService client = (HelloService)ar.result();
                    result.put("client", (Object)client.getClass().toString());
                    ServiceDiscovery.releaseServiceObject((ServiceDiscovery)discovery, (Object)client);
                    result.put("bindings", (Object)this.getBindings(discovery));
                    message.reply((Object)result);
                }
            });
        });
        eb.consumer("ds-ref", message -> discovery.getRecord(rec -> rec.getName().equalsIgnoreCase("my-data-source"), ar -> {
            if (ar.failed()) {
                message.fail(0, "FAIL - No service");
            } else {
                JsonObject result = new JsonObject();
                ServiceReference reference = discovery.getReference((Record)ar.result());
                if (reference == null) {
                    message.fail(0, "FAIL - reference is null");
                } else {
                    JDBCClient client = (JDBCClient)reference.getAs(JDBCClient.class);
                    result.put("client", (Object)client.getClass().toString());
                    reference.release();
                    result.put("bindings", (Object)this.getBindings(discovery));
                    message.reply((Object)result);
                }
            }
        }));
        eb.consumer("ds-sugar", message -> {
            JsonObject result = new JsonObject();
            JDBCDataSource.getJDBCClient((ServiceDiscovery)discovery, record -> record.getName().equalsIgnoreCase("my-data-source"), ar -> {
                if (ar.failed()) {
                    message.fail(0, "FAIL - no service");
                } else {
                    JDBCClient client = (JDBCClient)ar.result();
                    result.put("client", (Object)client.getClass().toString());
                    ServiceDiscovery.releaseServiceObject((ServiceDiscovery)discovery, (Object)client);
                    result.put("bindings", (Object)this.getBindings(discovery));
                    message.reply((Object)result);
                }
            });
        });
        eb.consumer("redis-ref", message -> discovery.getRecord(rec -> rec.getName().equalsIgnoreCase("my-redis-data-source"), ar -> {
            if (ar.failed()) {
                message.fail(0, "FAIL - No service");
            } else {
                JsonObject result = new JsonObject();
                ServiceReference reference = discovery.getReference((Record)ar.result());
                if (reference == null) {
                    message.fail(0, "FAIL - reference is null");
                } else {
                    Redis client = (Redis)reference.getAs(Redis.class);
                    result.put("client", (Object)client.getClass().toString());
                    reference.release();
                    result.put("bindings", (Object)this.getBindings(discovery));
                    message.reply((Object)result);
                }
            }
        }));
        eb.consumer("redis-sugar", message -> {
            JsonObject result = new JsonObject();
            RedisDataSource.getRedisClient((ServiceDiscovery)discovery, record -> record.getName().equalsIgnoreCase("my-redis-data-source"), ar -> {
                if (ar.failed()) {
                    message.fail(0, "FAIL - no service");
                } else {
                    Redis client = (Redis)ar.result();
                    result.put("client", (Object)client.getClass().toString());
                    ServiceDiscovery.releaseServiceObject((ServiceDiscovery)discovery, (Object)client);
                    result.put("bindings", (Object)this.getBindings(discovery));
                    message.reply((Object)result);
                }
            });
        });
        eb.consumer("mongo-ref", message -> discovery.getRecord(rec -> rec.getName().equalsIgnoreCase("my-mongo-data-source"), ar -> {
            if (ar.failed()) {
                message.fail(0, "FAIL - No service");
            } else {
                JsonObject result = new JsonObject();
                ServiceReference reference = discovery.getReference((Record)ar.result());
                if (reference == null) {
                    message.fail(0, "FAIL - reference is null");
                } else {
                    MongoClient client = (MongoClient)reference.getAs(MongoClient.class);
                    result.put("client", (Object)client.getClass().toString());
                    reference.release();
                    result.put("bindings", (Object)this.getBindings(discovery));
                    message.reply((Object)result);
                }
            }
        }));
        eb.consumer("mongo-sugar", message -> {
            JsonObject result = new JsonObject();
            MongoDataSource.getMongoClient((ServiceDiscovery)discovery, record -> record.getName().equalsIgnoreCase("my-mongo-data-source"), ar -> {
                if (ar.failed()) {
                    message.fail(0, "FAIL - no service");
                } else {
                    MongoClient client = (MongoClient)ar.result();
                    result.put("client", (Object)client.getClass().toString());
                    ServiceDiscovery.releaseServiceObject((ServiceDiscovery)discovery, (Object)client);
                    result.put("bindings", (Object)this.getBindings(discovery));
                    message.reply((Object)result);
                }
            });
        });
        eb.consumer("source1-ref", message -> discovery.getRecord(rec -> rec.getName().equalsIgnoreCase("my-message-source-1"), ar -> {
            if (ar.failed()) {
                message.fail(0, "FAIL - No service");
            } else {
                JsonObject result = new JsonObject();
                ServiceReference reference = discovery.getReference((Record)ar.result());
                if (reference == null) {
                    message.fail(0, "FAIL - reference is null");
                } else {
                    MessageConsumer client = (MessageConsumer)reference.getAs(MessageConsumer.class);
                    result.put("client", (Object)client.getClass().toString());
                    reference.release();
                    result.put("bindings", (Object)this.getBindings(discovery));
                    message.reply((Object)result);
                }
            }
        }));
        eb.consumer("source1-sugar", message -> {
            JsonObject result = new JsonObject();
            MessageSource.getConsumer((ServiceDiscovery)discovery, record -> record.getName().equalsIgnoreCase("my-message-source-1"), ar -> {
                if (ar.failed()) {
                    message.fail(0, "FAIL - no service");
                } else {
                    MessageConsumer client = (MessageConsumer)ar.result();
                    result.put("client", (Object)client.getClass().toString());
                    ServiceDiscovery.releaseServiceObject((ServiceDiscovery)discovery, (Object)client);
                    result.put("bindings", (Object)this.getBindings(discovery));
                    message.reply((Object)result);
                }
            });
        });
    }

    private synchronized JsonArray getBindings(ServiceDiscovery discovery) {
        JsonArray array = new JsonArray();
        for (ServiceReference ref : discovery.bindings()) {
            array.add((Object)ref.toString());
        }
        return array;
    }
}

