/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.reactivex.tests.web;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;


@RxGen(io.vertx.reactivex.tests.web.TestRouteHandler.class)
public class TestRouteHandler implements RxDelegate, Handler<io.vertx.reactivex.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TestRouteHandler that = (TestRouteHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<TestRouteHandler> __TYPE_ARG = new TypeArg<>(    obj -> new TestRouteHandler((io.vertx.reactivex.tests.web.TestRouteHandler) obj),
    TestRouteHandler::getDelegate
  );

  private final io.vertx.reactivex.tests.web.TestRouteHandler delegate;
  
  public TestRouteHandler(io.vertx.reactivex.tests.web.TestRouteHandler delegate) {
    this.delegate = delegate;
  }

  public TestRouteHandler(Object delegate) {
    this.delegate = (io.vertx.reactivex.tests.web.TestRouteHandler)delegate;
  }

  @Override 
  public io.vertx.reactivex.tests.web.TestRouteHandler getDelegate() {
    return delegate;
  }

  public void handle(io.vertx.reactivex.ext.web.RoutingContext arg0) { 
    delegate.handle(arg0.getDelegate());
  }

  public static io.vertx.reactivex.reactivex.tests.web.TestRouteHandler create() { 
    io.vertx.reactivex.reactivex.tests.web.TestRouteHandler ret = io.vertx.reactivex.reactivex.tests.web.TestRouteHandler.newInstance((io.vertx.reactivex.tests.web.TestRouteHandler)io.vertx.reactivex.tests.web.TestRouteHandler.create());
    return ret;
  }

  public static TestRouteHandler newInstance(io.vertx.reactivex.tests.web.TestRouteHandler arg) {
    return arg != null ? new TestRouteHandler(arg) : null;
  }

}
