/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.sqlclient;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An iterator for processing rows.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.RowIterator original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.sqlclient.RowIterator.class)
public class RowIterator<R> implements RxDelegate, Iterator<R> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RowIterator that = (RowIterator) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<RowIterator> __TYPE_ARG = new TypeArg<>(    obj -> new RowIterator((io.vertx.sqlclient.RowIterator) obj),
    RowIterator::getDelegate
  );

  private final io.vertx.sqlclient.RowIterator<R> delegate;
  public final TypeArg<R> __typeArg_0;
  
  public RowIterator(io.vertx.sqlclient.RowIterator delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();  }

  public RowIterator(Object delegate, TypeArg<R> typeArg_0) {
    this.delegate = (io.vertx.sqlclient.RowIterator)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  @Override 
  public io.vertx.sqlclient.RowIterator getDelegate() {
    return delegate;
  }

  public boolean hasNext() { 
    boolean ret = delegate.hasNext();
    return ret;
  }

  public R next() { 
    R ret = (R)__typeArg_0.wrap(delegate.next());
    return ret;
  }

  public static <R> RowIterator<R> newInstance(io.vertx.sqlclient.RowIterator arg) {
    return arg != null ? new RowIterator<R>(arg) : null;
  }

  public static <R> RowIterator<R> newInstance(io.vertx.sqlclient.RowIterator arg, TypeArg<R> __typeArg_R) {
    return arg != null ? new RowIterator<R>(arg, __typeArg_R) : null;
  }

}
