/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.openapi.contract;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A Security requirement is an object that contains the names of the security schemes that apply to the operation.
 * Each name has a list of scopes that apply to the operation.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.openapi.contract.SecurityRequirement original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.openapi.contract.SecurityRequirement.class)
public class SecurityRequirement implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SecurityRequirement that = (SecurityRequirement) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<SecurityRequirement> __TYPE_ARG = new TypeArg<>(    obj -> new SecurityRequirement((io.vertx.openapi.contract.SecurityRequirement) obj),
    SecurityRequirement::getDelegate
  );

  private final io.vertx.openapi.contract.SecurityRequirement delegate;
  
  public SecurityRequirement(io.vertx.openapi.contract.SecurityRequirement delegate) {
    this.delegate = delegate;
  }

  public SecurityRequirement(Object delegate) {
    this.delegate = (io.vertx.openapi.contract.SecurityRequirement)delegate;
  }

  @Override 
  public io.vertx.openapi.contract.SecurityRequirement getDelegate() {
    return delegate;
  }


  /**
   * How many requirements are present
   * @return size
   */
  public int size() { 
    int ret = delegate.size();
    return ret;
  }

  /**
   * Return the name at a given index
   * @return name
   */
  public java.util.Set<java.lang.String> getNames() { 
    java.util.Set<java.lang.String> ret = delegate.getNames();
    return ret;
  }

  /**
   * Return the scopes for a given name
   * @param name 
   * @return name
   */
  public java.util.List<java.lang.String> getScopes(java.lang.String name) { 
    java.util.List<java.lang.String> ret = delegate.getScopes(name);
    return ret;
  }

  public boolean isEmpty() { 
    boolean ret = delegate.isEmpty();
    return ret;
  }

  public static SecurityRequirement newInstance(io.vertx.openapi.contract.SecurityRequirement arg) {
    return arg != null ? new SecurityRequirement(arg) : null;
  }

}
