/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.openapi.contract;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;


@RxGen(io.vertx.openapi.contract.Response.class)
public class Response implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Response that = (Response) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Response> __TYPE_ARG = new TypeArg<>(    obj -> new Response((io.vertx.openapi.contract.Response) obj),
    Response::getDelegate
  );

  private final io.vertx.openapi.contract.Response delegate;
  
  public Response(io.vertx.openapi.contract.Response delegate) {
    this.delegate = delegate;
  }

  public Response(Object delegate) {
    this.delegate = (io.vertx.openapi.contract.Response)delegate;
  }

  @Override 
  public io.vertx.openapi.contract.Response getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.openapi.contract.Parameter> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.openapi.contract.Parameter>(o1 -> io.vertx.reactivex.openapi.contract.Parameter.newInstance((io.vertx.openapi.contract.Parameter)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.openapi.contract.MediaType> TYPE_ARG_1 = new TypeArg<io.vertx.reactivex.openapi.contract.MediaType>(o1 -> io.vertx.reactivex.openapi.contract.MediaType.newInstance((io.vertx.openapi.contract.MediaType)o1), o1 -> o1.getDelegate());

  /**
   * @return the headers of the response.
   */
  public java.util.List<io.vertx.reactivex.openapi.contract.Parameter> getHeaders() { 
    java.util.List<io.vertx.reactivex.openapi.contract.Parameter> ret = delegate.getHeaders().stream().map(elt -> io.vertx.reactivex.openapi.contract.Parameter.newInstance((io.vertx.openapi.contract.Parameter)elt)).collect(Collectors.toList());
    return ret;
  }

  /**
   * @return a map containing descriptions of potential response payloads. The key is a media type or media type range and the value describes it.
   */
  public java.util.Map<java.lang.String,io.vertx.reactivex.openapi.contract.MediaType> getContent() { 
    java.util.Map<java.lang.String,io.vertx.reactivex.openapi.contract.MediaType> ret = delegate.getContent().entrySet().stream().collect(Collectors.toMap(_e -> _e.getKey(), _e -> io.vertx.reactivex.openapi.contract.MediaType.newInstance((io.vertx.openapi.contract.MediaType)_e.getValue())));
    return ret;
  }

  public static Response newInstance(io.vertx.openapi.contract.Response arg) {
    return arg != null ? new Response(arg) : null;
  }

}
