/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.openapi.contract;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * This interface represents the most important attributes of an OpenAPI Operation.
 * <br>
 * <a href="https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.1.0.md#operation-Object">Operation V3.1</a>
 * <br>
 * <a href="https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.3.md#operation-Object">Operation V3.0</a>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.openapi.contract.Operation original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.openapi.contract.Operation.class)
public class Operation implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Operation that = (Operation) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Operation> __TYPE_ARG = new TypeArg<>(    obj -> new Operation((io.vertx.openapi.contract.Operation) obj),
    Operation::getDelegate
  );

  private final io.vertx.openapi.contract.Operation delegate;
  
  public Operation(io.vertx.openapi.contract.Operation delegate) {
    this.delegate = delegate;
  }

  public Operation(Object delegate) {
    this.delegate = (io.vertx.openapi.contract.Operation)delegate;
  }

  @Override 
  public io.vertx.openapi.contract.Operation getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.openapi.contract.Parameter> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.openapi.contract.Parameter>(o1 -> io.vertx.reactivex.openapi.contract.Parameter.newInstance((io.vertx.openapi.contract.Parameter)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.openapi.contract.SecurityRequirement> TYPE_ARG_1 = new TypeArg<io.vertx.reactivex.openapi.contract.SecurityRequirement>(o1 -> io.vertx.reactivex.openapi.contract.SecurityRequirement.newInstance((io.vertx.openapi.contract.SecurityRequirement)o1), o1 -> o1.getDelegate());

  /**
   * @return operationId of this operation
   */
  public java.lang.String getOperationId() { 
    java.lang.String ret = delegate.getOperationId();
    return ret;
  }

  /**
   * @return http method of this operation
   */
  public io.vertx.core.http.HttpMethod getHttpMethod() { 
    io.vertx.core.http.HttpMethod ret = delegate.getHttpMethod();
    return ret;
  }

  /**
   * @return path in OpenAPI style
   */
  public java.lang.String getOpenAPIPath() { 
    java.lang.String ret = delegate.getOpenAPIPath();
    return ret;
  }

  /**
   * @return absolute path in OpenAPI style
   */
  public java.lang.String getAbsoluteOpenAPIPath() { 
    java.lang.String ret = delegate.getAbsoluteOpenAPIPath();
    return ret;
  }

  /**
   * @return tags of this operation
   */
  public java.util.List<java.lang.String> getTags() { 
    java.util.List<java.lang.String> ret = delegate.getTags();
    return ret;
  }

  /**
   * @return parameters of this operation
   */
  public java.util.List<io.vertx.reactivex.openapi.contract.Parameter> getParameters() { 
    java.util.List<io.vertx.reactivex.openapi.contract.Parameter> ret = delegate.getParameters().stream().map(elt -> io.vertx.reactivex.openapi.contract.Parameter.newInstance((io.vertx.openapi.contract.Parameter)elt)).collect(Collectors.toList());
    return ret;
  }

  /**
   * @return request body of the operation, or null if no request body is defined
   */
  public io.vertx.reactivex.openapi.contract.RequestBody getRequestBody() { 
    io.vertx.reactivex.openapi.contract.RequestBody ret = io.vertx.reactivex.openapi.contract.RequestBody.newInstance((io.vertx.openapi.contract.RequestBody)delegate.getRequestBody());
    return ret;
  }

  /**
   * @return the default response, or null if no default response is defined.
   */
  public io.vertx.reactivex.openapi.contract.Response getDefaultResponse() { 
    io.vertx.reactivex.openapi.contract.Response ret = io.vertx.reactivex.openapi.contract.Response.newInstance((io.vertx.openapi.contract.Response)delegate.getDefaultResponse());
    return ret;
  }

  /**
   * Returns the response to the passed response code or null.
   * @param responseCode The related response code
   * @return The related response, or null.
   */
  public io.vertx.reactivex.openapi.contract.Response getResponse(int responseCode) { 
    io.vertx.reactivex.openapi.contract.Response ret = io.vertx.reactivex.openapi.contract.Response.newInstance((io.vertx.openapi.contract.Response)delegate.getResponse(responseCode));
    return ret;
  }

  /**
   * Returns the applicable list of security requirements (scopes) or empty list.
   * @return The related security requirement.
   */
  public java.util.List<io.vertx.reactivex.openapi.contract.SecurityRequirement> getSecurityRequirements() { 
    java.util.List<io.vertx.reactivex.openapi.contract.SecurityRequirement> ret = delegate.getSecurityRequirements().stream().map(elt -> io.vertx.reactivex.openapi.contract.SecurityRequirement.newInstance((io.vertx.openapi.contract.SecurityRequirement)elt)).collect(Collectors.toList());
    return ret;
  }

  public static Operation newInstance(io.vertx.openapi.contract.Operation arg) {
    return arg != null ? new Operation(arg) : null;
  }

}
