/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.openapi.contract;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents an OAuth Flow Object (the configuration).
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.openapi.contract.OAuthFlow original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.openapi.contract.OAuthFlow.class)
public class OAuthFlow implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OAuthFlow that = (OAuthFlow) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<OAuthFlow> __TYPE_ARG = new TypeArg<>(    obj -> new OAuthFlow((io.vertx.openapi.contract.OAuthFlow) obj),
    OAuthFlow::getDelegate
  );

  private final io.vertx.openapi.contract.OAuthFlow delegate;
  
  public OAuthFlow(io.vertx.openapi.contract.OAuthFlow delegate) {
    this.delegate = delegate;
  }

  public OAuthFlow(Object delegate) {
    this.delegate = (io.vertx.openapi.contract.OAuthFlow)delegate;
  }

  @Override 
  public io.vertx.openapi.contract.OAuthFlow getDelegate() {
    return delegate;
  }


  /**
   * The authorization URL to be used for this flow. This MUST be in the form of a URL.
   * The OAuth2 standard requires the use of TLS.
   * @return 
   */
  public java.lang.String getAuthorizationUrl() { 
    java.lang.String ret = delegate.getAuthorizationUrl();
    return ret;
  }

  /**
   * The token URL to be used for this flow. This MUST be in the form of a URL.
   * The OAuth2 standard requires the use of TLS.
   * @return 
   */
  public java.lang.String getTokenUrl() { 
    java.lang.String ret = delegate.getTokenUrl();
    return ret;
  }

  /**
   * The URL to be used for obtaining refresh tokens. This MUST be in the form of a URL.
   * The OAuth2 standard requires the use of TLS.
   * @return 
   */
  public java.lang.String getRefreshUrl() { 
    java.lang.String ret = delegate.getRefreshUrl();
    return ret;
  }

  /**
   * The available scopes for the OAuth2 security scheme. A set of the scope names.
   * The set MAY be empty.
   * @return 
   */
  public java.util.Set<java.lang.String> getScopes() { 
    java.util.Set<java.lang.String> ret = delegate.getScopes();
    return ret;
  }

  public static OAuthFlow newInstance(io.vertx.openapi.contract.OAuthFlow arg) {
    return arg != null ? new OAuthFlow(arg) : null;
  }

}
