/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.grpc.common;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Bundle all the bits required to call or bind a grpc service method.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.grpc.common.ServiceMethod original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.grpc.common.ServiceMethod.class)
public class ServiceMethod<I,O> implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ServiceMethod that = (ServiceMethod) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ServiceMethod> __TYPE_ARG = new TypeArg<>(    obj -> new ServiceMethod((io.vertx.grpc.common.ServiceMethod) obj),
    ServiceMethod::getDelegate
  );

  private final io.vertx.grpc.common.ServiceMethod<I,O> delegate;
  public final TypeArg<I> __typeArg_0;
  public final TypeArg<O> __typeArg_1;
  
  public ServiceMethod(io.vertx.grpc.common.ServiceMethod delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();    this.__typeArg_1 = TypeArg.unknown();  }

  public ServiceMethod(Object delegate, TypeArg<I> typeArg_0, TypeArg<O> typeArg_1) {
    this.delegate = (io.vertx.grpc.common.ServiceMethod)delegate;
    this.__typeArg_0 = typeArg_0;
    this.__typeArg_1 = typeArg_1;
  }

  @Override 
  public io.vertx.grpc.common.ServiceMethod getDelegate() {
    return delegate;
  }


  public static <Req, Resp> io.vertx.reactivex.grpc.common.ServiceMethod<Resp,Req> client(io.vertx.reactivex.grpc.common.ServiceName serviceName, java.lang.String methodName, io.vertx.reactivex.grpc.common.GrpcMessageEncoder<Req> encoder, io.vertx.reactivex.grpc.common.GrpcMessageDecoder<Resp> decoder) { 
    io.vertx.reactivex.grpc.common.ServiceMethod<Resp,Req> ret = io.vertx.reactivex.grpc.common.ServiceMethod.newInstance((io.vertx.grpc.common.ServiceMethod)io.vertx.grpc.common.ServiceMethod.client(serviceName.getDelegate(), methodName, encoder.getDelegate(), decoder.getDelegate()), TypeArg.unknown(), TypeArg.unknown());
    return ret;
  }

  public static <Req, Resp> io.vertx.reactivex.grpc.common.ServiceMethod<Req,Resp> server(io.vertx.reactivex.grpc.common.ServiceName serviceName, java.lang.String methodName, io.vertx.reactivex.grpc.common.GrpcMessageEncoder<Resp> encoder, io.vertx.reactivex.grpc.common.GrpcMessageDecoder<Req> decoder) { 
    io.vertx.reactivex.grpc.common.ServiceMethod<Req,Resp> ret = io.vertx.reactivex.grpc.common.ServiceMethod.newInstance((io.vertx.grpc.common.ServiceMethod)io.vertx.grpc.common.ServiceMethod.server(serviceName.getDelegate(), methodName, encoder.getDelegate(), decoder.getDelegate()), TypeArg.unknown(), TypeArg.unknown());
    return ret;
  }

  /**
   * @return the service name.
   */
  public io.vertx.reactivex.grpc.common.ServiceName serviceName() { 
    io.vertx.reactivex.grpc.common.ServiceName ret = io.vertx.reactivex.grpc.common.ServiceName.newInstance((io.vertx.grpc.common.ServiceName)delegate.serviceName());
    return ret;
  }

  /**
   * @return the method name
   */
  public java.lang.String methodName() { 
    java.lang.String ret = delegate.methodName();
    return ret;
  }

  public java.lang.String fullMethodName() { 
    java.lang.String ret = delegate.fullMethodName();
    return ret;
  }

  /**
   * @return the message decoder
   */
  public io.vertx.reactivex.grpc.common.GrpcMessageDecoder<I> decoder() { 
    io.vertx.reactivex.grpc.common.GrpcMessageDecoder<I> ret = io.vertx.reactivex.grpc.common.GrpcMessageDecoder.newInstance((io.vertx.grpc.common.GrpcMessageDecoder)delegate.decoder(), __typeArg_0);
    return ret;
  }

  /**
   * @return the message encoder
   */
  public io.vertx.reactivex.grpc.common.GrpcMessageEncoder<O> encoder() { 
    io.vertx.reactivex.grpc.common.GrpcMessageEncoder<O> ret = io.vertx.reactivex.grpc.common.GrpcMessageEncoder.newInstance((io.vertx.grpc.common.GrpcMessageEncoder)delegate.encoder(), __typeArg_1);
    return ret;
  }

  public static <I,O> ServiceMethod<I,O> newInstance(io.vertx.grpc.common.ServiceMethod arg) {
    return arg != null ? new ServiceMethod<I,O>(arg) : null;
  }

  public static <I,O> ServiceMethod<I,O> newInstance(io.vertx.grpc.common.ServiceMethod arg, TypeArg<I> __typeArg_I, TypeArg<O> __typeArg_O) {
    return arg != null ? new ServiceMethod<I,O>(arg, __typeArg_I, __typeArg_O) : null;
  }

}
