/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A web user is extended user coupled to the context and is used to perform verifications
 * and actions on behalf of the user. Actions can be:
 *
 * <ul>
 *   <li>{@link io.vertx.reactivex.ext.web.UserContext#impersonate} - Require a re-authentication to switch user identities</li>
 *   <li>{@link io.vertx.reactivex.ext.web.UserContext#restore} - De-escalate a previous impersonate call</li>
 *   <li>{@link io.vertx.reactivex.ext.web.UserContext#logout} - Logout the user from this application and redirect to a uri</li>
 *   <li>{@link io.vertx.reactivex.ext.web.UserContext#clear} - Same as logout, without requirind a redirect</li>
 * </ul>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.UserContext original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.UserContext.class)
public class UserContext implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    UserContext that = (UserContext) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<UserContext> __TYPE_ARG = new TypeArg<>(    obj -> new UserContext((io.vertx.ext.web.UserContext) obj),
    UserContext::getDelegate
  );

  private final io.vertx.ext.web.UserContext delegate;
  
  public UserContext(io.vertx.ext.web.UserContext delegate) {
    this.delegate = delegate;
  }

  public UserContext(Object delegate) {
    this.delegate = (io.vertx.ext.web.UserContext)delegate;
  }

  @Override 
  public io.vertx.ext.web.UserContext getDelegate() {
    return delegate;
  }

  /**
   * Get the authenticated user (if any). This will usually be injected by an auth handler if authentication if successful.
   * @return the user, or null if the current user is not authenticated.
   */
  public io.vertx.reactivex.ext.auth.User get() { 
    io.vertx.reactivex.ext.auth.User ret = io.vertx.reactivex.ext.auth.User.newInstance((io.vertx.ext.auth.User)delegate.get());
    return ret;
  }

  public boolean authenticated() { 
    boolean ret = delegate.authenticated();
    return ret;
  }

  /**
   * When performing a web identity operation, hint if possible to the identity provider to use the given login.
   * @param loginHint the desired login name, for example: <code>admin</code>.
   * @return fluent self
   */
  public io.vertx.reactivex.ext.web.UserContext loginHint(java.lang.String loginHint) { 
    delegate.loginHint(loginHint);
    return this;
  }

  public void impersonate(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> callback) { 
    delegate.impersonate(callback);
  }

  public void impersonate() {
    impersonate(ar -> { });
  }

  public io.reactivex.Completable rxImpersonate() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      impersonate($handler);
    });
  }

  public void impersonate(java.lang.String redirectUri, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> callback) { 
    delegate.impersonate(redirectUri, callback);
  }

  public void impersonate(java.lang.String redirectUri) {
    impersonate(redirectUri, ar -> { });
  }

  public io.reactivex.Completable rxImpersonate(java.lang.String redirectUri) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      impersonate(redirectUri, $handler);
    });
  }

  public void restore(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> callback) { 
    delegate.restore(callback);
  }

  public void restore() {
    restore(ar -> { });
  }

  public io.reactivex.Completable rxRestore() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      restore($handler);
    });
  }

  public void restore(java.lang.String redirectUri, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> callback) { 
    delegate.restore(redirectUri, callback);
  }

  public void restore(java.lang.String redirectUri) {
    restore(redirectUri, ar -> { });
  }

  public io.reactivex.Completable rxRestore(java.lang.String redirectUri) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      restore(redirectUri, $handler);
    });
  }

  public void logout(java.lang.String redirectUri, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> callback) { 
    delegate.logout(redirectUri, callback);
  }

  public void logout(java.lang.String redirectUri) {
    logout(redirectUri, ar -> { });
  }

  public io.reactivex.Completable rxLogout(java.lang.String redirectUri) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      logout(redirectUri, $handler);
    });
  }

  public void logout(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> callback) { 
    delegate.logout(callback);
  }

  public void logout() {
    logout(ar -> { });
  }

  public io.reactivex.Completable rxLogout() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      logout($handler);
    });
  }

  /**
   * Clear can be called from any route handler which needs to terminate a login session. Invoking logout will remove
   * the {@link io.vertx.reactivex.ext.auth.User} and clear the {@link io.vertx.reactivex.ext.web.Session} (if any) in the current context. Unlike
   * {@link io.vertx.reactivex.ext.web.UserContext#logout} no redirect will be performed.
   */
  public void clear() { 
    delegate.clear();
  }

  public static UserContext newInstance(io.vertx.ext.web.UserContext arg) {
    return arg != null ? new UserContext(arg) : null;
  }

}
