/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.consul;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A Vert.x service used to interact with Consul.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.consul.ConsulClient original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.consul.ConsulClient.class)
public class ConsulClient implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ConsulClient that = (ConsulClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ConsulClient> __TYPE_ARG = new TypeArg<>(    obj -> new ConsulClient((io.vertx.ext.consul.ConsulClient) obj),
    ConsulClient::getDelegate
  );

  private final io.vertx.ext.consul.ConsulClient delegate;
  
  public ConsulClient(io.vertx.ext.consul.ConsulClient delegate) {
    this.delegate = delegate;
  }

  public ConsulClient(Object delegate) {
    this.delegate = (io.vertx.ext.consul.ConsulClient)delegate;
  }

  @Override 
  public io.vertx.ext.consul.ConsulClient getDelegate() {
    return delegate;
  }

  /**
   * Create a Consul client with default options.
   * @param vertx the Vert.x instance
   * @return the client
   */
  public static io.vertx.reactivex.ext.consul.ConsulClient create(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.ext.consul.ConsulClient ret = io.vertx.reactivex.ext.consul.ConsulClient.newInstance((io.vertx.ext.consul.ConsulClient)io.vertx.ext.consul.ConsulClient.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create a Consul client.
   * @param vertx the Vert.x instance
   * @param options the options
   * @return the client
   */
  public static io.vertx.reactivex.ext.consul.ConsulClient create(io.vertx.reactivex.core.Vertx vertx, io.vertx.ext.consul.ConsulClientOptions options) { 
    io.vertx.reactivex.ext.consul.ConsulClient ret = io.vertx.reactivex.ext.consul.ConsulClient.newInstance((io.vertx.ext.consul.ConsulClient)io.vertx.ext.consul.ConsulClient.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Returns the configuration and member information of the local agent
   * @param resultHandler will be provided with the configuration and member information of the local agent
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient agentInfo(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.core.json.JsonObject>> resultHandler) { 
    delegate.agentInfo(resultHandler);
    return this;
  }

  /**
   * Returns the configuration and member information of the local agent
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient agentInfo() {
    return 
agentInfo(ar -> { });
  }

  /**
   * Returns the configuration and member information of the local agent
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<io.vertx.core.json.JsonObject> rxAgentInfo() { 
    return AsyncResultSingle.toSingle($handler -> {
      agentInfo($handler);
    });
  }

  /**
   * Returns the LAN network coordinates for all nodes in a given DC
   * @param resultHandler will be provided with network coordinates of nodes in datacenter
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient coordinateNodes(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.consul.CoordinateList>> resultHandler) { 
    delegate.coordinateNodes(resultHandler);
    return this;
  }

  /**
   * Returns the LAN network coordinates for all nodes in a given DC
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient coordinateNodes() {
    return 
coordinateNodes(ar -> { });
  }

  /**
   * Returns the LAN network coordinates for all nodes in a given DC
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<io.vertx.ext.consul.CoordinateList> rxCoordinateNodes() { 
    return AsyncResultSingle.toSingle($handler -> {
      coordinateNodes($handler);
    });
  }

  /**
   * Returns the LAN network coordinates for all nodes in a given DC
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#coordinateNodes}
   * @param options the blocking options
   * @param resultHandler will be provided with network coordinates of nodes in datacenter
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient coordinateNodesWithOptions(io.vertx.ext.consul.BlockingQueryOptions options, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.consul.CoordinateList>> resultHandler) { 
    delegate.coordinateNodesWithOptions(options, resultHandler);
    return this;
  }

  /**
   * Returns the LAN network coordinates for all nodes in a given DC
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#coordinateNodes}
   * @param options the blocking options
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient coordinateNodesWithOptions(io.vertx.ext.consul.BlockingQueryOptions options) {
    return 
coordinateNodesWithOptions(options, ar -> { });
  }

  /**
   * Returns the LAN network coordinates for all nodes in a given DC
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#coordinateNodes}
   * @param options the blocking options
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<io.vertx.ext.consul.CoordinateList> rxCoordinateNodesWithOptions(io.vertx.ext.consul.BlockingQueryOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      coordinateNodesWithOptions(options, $handler);
    });
  }

  /**
   * Returns the WAN network coordinates for all Consul servers, organized by DCs
   * @param resultHandler will be provided with network coordinates for all Consul servers
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient coordinateDatacenters(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<io.vertx.ext.consul.DcCoordinates>>> resultHandler) { 
    delegate.coordinateDatacenters(resultHandler);
    return this;
  }

  /**
   * Returns the WAN network coordinates for all Consul servers, organized by DCs
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient coordinateDatacenters() {
    return 
coordinateDatacenters(ar -> { });
  }

  /**
   * Returns the WAN network coordinates for all Consul servers, organized by DCs
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<java.util.List<io.vertx.ext.consul.DcCoordinates>> rxCoordinateDatacenters() { 
    return AsyncResultSingle.toSingle($handler -> {
      coordinateDatacenters($handler);
    });
  }

  /**
   * Returns the list of keys that corresponding to the specified key prefix.
   * @param keyPrefix the prefix
   * @param resultHandler will be provided with keys list
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient getKeys(java.lang.String keyPrefix, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<java.lang.String>>> resultHandler) { 
    delegate.getKeys(keyPrefix, resultHandler);
    return this;
  }

  /**
   * Returns the list of keys that corresponding to the specified key prefix.
   * @param keyPrefix the prefix
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient getKeys(java.lang.String keyPrefix) {
    return 
getKeys(keyPrefix, ar -> { });
  }

  /**
   * Returns the list of keys that corresponding to the specified key prefix.
   * @param keyPrefix the prefix
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<java.util.List<java.lang.String>> rxGetKeys(java.lang.String keyPrefix) { 
    return AsyncResultSingle.toSingle($handler -> {
      getKeys(keyPrefix, $handler);
    });
  }

  /**
   * Returns the list of keys that corresponding to the specified key prefix.
   * @param keyPrefix the prefix
   * @param options the blocking options
   * @param resultHandler will be provided with keys list
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient getKeysWithOptions(java.lang.String keyPrefix, io.vertx.ext.consul.BlockingQueryOptions options, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<java.lang.String>>> resultHandler) { 
    delegate.getKeysWithOptions(keyPrefix, options, resultHandler);
    return this;
  }

  /**
   * Returns the list of keys that corresponding to the specified key prefix.
   * @param keyPrefix the prefix
   * @param options the blocking options
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient getKeysWithOptions(java.lang.String keyPrefix, io.vertx.ext.consul.BlockingQueryOptions options) {
    return 
getKeysWithOptions(keyPrefix, options, ar -> { });
  }

  /**
   * Returns the list of keys that corresponding to the specified key prefix.
   * @param keyPrefix the prefix
   * @param options the blocking options
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<java.util.List<java.lang.String>> rxGetKeysWithOptions(java.lang.String keyPrefix, io.vertx.ext.consul.BlockingQueryOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      getKeysWithOptions(keyPrefix, options, $handler);
    });
  }

  /**
   * Returns key/value pair that corresponding to the specified key.
   * An empty {@link io.vertx.ext.consul.KeyValue} object will be returned if no such key is found.
   * @param key the key
   * @param resultHandler will be provided with key/value pair
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient getValue(java.lang.String key, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.consul.KeyValue>> resultHandler) { 
    delegate.getValue(key, resultHandler);
    return this;
  }

  /**
   * Returns key/value pair that corresponding to the specified key.
   * An empty {@link io.vertx.ext.consul.KeyValue} object will be returned if no such key is found.
   * @param key the key
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient getValue(java.lang.String key) {
    return 
getValue(key, ar -> { });
  }

  /**
   * Returns key/value pair that corresponding to the specified key.
   * An empty {@link io.vertx.ext.consul.KeyValue} object will be returned if no such key is found.
   * @param key the key
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<io.vertx.ext.consul.KeyValue> rxGetValue(java.lang.String key) { 
    return AsyncResultSingle.toSingle($handler -> {
      getValue(key, $handler);
    });
  }

  /**
   * Returns key/value pair that corresponding to the specified key.
   * An empty {@link io.vertx.ext.consul.KeyValue} object will be returned if no such key is found.
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#getValue}
   * @param key the key
   * @param options the blocking options
   * @param resultHandler will be provided with key/value pair
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient getValueWithOptions(java.lang.String key, io.vertx.ext.consul.BlockingQueryOptions options, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.consul.KeyValue>> resultHandler) { 
    delegate.getValueWithOptions(key, options, resultHandler);
    return this;
  }

  /**
   * Returns key/value pair that corresponding to the specified key.
   * An empty {@link io.vertx.ext.consul.KeyValue} object will be returned if no such key is found.
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#getValue}
   * @param key the key
   * @param options the blocking options
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient getValueWithOptions(java.lang.String key, io.vertx.ext.consul.BlockingQueryOptions options) {
    return 
getValueWithOptions(key, options, ar -> { });
  }

  /**
   * Returns key/value pair that corresponding to the specified key.
   * An empty {@link io.vertx.ext.consul.KeyValue} object will be returned if no such key is found.
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#getValue}
   * @param key the key
   * @param options the blocking options
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<io.vertx.ext.consul.KeyValue> rxGetValueWithOptions(java.lang.String key, io.vertx.ext.consul.BlockingQueryOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      getValueWithOptions(key, options, $handler);
    });
  }

  /**
   * Remove the key/value pair that corresponding to the specified key
   * @param key the key
   * @param resultHandler will be called on complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient deleteValue(java.lang.String key, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.deleteValue(key, resultHandler);
    return this;
  }

  /**
   * Remove the key/value pair that corresponding to the specified key
   * @param key the key
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient deleteValue(java.lang.String key) {
    return 
deleteValue(key, ar -> { });
  }

  /**
   * Remove the key/value pair that corresponding to the specified key
   * @param key the key
   * @return reference to this, for fluency
   */
  public io.reactivex.Completable rxDeleteValue(java.lang.String key) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      deleteValue(key, $handler);
    });
  }

  /**
   * Returns the list of key/value pairs that corresponding to the specified key prefix.
   * An empty {@link io.vertx.ext.consul.KeyValueList} object will be returned if no such key prefix is found.
   * @param keyPrefix the prefix
   * @param resultHandler will be provided with list of key/value pairs
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient getValues(java.lang.String keyPrefix, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.consul.KeyValueList>> resultHandler) { 
    delegate.getValues(keyPrefix, resultHandler);
    return this;
  }

  /**
   * Returns the list of key/value pairs that corresponding to the specified key prefix.
   * An empty {@link io.vertx.ext.consul.KeyValueList} object will be returned if no such key prefix is found.
   * @param keyPrefix the prefix
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient getValues(java.lang.String keyPrefix) {
    return 
getValues(keyPrefix, ar -> { });
  }

  /**
   * Returns the list of key/value pairs that corresponding to the specified key prefix.
   * An empty {@link io.vertx.ext.consul.KeyValueList} object will be returned if no such key prefix is found.
   * @param keyPrefix the prefix
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<io.vertx.ext.consul.KeyValueList> rxGetValues(java.lang.String keyPrefix) { 
    return AsyncResultSingle.toSingle($handler -> {
      getValues(keyPrefix, $handler);
    });
  }

  /**
   * Returns the list of key/value pairs that corresponding to the specified key prefix.
   * An empty {@link io.vertx.ext.consul.KeyValueList} object will be returned if no such key prefix is found.
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#getValues}
   * @param keyPrefix the prefix
   * @param options the blocking options
   * @param resultHandler will be provided with list of key/value pairs
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient getValuesWithOptions(java.lang.String keyPrefix, io.vertx.ext.consul.BlockingQueryOptions options, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.consul.KeyValueList>> resultHandler) { 
    delegate.getValuesWithOptions(keyPrefix, options, resultHandler);
    return this;
  }

  /**
   * Returns the list of key/value pairs that corresponding to the specified key prefix.
   * An empty {@link io.vertx.ext.consul.KeyValueList} object will be returned if no such key prefix is found.
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#getValues}
   * @param keyPrefix the prefix
   * @param options the blocking options
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient getValuesWithOptions(java.lang.String keyPrefix, io.vertx.ext.consul.BlockingQueryOptions options) {
    return 
getValuesWithOptions(keyPrefix, options, ar -> { });
  }

  /**
   * Returns the list of key/value pairs that corresponding to the specified key prefix.
   * An empty {@link io.vertx.ext.consul.KeyValueList} object will be returned if no such key prefix is found.
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#getValues}
   * @param keyPrefix the prefix
   * @param options the blocking options
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<io.vertx.ext.consul.KeyValueList> rxGetValuesWithOptions(java.lang.String keyPrefix, io.vertx.ext.consul.BlockingQueryOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      getValuesWithOptions(keyPrefix, options, $handler);
    });
  }

  /**
   * Removes all the key/value pair that corresponding to the specified key prefix
   * @param keyPrefix the prefix
   * @param resultHandler will be called on complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient deleteValues(java.lang.String keyPrefix, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.deleteValues(keyPrefix, resultHandler);
    return this;
  }

  /**
   * Removes all the key/value pair that corresponding to the specified key prefix
   * @param keyPrefix the prefix
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient deleteValues(java.lang.String keyPrefix) {
    return 
deleteValues(keyPrefix, ar -> { });
  }

  /**
   * Removes all the key/value pair that corresponding to the specified key prefix
   * @param keyPrefix the prefix
   * @return reference to this, for fluency
   */
  public io.reactivex.Completable rxDeleteValues(java.lang.String keyPrefix) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      deleteValues(keyPrefix, $handler);
    });
  }

  /**
   * Adds specified key/value pair
   * @param key the key
   * @param value the value
   * @param resultHandler will be provided with success of operation
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient putValue(java.lang.String key, java.lang.String value, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Boolean>> resultHandler) { 
    delegate.putValue(key, value, resultHandler);
    return this;
  }

  /**
   * Adds specified key/value pair
   * @param key the key
   * @param value the value
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient putValue(java.lang.String key, java.lang.String value) {
    return 
putValue(key, value, ar -> { });
  }

  /**
   * Adds specified key/value pair
   * @param key the key
   * @param value the value
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<java.lang.Boolean> rxPutValue(java.lang.String key, java.lang.String value) { 
    return AsyncResultSingle.toSingle($handler -> {
      putValue(key, value, $handler);
    });
  }

  /**
   * @param key the key
   * @param value the value
   * @param options options used to push pair
   * @param resultHandler will be provided with success of operation
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient putValueWithOptions(java.lang.String key, java.lang.String value, io.vertx.ext.consul.KeyValueOptions options, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Boolean>> resultHandler) { 
    delegate.putValueWithOptions(key, value, options, resultHandler);
    return this;
  }

  /**
   * @param key the key
   * @param value the value
   * @param options options used to push pair
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient putValueWithOptions(java.lang.String key, java.lang.String value, io.vertx.ext.consul.KeyValueOptions options) {
    return 
putValueWithOptions(key, value, options, ar -> { });
  }

  /**
   * @param key the key
   * @param value the value
   * @param options options used to push pair
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<java.lang.Boolean> rxPutValueWithOptions(java.lang.String key, java.lang.String value, io.vertx.ext.consul.KeyValueOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      putValueWithOptions(key, value, options, $handler);
    });
  }

  /**
   * Manages multiple operations inside a single, atomic transaction.
   * @param request transaction request
   * @param resultHandler will be provided with result of transaction
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient transaction(io.vertx.ext.consul.TxnRequest request, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.consul.TxnResponse>> resultHandler) { 
    delegate.transaction(request, resultHandler);
    return this;
  }

  /**
   * Manages multiple operations inside a single, atomic transaction.
   * @param request transaction request
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient transaction(io.vertx.ext.consul.TxnRequest request) {
    return 
transaction(request, ar -> { });
  }

  /**
   * Manages multiple operations inside a single, atomic transaction.
   * @param request transaction request
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<io.vertx.ext.consul.TxnResponse> rxTransaction(io.vertx.ext.consul.TxnRequest request) { 
    return AsyncResultSingle.toSingle($handler -> {
      transaction(request, $handler);
    });
  }

  /**
   * Creates a new ACL policy
   * @param policy properties of policy
   * @param resultHandler will be provided with result of policy
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient createAclPolicy(io.vertx.ext.consul.policy.AclPolicy policy, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.String>> resultHandler) { 
    delegate.createAclPolicy(policy, resultHandler);
    return this;
  }

  /**
   * Creates a new ACL policy
   * @param policy properties of policy
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient createAclPolicy(io.vertx.ext.consul.policy.AclPolicy policy) {
    return 
createAclPolicy(policy, ar -> { });
  }

  /**
   * Creates a new ACL policy
   * @param policy properties of policy
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<java.lang.String> rxCreateAclPolicy(io.vertx.ext.consul.policy.AclPolicy policy) { 
    return AsyncResultSingle.toSingle($handler -> {
      createAclPolicy(policy, $handler);
    });
  }

  /**
   * This endpoint reads an ACL policy with the given ID
   * @param id uuid policy
   * @param resultHandler will be provided with result of policy
   * @return a reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient readPolicy(java.lang.String id, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.consul.policy.AclPolicy>> resultHandler) { 
    delegate.readPolicy(id, resultHandler);
    return this;
  }

  /**
   * This endpoint reads an ACL policy with the given ID
   * @param id uuid policy
   * @return a reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient readPolicy(java.lang.String id) {
    return 
readPolicy(id, ar -> { });
  }

  /**
   * This endpoint reads an ACL policy with the given ID
   * @param id uuid policy
   * @return a reference to this, for fluency
   */
  public io.reactivex.Single<io.vertx.ext.consul.policy.AclPolicy> rxReadPolicy(java.lang.String id) { 
    return AsyncResultSingle.toSingle($handler -> {
      readPolicy(id, $handler);
    });
  }

  /**
   * This endpoint reads an ACL policy with the given name
   * @param name unique name of created policy
   * @param resultHandler will be provided with result of policy
   * @return a reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient readPolicyByName(java.lang.String name, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.consul.policy.AclPolicy>> resultHandler) { 
    delegate.readPolicyByName(name, resultHandler);
    return this;
  }

  /**
   * This endpoint reads an ACL policy with the given name
   * @param name unique name of created policy
   * @return a reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient readPolicyByName(java.lang.String name) {
    return 
readPolicyByName(name, ar -> { });
  }

  /**
   * This endpoint reads an ACL policy with the given name
   * @param name unique name of created policy
   * @return a reference to this, for fluency
   */
  public io.reactivex.Single<io.vertx.ext.consul.policy.AclPolicy> rxReadPolicyByName(java.lang.String name) { 
    return AsyncResultSingle.toSingle($handler -> {
      readPolicyByName(name, $handler);
    });
  }

  /**
   * This endpoint updates an existing ACL policy
   * @param id uuid of existing policy
   * @param policy options that will be applied to the existing policy
   * @param resultHandler will be provided with result of policy
   * @return a reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient updatePolicy(java.lang.String id, io.vertx.ext.consul.policy.AclPolicy policy, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.consul.policy.AclPolicy>> resultHandler) { 
    delegate.updatePolicy(id, policy, resultHandler);
    return this;
  }

  /**
   * This endpoint updates an existing ACL policy
   * @param id uuid of existing policy
   * @param policy options that will be applied to the existing policy
   * @return a reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient updatePolicy(java.lang.String id, io.vertx.ext.consul.policy.AclPolicy policy) {
    return 
updatePolicy(id, policy, ar -> { });
  }

  /**
   * This endpoint updates an existing ACL policy
   * @param id uuid of existing policy
   * @param policy options that will be applied to the existing policy
   * @return a reference to this, for fluency
   */
  public io.reactivex.Single<io.vertx.ext.consul.policy.AclPolicy> rxUpdatePolicy(java.lang.String id, io.vertx.ext.consul.policy.AclPolicy policy) { 
    return AsyncResultSingle.toSingle($handler -> {
      updatePolicy(id, policy, $handler);
    });
  }

  /**
   * This endpoint deletes an ACL policy
   * @param id uuid of existing policy
   * @param resultHandler will be provided with result of policy deleting
   * @return a reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient deletePolicy(java.lang.String id, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Boolean>> resultHandler) { 
    io.vertx.reactivex.ext.consul.ConsulClient ret = io.vertx.reactivex.ext.consul.ConsulClient.newInstance((io.vertx.ext.consul.ConsulClient)delegate.deletePolicy(id, resultHandler));
    return ret;
  }

  /**
   * This endpoint lists all the ACL policies.
   * Note - The policies rules are not included in the listing and must be retrieved by the policy reading endpoint
   * @param resultHandler will be provided with result of policy deleting
   * @return a reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient getAclPolicies(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<io.vertx.ext.consul.policy.AclPolicy>>> resultHandler) { 
    io.vertx.reactivex.ext.consul.ConsulClient ret = io.vertx.reactivex.ext.consul.ConsulClient.newInstance((io.vertx.ext.consul.ConsulClient)delegate.getAclPolicies(resultHandler));
    return ret;
  }

  /**
   * Create an Acl token
   * @param token properties of the token
   * @param resultHandler will be provided with result of token
   * @return reference to this, for fluency {@link io.vertx.ext.consul.token.AclToken} accessorId - required in the URL path or JSON body for getting, updating and cloning token. {@link io.vertx.ext.consul.token.AclToken} secretId - using in {@link io.vertx.ext.consul.ConsulClientOptions}.
   */
  public io.vertx.reactivex.ext.consul.ConsulClient createAclToken(io.vertx.ext.consul.token.AclToken token, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.consul.token.AclToken>> resultHandler) { 
    delegate.createAclToken(token, resultHandler);
    return this;
  }

  /**
   * Create an Acl token
   * @param token properties of the token
   * @return reference to this, for fluency {@link io.vertx.ext.consul.token.AclToken} accessorId - required in the URL path or JSON body for getting, updating and cloning token. {@link io.vertx.ext.consul.token.AclToken} secretId - using in {@link io.vertx.ext.consul.ConsulClientOptions}.
   */
  public io.vertx.reactivex.ext.consul.ConsulClient createAclToken(io.vertx.ext.consul.token.AclToken token) {
    return 
createAclToken(token, ar -> { });
  }

  /**
   * Create an Acl token
   * @param token properties of the token
   * @return reference to this, for fluency {@link io.vertx.ext.consul.token.AclToken} accessorId - required in the URL path or JSON body for getting, updating and cloning token. {@link io.vertx.ext.consul.token.AclToken} secretId - using in {@link io.vertx.ext.consul.ConsulClientOptions}.
   */
  public io.reactivex.Single<io.vertx.ext.consul.token.AclToken> rxCreateAclToken(io.vertx.ext.consul.token.AclToken token) { 
    return AsyncResultSingle.toSingle($handler -> {
      createAclToken(token, $handler);
    });
  }

  /**
   * Update an existing Acl token
   * @param accessorId uuid of the token
   * @param token properties of the token
   * @param resultHandler will be provided with result of token
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient updateAclToken(java.lang.String accessorId, io.vertx.ext.consul.token.AclToken token, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.consul.token.AclToken>> resultHandler) { 
    delegate.updateAclToken(accessorId, token, resultHandler);
    return this;
  }

  /**
   * Update an existing Acl token
   * @param accessorId uuid of the token
   * @param token properties of the token
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient updateAclToken(java.lang.String accessorId, io.vertx.ext.consul.token.AclToken token) {
    return 
updateAclToken(accessorId, token, ar -> { });
  }

  /**
   * Update an existing Acl token
   * @param accessorId uuid of the token
   * @param token properties of the token
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<io.vertx.ext.consul.token.AclToken> rxUpdateAclToken(java.lang.String accessorId, io.vertx.ext.consul.token.AclToken token) { 
    return AsyncResultSingle.toSingle($handler -> {
      updateAclToken(accessorId, token, $handler);
    });
  }

  /**
   * Clones an existing ACL token
   * @param accessorId uuid of the token
   * @param cloneAclToken properties of cloned token
   * @param resultHandler will be provided with result of token
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient cloneAclToken(java.lang.String accessorId, io.vertx.ext.consul.token.CloneAclTokenOptions cloneAclToken, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.consul.token.AclToken>> resultHandler) { 
    delegate.cloneAclToken(accessorId, cloneAclToken, resultHandler);
    return this;
  }

  /**
   * Clones an existing ACL token
   * @param accessorId uuid of the token
   * @param cloneAclToken properties of cloned token
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient cloneAclToken(java.lang.String accessorId, io.vertx.ext.consul.token.CloneAclTokenOptions cloneAclToken) {
    return 
cloneAclToken(accessorId, cloneAclToken, ar -> { });
  }

  /**
   * Clones an existing ACL token
   * @param accessorId uuid of the token
   * @param cloneAclToken properties of cloned token
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<io.vertx.ext.consul.token.AclToken> rxCloneAclToken(java.lang.String accessorId, io.vertx.ext.consul.token.CloneAclTokenOptions cloneAclToken) { 
    return AsyncResultSingle.toSingle($handler -> {
      cloneAclToken(accessorId, cloneAclToken, $handler);
    });
  }

  /**
   * Get list of Acl token
   * @param resultHandler will be provided with result of tokens
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient getAclTokens(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<io.vertx.ext.consul.token.AclToken>>> resultHandler) { 
    delegate.getAclTokens(resultHandler);
    return this;
  }

  /**
   * Get list of Acl token
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient getAclTokens() {
    return 
getAclTokens(ar -> { });
  }

  /**
   * Get list of Acl token
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<java.util.List<io.vertx.ext.consul.token.AclToken>> rxGetAclTokens() { 
    return AsyncResultSingle.toSingle($handler -> {
      getAclTokens($handler);
    });
  }

  /**
   * Reads an ACL token with the given Accessor ID
   * @param accessorId uuid of token
   * @param resultHandler will be provided with result of token
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient readAclToken(java.lang.String accessorId, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.consul.token.AclToken>> resultHandler) { 
    delegate.readAclToken(accessorId, resultHandler);
    return this;
  }

  /**
   * Reads an ACL token with the given Accessor ID
   * @param accessorId uuid of token
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient readAclToken(java.lang.String accessorId) {
    return 
readAclToken(accessorId, ar -> { });
  }

  /**
   * Reads an ACL token with the given Accessor ID
   * @param accessorId uuid of token
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<io.vertx.ext.consul.token.AclToken> rxReadAclToken(java.lang.String accessorId) { 
    return AsyncResultSingle.toSingle($handler -> {
      readAclToken(accessorId, $handler);
    });
  }

  /**
   * Deletes an ACL token
   * @param accessorId uuid of token
   * @param resultHandler will be provided with result of token deleting
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient deleteAclToken(java.lang.String accessorId, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Boolean>> resultHandler) { 
    delegate.deleteAclToken(accessorId, resultHandler);
    return this;
  }

  /**
   * Deletes an ACL token
   * @param accessorId uuid of token
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient deleteAclToken(java.lang.String accessorId) {
    return 
deleteAclToken(accessorId, ar -> { });
  }

  /**
   * Deletes an ACL token
   * @param accessorId uuid of token
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<java.lang.Boolean> rxDeleteAclToken(java.lang.String accessorId) { 
    return AsyncResultSingle.toSingle($handler -> {
      deleteAclToken(accessorId, $handler);
    });
  }

  /**
   * Legacy create new Acl token
   * @param token properties of the token
   * @param idHandler will be provided with ID of created token
   * @return reference to this, for fluency
   */
  @Deprecated()
  public io.vertx.reactivex.ext.consul.ConsulClient createAclToken(io.vertx.ext.consul.AclToken token, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.String>> idHandler) { 
    delegate.createAclToken(token, idHandler);
    return this;
  }

  /**
   * Legacy create new Acl token
   * @param token properties of the token
   * @return reference to this, for fluency
   */
  @Deprecated()
  public io.vertx.reactivex.ext.consul.ConsulClient createAclToken(io.vertx.ext.consul.AclToken token) {
    return 
createAclToken(token, ar -> { });
  }

  /**
   * Legacy create new Acl token
   * @param token properties of the token
   * @return reference to this, for fluency
   */
  @Deprecated()
  public io.reactivex.Single<java.lang.String> rxCreateAclToken(io.vertx.ext.consul.AclToken token) { 
    return AsyncResultSingle.toSingle($handler -> {
      createAclToken(token, $handler);
    });
  }

  /**
   * Update Acl token
   * @param token properties of the token to be updated
   * @param idHandler will be provided with ID of updated
   * @return reference to this, for fluency
   */
  @Deprecated()
  public io.vertx.reactivex.ext.consul.ConsulClient updateAclToken(io.vertx.ext.consul.AclToken token, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.String>> idHandler) { 
    delegate.updateAclToken(token, idHandler);
    return this;
  }

  /**
   * Update Acl token
   * @param token properties of the token to be updated
   * @return reference to this, for fluency
   */
  @Deprecated()
  public io.vertx.reactivex.ext.consul.ConsulClient updateAclToken(io.vertx.ext.consul.AclToken token) {
    return 
updateAclToken(token, ar -> { });
  }

  /**
   * Update Acl token
   * @param token properties of the token to be updated
   * @return reference to this, for fluency
   */
  @Deprecated()
  public io.reactivex.Single<java.lang.String> rxUpdateAclToken(io.vertx.ext.consul.AclToken token) { 
    return AsyncResultSingle.toSingle($handler -> {
      updateAclToken(token, $handler);
    });
  }

  /**
   * Clone Acl token
   * @param id the ID of token to be cloned
   * @param idHandler will be provided with ID of cloned token
   * @return reference to this, for fluency
   */
  @Deprecated()
  public io.vertx.reactivex.ext.consul.ConsulClient cloneAclToken(java.lang.String id, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.String>> idHandler) { 
    delegate.cloneAclToken(id, idHandler);
    return this;
  }

  /**
   * Clone Acl token
   * @param id the ID of token to be cloned
   * @return reference to this, for fluency
   */
  @Deprecated()
  public io.vertx.reactivex.ext.consul.ConsulClient cloneAclToken(java.lang.String id) {
    return 
cloneAclToken(id, ar -> { });
  }

  /**
   * Clone Acl token
   * @param id the ID of token to be cloned
   * @return reference to this, for fluency
   */
  @Deprecated()
  public io.reactivex.Single<java.lang.String> rxCloneAclToken(java.lang.String id) { 
    return AsyncResultSingle.toSingle($handler -> {
      cloneAclToken(id, $handler);
    });
  }

  /**
   * Get list of Acl token
   * @param resultHandler will be provided with list of tokens
   * @return reference to this, for fluency
   */
  @Deprecated()
  public io.vertx.reactivex.ext.consul.ConsulClient listAclTokens(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<io.vertx.ext.consul.AclToken>>> resultHandler) { 
    delegate.listAclTokens(resultHandler);
    return this;
  }

  /**
   * Get list of Acl token
   * @return reference to this, for fluency
   */
  @Deprecated()
  public io.vertx.reactivex.ext.consul.ConsulClient listAclTokens() {
    return 
listAclTokens(ar -> { });
  }

  /**
   * Get list of Acl token
   * @return reference to this, for fluency
   */
  @Deprecated()
  public io.reactivex.Single<java.util.List<io.vertx.ext.consul.AclToken>> rxListAclTokens() { 
    return AsyncResultSingle.toSingle($handler -> {
      listAclTokens($handler);
    });
  }

  /**
   * Get info of Acl token
   * @param id the ID of token
   * @param tokenHandler will be provided with token
   * @return reference to this, for fluency
   */
  @Deprecated()
  public io.vertx.reactivex.ext.consul.ConsulClient infoAclToken(java.lang.String id, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.consul.AclToken>> tokenHandler) { 
    delegate.infoAclToken(id, tokenHandler);
    return this;
  }

  /**
   * Get info of Acl token
   * @param id the ID of token
   * @return reference to this, for fluency
   */
  @Deprecated()
  public io.vertx.reactivex.ext.consul.ConsulClient infoAclToken(java.lang.String id) {
    return 
infoAclToken(id, ar -> { });
  }

  /**
   * Get info of Acl token
   * @param id the ID of token
   * @return reference to this, for fluency
   */
  @Deprecated()
  public io.reactivex.Single<io.vertx.ext.consul.AclToken> rxInfoAclToken(java.lang.String id) { 
    return AsyncResultSingle.toSingle($handler -> {
      infoAclToken(id, $handler);
    });
  }

  /**
   * Destroy Acl token
   * @param id the ID of token
   * @param resultHandler will be called on complete
   * @return reference to this, for fluency
   */
  @Deprecated()
  public io.vertx.reactivex.ext.consul.ConsulClient destroyAclToken(java.lang.String id, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.destroyAclToken(id, resultHandler);
    return this;
  }

  /**
   * Destroy Acl token
   * @param id the ID of token
   * @return reference to this, for fluency
   */
  @Deprecated()
  public io.vertx.reactivex.ext.consul.ConsulClient destroyAclToken(java.lang.String id) {
    return 
destroyAclToken(id, ar -> { });
  }

  /**
   * Destroy Acl token
   * @param id the ID of token
   * @return reference to this, for fluency
   */
  @Deprecated()
  public io.reactivex.Completable rxDestroyAclToken(java.lang.String id) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      destroyAclToken(id, $handler);
    });
  }

  /**
   * Fires a new user event
   * @param name name of event
   * @param resultHandler will be provided with properties of event
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient fireEvent(java.lang.String name, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.consul.Event>> resultHandler) { 
    delegate.fireEvent(name, resultHandler);
    return this;
  }

  /**
   * Fires a new user event
   * @param name name of event
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient fireEvent(java.lang.String name) {
    return 
fireEvent(name, ar -> { });
  }

  /**
   * Fires a new user event
   * @param name name of event
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<io.vertx.ext.consul.Event> rxFireEvent(java.lang.String name) { 
    return AsyncResultSingle.toSingle($handler -> {
      fireEvent(name, $handler);
    });
  }

  /**
   * Fires a new user event
   * @param name name of event
   * @param options options used to create event
   * @param resultHandler will be provided with properties of event
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient fireEventWithOptions(java.lang.String name, io.vertx.ext.consul.EventOptions options, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.consul.Event>> resultHandler) { 
    delegate.fireEventWithOptions(name, options, resultHandler);
    return this;
  }

  /**
   * Fires a new user event
   * @param name name of event
   * @param options options used to create event
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient fireEventWithOptions(java.lang.String name, io.vertx.ext.consul.EventOptions options) {
    return 
fireEventWithOptions(name, options, ar -> { });
  }

  /**
   * Fires a new user event
   * @param name name of event
   * @param options options used to create event
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<io.vertx.ext.consul.Event> rxFireEventWithOptions(java.lang.String name, io.vertx.ext.consul.EventOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      fireEventWithOptions(name, options, $handler);
    });
  }

  /**
   * Returns the most recent events known by the agent
   * @param resultHandler will be provided with list of events
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient listEvents(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.consul.EventList>> resultHandler) { 
    delegate.listEvents(resultHandler);
    return this;
  }

  /**
   * Returns the most recent events known by the agent
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient listEvents() {
    return 
listEvents(ar -> { });
  }

  /**
   * Returns the most recent events known by the agent
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<io.vertx.ext.consul.EventList> rxListEvents() { 
    return AsyncResultSingle.toSingle($handler -> {
      listEvents($handler);
    });
  }

  /**
   * Returns the most recent events known by the agent.
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#listEvents}. However, the semantics of this endpoint
   * are slightly different. Most blocking queries provide a monotonic index and block until a newer index is available.
   * This can be supported as a consequence of the total ordering of the consensus protocol. With gossip,
   * there is no ordering, and instead <code>X-Consul-Index</code> maps to the newest event that matches the query.
   * <p>
   * In practice, this means the index is only useful when used against a single agent and has no meaning globally.
   * Because Consul defines the index as being opaque, clients should not be expecting a natural ordering either.
   * @param options the blocking options
   * @param resultHandler will be provided with list of events
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient listEventsWithOptions(io.vertx.ext.consul.EventListOptions options, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.consul.EventList>> resultHandler) { 
    delegate.listEventsWithOptions(options, resultHandler);
    return this;
  }

  /**
   * Returns the most recent events known by the agent.
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#listEvents}. However, the semantics of this endpoint
   * are slightly different. Most blocking queries provide a monotonic index and block until a newer index is available.
   * This can be supported as a consequence of the total ordering of the consensus protocol. With gossip,
   * there is no ordering, and instead <code>X-Consul-Index</code> maps to the newest event that matches the query.
   * <p>
   * In practice, this means the index is only useful when used against a single agent and has no meaning globally.
   * Because Consul defines the index as being opaque, clients should not be expecting a natural ordering either.
   * @param options the blocking options
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient listEventsWithOptions(io.vertx.ext.consul.EventListOptions options) {
    return 
listEventsWithOptions(options, ar -> { });
  }

  /**
   * Returns the most recent events known by the agent.
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#listEvents}. However, the semantics of this endpoint
   * are slightly different. Most blocking queries provide a monotonic index and block until a newer index is available.
   * This can be supported as a consequence of the total ordering of the consensus protocol. With gossip,
   * there is no ordering, and instead <code>X-Consul-Index</code> maps to the newest event that matches the query.
   * <p>
   * In practice, this means the index is only useful when used against a single agent and has no meaning globally.
   * Because Consul defines the index as being opaque, clients should not be expecting a natural ordering either.
   * @param options the blocking options
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<io.vertx.ext.consul.EventList> rxListEventsWithOptions(io.vertx.ext.consul.EventListOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      listEventsWithOptions(options, $handler);
    });
  }

  /**
   * Adds a new service, with an optional health check, to the local agent.
   * @param serviceOptions the options of new service
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient registerService(io.vertx.ext.consul.ServiceOptions serviceOptions, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.registerService(serviceOptions, resultHandler);
    return this;
  }

  /**
   * Adds a new service, with an optional health check, to the local agent.
   * @param serviceOptions the options of new service
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient registerService(io.vertx.ext.consul.ServiceOptions serviceOptions) {
    return 
registerService(serviceOptions, ar -> { });
  }

  /**
   * Adds a new service, with an optional health check, to the local agent.
   * @param serviceOptions the options of new service
   * @return reference to this, for fluency
   */
  public io.reactivex.Completable rxRegisterService(io.vertx.ext.consul.ServiceOptions serviceOptions) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      registerService(serviceOptions, $handler);
    });
  }

  /**
   * Places a given service into "maintenance mode"
   * @param maintenanceOptions the maintenance options
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient maintenanceService(io.vertx.ext.consul.MaintenanceOptions maintenanceOptions, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.maintenanceService(maintenanceOptions, resultHandler);
    return this;
  }

  /**
   * Places a given service into "maintenance mode"
   * @param maintenanceOptions the maintenance options
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient maintenanceService(io.vertx.ext.consul.MaintenanceOptions maintenanceOptions) {
    return 
maintenanceService(maintenanceOptions, ar -> { });
  }

  /**
   * Places a given service into "maintenance mode"
   * @param maintenanceOptions the maintenance options
   * @return reference to this, for fluency
   */
  public io.reactivex.Completable rxMaintenanceService(io.vertx.ext.consul.MaintenanceOptions maintenanceOptions) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      maintenanceService(maintenanceOptions, $handler);
    });
  }

  /**
   * Remove a service from the local agent. The agent will take care of deregistering the service with the Catalog.
   * If there is an associated check, that is also deregistered.
   * @param id the ID of service
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient deregisterService(java.lang.String id, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.deregisterService(id, resultHandler);
    return this;
  }

  /**
   * Remove a service from the local agent. The agent will take care of deregistering the service with the Catalog.
   * If there is an associated check, that is also deregistered.
   * @param id the ID of service
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient deregisterService(java.lang.String id) {
    return 
deregisterService(id, ar -> { });
  }

  /**
   * Remove a service from the local agent. The agent will take care of deregistering the service with the Catalog.
   * If there is an associated check, that is also deregistered.
   * @param id the ID of service
   * @return reference to this, for fluency
   */
  public io.reactivex.Completable rxDeregisterService(java.lang.String id) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      deregisterService(id, $handler);
    });
  }

  /**
   * Returns the nodes providing a service
   * @param service name of service
   * @param resultHandler will be provided with list of nodes providing given service
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient catalogServiceNodes(java.lang.String service, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.consul.ServiceList>> resultHandler) { 
    delegate.catalogServiceNodes(service, resultHandler);
    return this;
  }

  /**
   * Returns the nodes providing a service
   * @param service name of service
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient catalogServiceNodes(java.lang.String service) {
    return 
catalogServiceNodes(service, ar -> { });
  }

  /**
   * Returns the nodes providing a service
   * @param service name of service
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<io.vertx.ext.consul.ServiceList> rxCatalogServiceNodes(java.lang.String service) { 
    return AsyncResultSingle.toSingle($handler -> {
      catalogServiceNodes(service, $handler);
    });
  }

  /**
   * Returns the nodes providing a service
   * @param service name of service
   * @param options options used to request services
   * @param resultHandler will be provided with list of nodes providing given service
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient catalogServiceNodesWithOptions(java.lang.String service, io.vertx.ext.consul.ServiceQueryOptions options, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.consul.ServiceList>> resultHandler) { 
    delegate.catalogServiceNodesWithOptions(service, options, resultHandler);
    return this;
  }

  /**
   * Returns the nodes providing a service
   * @param service name of service
   * @param options options used to request services
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient catalogServiceNodesWithOptions(java.lang.String service, io.vertx.ext.consul.ServiceQueryOptions options) {
    return 
catalogServiceNodesWithOptions(service, options, ar -> { });
  }

  /**
   * Returns the nodes providing a service
   * @param service name of service
   * @param options options used to request services
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<io.vertx.ext.consul.ServiceList> rxCatalogServiceNodesWithOptions(java.lang.String service, io.vertx.ext.consul.ServiceQueryOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      catalogServiceNodesWithOptions(service, options, $handler);
    });
  }

  /**
   * Return all the datacenters that are known by the Consul server
   * @param resultHandler will be provided with list of datacenters
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient catalogDatacenters(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<java.lang.String>>> resultHandler) { 
    delegate.catalogDatacenters(resultHandler);
    return this;
  }

  /**
   * Return all the datacenters that are known by the Consul server
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient catalogDatacenters() {
    return 
catalogDatacenters(ar -> { });
  }

  /**
   * Return all the datacenters that are known by the Consul server
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<java.util.List<java.lang.String>> rxCatalogDatacenters() { 
    return AsyncResultSingle.toSingle($handler -> {
      catalogDatacenters($handler);
    });
  }

  /**
   * Returns the nodes registered in a datacenter
   * @param resultHandler will be provided with list of nodes
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient catalogNodes(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.consul.NodeList>> resultHandler) { 
    delegate.catalogNodes(resultHandler);
    return this;
  }

  /**
   * Returns the nodes registered in a datacenter
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient catalogNodes() {
    return 
catalogNodes(ar -> { });
  }

  /**
   * Returns the nodes registered in a datacenter
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<io.vertx.ext.consul.NodeList> rxCatalogNodes() { 
    return AsyncResultSingle.toSingle($handler -> {
      catalogNodes($handler);
    });
  }

  /**
   * Returns the nodes registered in a datacenter
   * @param options options used to request nodes
   * @param resultHandler will be provided with list of nodes
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient catalogNodesWithOptions(io.vertx.ext.consul.NodeQueryOptions options, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.consul.NodeList>> resultHandler) { 
    delegate.catalogNodesWithOptions(options, resultHandler);
    return this;
  }

  /**
   * Returns the nodes registered in a datacenter
   * @param options options used to request nodes
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient catalogNodesWithOptions(io.vertx.ext.consul.NodeQueryOptions options) {
    return 
catalogNodesWithOptions(options, ar -> { });
  }

  /**
   * Returns the nodes registered in a datacenter
   * @param options options used to request nodes
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<io.vertx.ext.consul.NodeList> rxCatalogNodesWithOptions(io.vertx.ext.consul.NodeQueryOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      catalogNodesWithOptions(options, $handler);
    });
  }

  /**
   * Returns the checks associated with the service
   * @param service the service name
   * @param resultHandler will be provided with list of checks
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient healthChecks(java.lang.String service, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.consul.CheckList>> resultHandler) { 
    delegate.healthChecks(service, resultHandler);
    return this;
  }

  /**
   * Returns the checks associated with the service
   * @param service the service name
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient healthChecks(java.lang.String service) {
    return 
healthChecks(service, ar -> { });
  }

  /**
   * Returns the checks associated with the service
   * @param service the service name
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<io.vertx.ext.consul.CheckList> rxHealthChecks(java.lang.String service) { 
    return AsyncResultSingle.toSingle($handler -> {
      healthChecks(service, $handler);
    });
  }

  /**
   * Returns the checks associated with the service
   * @param service the service name
   * @param options options used to request checks
   * @param resultHandler will be provided with list of checks
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient healthChecksWithOptions(java.lang.String service, io.vertx.ext.consul.CheckQueryOptions options, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.consul.CheckList>> resultHandler) { 
    delegate.healthChecksWithOptions(service, options, resultHandler);
    return this;
  }

  /**
   * Returns the checks associated with the service
   * @param service the service name
   * @param options options used to request checks
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient healthChecksWithOptions(java.lang.String service, io.vertx.ext.consul.CheckQueryOptions options) {
    return 
healthChecksWithOptions(service, options, ar -> { });
  }

  /**
   * Returns the checks associated with the service
   * @param service the service name
   * @param options options used to request checks
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<io.vertx.ext.consul.CheckList> rxHealthChecksWithOptions(java.lang.String service, io.vertx.ext.consul.CheckQueryOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      healthChecksWithOptions(service, options, $handler);
    });
  }

  /**
   * Returns the checks in the specified status
   * @param healthState the health state
   * @param resultHandler will be provided with list of checks
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient healthState(io.vertx.ext.consul.HealthState healthState, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.consul.CheckList>> resultHandler) { 
    delegate.healthState(healthState, resultHandler);
    return this;
  }

  /**
   * Returns the checks in the specified status
   * @param healthState the health state
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient healthState(io.vertx.ext.consul.HealthState healthState) {
    return 
healthState(healthState, ar -> { });
  }

  /**
   * Returns the checks in the specified status
   * @param healthState the health state
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<io.vertx.ext.consul.CheckList> rxHealthState(io.vertx.ext.consul.HealthState healthState) { 
    return AsyncResultSingle.toSingle($handler -> {
      healthState(healthState, $handler);
    });
  }

  /**
   * Returns the checks in the specified status
   * @param healthState the health state
   * @param options options used to request checks
   * @param resultHandler will be provided with list of checks
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient healthStateWithOptions(io.vertx.ext.consul.HealthState healthState, io.vertx.ext.consul.CheckQueryOptions options, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.consul.CheckList>> resultHandler) { 
    delegate.healthStateWithOptions(healthState, options, resultHandler);
    return this;
  }

  /**
   * Returns the checks in the specified status
   * @param healthState the health state
   * @param options options used to request checks
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient healthStateWithOptions(io.vertx.ext.consul.HealthState healthState, io.vertx.ext.consul.CheckQueryOptions options) {
    return 
healthStateWithOptions(healthState, options, ar -> { });
  }

  /**
   * Returns the checks in the specified status
   * @param healthState the health state
   * @param options options used to request checks
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<io.vertx.ext.consul.CheckList> rxHealthStateWithOptions(io.vertx.ext.consul.HealthState healthState, io.vertx.ext.consul.CheckQueryOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      healthStateWithOptions(healthState, options, $handler);
    });
  }

  /**
   * Returns the nodes providing the service. This endpoint is very similar to the {@link io.vertx.reactivex.ext.consul.ConsulClient#catalogServiceNodes} endpoint;
   * however, this endpoint automatically returns the status of the associated health check as well as any system level health checks.
   * @param service the service name
   * @param passing if true, filter results to only nodes with all checks in the passing state
   * @param resultHandler will be provided with list of services
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient healthServiceNodes(java.lang.String service, boolean passing, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.consul.ServiceEntryList>> resultHandler) { 
    delegate.healthServiceNodes(service, passing, resultHandler);
    return this;
  }

  /**
   * Returns the nodes providing the service. This endpoint is very similar to the {@link io.vertx.reactivex.ext.consul.ConsulClient#catalogServiceNodes} endpoint;
   * however, this endpoint automatically returns the status of the associated health check as well as any system level health checks.
   * @param service the service name
   * @param passing if true, filter results to only nodes with all checks in the passing state
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient healthServiceNodes(java.lang.String service, boolean passing) {
    return 
healthServiceNodes(service, passing, ar -> { });
  }

  /**
   * Returns the nodes providing the service. This endpoint is very similar to the {@link io.vertx.reactivex.ext.consul.ConsulClient#catalogServiceNodes} endpoint;
   * however, this endpoint automatically returns the status of the associated health check as well as any system level health checks.
   * @param service the service name
   * @param passing if true, filter results to only nodes with all checks in the passing state
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<io.vertx.ext.consul.ServiceEntryList> rxHealthServiceNodes(java.lang.String service, boolean passing) { 
    return AsyncResultSingle.toSingle($handler -> {
      healthServiceNodes(service, passing, $handler);
    });
  }

  /**
   * Returns the nodes providing the service. This endpoint is very similar to the {@link io.vertx.reactivex.ext.consul.ConsulClient#catalogServiceNodesWithOptions} endpoint;
   * however, this endpoint automatically returns the status of the associated health check as well as any system level health checks.
   * @param service the service name
   * @param passing if true, filter results to only nodes with all checks in the passing state
   * @param options options used to request services
   * @param resultHandler will be provided with list of services
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient healthServiceNodesWithOptions(java.lang.String service, boolean passing, io.vertx.ext.consul.ServiceQueryOptions options, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.consul.ServiceEntryList>> resultHandler) { 
    delegate.healthServiceNodesWithOptions(service, passing, options, resultHandler);
    return this;
  }

  /**
   * Returns the nodes providing the service. This endpoint is very similar to the {@link io.vertx.reactivex.ext.consul.ConsulClient#catalogServiceNodesWithOptions} endpoint;
   * however, this endpoint automatically returns the status of the associated health check as well as any system level health checks.
   * @param service the service name
   * @param passing if true, filter results to only nodes with all checks in the passing state
   * @param options options used to request services
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient healthServiceNodesWithOptions(java.lang.String service, boolean passing, io.vertx.ext.consul.ServiceQueryOptions options) {
    return 
healthServiceNodesWithOptions(service, passing, options, ar -> { });
  }

  /**
   * Returns the nodes providing the service. This endpoint is very similar to the {@link io.vertx.reactivex.ext.consul.ConsulClient#catalogServiceNodesWithOptions} endpoint;
   * however, this endpoint automatically returns the status of the associated health check as well as any system level health checks.
   * @param service the service name
   * @param passing if true, filter results to only nodes with all checks in the passing state
   * @param options options used to request services
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<io.vertx.ext.consul.ServiceEntryList> rxHealthServiceNodesWithOptions(java.lang.String service, boolean passing, io.vertx.ext.consul.ServiceQueryOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      healthServiceNodesWithOptions(service, passing, options, $handler);
    });
  }

  /**
   * Returns the checks specific to the node provided on the path.
   * @param node the node name or ID
   * @param options options used to request node health checks
   * @param resultHandler 
   * @return a future provided with list of services
   */
  public io.vertx.reactivex.ext.consul.ConsulClient healthNodesWithOptions(java.lang.String node, io.vertx.ext.consul.CheckQueryOptions options, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.consul.CheckList>> resultHandler) { 
    delegate.healthNodesWithOptions(node, options, resultHandler);
    return this;
  }

  /**
   * Returns the checks specific to the node provided on the path.
   * @param node the node name or ID
   * @param options options used to request node health checks
   * @return a future provided with list of services
   */
  public io.vertx.reactivex.ext.consul.ConsulClient healthNodesWithOptions(java.lang.String node, io.vertx.ext.consul.CheckQueryOptions options) {
    return 
healthNodesWithOptions(node, options, ar -> { });
  }

  /**
   * Returns the checks specific to the node provided on the path.
   * @param node the node name or ID
   * @param options options used to request node health checks
   * @return a future provided with list of services
   */
  public io.reactivex.Single<io.vertx.ext.consul.CheckList> rxHealthNodesWithOptions(java.lang.String node, io.vertx.ext.consul.CheckQueryOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      healthNodesWithOptions(node, options, $handler);
    });
  }

  /**
   * Returns the services registered in a datacenter
   * @param resultHandler will be provided with list of services
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient catalogServices(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.consul.ServiceList>> resultHandler) { 
    delegate.catalogServices(resultHandler);
    return this;
  }

  /**
   * Returns the services registered in a datacenter
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient catalogServices() {
    return 
catalogServices(ar -> { });
  }

  /**
   * Returns the services registered in a datacenter
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<io.vertx.ext.consul.ServiceList> rxCatalogServices() { 
    return AsyncResultSingle.toSingle($handler -> {
      catalogServices($handler);
    });
  }

  /**
   * Returns the services registered in a datacenter
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#catalogServices}
   * @param options the blocking options
   * @param resultHandler will be provided with list of services
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient catalogServicesWithOptions(io.vertx.ext.consul.BlockingQueryOptions options, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.consul.ServiceList>> resultHandler) { 
    delegate.catalogServicesWithOptions(options, resultHandler);
    return this;
  }

  /**
   * Returns the services registered in a datacenter
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#catalogServices}
   * @param options the blocking options
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient catalogServicesWithOptions(io.vertx.ext.consul.BlockingQueryOptions options) {
    return 
catalogServicesWithOptions(options, ar -> { });
  }

  /**
   * Returns the services registered in a datacenter
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#catalogServices}
   * @param options the blocking options
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<io.vertx.ext.consul.ServiceList> rxCatalogServicesWithOptions(io.vertx.ext.consul.BlockingQueryOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      catalogServicesWithOptions(options, $handler);
    });
  }

  /**
   * Returns the node's registered services
   * @param node node name
   * @param resultHandler will be provided with list of services
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient catalogNodeServices(java.lang.String node, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.consul.ServiceList>> resultHandler) { 
    delegate.catalogNodeServices(node, resultHandler);
    return this;
  }

  /**
   * Returns the node's registered services
   * @param node node name
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient catalogNodeServices(java.lang.String node) {
    return 
catalogNodeServices(node, ar -> { });
  }

  /**
   * Returns the node's registered services
   * @param node node name
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<io.vertx.ext.consul.ServiceList> rxCatalogNodeServices(java.lang.String node) { 
    return AsyncResultSingle.toSingle($handler -> {
      catalogNodeServices(node, $handler);
    });
  }

  /**
   * Returns the node's registered services
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#catalogNodeServices}
   * @param node node name
   * @param options the blocking options
   * @param resultHandler will be provided with list of services
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient catalogNodeServicesWithOptions(java.lang.String node, io.vertx.ext.consul.BlockingQueryOptions options, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.consul.ServiceList>> resultHandler) { 
    delegate.catalogNodeServicesWithOptions(node, options, resultHandler);
    return this;
  }

  /**
   * Returns the node's registered services
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#catalogNodeServices}
   * @param node node name
   * @param options the blocking options
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient catalogNodeServicesWithOptions(java.lang.String node, io.vertx.ext.consul.BlockingQueryOptions options) {
    return 
catalogNodeServicesWithOptions(node, options, ar -> { });
  }

  /**
   * Returns the node's registered services
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#catalogNodeServices}
   * @param node node name
   * @param options the blocking options
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<io.vertx.ext.consul.ServiceList> rxCatalogNodeServicesWithOptions(java.lang.String node, io.vertx.ext.consul.BlockingQueryOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      catalogNodeServicesWithOptions(node, options, $handler);
    });
  }

  /**
   * Returns list of services registered with the local agent.
   * @param resultHandler will be provided with list of services
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient localServices(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<io.vertx.ext.consul.Service>>> resultHandler) { 
    delegate.localServices(resultHandler);
    return this;
  }

  /**
   * Returns list of services registered with the local agent.
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient localServices() {
    return 
localServices(ar -> { });
  }

  /**
   * Returns list of services registered with the local agent.
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<java.util.List<io.vertx.ext.consul.Service>> rxLocalServices() { 
    return AsyncResultSingle.toSingle($handler -> {
      localServices($handler);
    });
  }

  /**
   * Return all the checks that are registered with the local agent.
   * @param resultHandler will be provided with list of checks
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient localChecks(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<io.vertx.ext.consul.Check>>> resultHandler) { 
    delegate.localChecks(resultHandler);
    return this;
  }

  /**
   * Return all the checks that are registered with the local agent.
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient localChecks() {
    return 
localChecks(ar -> { });
  }

  /**
   * Return all the checks that are registered with the local agent.
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<java.util.List<io.vertx.ext.consul.Check>> rxLocalChecks() { 
    return AsyncResultSingle.toSingle($handler -> {
      localChecks($handler);
    });
  }

  /**
   * Add a new check to the local agent. The agent is responsible for managing the status of the check
   * and keeping the Catalog in sync.
   * @param checkOptions options used to register new check
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient registerCheck(io.vertx.ext.consul.CheckOptions checkOptions, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.registerCheck(checkOptions, resultHandler);
    return this;
  }

  /**
   * Add a new check to the local agent. The agent is responsible for managing the status of the check
   * and keeping the Catalog in sync.
   * @param checkOptions options used to register new check
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient registerCheck(io.vertx.ext.consul.CheckOptions checkOptions) {
    return 
registerCheck(checkOptions, ar -> { });
  }

  /**
   * Add a new check to the local agent. The agent is responsible for managing the status of the check
   * and keeping the Catalog in sync.
   * @param checkOptions options used to register new check
   * @return reference to this, for fluency
   */
  public io.reactivex.Completable rxRegisterCheck(io.vertx.ext.consul.CheckOptions checkOptions) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      registerCheck(checkOptions, $handler);
    });
  }

  /**
   * Remove a check from the local agent. The agent will take care of deregistering the check from the Catalog.
   * @param checkId the ID of check
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient deregisterCheck(java.lang.String checkId, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.deregisterCheck(checkId, resultHandler);
    return this;
  }

  /**
   * Remove a check from the local agent. The agent will take care of deregistering the check from the Catalog.
   * @param checkId the ID of check
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient deregisterCheck(java.lang.String checkId) {
    return 
deregisterCheck(checkId, ar -> { });
  }

  /**
   * Remove a check from the local agent. The agent will take care of deregistering the check from the Catalog.
   * @param checkId the ID of check
   * @return reference to this, for fluency
   */
  public io.reactivex.Completable rxDeregisterCheck(java.lang.String checkId) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      deregisterCheck(checkId, $handler);
    });
  }

  /**
   * Set status of the check to "passing". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient passCheck(java.lang.String checkId, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.passCheck(checkId, resultHandler);
    return this;
  }

  /**
   * Set status of the check to "passing". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient passCheck(java.lang.String checkId) {
    return 
passCheck(checkId, ar -> { });
  }

  /**
   * Set status of the check to "passing". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @return reference to this, for fluency
   */
  public io.reactivex.Completable rxPassCheck(java.lang.String checkId) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      passCheck(checkId, $handler);
    });
  }

  /**
   * Set status of the check to "passing". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient passCheckWithNote(java.lang.String checkId, java.lang.String note, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.passCheckWithNote(checkId, note, resultHandler);
    return this;
  }

  /**
   * Set status of the check to "passing". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient passCheckWithNote(java.lang.String checkId, java.lang.String note) {
    return 
passCheckWithNote(checkId, note, ar -> { });
  }

  /**
   * Set status of the check to "passing". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
   * @return reference to this, for fluency
   */
  public io.reactivex.Completable rxPassCheckWithNote(java.lang.String checkId, java.lang.String note) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      passCheckWithNote(checkId, note, $handler);
    });
  }

  /**
   * Set status of the check to "warning". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient warnCheck(java.lang.String checkId, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.warnCheck(checkId, resultHandler);
    return this;
  }

  /**
   * Set status of the check to "warning". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient warnCheck(java.lang.String checkId) {
    return 
warnCheck(checkId, ar -> { });
  }

  /**
   * Set status of the check to "warning". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @return reference to this, for fluency
   */
  public io.reactivex.Completable rxWarnCheck(java.lang.String checkId) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      warnCheck(checkId, $handler);
    });
  }

  /**
   * Set status of the check to "warning". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient warnCheckWithNote(java.lang.String checkId, java.lang.String note, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.warnCheckWithNote(checkId, note, resultHandler);
    return this;
  }

  /**
   * Set status of the check to "warning". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient warnCheckWithNote(java.lang.String checkId, java.lang.String note) {
    return 
warnCheckWithNote(checkId, note, ar -> { });
  }

  /**
   * Set status of the check to "warning". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
   * @return reference to this, for fluency
   */
  public io.reactivex.Completable rxWarnCheckWithNote(java.lang.String checkId, java.lang.String note) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      warnCheckWithNote(checkId, note, $handler);
    });
  }

  /**
   * Set status of the check to "critical". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient failCheck(java.lang.String checkId, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.failCheck(checkId, resultHandler);
    return this;
  }

  /**
   * Set status of the check to "critical". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient failCheck(java.lang.String checkId) {
    return 
failCheck(checkId, ar -> { });
  }

  /**
   * Set status of the check to "critical". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @return reference to this, for fluency
   */
  public io.reactivex.Completable rxFailCheck(java.lang.String checkId) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      failCheck(checkId, $handler);
    });
  }

  /**
   * Set status of the check to "critical". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient failCheckWithNote(java.lang.String checkId, java.lang.String note, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.failCheckWithNote(checkId, note, resultHandler);
    return this;
  }

  /**
   * Set status of the check to "critical". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient failCheckWithNote(java.lang.String checkId, java.lang.String note) {
    return 
failCheckWithNote(checkId, note, ar -> { });
  }

  /**
   * Set status of the check to "critical". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
   * @return reference to this, for fluency
   */
  public io.reactivex.Completable rxFailCheckWithNote(java.lang.String checkId, java.lang.String note) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      failCheckWithNote(checkId, note, $handler);
    });
  }

  /**
   * Set status of the check to given status. Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param status new status of check
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient updateCheck(java.lang.String checkId, io.vertx.ext.consul.CheckStatus status, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.updateCheck(checkId, status, resultHandler);
    return this;
  }

  /**
   * Set status of the check to given status. Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param status new status of check
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient updateCheck(java.lang.String checkId, io.vertx.ext.consul.CheckStatus status) {
    return 
updateCheck(checkId, status, ar -> { });
  }

  /**
   * Set status of the check to given status. Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param status new status of check
   * @return reference to this, for fluency
   */
  public io.reactivex.Completable rxUpdateCheck(java.lang.String checkId, io.vertx.ext.consul.CheckStatus status) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      updateCheck(checkId, status, $handler);
    });
  }

  /**
   * Set status of the check to given status. Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param status new status of check
   * @param note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient updateCheckWithNote(java.lang.String checkId, io.vertx.ext.consul.CheckStatus status, java.lang.String note, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.updateCheckWithNote(checkId, status, note, resultHandler);
    return this;
  }

  /**
   * Set status of the check to given status. Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param status new status of check
   * @param note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient updateCheckWithNote(java.lang.String checkId, io.vertx.ext.consul.CheckStatus status, java.lang.String note) {
    return 
updateCheckWithNote(checkId, status, note, ar -> { });
  }

  /**
   * Set status of the check to given status. Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param status new status of check
   * @param note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
   * @return reference to this, for fluency
   */
  public io.reactivex.Completable rxUpdateCheckWithNote(java.lang.String checkId, io.vertx.ext.consul.CheckStatus status, java.lang.String note) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      updateCheckWithNote(checkId, status, note, $handler);
    });
  }

  /**
   * Get the Raft leader for the datacenter in which the agent is running.
   * It returns an address in format "<code>10.1.10.12:8300</code>"
   * @param resultHandler will be provided with address of cluster leader
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient leaderStatus(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.String>> resultHandler) { 
    delegate.leaderStatus(resultHandler);
    return this;
  }

  /**
   * Get the Raft leader for the datacenter in which the agent is running.
   * It returns an address in format "<code>10.1.10.12:8300</code>"
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient leaderStatus() {
    return 
leaderStatus(ar -> { });
  }

  /**
   * Get the Raft leader for the datacenter in which the agent is running.
   * It returns an address in format "<code>10.1.10.12:8300</code>"
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<java.lang.String> rxLeaderStatus() { 
    return AsyncResultSingle.toSingle($handler -> {
      leaderStatus($handler);
    });
  }

  /**
   * Retrieves the Raft peers for the datacenter in which the the agent is running.
   * It returns a list of addresses "<code>10.1.10.12:8300</code>", "<code>10.1.10.13:8300</code>"
   * @param resultHandler will be provided with list of peers
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient peersStatus(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<java.lang.String>>> resultHandler) { 
    delegate.peersStatus(resultHandler);
    return this;
  }

  /**
   * Retrieves the Raft peers for the datacenter in which the the agent is running.
   * It returns a list of addresses "<code>10.1.10.12:8300</code>", "<code>10.1.10.13:8300</code>"
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient peersStatus() {
    return 
peersStatus(ar -> { });
  }

  /**
   * Retrieves the Raft peers for the datacenter in which the the agent is running.
   * It returns a list of addresses "<code>10.1.10.12:8300</code>", "<code>10.1.10.13:8300</code>"
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<java.util.List<java.lang.String>> rxPeersStatus() { 
    return AsyncResultSingle.toSingle($handler -> {
      peersStatus($handler);
    });
  }

  /**
   * Initialize a new session
   * @param idHandler will be provided with ID of new session
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient createSession(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.String>> idHandler) { 
    delegate.createSession(idHandler);
    return this;
  }

  /**
   * Initialize a new session
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient createSession() {
    return 
createSession(ar -> { });
  }

  /**
   * Initialize a new session
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<java.lang.String> rxCreateSession() { 
    return AsyncResultSingle.toSingle($handler -> {
      createSession($handler);
    });
  }

  /**
   * Initialize a new session
   * @param options options used to create session
   * @param idHandler will be provided with ID of new session
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient createSessionWithOptions(io.vertx.ext.consul.SessionOptions options, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.String>> idHandler) { 
    delegate.createSessionWithOptions(options, idHandler);
    return this;
  }

  /**
   * Initialize a new session
   * @param options options used to create session
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient createSessionWithOptions(io.vertx.ext.consul.SessionOptions options) {
    return 
createSessionWithOptions(options, ar -> { });
  }

  /**
   * Initialize a new session
   * @param options options used to create session
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<java.lang.String> rxCreateSessionWithOptions(io.vertx.ext.consul.SessionOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      createSessionWithOptions(options, $handler);
    });
  }

  /**
   * Returns the requested session information
   * @param id the ID of requested session
   * @param resultHandler will be provided with info of requested session
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient infoSession(java.lang.String id, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.consul.Session>> resultHandler) { 
    delegate.infoSession(id, resultHandler);
    return this;
  }

  /**
   * Returns the requested session information
   * @param id the ID of requested session
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient infoSession(java.lang.String id) {
    return 
infoSession(id, ar -> { });
  }

  /**
   * Returns the requested session information
   * @param id the ID of requested session
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<io.vertx.ext.consul.Session> rxInfoSession(java.lang.String id) { 
    return AsyncResultSingle.toSingle($handler -> {
      infoSession(id, $handler);
    });
  }

  /**
   * Returns the requested session information
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#infoSession}
   * @param id the ID of requested session
   * @param options the blocking options
   * @param resultHandler will be provided with info of requested session
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient infoSessionWithOptions(java.lang.String id, io.vertx.ext.consul.BlockingQueryOptions options, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.consul.Session>> resultHandler) { 
    delegate.infoSessionWithOptions(id, options, resultHandler);
    return this;
  }

  /**
   * Returns the requested session information
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#infoSession}
   * @param id the ID of requested session
   * @param options the blocking options
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient infoSessionWithOptions(java.lang.String id, io.vertx.ext.consul.BlockingQueryOptions options) {
    return 
infoSessionWithOptions(id, options, ar -> { });
  }

  /**
   * Returns the requested session information
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#infoSession}
   * @param id the ID of requested session
   * @param options the blocking options
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<io.vertx.ext.consul.Session> rxInfoSessionWithOptions(java.lang.String id, io.vertx.ext.consul.BlockingQueryOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      infoSessionWithOptions(id, options, $handler);
    });
  }

  /**
   * Renews the given session. This is used with sessions that have a TTL, and it extends the expiration by the TTL
   * @param id the ID of session that should be renewed
   * @param resultHandler will be provided with info of renewed session
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient renewSession(java.lang.String id, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.consul.Session>> resultHandler) { 
    delegate.renewSession(id, resultHandler);
    return this;
  }

  /**
   * Renews the given session. This is used with sessions that have a TTL, and it extends the expiration by the TTL
   * @param id the ID of session that should be renewed
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient renewSession(java.lang.String id) {
    return 
renewSession(id, ar -> { });
  }

  /**
   * Renews the given session. This is used with sessions that have a TTL, and it extends the expiration by the TTL
   * @param id the ID of session that should be renewed
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<io.vertx.ext.consul.Session> rxRenewSession(java.lang.String id) { 
    return AsyncResultSingle.toSingle($handler -> {
      renewSession(id, $handler);
    });
  }

  /**
   * Returns the active sessions
   * @param resultHandler will be provided with list of sessions
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient listSessions(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.consul.SessionList>> resultHandler) { 
    delegate.listSessions(resultHandler);
    return this;
  }

  /**
   * Returns the active sessions
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient listSessions() {
    return 
listSessions(ar -> { });
  }

  /**
   * Returns the active sessions
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<io.vertx.ext.consul.SessionList> rxListSessions() { 
    return AsyncResultSingle.toSingle($handler -> {
      listSessions($handler);
    });
  }

  /**
   * Returns the active sessions
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#listSessions}
   * @param options the blocking options
   * @param resultHandler will be provided with list of sessions
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient listSessionsWithOptions(io.vertx.ext.consul.BlockingQueryOptions options, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.consul.SessionList>> resultHandler) { 
    delegate.listSessionsWithOptions(options, resultHandler);
    return this;
  }

  /**
   * Returns the active sessions
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#listSessions}
   * @param options the blocking options
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient listSessionsWithOptions(io.vertx.ext.consul.BlockingQueryOptions options) {
    return 
listSessionsWithOptions(options, ar -> { });
  }

  /**
   * Returns the active sessions
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#listSessions}
   * @param options the blocking options
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<io.vertx.ext.consul.SessionList> rxListSessionsWithOptions(io.vertx.ext.consul.BlockingQueryOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      listSessionsWithOptions(options, $handler);
    });
  }

  /**
   * Returns the active sessions for a given node
   * @param nodeId the ID of node
   * @param resultHandler will be provided with list of sessions
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient listNodeSessions(java.lang.String nodeId, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.consul.SessionList>> resultHandler) { 
    delegate.listNodeSessions(nodeId, resultHandler);
    return this;
  }

  /**
   * Returns the active sessions for a given node
   * @param nodeId the ID of node
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient listNodeSessions(java.lang.String nodeId) {
    return 
listNodeSessions(nodeId, ar -> { });
  }

  /**
   * Returns the active sessions for a given node
   * @param nodeId the ID of node
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<io.vertx.ext.consul.SessionList> rxListNodeSessions(java.lang.String nodeId) { 
    return AsyncResultSingle.toSingle($handler -> {
      listNodeSessions(nodeId, $handler);
    });
  }

  /**
   * Returns the active sessions for a given node
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#listNodeSessions}
   * @param nodeId the ID of node
   * @param options the blocking options
   * @param resultHandler will be provided with list of sessions
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient listNodeSessionsWithOptions(java.lang.String nodeId, io.vertx.ext.consul.BlockingQueryOptions options, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.consul.SessionList>> resultHandler) { 
    delegate.listNodeSessionsWithOptions(nodeId, options, resultHandler);
    return this;
  }

  /**
   * Returns the active sessions for a given node
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#listNodeSessions}
   * @param nodeId the ID of node
   * @param options the blocking options
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient listNodeSessionsWithOptions(java.lang.String nodeId, io.vertx.ext.consul.BlockingQueryOptions options) {
    return 
listNodeSessionsWithOptions(nodeId, options, ar -> { });
  }

  /**
   * Returns the active sessions for a given node
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#listNodeSessions}
   * @param nodeId the ID of node
   * @param options the blocking options
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<io.vertx.ext.consul.SessionList> rxListNodeSessionsWithOptions(java.lang.String nodeId, io.vertx.ext.consul.BlockingQueryOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      listNodeSessionsWithOptions(nodeId, options, $handler);
    });
  }

  /**
   * Destroys the given session
   * @param id the ID of session
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient destroySession(java.lang.String id, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.destroySession(id, resultHandler);
    return this;
  }

  /**
   * Destroys the given session
   * @param id the ID of session
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient destroySession(java.lang.String id) {
    return 
destroySession(id, ar -> { });
  }

  /**
   * Destroys the given session
   * @param id the ID of session
   * @return reference to this, for fluency
   */
  public io.reactivex.Completable rxDestroySession(java.lang.String id) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      destroySession(id, $handler);
    });
  }

  /**
   * @param definition definition of the prepare query
   * @param resultHandler will be provided with id of created prepare query
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient createPreparedQuery(io.vertx.ext.consul.PreparedQueryDefinition definition, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.String>> resultHandler) { 
    delegate.createPreparedQuery(definition, resultHandler);
    return this;
  }

  /**
   * @param definition definition of the prepare query
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient createPreparedQuery(io.vertx.ext.consul.PreparedQueryDefinition definition) {
    return 
createPreparedQuery(definition, ar -> { });
  }

  /**
   * @param definition definition of the prepare query
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<java.lang.String> rxCreatePreparedQuery(io.vertx.ext.consul.PreparedQueryDefinition definition) { 
    return AsyncResultSingle.toSingle($handler -> {
      createPreparedQuery(definition, $handler);
    });
  }

  /**
   * Returns an existing prepared query
   * @param id the id of the query to read
   * @param resultHandler will be provided with definition of the prepare query
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient getPreparedQuery(java.lang.String id, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.consul.PreparedQueryDefinition>> resultHandler) { 
    delegate.getPreparedQuery(id, resultHandler);
    return this;
  }

  /**
   * Returns an existing prepared query
   * @param id the id of the query to read
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient getPreparedQuery(java.lang.String id) {
    return 
getPreparedQuery(id, ar -> { });
  }

  /**
   * Returns an existing prepared query
   * @param id the id of the query to read
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<io.vertx.ext.consul.PreparedQueryDefinition> rxGetPreparedQuery(java.lang.String id) { 
    return AsyncResultSingle.toSingle($handler -> {
      getPreparedQuery(id, $handler);
    });
  }

  /**
   * Returns a list of all prepared queries.
   * @param resultHandler will be provided with list of definitions of the all prepare queries
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient getAllPreparedQueries(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<io.vertx.ext.consul.PreparedQueryDefinition>>> resultHandler) { 
    delegate.getAllPreparedQueries(resultHandler);
    return this;
  }

  /**
   * Returns a list of all prepared queries.
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient getAllPreparedQueries() {
    return 
getAllPreparedQueries(ar -> { });
  }

  /**
   * Returns a list of all prepared queries.
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<java.util.List<io.vertx.ext.consul.PreparedQueryDefinition>> rxGetAllPreparedQueries() { 
    return AsyncResultSingle.toSingle($handler -> {
      getAllPreparedQueries($handler);
    });
  }

  /**
   * @param definition definition of the prepare query
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient updatePreparedQuery(io.vertx.ext.consul.PreparedQueryDefinition definition, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.updatePreparedQuery(definition, resultHandler);
    return this;
  }

  /**
   * @param definition definition of the prepare query
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient updatePreparedQuery(io.vertx.ext.consul.PreparedQueryDefinition definition) {
    return 
updatePreparedQuery(definition, ar -> { });
  }

  /**
   * @param definition definition of the prepare query
   * @return reference to this, for fluency
   */
  public io.reactivex.Completable rxUpdatePreparedQuery(io.vertx.ext.consul.PreparedQueryDefinition definition) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      updatePreparedQuery(definition, $handler);
    });
  }

  /**
   * Deletes an existing prepared query
   * @param id the id of the query to delete
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient deletePreparedQuery(java.lang.String id, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.deletePreparedQuery(id, resultHandler);
    return this;
  }

  /**
   * Deletes an existing prepared query
   * @param id the id of the query to delete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient deletePreparedQuery(java.lang.String id) {
    return 
deletePreparedQuery(id, ar -> { });
  }

  /**
   * Deletes an existing prepared query
   * @param id the id of the query to delete
   * @return reference to this, for fluency
   */
  public io.reactivex.Completable rxDeletePreparedQuery(java.lang.String id) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      deletePreparedQuery(id, $handler);
    });
  }

  /**
   * Executes an existing prepared query.
   * @param query the ID of the query to execute. This can also be the name of an existing prepared query, or a name that matches a prefix name for a prepared query template.
   * @param resultHandler will be provided with response
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient executePreparedQuery(java.lang.String query, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.consul.PreparedQueryExecuteResponse>> resultHandler) { 
    delegate.executePreparedQuery(query, resultHandler);
    return this;
  }

  /**
   * Executes an existing prepared query.
   * @param query the ID of the query to execute. This can also be the name of an existing prepared query, or a name that matches a prefix name for a prepared query template.
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient executePreparedQuery(java.lang.String query) {
    return 
executePreparedQuery(query, ar -> { });
  }

  /**
   * Executes an existing prepared query.
   * @param query the ID of the query to execute. This can also be the name of an existing prepared query, or a name that matches a prefix name for a prepared query template.
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<io.vertx.ext.consul.PreparedQueryExecuteResponse> rxExecutePreparedQuery(java.lang.String query) { 
    return AsyncResultSingle.toSingle($handler -> {
      executePreparedQuery(query, $handler);
    });
  }

  /**
   * Executes an existing prepared query.
   * @param query the ID of the query to execute. This can also be the name of an existing prepared query, or a name that matches a prefix name for a prepared query template.
   * @param options the options used to execute prepared query
   * @param resultHandler will be provided with response
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient executePreparedQueryWithOptions(java.lang.String query, io.vertx.ext.consul.PreparedQueryExecuteOptions options, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.consul.PreparedQueryExecuteResponse>> resultHandler) { 
    delegate.executePreparedQueryWithOptions(query, options, resultHandler);
    return this;
  }

  /**
   * Executes an existing prepared query.
   * @param query the ID of the query to execute. This can also be the name of an existing prepared query, or a name that matches a prefix name for a prepared query template.
   * @param options the options used to execute prepared query
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient executePreparedQueryWithOptions(java.lang.String query, io.vertx.ext.consul.PreparedQueryExecuteOptions options) {
    return 
executePreparedQueryWithOptions(query, options, ar -> { });
  }

  /**
   * Executes an existing prepared query.
   * @param query the ID of the query to execute. This can also be the name of an existing prepared query, or a name that matches a prefix name for a prepared query template.
   * @param options the options used to execute prepared query
   * @return reference to this, for fluency
   */
  public io.reactivex.Single<io.vertx.ext.consul.PreparedQueryExecuteResponse> rxExecutePreparedQueryWithOptions(java.lang.String query, io.vertx.ext.consul.PreparedQueryExecuteOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      executePreparedQueryWithOptions(query, options, $handler);
    });
  }

  /**
   * Register node with external service
   * @param nodeOptions the options of new node
   * @param serviceOptions the options of new service
   * @param resultHandler will be provided with response
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient registerCatalogService(io.vertx.ext.consul.Node nodeOptions, io.vertx.ext.consul.ServiceOptions serviceOptions, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.registerCatalogService(nodeOptions, serviceOptions, resultHandler);
    return this;
  }

  /**
   * Register node with external service
   * @param nodeOptions the options of new node
   * @param serviceOptions the options of new service
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient registerCatalogService(io.vertx.ext.consul.Node nodeOptions, io.vertx.ext.consul.ServiceOptions serviceOptions) {
    return 
registerCatalogService(nodeOptions, serviceOptions, ar -> { });
  }

  /**
   * Register node with external service
   * @param nodeOptions the options of new node
   * @param serviceOptions the options of new service
   * @return reference to this, for fluency
   */
  public io.reactivex.Completable rxRegisterCatalogService(io.vertx.ext.consul.Node nodeOptions, io.vertx.ext.consul.ServiceOptions serviceOptions) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      registerCatalogService(nodeOptions, serviceOptions, $handler);
    });
  }

  /**
   * Deregister entities from the node or deregister the node itself.
   * @param nodeId the ID of node
   * @param serviceId the ID of the service to de-registered; if it is null, the node itself will be de-registered (as well as the entities that belongs to that node)
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient deregisterCatalogService(java.lang.String nodeId, java.lang.String serviceId, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.deregisterCatalogService(nodeId, serviceId, resultHandler);
    return this;
  }

  /**
   * Deregister entities from the node or deregister the node itself.
   * @param nodeId the ID of node
   * @param serviceId the ID of the service to de-registered; if it is null, the node itself will be de-registered (as well as the entities that belongs to that node)
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient deregisterCatalogService(java.lang.String nodeId, java.lang.String serviceId) {
    return 
deregisterCatalogService(nodeId, serviceId, ar -> { });
  }

  /**
   * Deregister entities from the node or deregister the node itself.
   * @param nodeId the ID of node
   * @param serviceId the ID of the service to de-registered; if it is null, the node itself will be de-registered (as well as the entities that belongs to that node)
   * @return reference to this, for fluency
   */
  public io.reactivex.Completable rxDeregisterCatalogService(java.lang.String nodeId, java.lang.String serviceId) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      deregisterCatalogService(nodeId, serviceId, $handler);
    });
  }

  /**
   * Close the client and release its resources
   */
  public void close() { 
    delegate.close();
  }

  public static ConsulClient newInstance(io.vertx.ext.consul.ConsulClient arg) {
    return arg != null ? new ConsulClient(arg) : null;
  }

}
