/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.shareddata;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An asynchronous counter that can be used to across the cluster to maintain a consistent count.
 * <p>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.shareddata.Counter original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.shareddata.Counter.class)
public class Counter implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Counter that = (Counter) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Counter> __TYPE_ARG = new TypeArg<>(    obj -> new Counter((io.vertx.core.shareddata.Counter) obj),
    Counter::getDelegate
  );

  private final io.vertx.core.shareddata.Counter delegate;
  
  public Counter(io.vertx.core.shareddata.Counter delegate) {
    this.delegate = delegate;
  }

  public Counter(Object delegate) {
    this.delegate = (io.vertx.core.shareddata.Counter)delegate;
  }

  @Override 
  public io.vertx.core.shareddata.Counter getDelegate() {
    return delegate;
  }

  /**
   * Get the current value of the counter
   * @param resultHandler handler which will be passed the value
   */
  public void get(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Long>> resultHandler) { 
    delegate.get(resultHandler);
  }

  /**
   * Get the current value of the counter
   */
  public void get() {
    get(ar -> { });
  }

  /**
   * Get the current value of the counter
   * @return 
   */
  public io.reactivex.Single<java.lang.Long> rxGet() { 
    return AsyncResultSingle.toSingle($handler -> {
      get($handler);
    });
  }

  /**
   * Increment the counter atomically and return the new count
   * @param resultHandler handler which will be passed the value
   */
  public void incrementAndGet(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Long>> resultHandler) { 
    delegate.incrementAndGet(resultHandler);
  }

  /**
   * Increment the counter atomically and return the new count
   */
  public void incrementAndGet() {
    incrementAndGet(ar -> { });
  }

  /**
   * Increment the counter atomically and return the new count
   * @return 
   */
  public io.reactivex.Single<java.lang.Long> rxIncrementAndGet() { 
    return AsyncResultSingle.toSingle($handler -> {
      incrementAndGet($handler);
    });
  }

  /**
   * Increment the counter atomically and return the value before the increment.
   * @param resultHandler handler which will be passed the value
   */
  public void getAndIncrement(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Long>> resultHandler) { 
    delegate.getAndIncrement(resultHandler);
  }

  /**
   * Increment the counter atomically and return the value before the increment.
   */
  public void getAndIncrement() {
    getAndIncrement(ar -> { });
  }

  /**
   * Increment the counter atomically and return the value before the increment.
   * @return 
   */
  public io.reactivex.Single<java.lang.Long> rxGetAndIncrement() { 
    return AsyncResultSingle.toSingle($handler -> {
      getAndIncrement($handler);
    });
  }

  /**
   * Decrement the counter atomically and return the new count
   * @param resultHandler handler which will be passed the value
   */
  public void decrementAndGet(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Long>> resultHandler) { 
    delegate.decrementAndGet(resultHandler);
  }

  /**
   * Decrement the counter atomically and return the new count
   */
  public void decrementAndGet() {
    decrementAndGet(ar -> { });
  }

  /**
   * Decrement the counter atomically and return the new count
   * @return 
   */
  public io.reactivex.Single<java.lang.Long> rxDecrementAndGet() { 
    return AsyncResultSingle.toSingle($handler -> {
      decrementAndGet($handler);
    });
  }

  /**
   * Add the value to the counter atomically and return the new count
   * @param value the value to add
   * @param resultHandler handler which will be passed the value
   */
  public void addAndGet(long value, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Long>> resultHandler) { 
    delegate.addAndGet(value, resultHandler);
  }

  /**
   * Add the value to the counter atomically and return the new count
   * @param value the value to add
   */
  public void addAndGet(long value) {
    addAndGet(value, ar -> { });
  }

  /**
   * Add the value to the counter atomically and return the new count
   * @param value the value to add
   * @return 
   */
  public io.reactivex.Single<java.lang.Long> rxAddAndGet(long value) { 
    return AsyncResultSingle.toSingle($handler -> {
      addAndGet(value, $handler);
    });
  }

  /**
   * Add the value to the counter atomically and return the value before the add
   * @param value the value to add
   * @param resultHandler handler which will be passed the value
   */
  public void getAndAdd(long value, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Long>> resultHandler) { 
    delegate.getAndAdd(value, resultHandler);
  }

  /**
   * Add the value to the counter atomically and return the value before the add
   * @param value the value to add
   */
  public void getAndAdd(long value) {
    getAndAdd(value, ar -> { });
  }

  /**
   * Add the value to the counter atomically and return the value before the add
   * @param value the value to add
   * @return 
   */
  public io.reactivex.Single<java.lang.Long> rxGetAndAdd(long value) { 
    return AsyncResultSingle.toSingle($handler -> {
      getAndAdd(value, $handler);
    });
  }

  /**
   * Set the counter to the specified value only if the current value is the expectec value. This happens
   * atomically.
   * @param expected the expected value
   * @param value the new value
   * @param resultHandler the handler will be passed true on success
   */
  public void compareAndSet(long expected, long value, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Boolean>> resultHandler) { 
    delegate.compareAndSet(expected, value, resultHandler);
  }

  /**
   * Set the counter to the specified value only if the current value is the expectec value. This happens
   * atomically.
   * @param expected the expected value
   * @param value the new value
   */
  public void compareAndSet(long expected, long value) {
    compareAndSet(expected, value, ar -> { });
  }

  /**
   * Set the counter to the specified value only if the current value is the expectec value. This happens
   * atomically.
   * @param expected the expected value
   * @param value the new value
   * @return 
   */
  public io.reactivex.Single<java.lang.Boolean> rxCompareAndSet(long expected, long value) { 
    return AsyncResultSingle.toSingle($handler -> {
      compareAndSet(expected, value, $handler);
    });
  }

  public static Counter newInstance(io.vertx.core.shareddata.Counter arg) {
    return arg != null ? new Counter(arg) : null;
  }

}
