/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.amqp;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Once connected to the broker or router, you get a connection. This connection is automatically opened.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.amqp.AmqpConnection original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.amqp.AmqpConnection.class)
public class AmqpConnection implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AmqpConnection that = (AmqpConnection) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<AmqpConnection> __TYPE_ARG = new TypeArg<>(    obj -> new AmqpConnection((io.vertx.amqp.AmqpConnection) obj),
    AmqpConnection::getDelegate
  );

  private final io.vertx.amqp.AmqpConnection delegate;
  
  public AmqpConnection(io.vertx.amqp.AmqpConnection delegate) {
    this.delegate = delegate;
  }

  public AmqpConnection(Object delegate) {
    this.delegate = (io.vertx.amqp.AmqpConnection)delegate;
  }

  @Override 
  public io.vertx.amqp.AmqpConnection getDelegate() {
    return delegate;
  }


  /**
   * Registers a handler called on disconnection.
   * @param handler the exception handler.
   * @return the connection
   */
  public io.vertx.reactivex.amqp.AmqpConnection exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * Closes the AMQP connection, i.e. allows the Close frame to be emitted.
   * @param done the close handler notified when the connection is closed. May be <code>null</code>.
   * @return the connection
   */
  public io.vertx.reactivex.amqp.AmqpConnection close(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> done) { 
    delegate.close(done);
    return this;
  }

  /**
   * Closes the AMQP connection, i.e. allows the Close frame to be emitted.
   * @return the connection
   */
  public io.vertx.reactivex.amqp.AmqpConnection close() {
    return 
close(ar -> { });
  }

  /**
   * Closes the AMQP connection, i.e. allows the Close frame to be emitted.
   * @return the connection
   */
  public io.reactivex.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      close($handler);
    });
  }

  /**
   * Creates a receiver used to consume messages from the given address. The receiver has no handler and won't
   * start receiving messages until a handler is explicitly configured.
   * @param address The source address to attach the consumer to, must not be <code>null</code>
   * @param completionHandler the handler called with the receiver. The receiver has been opened.
   * @return the connection.
   */
  public io.vertx.reactivex.amqp.AmqpConnection createReceiver(java.lang.String address, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.amqp.AmqpReceiver>> completionHandler) { 
    delegate.createReceiver(address, io.vertx.lang.reactivex.Helper.convertHandler(completionHandler, ar -> ar.map(event -> io.vertx.reactivex.amqp.AmqpReceiver.newInstance((io.vertx.amqp.AmqpReceiver)event))));
    return this;
  }

  /**
   * Creates a receiver used to consume messages from the given address. The receiver has no handler and won't
   * start receiving messages until a handler is explicitly configured.
   * @param address The source address to attach the consumer to, must not be <code>null</code>
   * @return the connection.
   */
  public io.vertx.reactivex.amqp.AmqpConnection createReceiver(java.lang.String address) {
    return 
createReceiver(address, ar -> { });
  }

  /**
   * Creates a receiver used to consume messages from the given address. The receiver has no handler and won't
   * start receiving messages until a handler is explicitly configured.
   * @param address The source address to attach the consumer to, must not be <code>null</code>
   * @return the connection.
   */
  public io.reactivex.Single<io.vertx.reactivex.amqp.AmqpReceiver> rxCreateReceiver(java.lang.String address) { 
    return AsyncResultSingle.toSingle($handler -> {
      createReceiver(address, $handler);
    });
  }

  /**
   * Creates a receiver used to consumer messages from the given address.
   * @param address The source address to attach the consumer to.
   * @param receiverOptions The options for this receiver.
   * @param completionHandler The handler called with the receiver, once opened. Note that the <code>messageHandler</code> can be called before the <code>completionHandler</code> if messages are awaiting delivery.
   * @return the connection.
   */
  public io.vertx.reactivex.amqp.AmqpConnection createReceiver(java.lang.String address, io.vertx.amqp.AmqpReceiverOptions receiverOptions, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.amqp.AmqpReceiver>> completionHandler) { 
    delegate.createReceiver(address, receiverOptions, io.vertx.lang.reactivex.Helper.convertHandler(completionHandler, ar -> ar.map(event -> io.vertx.reactivex.amqp.AmqpReceiver.newInstance((io.vertx.amqp.AmqpReceiver)event))));
    return this;
  }

  /**
   * Creates a receiver used to consumer messages from the given address.
   * @param address The source address to attach the consumer to.
   * @param receiverOptions The options for this receiver.
   * @return the connection.
   */
  public io.vertx.reactivex.amqp.AmqpConnection createReceiver(java.lang.String address, io.vertx.amqp.AmqpReceiverOptions receiverOptions) {
    return 
createReceiver(address, receiverOptions, ar -> { });
  }

  /**
   * Creates a receiver used to consumer messages from the given address.
   * @param address The source address to attach the consumer to.
   * @param receiverOptions The options for this receiver.
   * @return the connection.
   */
  public io.reactivex.Single<io.vertx.reactivex.amqp.AmqpReceiver> rxCreateReceiver(java.lang.String address, io.vertx.amqp.AmqpReceiverOptions receiverOptions) { 
    return AsyncResultSingle.toSingle($handler -> {
      createReceiver(address, receiverOptions, $handler);
    });
  }

  /**
   * Creates a dynamic receiver. The address is provided by the broker and is available in the <code>completionHandler</code>,
   * using the {@link io.vertx.reactivex.amqp.AmqpReceiver#address} method. this method is useful for request-reply to generate a unique
   * reply address.
   * @param completionHandler the completion handler, called when the receiver has been created and opened.
   * @return the connection.
   */
  public io.vertx.reactivex.amqp.AmqpConnection createDynamicReceiver(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.amqp.AmqpReceiver>> completionHandler) { 
    delegate.createDynamicReceiver(io.vertx.lang.reactivex.Helper.convertHandler(completionHandler, ar -> ar.map(event -> io.vertx.reactivex.amqp.AmqpReceiver.newInstance((io.vertx.amqp.AmqpReceiver)event))));
    return this;
  }

  /**
   * Creates a dynamic receiver. The address is provided by the broker and is available in the <code>completionHandler</code>,
   * using the {@link io.vertx.reactivex.amqp.AmqpReceiver#address} method. this method is useful for request-reply to generate a unique
   * reply address.
   * @return the connection.
   */
  public io.vertx.reactivex.amqp.AmqpConnection createDynamicReceiver() {
    return 
createDynamicReceiver(ar -> { });
  }

  /**
   * Creates a dynamic receiver. The address is provided by the broker and is available in the <code>completionHandler</code>,
   * using the {@link io.vertx.reactivex.amqp.AmqpReceiver#address} method. this method is useful for request-reply to generate a unique
   * reply address.
   * @return the connection.
   */
  public io.reactivex.Single<io.vertx.reactivex.amqp.AmqpReceiver> rxCreateDynamicReceiver() { 
    return AsyncResultSingle.toSingle($handler -> {
      createDynamicReceiver($handler);
    });
  }

  /**
   * Creates a sender used to send messages to the given address. The address must be set. For anonymous sender, check
   * {@link io.vertx.reactivex.amqp.AmqpConnection#createAnonymousSender}.
   * @param address The target address to attach to, must not be <code>null</code>
   * @param completionHandler The handler called with the sender, once opened
   * @return the connection.
   */
  public io.vertx.reactivex.amqp.AmqpConnection createSender(java.lang.String address, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.amqp.AmqpSender>> completionHandler) { 
    delegate.createSender(address, io.vertx.lang.reactivex.Helper.convertHandler(completionHandler, ar -> ar.map(event -> io.vertx.reactivex.amqp.AmqpSender.newInstance((io.vertx.amqp.AmqpSender)event))));
    return this;
  }

  /**
   * Creates a sender used to send messages to the given address. The address must be set. For anonymous sender, check
   * {@link io.vertx.reactivex.amqp.AmqpConnection#createAnonymousSender}.
   * @param address The target address to attach to, must not be <code>null</code>
   * @return the connection.
   */
  public io.vertx.reactivex.amqp.AmqpConnection createSender(java.lang.String address) {
    return 
createSender(address, ar -> { });
  }

  /**
   * Creates a sender used to send messages to the given address. The address must be set. For anonymous sender, check
   * {@link io.vertx.reactivex.amqp.AmqpConnection#createAnonymousSender}.
   * @param address The target address to attach to, must not be <code>null</code>
   * @return the connection.
   */
  public io.reactivex.Single<io.vertx.reactivex.amqp.AmqpSender> rxCreateSender(java.lang.String address) { 
    return AsyncResultSingle.toSingle($handler -> {
      createSender(address, $handler);
    });
  }

  /**
   * Creates a sender used to send messages to the given address. The address must be set. For anonymous sender, check
   * {@link io.vertx.reactivex.amqp.AmqpConnection#createAnonymousSender}.
   * @param address The target address to attach to, allowed to be <code>null</code> if the <code>options</code> configures the sender to be attached to a dynamic address (provided by the broker).
   * @param options The AMQP sender options
   * @param completionHandler The handler called with the sender, once opened
   * @return the connection.
   */
  public io.vertx.reactivex.amqp.AmqpConnection createSender(java.lang.String address, io.vertx.amqp.AmqpSenderOptions options, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.amqp.AmqpSender>> completionHandler) { 
    delegate.createSender(address, options, io.vertx.lang.reactivex.Helper.convertHandler(completionHandler, ar -> ar.map(event -> io.vertx.reactivex.amqp.AmqpSender.newInstance((io.vertx.amqp.AmqpSender)event))));
    return this;
  }

  /**
   * Creates a sender used to send messages to the given address. The address must be set. For anonymous sender, check
   * {@link io.vertx.reactivex.amqp.AmqpConnection#createAnonymousSender}.
   * @param address The target address to attach to, allowed to be <code>null</code> if the <code>options</code> configures the sender to be attached to a dynamic address (provided by the broker).
   * @param options The AMQP sender options
   * @return the connection.
   */
  public io.vertx.reactivex.amqp.AmqpConnection createSender(java.lang.String address, io.vertx.amqp.AmqpSenderOptions options) {
    return 
createSender(address, options, ar -> { });
  }

  /**
   * Creates a sender used to send messages to the given address. The address must be set. For anonymous sender, check
   * {@link io.vertx.reactivex.amqp.AmqpConnection#createAnonymousSender}.
   * @param address The target address to attach to, allowed to be <code>null</code> if the <code>options</code> configures the sender to be attached to a dynamic address (provided by the broker).
   * @param options The AMQP sender options
   * @return the connection.
   */
  public io.reactivex.Single<io.vertx.reactivex.amqp.AmqpSender> rxCreateSender(java.lang.String address, io.vertx.amqp.AmqpSenderOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      createSender(address, options, $handler);
    });
  }

  /**
   * Creates an anonymous sender.
   * <p>
   * Unlike "regular" sender, this sender is not associated to a specific address, and each message sent must provide
   * an address. This method can be used in request-reply scenarios where you create a sender to send the reply,
   * but you don't know the address, as the reply address is passed into the message you are going to receive.
   * @param completionHandler The handler called with the created sender, once opened
   * @return the connection.
   */
  public io.vertx.reactivex.amqp.AmqpConnection createAnonymousSender(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.amqp.AmqpSender>> completionHandler) { 
    delegate.createAnonymousSender(io.vertx.lang.reactivex.Helper.convertHandler(completionHandler, ar -> ar.map(event -> io.vertx.reactivex.amqp.AmqpSender.newInstance((io.vertx.amqp.AmqpSender)event))));
    return this;
  }

  /**
   * Creates an anonymous sender.
   * <p>
   * Unlike "regular" sender, this sender is not associated to a specific address, and each message sent must provide
   * an address. This method can be used in request-reply scenarios where you create a sender to send the reply,
   * but you don't know the address, as the reply address is passed into the message you are going to receive.
   * @return the connection.
   */
  public io.vertx.reactivex.amqp.AmqpConnection createAnonymousSender() {
    return 
createAnonymousSender(ar -> { });
  }

  /**
   * Creates an anonymous sender.
   * <p>
   * Unlike "regular" sender, this sender is not associated to a specific address, and each message sent must provide
   * an address. This method can be used in request-reply scenarios where you create a sender to send the reply,
   * but you don't know the address, as the reply address is passed into the message you are going to receive.
   * @return the connection.
   */
  public io.reactivex.Single<io.vertx.reactivex.amqp.AmqpSender> rxCreateAnonymousSender() { 
    return AsyncResultSingle.toSingle($handler -> {
      createAnonymousSender($handler);
    });
  }

  /**
   * @return whether the connection has been disconnected.
   */
  public boolean isDisconnected() { 
    boolean ret = delegate.isDisconnected();
    return ret;
  }

  /**
   * @return a future completed when the connection is closed
   */
  public io.vertx.core.Future<java.lang.Void> closeFuture() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.closeFuture().map(val -> val);
    return ret;
  }

  /**
   * @return the underlying ProtonConnection.
   */
  public io.vertx.proton.ProtonConnection unwrap() { 
    io.vertx.proton.ProtonConnection ret = delegate.unwrap();
    return ret;
  }

  public static AmqpConnection newInstance(io.vertx.amqp.AmqpConnection arg) {
    return arg != null ? new AmqpConnection(arg) : null;
  }

}
