/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.http;

import io.reactivex.Single;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.PoolOptions;
import io.vertx.core.http.RequestOptions;
import io.vertx.lang.rx.DelegatingHandler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.SingleHelper;
import io.vertx.reactivex.core.http.HttpClient;
import io.vertx.reactivex.core.http.HttpClientResponse;
import io.vertx.reactivex.core.http.HttpConnection;
import java.util.function.Function;

@RxGen(value=io.vertx.core.http.HttpClientBuilder.class)
public class HttpClientBuilder {
    public static final TypeArg<HttpClientBuilder> __TYPE_ARG = new TypeArg(obj -> new HttpClientBuilder((io.vertx.core.http.HttpClientBuilder)obj), HttpClientBuilder::getDelegate);
    private final io.vertx.core.http.HttpClientBuilder delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpClientBuilder that = (HttpClientBuilder)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public HttpClientBuilder(io.vertx.core.http.HttpClientBuilder delegate) {
        this.delegate = delegate;
    }

    public HttpClientBuilder(Object delegate) {
        this.delegate = (io.vertx.core.http.HttpClientBuilder)delegate;
    }

    public io.vertx.core.http.HttpClientBuilder getDelegate() {
        return this.delegate;
    }

    public HttpClientBuilder with(HttpClientOptions options) {
        this.delegate.with(options);
        return this;
    }

    public HttpClientBuilder with(PoolOptions options) {
        this.delegate.with(options);
        return this;
    }

    public HttpClientBuilder withConnectHandler(Handler<HttpConnection> handler) {
        this.delegate.withConnectHandler((Handler)new DelegatingHandler(handler, event -> HttpConnection.newInstance(event)));
        return this;
    }

    public HttpClientBuilder withRedirectHandler(final Function<HttpClientResponse, Future<RequestOptions>> handler) {
        this.delegate.withRedirectHandler((Function)new Function<io.vertx.core.http.HttpClientResponse, Future<RequestOptions>>(){

            @Override
            public Future<RequestOptions> apply(io.vertx.core.http.HttpClientResponse arg) {
                Future ret = (Future)handler.apply(HttpClientResponse.newInstance(arg));
                return ret.map(val -> val);
            }
        });
        return this;
    }

    public HttpClientBuilder withRedirectHandler(final io.reactivex.functions.Function<HttpClientResponse, Single<RequestOptions>> handler) {
        this.delegate.withRedirectHandler((Function)new Function<io.vertx.core.http.HttpClientResponse, Future<RequestOptions>>(){

            @Override
            public Future<RequestOptions> apply(io.vertx.core.http.HttpClientResponse arg) {
                Single ret;
                try {
                    ret = (Single)handler.apply((Object)HttpClientResponse.newInstance(arg));
                }
                catch (Exception e) {
                    return Future.failedFuture((Throwable)e);
                }
                return SingleHelper.toFuture((Single)ret, obj -> obj);
            }
        });
        return this;
    }

    public HttpClient build() {
        HttpClient ret = HttpClient.newInstance(this.delegate.build());
        return ret;
    }

    public static HttpClientBuilder newInstance(io.vertx.core.http.HttpClientBuilder arg) {
        return arg != null ? new HttpClientBuilder(arg) : null;
    }
}

