/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.dns;

import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.lang.rx.DelegatingHandler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.core.dns.MxRecord;
import io.vertx.reactivex.core.dns.SrvRecord;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import java.util.List;
import java.util.stream.Collectors;

@RxGen(value=io.vertx.core.dns.DnsClient.class)
public class DnsClient {
    public static final TypeArg<DnsClient> __TYPE_ARG = new TypeArg(obj -> new DnsClient((io.vertx.core.dns.DnsClient)obj), DnsClient::getDelegate);
    private final io.vertx.core.dns.DnsClient delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DnsClient that = (DnsClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public DnsClient(io.vertx.core.dns.DnsClient delegate) {
        this.delegate = delegate;
    }

    public DnsClient(Object delegate) {
        this.delegate = (io.vertx.core.dns.DnsClient)delegate;
    }

    public io.vertx.core.dns.DnsClient getDelegate() {
        return this.delegate;
    }

    public DnsClient lookup(String name, Handler<AsyncResult<String>> handler) {
        this.delegate.lookup(name, handler);
        return this;
    }

    public DnsClient lookup(String name) {
        return this.lookup(name, (Handler<AsyncResult<String>>)((Handler)ar -> {}));
    }

    public Maybe<String> rxLookup(String name) {
        return AsyncResultMaybe.toMaybe($handler -> this.lookup(name, (Handler<AsyncResult<String>>)$handler));
    }

    public DnsClient lookup4(String name, Handler<AsyncResult<String>> handler) {
        this.delegate.lookup4(name, handler);
        return this;
    }

    public DnsClient lookup4(String name) {
        return this.lookup4(name, (Handler<AsyncResult<String>>)((Handler)ar -> {}));
    }

    public Maybe<String> rxLookup4(String name) {
        return AsyncResultMaybe.toMaybe($handler -> this.lookup4(name, (Handler<AsyncResult<String>>)$handler));
    }

    public DnsClient lookup6(String name, Handler<AsyncResult<String>> handler) {
        this.delegate.lookup6(name, handler);
        return this;
    }

    public DnsClient lookup6(String name) {
        return this.lookup6(name, (Handler<AsyncResult<String>>)((Handler)ar -> {}));
    }

    public Maybe<String> rxLookup6(String name) {
        return AsyncResultMaybe.toMaybe($handler -> this.lookup6(name, (Handler<AsyncResult<String>>)$handler));
    }

    public DnsClient resolveA(String name, Handler<AsyncResult<List<String>>> handler) {
        this.delegate.resolveA(name, handler);
        return this;
    }

    public DnsClient resolveA(String name) {
        return this.resolveA(name, (Handler<AsyncResult<List<String>>>)((Handler)ar -> {}));
    }

    public Single<List<String>> rxResolveA(String name) {
        return AsyncResultSingle.toSingle($handler -> this.resolveA(name, (Handler<AsyncResult<List<String>>>)$handler));
    }

    public DnsClient resolveAAAA(String name, Handler<AsyncResult<List<String>>> handler) {
        this.delegate.resolveAAAA(name, handler);
        return this;
    }

    public DnsClient resolveAAAA(String name) {
        return this.resolveAAAA(name, (Handler<AsyncResult<List<String>>>)((Handler)ar -> {}));
    }

    public Single<List<String>> rxResolveAAAA(String name) {
        return AsyncResultSingle.toSingle($handler -> this.resolveAAAA(name, (Handler<AsyncResult<List<String>>>)$handler));
    }

    public DnsClient resolveCNAME(String name, Handler<AsyncResult<List<String>>> handler) {
        this.delegate.resolveCNAME(name, handler);
        return this;
    }

    public DnsClient resolveCNAME(String name) {
        return this.resolveCNAME(name, (Handler<AsyncResult<List<String>>>)((Handler)ar -> {}));
    }

    public Single<List<String>> rxResolveCNAME(String name) {
        return AsyncResultSingle.toSingle($handler -> this.resolveCNAME(name, (Handler<AsyncResult<List<String>>>)$handler));
    }

    public DnsClient resolveMX(String name, Handler<AsyncResult<List<MxRecord>>> handler) {
        this.delegate.resolveMX(name, (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> event.stream().map(elt -> MxRecord.newInstance(elt)).collect(Collectors.toList()))));
        return this;
    }

    public DnsClient resolveMX(String name) {
        return this.resolveMX(name, (Handler<AsyncResult<List<MxRecord>>>)((Handler)ar -> {}));
    }

    public Single<List<MxRecord>> rxResolveMX(String name) {
        return AsyncResultSingle.toSingle($handler -> this.resolveMX(name, (Handler<AsyncResult<List<MxRecord>>>)$handler));
    }

    public DnsClient resolveTXT(String name, Handler<AsyncResult<List<String>>> handler) {
        this.delegate.resolveTXT(name, handler);
        return this;
    }

    public DnsClient resolveTXT(String name) {
        return this.resolveTXT(name, (Handler<AsyncResult<List<String>>>)((Handler)ar -> {}));
    }

    public Single<List<String>> rxResolveTXT(String name) {
        return AsyncResultSingle.toSingle($handler -> this.resolveTXT(name, (Handler<AsyncResult<List<String>>>)$handler));
    }

    public DnsClient resolvePTR(String name, Handler<AsyncResult<String>> handler) {
        this.delegate.resolvePTR(name, handler);
        return this;
    }

    public DnsClient resolvePTR(String name) {
        return this.resolvePTR(name, (Handler<AsyncResult<String>>)((Handler)ar -> {}));
    }

    public Maybe<String> rxResolvePTR(String name) {
        return AsyncResultMaybe.toMaybe($handler -> this.resolvePTR(name, (Handler<AsyncResult<String>>)$handler));
    }

    public DnsClient resolveNS(String name, Handler<AsyncResult<List<String>>> handler) {
        this.delegate.resolveNS(name, handler);
        return this;
    }

    public DnsClient resolveNS(String name) {
        return this.resolveNS(name, (Handler<AsyncResult<List<String>>>)((Handler)ar -> {}));
    }

    public Single<List<String>> rxResolveNS(String name) {
        return AsyncResultSingle.toSingle($handler -> this.resolveNS(name, (Handler<AsyncResult<List<String>>>)$handler));
    }

    public DnsClient resolveSRV(String name, Handler<AsyncResult<List<SrvRecord>>> handler) {
        this.delegate.resolveSRV(name, (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> event.stream().map(elt -> SrvRecord.newInstance(elt)).collect(Collectors.toList()))));
        return this;
    }

    public DnsClient resolveSRV(String name) {
        return this.resolveSRV(name, (Handler<AsyncResult<List<SrvRecord>>>)((Handler)ar -> {}));
    }

    public Single<List<SrvRecord>> rxResolveSRV(String name) {
        return AsyncResultSingle.toSingle($handler -> this.resolveSRV(name, (Handler<AsyncResult<List<SrvRecord>>>)$handler));
    }

    public DnsClient reverseLookup(String ipaddress, Handler<AsyncResult<String>> handler) {
        this.delegate.reverseLookup(ipaddress, handler);
        return this;
    }

    public DnsClient reverseLookup(String ipaddress) {
        return this.reverseLookup(ipaddress, (Handler<AsyncResult<String>>)((Handler)ar -> {}));
    }

    public Maybe<String> rxReverseLookup(String ipaddress) {
        return AsyncResultMaybe.toMaybe($handler -> this.reverseLookup(ipaddress, (Handler<AsyncResult<String>>)$handler));
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    public void close() {
        this.close((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable($handler -> this.close((Handler<AsyncResult<Void>>)$handler));
    }

    public static DnsClient newInstance(io.vertx.core.dns.DnsClient arg) {
        return arg != null ? new DnsClient(arg) : null;
    }
}

