/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.test;

import io.reactivex.Single;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Promise;
import io.vertx.core.Verticle;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.reactivex.core.RxHelper;
import io.vertx.reactivex.core.Vertx;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class RxHelperTest {
    private Vertx vertx = Vertx.vertx();

    @After
    public void tearDown() {
        this.vertx.close();
    }

    @Test
    public void deployVerticle() throws Exception {
        CoreVerticle verticle = new CoreVerticle();
        Single single = RxHelper.deployVerticle((Vertx)this.vertx, (Verticle)verticle);
        Assert.assertNull((Object)verticle.config);
        single.blockingGet();
        Assert.assertNotNull((Object)verticle.config);
        Assert.assertTrue((boolean)verticle.config.isEmpty());
    }

    @Test
    public void deployVerticleWithOptions() throws Exception {
        CoreVerticle verticle = new CoreVerticle();
        JsonObject expected = new JsonObject().put("bim", Integer.valueOf(1)).put("bam", new JsonArray().add(Integer.valueOf(1)).add(Integer.valueOf(2)).add(Integer.valueOf(3))).put("boum", new JsonObject().put("toto", "titi"));
        Single single = RxHelper.deployVerticle((Vertx)this.vertx, (Verticle)verticle, (DeploymentOptions)new DeploymentOptions().setConfig(expected));
        Assert.assertNull((Object)verticle.config);
        single.blockingGet();
        Assert.assertEquals((Object)expected, (Object)verticle.config);
    }

    @Test
    public void deployVerticleFailure() throws Exception {
        CoreVerticle verticle = new CoreVerticle(true);
        Single single = RxHelper.deployVerticle((Vertx)this.vertx, (Verticle)verticle);
        Assert.assertNull((Object)verticle.config);
        try {
            single.blockingGet();
            Assert.fail((String)"Verticle deployment should fail");
        }
        catch (RuntimeException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(MyException.class));
            Assert.assertNotNull((Object)verticle.config);
            Assert.assertTrue((boolean)verticle.config.isEmpty());
        }
    }

    static class MyException
    extends Exception {
        MyException() {
        }
    }

    public static class CoreVerticle
    extends AbstractVerticle {
        private final boolean failDeployment;
        private volatile JsonObject config;

        public CoreVerticle() {
            this.failDeployment = false;
        }

        public CoreVerticle(boolean failDeployment) {
            this.failDeployment = failDeployment;
        }

        public void start(Promise<Void> startFuture) throws Exception {
            this.config = this.config();
            if (this.failDeployment) {
                startFuture.fail((Throwable)new MyException());
            } else {
                startFuture.complete();
            }
        }
    }
}

