/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.test;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.reactivex.Flowable;
import io.reactivex.FlowableTransformer;
import io.reactivex.Maybe;
import io.reactivex.MaybeTransformer;
import io.reactivex.Observable;
import io.reactivex.ObservableTransformer;
import io.reactivex.Single;
import io.reactivex.SingleTransformer;
import io.vertx.core.buffer.Buffer;
import io.vertx.lang.rx.test.SimplePojo;
import io.vertx.lang.rx.test.TestSubscriber;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.MaybeHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.SingleHelper;
import io.vertx.reactivex.test.TestUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BufferTest {
    ObjectMapper mapper;

    @Before
    public void setUp() throws Exception {
        this.mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    }

    @Test
    public void testFlowableMapPojoFromBuffer() throws Exception {
        this.testFlowableMapPojoFromBuffer((Flowable<Buffer>)Flowable.just((Object)Buffer.buffer((String)"{\"foo\""), (Object)Buffer.buffer((String)":\"bar\"}")), (FlowableTransformer<Buffer, SimplePojo>)FlowableHelper.unmarshaller(SimplePojo.class));
    }

    @Test
    public void testFlowableMapPojoFromBufferCustom() throws Exception {
        this.testFlowableMapPojoFromBuffer((Flowable<Buffer>)Flowable.just((Object)Buffer.buffer((String)"foo"), (Object)Buffer.buffer((String)": bar")), (FlowableTransformer<Buffer, SimplePojo>)FlowableHelper.unmarshaller(SimplePojo.class, (ObjectMapper)this.mapper));
    }

    private void testFlowableMapPojoFromBuffer(Flowable<Buffer> stream, FlowableTransformer<Buffer, SimplePojo> composer) throws Exception {
        Flowable mapped = stream.compose(composer);
        TestSubscriber subscriber = new TestSubscriber().prefetch(0L);
        TestUtils.subscribe((Flowable)mapped, (TestSubscriber)subscriber);
        subscriber.assertEmpty().request(1L).assertItem((Object)new SimplePojo("bar")).assertCompleted().assertEmpty();
    }

    @Test
    public void testObservableMapPojoFromBuffer() throws Exception {
        this.testObservableMapPojoFromBuffer((Observable<Buffer>)Observable.just((Object)Buffer.buffer((String)"{\"foo\""), (Object)Buffer.buffer((String)":\"bar\"}")), (ObservableTransformer<Buffer, SimplePojo>)ObservableHelper.unmarshaller(SimplePojo.class));
    }

    @Test
    public void testObservableMapPojoFromBufferCustom() throws Exception {
        this.testObservableMapPojoFromBuffer((Observable<Buffer>)Observable.just((Object)Buffer.buffer((String)"foo"), (Object)Buffer.buffer((String)": bar")), (ObservableTransformer<Buffer, SimplePojo>)ObservableHelper.unmarshaller(SimplePojo.class, (ObjectMapper)this.mapper));
    }

    private void testObservableMapPojoFromBuffer(Observable<Buffer> stream, ObservableTransformer<Buffer, SimplePojo> composer) throws Exception {
        Observable mapped = stream.compose(composer);
        TestSubscriber subscriber = new TestSubscriber();
        TestUtils.subscribe((Observable)mapped, (TestSubscriber)subscriber);
        subscriber.assertItem((Object)new SimplePojo("bar")).assertCompleted().assertEmpty();
    }

    @Test
    public void testSingleMapPojoFromBuffer() throws Exception {
        this.testSingleMapFromBuffer("{\"foo\":\"bar\"}", SingleHelper.unmarshaller(SimplePojo.class), new SimplePojo("bar"));
    }

    @Test
    public void testSingleMapPojoFromBufferCustom() throws Exception {
        this.testSingleMapFromBuffer("foo: bar", SingleHelper.unmarshaller(SimplePojo.class, (ObjectMapper)this.mapper), new SimplePojo("bar"));
    }

    @Test
    public void testMaybeMapPojoFromBuffer() throws Exception {
        BufferTest.testMaybeMapFromBuffer("{\"foo\":\"bar\"}", MaybeHelper.unmarshaller(SimplePojo.class), new SimplePojo("bar"));
    }

    @Test
    public void testMaybeMapPojoFromBufferCustom() throws Exception {
        BufferTest.testMaybeMapFromBuffer("foo: bar", MaybeHelper.unmarshaller(SimplePojo.class, (ObjectMapper)this.mapper), new SimplePojo("bar"));
    }

    @Test
    public void testFlowableMapPojoFromBufferFailure() throws Exception {
        this.testFlowableMapPojoFromBufferFailure((Flowable<Buffer>)Flowable.just((Object)Buffer.buffer((String)"{\"foo\"")), (FlowableTransformer<Buffer, SimplePojo>)FlowableHelper.unmarshaller(SimplePojo.class));
    }

    @Test
    public void testFlowableMapPojoFromBufferFailureCustom() throws Exception {
        this.testFlowableMapPojoFromBufferFailure((Flowable<Buffer>)Flowable.just((Object)Buffer.buffer((String)"{\"foo\"")), (FlowableTransformer<Buffer, SimplePojo>)FlowableHelper.unmarshaller(SimplePojo.class, (ObjectMapper)this.mapper));
    }

    private void testFlowableMapPojoFromBufferFailure(Flowable<Buffer> stream, FlowableTransformer<Buffer, SimplePojo> composer) throws Exception {
        Flowable mapped = stream.compose(composer);
        TestSubscriber subscriber = new TestSubscriber().prefetch(0L);
        TestUtils.subscribe((Flowable)mapped, (TestSubscriber)subscriber);
        subscriber.request(1L).assertError(err -> TestCase.assertTrue((boolean)(err instanceof JsonParseException))).assertEmpty();
    }

    @Test
    public void testObservableMapPojoFromBufferFailure() throws Exception {
        this.testObservableMapPojoFromBufferFailure((Observable<Buffer>)Observable.just((Object)Buffer.buffer((String)"{\"foo\"")), (ObservableTransformer<Buffer, SimplePojo>)ObservableHelper.unmarshaller(SimplePojo.class));
    }

    @Test
    public void testObservableMapPojoFromBufferFailureCustom() throws Exception {
        this.testObservableMapPojoFromBufferFailure((Observable<Buffer>)Observable.just((Object)Buffer.buffer((String)"{\"foo\"")), (ObservableTransformer<Buffer, SimplePojo>)ObservableHelper.unmarshaller(SimplePojo.class, (ObjectMapper)this.mapper));
    }

    private void testObservableMapPojoFromBufferFailure(Observable<Buffer> stream, ObservableTransformer<Buffer, SimplePojo> composer) throws Exception {
        Observable mapped = stream.compose(composer);
        TestSubscriber subscriber = new TestSubscriber();
        TestUtils.subscribe((Observable)mapped, (TestSubscriber)subscriber);
        subscriber.assertError(err -> TestCase.assertTrue((boolean)(err instanceof JsonParseException))).assertEmpty();
    }

    @Test
    public void testSingleMapPojoFromBufferFailure() throws Exception {
        this.testSingleMapPojoFromBufferFailure((Single<Buffer>)Single.just((Object)Buffer.buffer((String)"{\"foo\"")), (SingleTransformer<Buffer, SimplePojo>)SingleHelper.unmarshaller(SimplePojo.class));
    }

    @Test
    public void testSingleMapPojoFromBufferFailureCustom() throws Exception {
        this.testSingleMapPojoFromBufferFailure((Single<Buffer>)Single.just((Object)Buffer.buffer((String)"{\"foo\"")), (SingleTransformer<Buffer, SimplePojo>)SingleHelper.unmarshaller(SimplePojo.class, (ObjectMapper)this.mapper));
    }

    private void testSingleMapPojoFromBufferFailure(Single<Buffer> stream, SingleTransformer<Buffer, SimplePojo> composer) throws Exception {
        Single mapped = stream.compose(composer);
        TestSubscriber subscriber = new TestSubscriber();
        TestUtils.subscribe((Single)mapped, (TestSubscriber)subscriber);
        subscriber.assertError(err -> TestCase.assertTrue((boolean)(err instanceof JsonParseException))).assertEmpty();
    }

    @Test
    public void testMaybeMapPojoFromBufferFailure() throws Exception {
        this.testMaybeMapPojoFromBufferFailure((Maybe<Buffer>)Maybe.just((Object)Buffer.buffer((String)"{\"foo\"")), (MaybeTransformer<Buffer, SimplePojo>)MaybeHelper.unmarshaller(SimplePojo.class));
    }

    @Test
    public void testMaybeMapPojoFromBufferFailureCustom() throws Exception {
        this.testMaybeMapPojoFromBufferFailure((Maybe<Buffer>)Maybe.just((Object)Buffer.buffer((String)"{\"foo\"")), (MaybeTransformer<Buffer, SimplePojo>)MaybeHelper.unmarshaller(SimplePojo.class, (ObjectMapper)this.mapper));
    }

    private void testMaybeMapPojoFromBufferFailure(Maybe<Buffer> stream, MaybeTransformer<Buffer, SimplePojo> transformer) throws Exception {
        Maybe mapped = stream.compose(transformer);
        TestSubscriber subscriber = new TestSubscriber();
        TestUtils.subscribe((Maybe)mapped, (TestSubscriber)subscriber);
        subscriber.assertError(err -> TestCase.assertTrue((boolean)(err instanceof JsonParseException))).assertEmpty();
    }

    @Test
    public void testFlowableMapObjectNodeFromBuffer() throws Exception {
        this.testFlowableMapObjectNodeFromBuffer((Flowable<Buffer>)Flowable.just((Object)Buffer.buffer((String)"{\"foo\""), (Object)Buffer.buffer((String)":\"bar\"}")), (FlowableTransformer<Buffer, JsonNode>)FlowableHelper.unmarshaller(JsonNode.class));
    }

    @Test
    public void testFlowableMapObjectNodeFromBufferCustom() throws Exception {
        this.testFlowableMapObjectNodeFromBuffer((Flowable<Buffer>)Flowable.just((Object)Buffer.buffer((String)"foo"), (Object)Buffer.buffer((String)": bar ")), (FlowableTransformer<Buffer, JsonNode>)FlowableHelper.unmarshaller(JsonNode.class, (ObjectMapper)this.mapper));
    }

    private void testFlowableMapObjectNodeFromBuffer(Flowable<Buffer> stream, FlowableTransformer<Buffer, JsonNode> composer) throws Exception {
        Flowable mapped = stream.compose(composer);
        TestSubscriber subscriber = new TestSubscriber().prefetch(0L);
        TestUtils.subscribe((Flowable)mapped, (TestSubscriber)subscriber);
        subscriber.assertEmpty().request(1L).assertItem((Object)new ObjectMapper().createObjectNode().put("foo", "bar")).assertCompleted().assertEmpty();
    }

    @Test
    public void testObservableMapObjectNodeFromBuffer() throws Exception {
        this.testObservableMapObjectNodeFromBuffer((Observable<Buffer>)Observable.just((Object)Buffer.buffer((String)"{\"foo\""), (Object)Buffer.buffer((String)":\"bar\"}")), (ObservableTransformer<Buffer, JsonNode>)ObservableHelper.unmarshaller(JsonNode.class));
    }

    @Test
    public void testObservableMapObjectNodeFromBufferCustom() throws Exception {
        this.testObservableMapObjectNodeFromBuffer((Observable<Buffer>)Observable.just((Object)Buffer.buffer((String)"foo"), (Object)Buffer.buffer((String)": bar")), (ObservableTransformer<Buffer, JsonNode>)ObservableHelper.unmarshaller(JsonNode.class, (ObjectMapper)this.mapper));
    }

    private void testObservableMapObjectNodeFromBuffer(Observable<Buffer> stream, ObservableTransformer<Buffer, JsonNode> composer) throws Exception {
        Observable mapped = stream.compose(composer);
        TestSubscriber subscriber = new TestSubscriber();
        TestUtils.subscribe((Observable)mapped, (TestSubscriber)subscriber);
        subscriber.assertItem((Object)new ObjectMapper().createObjectNode().put("foo", "bar")).assertCompleted().assertEmpty();
    }

    @Test
    public void testSingleMapObjectNodeFromBuffer() throws Exception {
        this.testSingleMapFromBuffer("{\"foo\":\"bar\"}", SingleHelper.unmarshaller(JsonNode.class), new ObjectMapper().createObjectNode().put("foo", "bar"));
    }

    @Test
    public void testSingleMapObjectNodeFromBufferCustom() throws Exception {
        this.testSingleMapFromBuffer("foo: bar", SingleHelper.unmarshaller(JsonNode.class, (ObjectMapper)this.mapper), new ObjectMapper().createObjectNode().put("foo", "bar"));
    }

    private <T> void testSingleMapFromBuffer(String json, SingleTransformer<Buffer, ? extends T> transformer, T expected) throws Exception {
        Single stream = Single.just((Object)Buffer.buffer((String)json));
        Single mapped = stream.compose(transformer);
        ArrayList items = new ArrayList();
        ArrayList errors = new ArrayList();
        AtomicInteger completions = new AtomicInteger();
        mapped.subscribe(items::add, errors::add);
        Assert.assertEquals(Collections.singletonList(expected), items);
        Assert.assertEquals(Collections.emptyList(), errors);
    }

    @Test
    public void testMaybeMapObjectNodeFromBuffer() throws Exception {
        BufferTest.testMaybeMapFromBuffer("{\"foo\":\"bar\"}", MaybeHelper.unmarshaller(JsonNode.class), new ObjectMapper().createObjectNode().put("foo", "bar"));
    }

    @Test
    public void testMaybeMapObjectNodeFromBufferCustom() throws Exception {
        BufferTest.testMaybeMapFromBuffer("foo: bar", MaybeHelper.unmarshaller(JsonNode.class, (ObjectMapper)this.mapper), new ObjectMapper().createObjectNode().put("foo", "bar"));
    }

    static <T> void testMaybeMapFromBuffer(String json, MaybeTransformer<Buffer, ? extends T> transformer, T expected) throws Exception {
        Maybe stream = Maybe.just((Object)Buffer.buffer((String)json));
        Maybe mapped = stream.compose(transformer);
        ArrayList items = new ArrayList();
        ArrayList errors = new ArrayList();
        AtomicInteger completions = new AtomicInteger();
        mapped.subscribe(items::add, errors::add, completions::incrementAndGet);
        Assert.assertEquals(Collections.singletonList(expected), items);
        Assert.assertEquals(Collections.emptyList(), errors);
        Assert.assertEquals((long)0L, (long)completions.get());
    }

    @Test
    public void testFlowableMapPojoListFromBuffer() throws Exception {
        this.testFlowableMapPojoListFromBuffer((Flowable<Buffer>)Flowable.just((Object)Buffer.buffer((String)"[{\"foo\":\"bar\"}]")), (FlowableTransformer<Buffer, List<SimplePojo>>)FlowableHelper.unmarshaller((TypeReference)new TypeReference<List<SimplePojo>>(){}));
    }

    @Test
    public void testFlowableMapPojoListFromBufferCustom() throws Exception {
        this.testFlowableMapPojoListFromBuffer((Flowable<Buffer>)Flowable.just((Object)Buffer.buffer((String)"- foo: bar")), (FlowableTransformer<Buffer, List<SimplePojo>>)FlowableHelper.unmarshaller((TypeReference)new TypeReference<List<SimplePojo>>(){}, (ObjectMapper)this.mapper));
    }

    private void testFlowableMapPojoListFromBuffer(Flowable<Buffer> stream, FlowableTransformer<Buffer, List<SimplePojo>> composer) throws Exception {
        Flowable mapped = stream.compose(composer);
        TestSubscriber subscriber = new TestSubscriber().prefetch(0L);
        TestUtils.subscribe((Flowable)mapped, (TestSubscriber)subscriber);
        subscriber.assertEmpty().request(1L).assertItem(Arrays.asList(new SimplePojo("bar"))).assertCompleted().assertEmpty();
    }

    @Test
    public void testObservableMapPojoListFromBuffer() throws Exception {
        this.testObservableMapPojoListFromBuffer((Observable<Buffer>)Observable.just((Object)Buffer.buffer((String)"[{\"foo\":\"bar\"}]")), (ObservableTransformer<Buffer, List<SimplePojo>>)ObservableHelper.unmarshaller((TypeReference)new TypeReference<List<SimplePojo>>(){}));
    }

    @Test
    public void testObservableMapPojoListFromBufferCustom() throws Exception {
        this.testObservableMapPojoListFromBuffer((Observable<Buffer>)Observable.just((Object)Buffer.buffer((String)"- foo: bar")), (ObservableTransformer<Buffer, List<SimplePojo>>)ObservableHelper.unmarshaller((TypeReference)new TypeReference<List<SimplePojo>>(){}, (ObjectMapper)this.mapper));
    }

    private void testObservableMapPojoListFromBuffer(Observable<Buffer> stream, ObservableTransformer<Buffer, List<SimplePojo>> composer) throws Exception {
        Observable mapped = stream.compose(composer);
        TestSubscriber subscriber = new TestSubscriber();
        TestUtils.subscribe((Observable)mapped, (TestSubscriber)subscriber);
        subscriber.assertItem(Arrays.asList(new SimplePojo("bar"))).assertCompleted().assertEmpty();
    }

    @Test
    public void testSingleMapPojoListFromBuffer() throws Exception {
        this.testSingleMapFromBuffer("[{\"foo\":\"bar\"}]", SingleHelper.unmarshaller((TypeReference)new TypeReference<List<SimplePojo>>(){}), Collections.singletonList(new SimplePojo("bar")));
    }

    @Test
    public void testSingleMapPojoListFromBufferCustom() throws Exception {
        this.testSingleMapFromBuffer("- foo: bar", SingleHelper.unmarshaller((TypeReference)new TypeReference<List<SimplePojo>>(){}, (ObjectMapper)this.mapper), Collections.singletonList(new SimplePojo("bar")));
    }

    @Test
    public void testMaybeMapPojoListFromBuffer() throws Exception {
        BufferTest.testMaybeMapFromBuffer("[{\"foo\":\"bar\"}]", MaybeHelper.unmarshaller((TypeReference)new TypeReference<List<SimplePojo>>(){}), Collections.singletonList(new SimplePojo("bar")));
    }

    @Test
    public void testMaybeMapPojoListFromBufferCustom() throws Exception {
        BufferTest.testMaybeMapFromBuffer("- foo: bar", MaybeHelper.unmarshaller((TypeReference)new TypeReference<List<SimplePojo>>(){}, (ObjectMapper)this.mapper), Collections.singletonList(new SimplePojo("bar")));
    }

    @Test
    public void testFlowableMapFromEmptyBuffer() throws Exception {
        this.testFlowableMapFromEmptyBuffer((FlowableTransformer<Buffer, SimplePojo>)FlowableHelper.unmarshaller(SimplePojo.class, (ObjectMapper)this.mapper));
    }

    @Test
    public void testFlowableMapFromEmptyBufferCustom() throws Exception {
        this.testFlowableMapFromEmptyBuffer((FlowableTransformer<Buffer, SimplePojo>)FlowableHelper.unmarshaller(SimplePojo.class));
    }

    private void testFlowableMapFromEmptyBuffer(FlowableTransformer<Buffer, SimplePojo> composer) throws Exception {
        Flowable stream = Flowable.empty();
        Flowable mapped = stream.compose(composer);
        TestSubscriber subscriber = new TestSubscriber().prefetch(0L);
        TestUtils.subscribe((Flowable)mapped, (TestSubscriber)subscriber);
        subscriber.assertCompleted().assertEmpty();
    }

    @Test
    public void testObservableMapFromEmptyBuffer() throws Exception {
        this.testObservableMapFromEmptyBuffer((ObservableTransformer<Buffer, SimplePojo>)ObservableHelper.unmarshaller(SimplePojo.class, (ObjectMapper)this.mapper));
    }

    @Test
    public void testObservableMapFromEmptyBufferCustom() throws Exception {
        this.testObservableMapFromEmptyBuffer((ObservableTransformer<Buffer, SimplePojo>)ObservableHelper.unmarshaller(SimplePojo.class));
    }

    private void testObservableMapFromEmptyBuffer(ObservableTransformer<Buffer, SimplePojo> composer) throws Exception {
        Observable stream = Observable.empty();
        Observable mapped = stream.compose(composer);
        TestSubscriber subscriber = new TestSubscriber().prefetch(0L);
        TestUtils.subscribe((Observable)mapped, (TestSubscriber)subscriber);
        subscriber.assertCompleted().assertEmpty();
    }

    @Test
    public void testMaybeMapFromEmptyBuffer() throws Exception {
        this.testMaybeMapFromEmptyBuffer((MaybeTransformer<Buffer, SimplePojo>)MaybeHelper.unmarshaller(SimplePojo.class));
    }

    @Test
    public void testMaybeMapFromEmptyBufferCustom() throws Exception {
        this.testMaybeMapFromEmptyBuffer((MaybeTransformer<Buffer, SimplePojo>)MaybeHelper.unmarshaller(SimplePojo.class, (ObjectMapper)this.mapper));
    }

    private void testMaybeMapFromEmptyBuffer(MaybeTransformer<Buffer, SimplePojo> transformer) throws Exception {
        Maybe stream = Maybe.empty();
        Maybe mapped = stream.compose(transformer);
        TestSubscriber subscriber = new TestSubscriber().prefetch(0L);
        TestUtils.subscribe((Maybe)mapped, (TestSubscriber)subscriber);
        subscriber.assertCompleted().assertEmpty();
    }

    @Test
    public void testClusterSerializable() throws Exception {
        io.vertx.reactivex.core.buffer.Buffer buff = io.vertx.reactivex.core.buffer.Buffer.buffer((String)"hello-world");
        Buffer actual = Buffer.buffer();
        buff.writeToBuffer(actual);
        Buffer expected = Buffer.buffer();
        Buffer.buffer((String)"hello-world").writeToBuffer(expected);
        TestCase.assertEquals((Object)expected, (Object)actual);
        buff = io.vertx.reactivex.core.buffer.Buffer.buffer((String)"hello-world");
        TestCase.assertEquals((int)expected.length(), (int)buff.readFromBuffer(0, expected));
        TestCase.assertEquals((String)"hello-world", (String)buff.toString());
    }
}

