/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.ext.sql;

import io.reactivex.Maybe;
import io.reactivex.MaybeSource;
import io.reactivex.observers.TestObserver;
import io.vertx.reactivex.ext.sql.SQLClientHelper;
import io.vertx.reactivex.ext.sql.SQLConnection;
import io.vertx.reactivex.ext.sql.SQLTestBase;
import java.util.ArrayList;
import java.util.List;
import org.junit.Test;

public class InTransactionMaybeTest
extends SQLTestBase {
    @Test
    public void inTransactionSuccessWithValue() throws Exception {
        ((TestObserver)this.inTransaction(true, null).test().await()).assertValue(this.namesWithExtraFolks());
    }

    @Test
    public void inTransactionSuccessWithoutValue() throws Exception {
        ((TestObserver)this.inTransaction(false, null).test().await()).assertComplete();
    }

    @Test
    public void inTransactionFailureWithValue() throws Exception {
        Exception error = new Exception();
        ((TestObserver)this.inTransaction(true, error).test().await()).assertError((Throwable)error);
        this.assertTableContainsInitDataOnly();
    }

    @Test
    public void inTransactionFailureWithoutValue() throws Exception {
        Exception error = new Exception();
        ((TestObserver)this.inTransaction(true, error).test().await()).assertError((Throwable)error);
        this.assertTableContainsInitDataOnly();
    }

    private Maybe<List<String>> inTransaction(boolean withValue, Exception e) throws Exception {
        return this.client.rxGetConnection().flatMapMaybe(conn -> this.rxInsertExtraFolks((SQLConnection)conn).andThen(this.uniqueNames((SQLConnection)conn)).collect(ArrayList::new, List::add).flatMapMaybe(names -> withValue ? Maybe.just((Object)names) : Maybe.empty()).compose(upstream -> e == null ? upstream : upstream.flatMap(names -> Maybe.error((Throwable)e), Maybe::error, () -> Maybe.error((Throwable)e))).compose(SQLClientHelper.txMaybeTransformer((SQLConnection)conn)).flatMap(names -> this.rxAssertAutoCommit((SQLConnection)conn).andThen((MaybeSource)Maybe.just((Object)names)), Maybe::error, () -> this.rxAssertAutoCommit((SQLConnection)conn).andThen((MaybeSource)Maybe.empty())).doFinally(() -> ((SQLConnection)conn).close()));
    }
}

