/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.redis.client;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.redis.client.RedisOptions;
import java.util.List;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * A simple Redis client.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.redis.client.Redis original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.redis.client.Redis.class)
public class Redis implements io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.redis.client.Response> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Redis that = (Redis) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<Redis> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new Redis((io.vertx.redis.client.Redis) obj),
    Redis::getDelegate
  );

  private final io.vertx.redis.client.Redis delegate;
  
  public Redis(io.vertx.redis.client.Redis delegate) {
    this.delegate = delegate;
  }

  public io.vertx.redis.client.Redis getDelegate() {
    return delegate;
  }

  private io.reactivex.Observable<io.vertx.reactivex.redis.client.Response> observable;
  private io.reactivex.Flowable<io.vertx.reactivex.redis.client.Response> flowable;

  public synchronized io.reactivex.Observable<io.vertx.reactivex.redis.client.Response> toObservable() {
    if (observable == null) {
      java.util.function.Function<io.vertx.redis.client.Response, io.vertx.reactivex.redis.client.Response> conv = io.vertx.reactivex.redis.client.Response::newInstance;
      observable = io.vertx.reactivex.ObservableHelper.toObservable(delegate, conv);
    }
    return observable;
  }

  public synchronized io.reactivex.Flowable<io.vertx.reactivex.redis.client.Response> toFlowable() {
    if (flowable == null) {
      java.util.function.Function<io.vertx.redis.client.Response, io.vertx.reactivex.redis.client.Response> conv = io.vertx.reactivex.redis.client.Response::newInstance;
      flowable = io.vertx.reactivex.FlowableHelper.toFlowable(delegate, conv);
    }
    return flowable;
  }

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.reactivex.core.streams.Pipe<io.vertx.reactivex.redis.client.Response> pipe() { 
    io.vertx.reactivex.core.streams.Pipe<io.vertx.reactivex.redis.client.Response> ret = io.vertx.reactivex.core.streams.Pipe.newInstance(delegate.pipe(), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.redis.client.Response.__TYPE_ARG);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  public void pipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.redis.client.Response> dst, Handler<AsyncResult<Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   */
  public void pipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.redis.client.Response> dst) {
    pipeTo(dst, ar -> { });
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public Completable rxPipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.redis.client.Response> dst) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      pipeTo(dst, handler);
    });
  }

  /**
   * Connect to redis, the <code>onConnect</code> will get the {@link io.vertx.reactivex.redis.client.Redis} instance.
   *
   * This connection will use the default options which are connect
   * to a standalone server on the default port on "localhost".
   * @param vertx 
   * @param address 
   * @return 
   */
  public static io.vertx.reactivex.redis.client.Redis createClient(io.vertx.reactivex.core.Vertx vertx, String address) { 
    io.vertx.reactivex.redis.client.Redis ret = io.vertx.reactivex.redis.client.Redis.newInstance(io.vertx.redis.client.Redis.createClient(vertx.getDelegate(), address));
    return ret;
  }

  /**
   * Connect to redis, the <code>onConnect</code> will get the {@link io.vertx.reactivex.redis.client.Redis} instance.
   * @param vertx 
   * @param options 
   * @return 
   */
  public static io.vertx.reactivex.redis.client.Redis createClient(io.vertx.reactivex.core.Vertx vertx, RedisOptions options) { 
    io.vertx.reactivex.redis.client.Redis ret = io.vertx.reactivex.redis.client.Redis.newInstance(io.vertx.redis.client.Redis.createClient(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Connects to the redis server.
   * @param handler the async result handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.redis.client.Redis connect(Handler<AsyncResult<io.vertx.reactivex.redis.client.Redis>> handler) { 
    delegate.connect(new Handler<AsyncResult<io.vertx.redis.client.Redis>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Redis> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Redis.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Connects to the redis server.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.redis.client.Redis connect() {
    return 
connect(ar -> { });
  }

  /**
   * Connects to the redis server.
   * @return a reference to this, so the API can be used fluently
   */
  public Single<io.vertx.reactivex.redis.client.Redis> rxConnect() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      connect(handler);
    });
  }

  /**
   * Set an exception handler on the read stream.
   * @param handler the exception handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.redis.client.Redis exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * Set a data handler. As data is read, the handler will be called with the data.
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.redis.client.Redis handler(Handler<io.vertx.reactivex.redis.client.Response> handler) { 
    delegate.handler(new Handler<io.vertx.redis.client.Response>() {
      public void handle(io.vertx.redis.client.Response event) {
        handler.handle(io.vertx.reactivex.redis.client.Response.newInstance(event));
      }
    });
    return this;
  }

  /**
   * Pause the <code>ReadStream</code>, it sets the buffer in <code>fetch</code> mode and clears the actual demand.
   * <p>
   * While it's paused, no data will be sent to the data <code>handler</code>.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.redis.client.Redis pause() { 
    delegate.pause();
    return this;
  }

  /**
   * Resume reading, and sets the buffer in <code>flowing</code> mode.
   * <p/>
   * If the <code>ReadStream</code> has been paused, reading will recommence on it.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.redis.client.Redis resume() { 
    delegate.resume();
    return this;
  }

  /**
   * Fetch the specified <code>amount</code> of elements. If the <code>ReadStream</code> has been paused, reading will
   * recommence with the specified <code>amount</code> of items, otherwise the specified <code>amount</code> will
   * be added to the current stream demand.
   * @param amount 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.redis.client.Redis fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  /**
   * Set an end handler. Once the stream has ended, and there is no more data to be read, this handler will be called.
   * @param endHandler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.redis.client.Redis endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  /**
   * Send the given command to the redis server or cluster.
   * @param command the command to send
   * @param onSend the asynchronous result handler.
   * @return fluent self.
   */
  public io.vertx.reactivex.redis.client.Redis send(io.vertx.reactivex.redis.client.Request command, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> onSend) { 
    delegate.send(command.getDelegate(), new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          onSend.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance(ar.result())));
        } else {
          onSend.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Send the given command to the redis server or cluster.
   * @param command the command to send
   * @return fluent self.
   */
  public io.vertx.reactivex.redis.client.Redis send(io.vertx.reactivex.redis.client.Request command) {
    return 
send(command, ar -> { });
  }

  /**
   * Send the given command to the redis server or cluster.
   * @param command the command to send
   * @return fluent self.
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxSend(io.vertx.reactivex.redis.client.Request command) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      send(command, handler);
    });
  }

  /**
   * Sends a list of commands in a single IO operation, this prevents any inter twinning to happen from other
   * client users.
   * @param commands list of command to send
   * @param onSend the asynchronous result handler.
   * @return fluent self.
   */
  public io.vertx.reactivex.redis.client.Redis batch(List<io.vertx.reactivex.redis.client.Request> commands, Handler<AsyncResult<List<io.vertx.reactivex.redis.client.Response>>> onSend) { 
    delegate.batch(commands.stream().map(elt -> elt.getDelegate()).collect(java.util.stream.Collectors.toList()), new Handler<AsyncResult<java.util.List<io.vertx.redis.client.Response>>>() {
      public void handle(AsyncResult<java.util.List<io.vertx.redis.client.Response>> ar) {
        if (ar.succeeded()) {
          onSend.handle(io.vertx.core.Future.succeededFuture(ar.result().stream().map(elt -> io.vertx.reactivex.redis.client.Response.newInstance(elt)).collect(java.util.stream.Collectors.toList())));
        } else {
          onSend.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Sends a list of commands in a single IO operation, this prevents any inter twinning to happen from other
   * client users.
   * @param commands list of command to send
   * @return fluent self.
   */
  public io.vertx.reactivex.redis.client.Redis batch(List<io.vertx.reactivex.redis.client.Request> commands) {
    return 
batch(commands, ar -> { });
  }

  /**
   * Sends a list of commands in a single IO operation, this prevents any inter twinning to happen from other
   * client users.
   * @param commands list of command to send
   * @return fluent self.
   */
  public Single<List<io.vertx.reactivex.redis.client.Response>> rxBatch(List<io.vertx.reactivex.redis.client.Request> commands) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      batch(commands, handler);
    });
  }

  /**
   * Returns the address associated with this client.
   * @return the address.
   */
  public String socketAddress() { 
    String ret = delegate.socketAddress();
    return ret;
  }

  public void close() { 
    delegate.close();
  }


  public static  Redis newInstance(io.vertx.redis.client.Redis arg) {
    return arg != null ? new Redis(arg) : null;
  }
}
