/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.redis.client;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;

/**
 * <b>Auto generated</b> API Commands to interact with REDIS.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.redis.client.Command original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.redis.client.Command.class)
public class Command {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Command that = (Command) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<Command> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new Command((io.vertx.redis.client.Command) obj),
    Command::getDelegate
  );

  private final io.vertx.redis.client.Command delegate;
  
  public Command(io.vertx.redis.client.Command delegate) {
    this.delegate = delegate;
  }

  public io.vertx.redis.client.Command getDelegate() {
    return delegate;
  }

  /**
   * Creates a Redis Command from METADATA. The metadata comes from the REDIS command "COMMAND"
   * https://redis.io/commands/command
   *
   * Each top-level result contains six nested results. Each nested result is:
   *
   *     command name
   *     command arity specification
   *     nested Array reply of command flags
   *     position of first key in argument list
   *     position of last key in argument list
   *     step count for locating repeating keys
   * @param command command name
   * @param arity arity
   * @param firstKey position of the first key
   * @param lastKey position of the last key
   * @param interval step count for locating repeating keys
   * @param readOnly readOnly flag extracted from the nested Array reply of command flags
   * @param movable movable flag extracted from the nested Array reply of command flags
   * @return a command instance
   */
  public static io.vertx.reactivex.redis.client.Command create(String command, int arity, int firstKey, int lastKey, int interval, boolean readOnly, boolean movable) { 
    io.vertx.reactivex.redis.client.Command ret = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.create(command, arity, firstKey, lastKey, interval, readOnly, movable));
    return ret;
  }

  public int getArity() { 
    int ret = delegate.getArity();
    return ret;
  }

  public boolean isMultiKey() { 
    boolean ret = delegate.isMultiKey();
    return ret;
  }

  public int getFirstKey() { 
    int ret = delegate.getFirstKey();
    return ret;
  }

  public int getLastKey() { 
    int ret = delegate.getLastKey();
    return ret;
  }

  public int getInterval() { 
    int ret = delegate.getInterval();
    return ret;
  }

  public boolean isKeyless() { 
    boolean ret = delegate.isKeyless();
    return ret;
  }

  public boolean isReadOnly() { 
    boolean ret = delegate.isReadOnly();
    return ret;
  }

  public boolean isMovable() { 
    boolean ret = delegate.isMovable();
    return ret;
  }

  public byte[] getBytes() { 
    byte[] ret = delegate.getBytes();
    return ret;
  }

  public static final Command APPEND = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.APPEND);
  public static final Command ASKING = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.ASKING);
  public static final Command AUTH = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.AUTH);
  public static final Command BGREWRITEAOF = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.BGREWRITEAOF);
  public static final Command BGSAVE = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.BGSAVE);
  public static final Command BITCOUNT = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.BITCOUNT);
  public static final Command BITFIELD = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.BITFIELD);
  public static final Command BITOP = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.BITOP);
  public static final Command BITPOS = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.BITPOS);
  public static final Command BLPOP = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.BLPOP);
  public static final Command BRPOP = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.BRPOP);
  public static final Command BRPOPLPUSH = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.BRPOPLPUSH);
  public static final Command BZPOPMAX = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.BZPOPMAX);
  public static final Command BZPOPMIN = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.BZPOPMIN);
  public static final Command CLIENT = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.CLIENT);
  public static final Command CLUSTER = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.CLUSTER);
  public static final Command COMMAND = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.COMMAND);
  public static final Command CONFIG = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.CONFIG);
  public static final Command DBSIZE = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.DBSIZE);
  public static final Command DEBUG = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.DEBUG);
  public static final Command DECR = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.DECR);
  public static final Command DECRBY = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.DECRBY);
  public static final Command DEL = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.DEL);
  public static final Command DISCARD = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.DISCARD);
  public static final Command DUMP = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.DUMP);
  public static final Command ECHO = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.ECHO);
  public static final Command EVAL = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.EVAL);
  public static final Command EVALSHA = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.EVALSHA);
  public static final Command EXEC = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.EXEC);
  public static final Command EXISTS = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.EXISTS);
  public static final Command EXPIRE = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.EXPIRE);
  public static final Command EXPIREAT = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.EXPIREAT);
  public static final Command FLUSHALL = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.FLUSHALL);
  public static final Command FLUSHDB = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.FLUSHDB);
  public static final Command GEOADD = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.GEOADD);
  public static final Command GEODIST = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.GEODIST);
  public static final Command GEOHASH = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.GEOHASH);
  public static final Command GEOPOS = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.GEOPOS);
  public static final Command GEORADIUS = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.GEORADIUS);
  public static final Command GEORADIUS_RO = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.GEORADIUS_RO);
  public static final Command GEORADIUSBYMEMBER = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.GEORADIUSBYMEMBER);
  public static final Command GEORADIUSBYMEMBER_RO = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.GEORADIUSBYMEMBER_RO);
  public static final Command GET = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.GET);
  public static final Command GETBIT = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.GETBIT);
  public static final Command GETRANGE = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.GETRANGE);
  public static final Command GETSET = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.GETSET);
  public static final Command HDEL = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.HDEL);
  public static final Command HEXISTS = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.HEXISTS);
  public static final Command HGET = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.HGET);
  public static final Command HGETALL = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.HGETALL);
  public static final Command HINCRBY = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.HINCRBY);
  public static final Command HINCRBYFLOAT = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.HINCRBYFLOAT);
  public static final Command HKEYS = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.HKEYS);
  public static final Command HLEN = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.HLEN);
  public static final Command HMGET = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.HMGET);
  public static final Command HMSET = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.HMSET);
  public static final Command HOST = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.HOST);
  public static final Command HSCAN = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.HSCAN);
  public static final Command HSET = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.HSET);
  public static final Command HSETNX = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.HSETNX);
  public static final Command HSTRLEN = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.HSTRLEN);
  public static final Command HVALS = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.HVALS);
  public static final Command INCR = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.INCR);
  public static final Command INCRBY = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.INCRBY);
  public static final Command INCRBYFLOAT = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.INCRBYFLOAT);
  public static final Command INFO = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.INFO);
  public static final Command KEYS = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.KEYS);
  public static final Command LASTSAVE = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.LASTSAVE);
  public static final Command LATENCY = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.LATENCY);
  public static final Command LINDEX = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.LINDEX);
  public static final Command LINSERT = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.LINSERT);
  public static final Command LLEN = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.LLEN);
  public static final Command LOLWUT = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.LOLWUT);
  public static final Command LPOP = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.LPOP);
  public static final Command LPUSH = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.LPUSH);
  public static final Command LPUSHX = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.LPUSHX);
  public static final Command LRANGE = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.LRANGE);
  public static final Command LREM = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.LREM);
  public static final Command LSET = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.LSET);
  public static final Command LTRIM = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.LTRIM);
  public static final Command MEMORY = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.MEMORY);
  public static final Command MGET = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.MGET);
  public static final Command MIGRATE = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.MIGRATE);
  public static final Command MODULE = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.MODULE);
  public static final Command MONITOR = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.MONITOR);
  public static final Command MOVE = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.MOVE);
  public static final Command MSET = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.MSET);
  public static final Command MSETNX = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.MSETNX);
  public static final Command MULTI = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.MULTI);
  public static final Command OBJECT = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.OBJECT);
  public static final Command PERSIST = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.PERSIST);
  public static final Command PEXPIRE = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.PEXPIRE);
  public static final Command PEXPIREAT = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.PEXPIREAT);
  public static final Command PFADD = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.PFADD);
  public static final Command PFCOUNT = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.PFCOUNT);
  public static final Command PFDEBUG = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.PFDEBUG);
  public static final Command PFMERGE = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.PFMERGE);
  public static final Command PFSELFTEST = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.PFSELFTEST);
  public static final Command PING = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.PING);
  public static final Command POST = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.POST);
  public static final Command PSETEX = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.PSETEX);
  public static final Command PSUBSCRIBE = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.PSUBSCRIBE);
  public static final Command PSYNC = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.PSYNC);
  public static final Command PTTL = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.PTTL);
  public static final Command PUBLISH = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.PUBLISH);
  public static final Command PUBSUB = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.PUBSUB);
  public static final Command PUNSUBSCRIBE = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.PUNSUBSCRIBE);
  public static final Command RANDOMKEY = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.RANDOMKEY);
  public static final Command READONLY = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.READONLY);
  public static final Command READWRITE = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.READWRITE);
  public static final Command RENAME = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.RENAME);
  public static final Command RENAMENX = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.RENAMENX);
  public static final Command REPLCONF = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.REPLCONF);
  public static final Command REPLICAOF = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.REPLICAOF);
  public static final Command RESTORE = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.RESTORE);
  public static final Command RESTORE_ASKING = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.RESTORE_ASKING);
  public static final Command ROLE = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.ROLE);
  public static final Command RPOP = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.RPOP);
  public static final Command RPOPLPUSH = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.RPOPLPUSH);
  public static final Command RPUSH = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.RPUSH);
  public static final Command RPUSHX = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.RPUSHX);
  public static final Command SADD = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.SADD);
  public static final Command SAVE = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.SAVE);
  public static final Command SCAN = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.SCAN);
  public static final Command SCARD = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.SCARD);
  public static final Command SCRIPT = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.SCRIPT);
  public static final Command SDIFF = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.SDIFF);
  public static final Command SDIFFSTORE = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.SDIFFSTORE);
  public static final Command SELECT = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.SELECT);
  public static final Command SET = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.SET);
  public static final Command SETBIT = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.SETBIT);
  public static final Command SETEX = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.SETEX);
  public static final Command SETNX = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.SETNX);
  public static final Command SETRANGE = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.SETRANGE);
  public static final Command SHUTDOWN = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.SHUTDOWN);
  public static final Command SINTER = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.SINTER);
  public static final Command SINTERSTORE = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.SINTERSTORE);
  public static final Command SISMEMBER = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.SISMEMBER);
  public static final Command SLAVEOF = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.SLAVEOF);
  public static final Command SLOWLOG = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.SLOWLOG);
  public static final Command SMEMBERS = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.SMEMBERS);
  public static final Command SMOVE = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.SMOVE);
  public static final Command SORT = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.SORT);
  public static final Command SPOP = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.SPOP);
  public static final Command SRANDMEMBER = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.SRANDMEMBER);
  public static final Command SREM = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.SREM);
  public static final Command SSCAN = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.SSCAN);
  public static final Command STRLEN = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.STRLEN);
  public static final Command SUBSCRIBE = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.SUBSCRIBE);
  public static final Command SUBSTR = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.SUBSTR);
  public static final Command SUNION = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.SUNION);
  public static final Command SUNIONSTORE = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.SUNIONSTORE);
  public static final Command SWAPDB = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.SWAPDB);
  public static final Command SYNC = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.SYNC);
  public static final Command TIME = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.TIME);
  public static final Command TOUCH = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.TOUCH);
  public static final Command TTL = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.TTL);
  public static final Command TYPE = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.TYPE);
  public static final Command UNLINK = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.UNLINK);
  public static final Command UNSUBSCRIBE = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.UNSUBSCRIBE);
  public static final Command UNWATCH = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.UNWATCH);
  public static final Command WAIT = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.WAIT);
  public static final Command WATCH = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.WATCH);
  public static final Command XACK = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.XACK);
  public static final Command XADD = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.XADD);
  public static final Command XCLAIM = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.XCLAIM);
  public static final Command XDEL = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.XDEL);
  public static final Command XGROUP = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.XGROUP);
  public static final Command XINFO = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.XINFO);
  public static final Command XLEN = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.XLEN);
  public static final Command XPENDING = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.XPENDING);
  public static final Command XRANGE = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.XRANGE);
  public static final Command XREAD = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.XREAD);
  public static final Command XREADGROUP = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.XREADGROUP);
  public static final Command XREVRANGE = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.XREVRANGE);
  public static final Command XSETID = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.XSETID);
  public static final Command XTRIM = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.XTRIM);
  public static final Command ZADD = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.ZADD);
  public static final Command ZCARD = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.ZCARD);
  public static final Command ZCOUNT = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.ZCOUNT);
  public static final Command ZINCRBY = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.ZINCRBY);
  public static final Command ZINTERSTORE = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.ZINTERSTORE);
  public static final Command ZLEXCOUNT = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.ZLEXCOUNT);
  public static final Command ZPOPMAX = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.ZPOPMAX);
  public static final Command ZPOPMIN = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.ZPOPMIN);
  public static final Command ZRANGE = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.ZRANGE);
  public static final Command ZRANGEBYLEX = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.ZRANGEBYLEX);
  public static final Command ZRANGEBYSCORE = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.ZRANGEBYSCORE);
  public static final Command ZRANK = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.ZRANK);
  public static final Command ZREM = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.ZREM);
  public static final Command ZREMRANGEBYLEX = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.ZREMRANGEBYLEX);
  public static final Command ZREMRANGEBYRANK = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.ZREMRANGEBYRANK);
  public static final Command ZREMRANGEBYSCORE = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.ZREMRANGEBYSCORE);
  public static final Command ZREVRANGE = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.ZREVRANGE);
  public static final Command ZREVRANGEBYLEX = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.ZREVRANGEBYLEX);
  public static final Command ZREVRANGEBYSCORE = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.ZREVRANGEBYSCORE);
  public static final Command ZREVRANK = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.ZREVRANK);
  public static final Command ZSCAN = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.ZSCAN);
  public static final Command ZSCORE = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.ZSCORE);
  public static final Command ZUNIONSTORE = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.ZUNIONSTORE);
  public static final Command SENTINEL = io.vertx.reactivex.redis.client.Command.newInstance(io.vertx.redis.client.Command.SENTINEL);

  public static  Command newInstance(io.vertx.redis.client.Command arg) {
    return arg != null ? new Command(arg) : null;
  }
}
