/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.rabbitmq;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * A stream of messages from a rabbitmq queue.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.rabbitmq.RabbitMQConsumer original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.rabbitmq.RabbitMQConsumer.class)
public class RabbitMQConsumer implements io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.rabbitmq.RabbitMQMessage> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RabbitMQConsumer that = (RabbitMQConsumer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<RabbitMQConsumer> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new RabbitMQConsumer((io.vertx.rabbitmq.RabbitMQConsumer) obj),
    RabbitMQConsumer::getDelegate
  );

  private final io.vertx.rabbitmq.RabbitMQConsumer delegate;
  
  public RabbitMQConsumer(io.vertx.rabbitmq.RabbitMQConsumer delegate) {
    this.delegate = delegate;
  }

  public io.vertx.rabbitmq.RabbitMQConsumer getDelegate() {
    return delegate;
  }

  private io.reactivex.Observable<io.vertx.reactivex.rabbitmq.RabbitMQMessage> observable;
  private io.reactivex.Flowable<io.vertx.reactivex.rabbitmq.RabbitMQMessage> flowable;

  public synchronized io.reactivex.Observable<io.vertx.reactivex.rabbitmq.RabbitMQMessage> toObservable() {
    if (observable == null) {
      java.util.function.Function<io.vertx.rabbitmq.RabbitMQMessage, io.vertx.reactivex.rabbitmq.RabbitMQMessage> conv = io.vertx.reactivex.rabbitmq.RabbitMQMessage::newInstance;
      observable = io.vertx.reactivex.ObservableHelper.toObservable(delegate, conv);
    }
    return observable;
  }

  public synchronized io.reactivex.Flowable<io.vertx.reactivex.rabbitmq.RabbitMQMessage> toFlowable() {
    if (flowable == null) {
      java.util.function.Function<io.vertx.rabbitmq.RabbitMQMessage, io.vertx.reactivex.rabbitmq.RabbitMQMessage> conv = io.vertx.reactivex.rabbitmq.RabbitMQMessage::newInstance;
      flowable = io.vertx.reactivex.FlowableHelper.toFlowable(delegate, conv);
    }
    return flowable;
  }

  /**
   * Fetch the specified <code>amount</code> of elements. If the <code>ReadStream</code> has been paused, reading will
   * recommence with the specified <code>amount</code> of items, otherwise the specified <code>amount</code> will
   * be added to the current stream demand.
   * @param amount 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.rabbitmq.RabbitMQMessage> fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.reactivex.core.streams.Pipe<io.vertx.reactivex.rabbitmq.RabbitMQMessage> pipe() { 
    io.vertx.reactivex.core.streams.Pipe<io.vertx.reactivex.rabbitmq.RabbitMQMessage> ret = io.vertx.reactivex.core.streams.Pipe.newInstance(delegate.pipe(), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.rabbitmq.RabbitMQMessage.__TYPE_ARG);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  public void pipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.rabbitmq.RabbitMQMessage> dst, Handler<AsyncResult<Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   */
  public void pipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.rabbitmq.RabbitMQMessage> dst) {
    pipeTo(dst, ar -> { });
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public Completable rxPipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.rabbitmq.RabbitMQMessage> dst) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      pipeTo(dst, handler);
    });
  }

  /**
   * Set an exception handler on the read stream.
   * @param exceptionHandler the exception handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.rabbitmq.RabbitMQConsumer exceptionHandler(Handler<Throwable> exceptionHandler) { 
    delegate.exceptionHandler(exceptionHandler);
    return this;
  }

  /**
   * Set a message handler. As message appear in a queue, the handler will be called with the message.
   * @param messageArrived 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.rabbitmq.RabbitMQConsumer handler(Handler<io.vertx.reactivex.rabbitmq.RabbitMQMessage> messageArrived) { 
    delegate.handler(new Handler<io.vertx.rabbitmq.RabbitMQMessage>() {
      public void handle(io.vertx.rabbitmq.RabbitMQMessage event) {
        messageArrived.handle(io.vertx.reactivex.rabbitmq.RabbitMQMessage.newInstance(event));
      }
    });
    return this;
  }

  /**
   * Pause the stream of incoming messages from queue.
   * <p>
   * The messages will continue to arrive, but they will be stored in a internal queue.
   * If the queue size would exceed the limit provided by , then incoming messages will be discarded.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.rabbitmq.RabbitMQConsumer pause() { 
    delegate.pause();
    return this;
  }

  /**
   * Resume reading from a queue. Flushes internal queue.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.rabbitmq.RabbitMQConsumer resume() { 
    delegate.resume();
    return this;
  }

  /**
   * Set an end handler. Once the stream has canceled successfully, the handler will be called.
   * @param endHandler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.rabbitmq.RabbitMQConsumer endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  /**
   * @return a consumer tag
   */
  public String consumerTag() { 
    String ret = delegate.consumerTag();
    return ret;
  }

  /**
   * Stop message consumption from a queue.
   * <p>
   * The operation is asynchronous. When consumption will be stopped, you can by notified via {@link io.vertx.reactivex.rabbitmq.RabbitMQConsumer#endHandler}
   */
  public void cancel() { 
    delegate.cancel();
  }

  /**
   * Stop message consumption from a queue.
   * <p>
   * The operation is asynchronous. When consumption will be stopped, you can by notified via {@link io.vertx.reactivex.rabbitmq.RabbitMQConsumer#endHandler}
   * @param cancelResult contains information about operation status: success/fail.
   */
  public void cancel(Handler<AsyncResult<Void>> cancelResult) { 
    delegate.cancel(cancelResult);
  }

  /**
   * Stop message consumption from a queue.
   * <p>
   * The operation is asynchronous. When consumption will be stopped, you can by notified via {@link io.vertx.reactivex.rabbitmq.RabbitMQConsumer#endHandler}
   * @return 
   */
  public Completable rxCancel() { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      cancel(handler);
    });
  }

  /**
   * @return is the stream paused?
   */
  public boolean isPaused() { 
    boolean ret = delegate.isPaused();
    return ret;
  }


  public static  RabbitMQConsumer newInstance(io.vertx.rabbitmq.RabbitMQConsumer arg) {
    return arg != null ? new RabbitMQConsumer(arg) : null;
  }
}
