/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.kafka.admin;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.kafka.admin.NewTopic;
import java.util.Set;
import java.util.List;
import io.vertx.kafka.admin.ConsumerGroupListing;
import io.vertx.kafka.admin.ConsumerGroupDescription;
import io.vertx.kafka.admin.TopicDescription;
import java.util.Map;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Vert.x Kafka Admin client implementation
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.kafka.admin.KafkaAdminClient original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.kafka.admin.KafkaAdminClient.class)
public class KafkaAdminClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    KafkaAdminClient that = (KafkaAdminClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<KafkaAdminClient> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new KafkaAdminClient((io.vertx.kafka.admin.KafkaAdminClient) obj),
    KafkaAdminClient::getDelegate
  );

  private final io.vertx.kafka.admin.KafkaAdminClient delegate;
  
  public KafkaAdminClient(io.vertx.kafka.admin.KafkaAdminClient delegate) {
    this.delegate = delegate;
  }

  public io.vertx.kafka.admin.KafkaAdminClient getDelegate() {
    return delegate;
  }

  /**
   * Create a new KafkaAdminClient instance
   * @param vertx Vert.x instance to use
   * @param config Kafka admin client configuration
   * @return an instance of the KafkaAdminClient
   */
  public static io.vertx.reactivex.kafka.admin.KafkaAdminClient create(io.vertx.reactivex.core.Vertx vertx, Map<String, String> config) { 
    io.vertx.reactivex.kafka.admin.KafkaAdminClient ret = io.vertx.reactivex.kafka.admin.KafkaAdminClient.newInstance(io.vertx.kafka.admin.KafkaAdminClient.create(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * List the topics available in the cluster with the default options.
   * @param completionHandler handler called on operation completed with the topics set
   */
  public void listTopics(Handler<AsyncResult<Set<String>>> completionHandler) { 
    delegate.listTopics(completionHandler);
  }

  /**
   * List the topics available in the cluster with the default options.
   */
  public void listTopics() {
    listTopics(ar -> { });
  }

  /**
   * List the topics available in the cluster with the default options.
   * @return 
   */
  public Single<Set<String>> rxListTopics() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      listTopics(handler);
    });
  }

  /**
   * Describe some topics in the cluster, with the default options.
   * @param topicNames the names of the topics to describe
   * @param completionHandler handler called on operation completed with the topics descriptions
   */
  public void describeTopics(List<String> topicNames, Handler<AsyncResult<Map<String, TopicDescription>>> completionHandler) { 
    delegate.describeTopics(topicNames, completionHandler);
  }

  /**
   * Describe some topics in the cluster, with the default options.
   * @param topicNames the names of the topics to describe
   */
  public void describeTopics(List<String> topicNames) {
    describeTopics(topicNames, ar -> { });
  }

  /**
   * Describe some topics in the cluster, with the default options.
   * @param topicNames the names of the topics to describe
   * @return 
   */
  public Single<Map<String, TopicDescription>> rxDescribeTopics(List<String> topicNames) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      describeTopics(topicNames, handler);
    });
  }

  /**
   * Creates a batch of new Kafka topics
   * @param topics topics to create
   * @param completionHandler handler called on operation completed
   */
  public void createTopics(List<NewTopic> topics, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.createTopics(topics, completionHandler);
  }

  /**
   * Creates a batch of new Kafka topics
   * @param topics topics to create
   */
  public void createTopics(List<NewTopic> topics) {
    createTopics(topics, ar -> { });
  }

  /**
   * Creates a batch of new Kafka topics
   * @param topics topics to create
   * @return 
   */
  public Completable rxCreateTopics(List<NewTopic> topics) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      createTopics(topics, handler);
    });
  }

  /**
   * Deletes a batch of Kafka topics
   * @param topicNames the names of the topics to delete
   * @param completionHandler handler called on operation completed
   */
  public void deleteTopics(List<String> topicNames, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.deleteTopics(topicNames, completionHandler);
  }

  /**
   * Deletes a batch of Kafka topics
   * @param topicNames the names of the topics to delete
   */
  public void deleteTopics(List<String> topicNames) {
    deleteTopics(topicNames, ar -> { });
  }

  /**
   * Deletes a batch of Kafka topics
   * @param topicNames the names of the topics to delete
   * @return 
   */
  public Completable rxDeleteTopics(List<String> topicNames) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      deleteTopics(topicNames, handler);
    });
  }

  /**
   * Get the the consumer groups available in the cluster with the default options
   * @param completionHandler handler called on operation completed with the consumer groups ids
   */
  public void listConsumerGroups(Handler<AsyncResult<List<ConsumerGroupListing>>> completionHandler) { 
    delegate.listConsumerGroups(completionHandler);
  }

  /**
   * Get the the consumer groups available in the cluster with the default options
   */
  public void listConsumerGroups() {
    listConsumerGroups(ar -> { });
  }

  /**
   * Get the the consumer groups available in the cluster with the default options
   * @return 
   */
  public Single<List<ConsumerGroupListing>> rxListConsumerGroups() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      listConsumerGroups(handler);
    });
  }

  /**
   * Describe some group ids in the cluster, with the default options
   * @param groupIds the ids of the groups to describe
   * @param completionHandler handler called on operation completed with the consumer groups descriptions
   */
  public void describeConsumerGroups(List<String> groupIds, Handler<AsyncResult<Map<String, ConsumerGroupDescription>>> completionHandler) { 
    delegate.describeConsumerGroups(groupIds, completionHandler);
  }

  /**
   * Describe some group ids in the cluster, with the default options
   * @param groupIds the ids of the groups to describe
   */
  public void describeConsumerGroups(List<String> groupIds) {
    describeConsumerGroups(groupIds, ar -> { });
  }

  /**
   * Describe some group ids in the cluster, with the default options
   * @param groupIds the ids of the groups to describe
   * @return 
   */
  public Single<Map<String, ConsumerGroupDescription>> rxDescribeConsumerGroups(List<String> groupIds) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      describeConsumerGroups(groupIds, handler);
    });
  }


  public static  KafkaAdminClient newInstance(io.vertx.kafka.admin.KafkaAdminClient arg) {
    return arg != null ? new KafkaAdminClient(arg) : null;
  }
}
