/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.handler.sockjs;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 *
 * You interact with SockJS clients through instances of SockJS socket.
 * <p>
 * The API is very similar to {@link io.vertx.reactivex.core.http.WebSocket}.
 * It implements both  and 
 * so it can be used with
 * {@link io.vertx.reactivex.core.streams.Pump} to pump data with flow control.<p>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.sockjs.SockJSSocket original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.web.handler.sockjs.SockJSSocket.class)
public class SockJSSocket implements io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.buffer.Buffer>, io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.core.buffer.Buffer> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SockJSSocket that = (SockJSSocket) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<SockJSSocket> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new SockJSSocket((io.vertx.ext.web.handler.sockjs.SockJSSocket) obj),
    SockJSSocket::getDelegate
  );

  private final io.vertx.ext.web.handler.sockjs.SockJSSocket delegate;
  
  public SockJSSocket(io.vertx.ext.web.handler.sockjs.SockJSSocket delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.web.handler.sockjs.SockJSSocket getDelegate() {
    return delegate;
  }

  private io.reactivex.Observable<io.vertx.reactivex.core.buffer.Buffer> observable;
  private io.reactivex.Flowable<io.vertx.reactivex.core.buffer.Buffer> flowable;

  public synchronized io.reactivex.Observable<io.vertx.reactivex.core.buffer.Buffer> toObservable() {
    if (observable == null) {
      java.util.function.Function<io.vertx.core.buffer.Buffer, io.vertx.reactivex.core.buffer.Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::newInstance;
      observable = io.vertx.reactivex.ObservableHelper.toObservable(delegate, conv);
    }
    return observable;
  }

  public synchronized io.reactivex.Flowable<io.vertx.reactivex.core.buffer.Buffer> toFlowable() {
    if (flowable == null) {
      java.util.function.Function<io.vertx.core.buffer.Buffer, io.vertx.reactivex.core.buffer.Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::newInstance;
      flowable = io.vertx.reactivex.FlowableHelper.toFlowable(delegate, conv);
    }
    return flowable;
  }

  private io.vertx.reactivex.WriteStreamObserver<io.vertx.reactivex.core.buffer.Buffer> observer;
  private io.vertx.reactivex.WriteStreamSubscriber<io.vertx.reactivex.core.buffer.Buffer> subscriber;

  public synchronized io.vertx.reactivex.WriteStreamObserver<io.vertx.reactivex.core.buffer.Buffer> toObserver() {
    if (observer == null) {
      java.util.function.Function<io.vertx.reactivex.core.buffer.Buffer, io.vertx.core.buffer.Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::getDelegate;
      observer = io.vertx.reactivex.RxHelper.toObserver(getDelegate(), conv);
    }
    return observer;
  }

  public synchronized io.vertx.reactivex.WriteStreamSubscriber<io.vertx.reactivex.core.buffer.Buffer> toSubscriber() {
    if (subscriber == null) {
      java.util.function.Function<io.vertx.reactivex.core.buffer.Buffer, io.vertx.core.buffer.Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::getDelegate;
      subscriber = io.vertx.reactivex.RxHelper.toSubscriber(getDelegate(), conv);
    }
    return subscriber;
  }

  /**
   * Same as {@link io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket#end} but with an <code>handler</code> called when the operation completes
   * @param handler 
   */
  public void end(Handler<AsyncResult<Void>> handler) { 
    delegate.end(handler);
  }

  /**
   * Same as {@link io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket#end} but with an <code>handler</code> called when the operation completes
   */
  public void end() {
    end(ar -> { });
  }

  /**
   * Same as {@link io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket#end} but with an <code>handler</code> called when the operation completes
   * @return 
   */
  public Completable rxEnd() { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      end(handler);
    });
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @param handler 
   */
  public void end(io.vertx.reactivex.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) { 
    delegate.end(data.getDelegate(), handler);
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   */
  public void end(io.vertx.reactivex.core.buffer.Buffer data) {
    end(data, ar -> { });
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public Completable rxEnd(io.vertx.reactivex.core.buffer.Buffer data) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      end(data, handler);
    });
  }

  /**
   * This will return <code>true</code> if there are more bytes in the write queue than the value set using {@link io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket#setWriteQueueMaxSize}
   * @return true if write queue is full
   */
  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  /**
   * Fetch the specified <code>amount</code> of elements. If the <code>ReadStream</code> has been paused, reading will
   * recommence with the specified <code>amount</code> of items, otherwise the specified <code>amount</code> will
   * be added to the current stream demand.
   * @param amount 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.buffer.Buffer> fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.reactivex.core.streams.Pipe<io.vertx.reactivex.core.buffer.Buffer> pipe() { 
    io.vertx.reactivex.core.streams.Pipe<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.core.streams.Pipe.newInstance(delegate.pipe(), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  public void pipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.core.buffer.Buffer> dst, Handler<AsyncResult<Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   */
  public void pipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.core.buffer.Buffer> dst) {
    pipeTo(dst, ar -> { });
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public Completable rxPipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.core.buffer.Buffer> dst) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      pipeTo(dst, handler);
    });
  }

  public io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket handler(Handler<io.vertx.reactivex.core.buffer.Buffer> handler) { 
    delegate.handler(new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        handler.handle(io.vertx.reactivex.core.buffer.Buffer.newInstance(event));
      }
    });
    return this;
  }

  public io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  /**
   * Write a {@link java.lang.String} to the socket, encoded in UTF-8.
   * @param data the string to write
   */
  public void write(String data) { 
    delegate.write(data);
  }

  public void write(String data, Handler<AsyncResult<Void>> handler) { 
    delegate.write(data, handler);
  }

  public Completable rxWrite(String data) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      write(data, handler);
    });
  }

  public void write(io.vertx.reactivex.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) { 
    delegate.write(data.getDelegate(), handler);
  }

  public void write(io.vertx.reactivex.core.buffer.Buffer data) {
    write(data, ar -> { });
  }

  public Completable rxWrite(io.vertx.reactivex.core.buffer.Buffer data) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      write(data, handler);
    });
  }

  public io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket setWriteQueueMaxSize(int maxSize) { 
    delegate.setWriteQueueMaxSize(maxSize);
    return this;
  }

  public io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket drainHandler(Handler<Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

  /**
   * When a <code>SockJSSocket</code> is created it automatically registers an event handler with the event bus, the ID of that
   * handler is given by <code>writeHandlerID</code>.
   * <p>
   * Given this ID, a different event loop can send a buffer to that event handler using the event bus and
   * that buffer will be received by this instance in its own event loop and written to the underlying socket. This
   * allows you to write data to other sockets which are owned by different event loops.
   * @return 
   */
  public String writeHandlerID() { 
    String ret = delegate.writeHandlerID();
    return ret;
  }

  /**
   * Close it
   */
  public void close() { 
    delegate.close();
  }

  /**
   * Close it giving a status code and reason. Only Applicable to RawWebSocket will downgrade to plain close for
   * other transports.
   * @param statusCode 
   * @param reason 
   */
  public void close(int statusCode, String reason) { 
    delegate.close(statusCode, reason);
  }

  /**
   * Return the remote address for this socket
   * @return 
   */
  public io.vertx.reactivex.core.net.SocketAddress remoteAddress() { 
    io.vertx.reactivex.core.net.SocketAddress ret = io.vertx.reactivex.core.net.SocketAddress.newInstance(delegate.remoteAddress());
    return ret;
  }

  /**
   * Return the local address for this socket
   * @return 
   */
  public io.vertx.reactivex.core.net.SocketAddress localAddress() { 
    io.vertx.reactivex.core.net.SocketAddress ret = io.vertx.reactivex.core.net.SocketAddress.newInstance(delegate.localAddress());
    return ret;
  }

  /**
   * Return the headers corresponding to the last request for this socket or the websocket handshake
   * Any cookie headers will be removed for security reasons
   * @return 
   */
  public io.vertx.reactivex.core.MultiMap headers() { 
    io.vertx.reactivex.core.MultiMap ret = io.vertx.reactivex.core.MultiMap.newInstance(delegate.headers());
    return ret;
  }

  /**
   * Return the URI corresponding to the last request for this socket or the websocket handshake
   * @return 
   */
  public String uri() { 
    String ret = delegate.uri();
    return ret;
  }

  /**
   * @return the Vert.x-Web session corresponding to this socket
   */
  public io.vertx.reactivex.ext.web.Session webSession() { 
    io.vertx.reactivex.ext.web.Session ret = io.vertx.reactivex.ext.web.Session.newInstance(delegate.webSession());
    return ret;
  }

  /**
   * @return the Vert.x-Web user corresponding to this socket
   */
  public io.vertx.reactivex.ext.auth.User webUser() { 
    io.vertx.reactivex.ext.auth.User ret = io.vertx.reactivex.ext.auth.User.newInstance(delegate.webUser());
    return ret;
  }


  public static  SockJSSocket newInstance(io.vertx.ext.web.handler.sockjs.SockJSSocket arg) {
    return arg != null ? new SockJSSocket(arg) : null;
  }
}
