/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.handler.graphql;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import org.dataloader.DataLoaderRegistry;
import graphql.GraphQL;
import io.vertx.ext.web.handler.graphql.GraphQLHandlerOptions;
import io.vertx.core.Handler;
import java.util.function.Function;

/**
 * A {@link io.vertx.reactivex.ext.web.Route} handler for GraphQL requests.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.graphql.GraphQLHandler original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.web.handler.graphql.GraphQLHandler.class)
public class GraphQLHandler implements io.vertx.core.Handler<io.vertx.reactivex.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GraphQLHandler that = (GraphQLHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<GraphQLHandler> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new GraphQLHandler((io.vertx.ext.web.handler.graphql.GraphQLHandler) obj),
    GraphQLHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.graphql.GraphQLHandler delegate;
  
  public GraphQLHandler(io.vertx.ext.web.handler.graphql.GraphQLHandler delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.web.handler.graphql.GraphQLHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.reactivex.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Customize the query context object.
   * The provided <code>factory</code> method will be invoked for each incoming GraphQL request.
   * @param factory 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.graphql.GraphQLHandler queryContext(Function<io.vertx.reactivex.ext.web.RoutingContext, Object> factory) { 
    delegate.queryContext(new java.util.function.Function<io.vertx.ext.web.RoutingContext,java.lang.Object>() {
      public java.lang.Object apply(io.vertx.ext.web.RoutingContext arg) {
        Object ret = factory.apply(io.vertx.reactivex.ext.web.RoutingContext.newInstance(arg));
        return ret;
      }
    });
    return this;
  }

  /**
   * Customize the HTTP headers to add to GraphQL requests sent by the GraphiQL user interface.
   * The result will be applied on top of the fixed set of headers specified in {@link io.vertx.ext.web.handler.graphql.GraphiQLOptions}.
   * <p>
   * This can be useful if, for example, the server is protected by authentication.
   * @param factory 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.graphql.GraphQLHandler graphiQLRequestHeaders(Function<io.vertx.reactivex.ext.web.RoutingContext, io.vertx.reactivex.core.MultiMap> factory) { 
    delegate.graphiQLRequestHeaders(new java.util.function.Function<io.vertx.ext.web.RoutingContext,io.vertx.core.MultiMap>() {
      public io.vertx.core.MultiMap apply(io.vertx.ext.web.RoutingContext arg) {
        io.vertx.reactivex.core.MultiMap ret = factory.apply(io.vertx.reactivex.ext.web.RoutingContext.newInstance(arg));
        return ret.getDelegate();
      }
    });
    return this;
  }

  /**
   * Create a new {@link io.vertx.reactivex.ext.web.handler.graphql.GraphQLHandler} that will use the provided <code>graphQL</code> object to execute queries.
   * <p>
   * The handler will be configured with default {@link io.vertx.ext.web.handler.graphql.GraphQLHandlerOptions}.
   * @param graphQL 
   * @return 
   */
  public static io.vertx.reactivex.ext.web.handler.graphql.GraphQLHandler create(GraphQL graphQL) { 
    io.vertx.reactivex.ext.web.handler.graphql.GraphQLHandler ret = io.vertx.reactivex.ext.web.handler.graphql.GraphQLHandler.newInstance(io.vertx.ext.web.handler.graphql.GraphQLHandler.create(graphQL));
    return ret;
  }

  /**
   * Create a new {@link io.vertx.reactivex.ext.web.handler.graphql.GraphQLHandler} that will use the provided <code>graphQL</code> object to execute queries.
   * <p>
   * The handler will be configured with the given <code>options</code>.
   * @param graphQL 
   * @param options options for configuring the {@link io.vertx.reactivex.ext.web.handler.graphql.GraphQLHandler}
   * @return 
   */
  public static io.vertx.reactivex.ext.web.handler.graphql.GraphQLHandler create(GraphQL graphQL, GraphQLHandlerOptions options) { 
    io.vertx.reactivex.ext.web.handler.graphql.GraphQLHandler ret = io.vertx.reactivex.ext.web.handler.graphql.GraphQLHandler.newInstance(io.vertx.ext.web.handler.graphql.GraphQLHandler.create(graphQL, options));
    return ret;
  }

  /**
   * Customize the .
   * The provided <code>factory</code> method will be invoked for each incoming GraphQL request.
   * @param factory 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.graphql.GraphQLHandler dataLoaderRegistry(Function<io.vertx.reactivex.ext.web.RoutingContext, DataLoaderRegistry> factory) { 
    delegate.dataLoaderRegistry(new java.util.function.Function<io.vertx.ext.web.RoutingContext,org.dataloader.DataLoaderRegistry>() {
      public org.dataloader.DataLoaderRegistry apply(io.vertx.ext.web.RoutingContext arg) {
        DataLoaderRegistry ret = factory.apply(io.vertx.reactivex.ext.web.RoutingContext.newInstance(arg));
        return ret;
      }
    });
    return this;
  }


  public static  GraphQLHandler newInstance(io.vertx.ext.web.handler.graphql.GraphQLHandler arg) {
    return arg != null ? new GraphQLHandler(arg) : null;
  }
}
