/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.handler;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.Handler;

/**
 * A handler that maintains a {@link io.vertx.reactivex.ext.web.Session} for each browser
 * session.
 * <p>
 * It looks up the session for each request based on a session cookie which
 * contains a session ID. It stores the session when the response is ended in
 * the session store.
 * <p>
 * The session is available on the routing context with
 * .
 * <p>
 * The session handler requires a {@link io.vertx.reactivex.ext.web.handler.CookieHandler} to be on the routing
 * chain before it.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.SessionHandler original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.web.handler.SessionHandler.class)
public class SessionHandler implements io.vertx.core.Handler<io.vertx.reactivex.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SessionHandler that = (SessionHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<SessionHandler> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new SessionHandler((io.vertx.ext.web.handler.SessionHandler) obj),
    SessionHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.SessionHandler delegate;
  
  public SessionHandler(io.vertx.ext.web.handler.SessionHandler delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.web.handler.SessionHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.reactivex.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Create a session handler
   * @param sessionStore the session store
   * @return the handler
   */
  public static io.vertx.reactivex.ext.web.handler.SessionHandler create(io.vertx.reactivex.ext.web.sstore.SessionStore sessionStore) { 
    io.vertx.reactivex.ext.web.handler.SessionHandler ret = io.vertx.reactivex.ext.web.handler.SessionHandler.newInstance(io.vertx.ext.web.handler.SessionHandler.create(sessionStore.getDelegate()));
    return ret;
  }

  /**
   * Set the session timeout
   * @param timeout the timeout, in ms.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.SessionHandler setSessionTimeout(long timeout) { 
    delegate.setSessionTimeout(timeout);
    return this;
  }

  /**
   * Set whether a nagging log warning should be written if the session handler is
   * accessed over HTTP, not HTTPS
   * @param nag true to nag
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.SessionHandler setNagHttps(boolean nag) { 
    delegate.setNagHttps(nag);
    return this;
  }

  /**
   * Sets whether the 'secure' flag should be set for the session cookie. When set
   * this flag instructs browsers to only send the cookie over HTTPS. Note that
   * this will probably stop your sessions working if used without HTTPS (e.g. in
   * development).
   * @param secure true to set the secure flag on the cookie
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.SessionHandler setCookieSecureFlag(boolean secure) { 
    delegate.setCookieSecureFlag(secure);
    return this;
  }

  /**
   * Sets whether the 'HttpOnly' flag should be set for the session cookie. When
   * set this flag instructs browsers to prevent Javascript access to the the
   * cookie. Used as a line of defence against the most common XSS attacks.
   * @param httpOnly true to set the HttpOnly flag on the cookie
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.SessionHandler setCookieHttpOnlyFlag(boolean httpOnly) { 
    delegate.setCookieHttpOnlyFlag(httpOnly);
    return this;
  }

  /**
   * Set the session cookie name
   * @param sessionCookieName the session cookie name
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.SessionHandler setSessionCookieName(String sessionCookieName) { 
    delegate.setSessionCookieName(sessionCookieName);
    return this;
  }

  /**
   * Set the session cookie path
   * @param sessionCookiePath the session cookie path
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.SessionHandler setSessionCookiePath(String sessionCookiePath) { 
    delegate.setSessionCookiePath(sessionCookiePath);
    return this;
  }

  /**
   * Set expected session id minimum length.
   * @param minLength the session id minimal length
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.SessionHandler setMinLength(int minLength) { 
    delegate.setMinLength(minLength);
    return this;
  }

  /**
   * Set an auth provider that will allow retrieving the User object from the session to the current routing context.
   * @param authProvider any auth provider.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.SessionHandler setAuthProvider(io.vertx.reactivex.ext.auth.AuthProvider authProvider) { 
    delegate.setAuthProvider(authProvider.getDelegate());
    return this;
  }

  /**
   * Default name of session cookie
   */
  public static final String DEFAULT_SESSION_COOKIE_NAME = io.vertx.ext.web.handler.SessionHandler.DEFAULT_SESSION_COOKIE_NAME;
  /**
   * Default path of session cookie
   */
  public static final String DEFAULT_SESSION_COOKIE_PATH = io.vertx.ext.web.handler.SessionHandler.DEFAULT_SESSION_COOKIE_PATH;
  /**
   * Default time, in ms, that a session lasts for without being accessed before
   * expiring.
   */
  public static final long DEFAULT_SESSION_TIMEOUT = io.vertx.ext.web.handler.SessionHandler.DEFAULT_SESSION_TIMEOUT;
  /**
   * Default of whether a nagging log warning should be written if the session
   * handler is accessed over HTTP, not HTTPS
   */
  public static final boolean DEFAULT_NAG_HTTPS = io.vertx.ext.web.handler.SessionHandler.DEFAULT_NAG_HTTPS;
  /**
   * Default of whether the cookie has the HttpOnly flag set More info:
   * https://www.owasp.org/index.php/HttpOnly
   */
  public static final boolean DEFAULT_COOKIE_HTTP_ONLY_FLAG = io.vertx.ext.web.handler.SessionHandler.DEFAULT_COOKIE_HTTP_ONLY_FLAG;
  /**
   * Default of whether the cookie has the 'secure' flag set to allow transmission
   * over https only. More info: https://www.owasp.org/index.php/SecureFlag
   */
  public static final boolean DEFAULT_COOKIE_SECURE_FLAG = io.vertx.ext.web.handler.SessionHandler.DEFAULT_COOKIE_SECURE_FLAG;
  /**
   * Default min length for a session id. More info:
   * https://www.owasp.org/index.php/Session_Management_Cheat_Sheet
   */
  public static final int DEFAULT_SESSIONID_MIN_LENGTH = io.vertx.ext.web.handler.SessionHandler.DEFAULT_SESSIONID_MIN_LENGTH;

  public static  SessionHandler newInstance(io.vertx.ext.web.handler.SessionHandler arg) {
    return arg != null ? new SessionHandler(arg) : null;
  }
}
