/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.handler;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.Handler;

/**
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.MethodOverrideHandler original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.web.handler.MethodOverrideHandler.class)
public class MethodOverrideHandler implements io.vertx.core.Handler<io.vertx.reactivex.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MethodOverrideHandler that = (MethodOverrideHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<MethodOverrideHandler> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new MethodOverrideHandler((io.vertx.ext.web.handler.MethodOverrideHandler) obj),
    MethodOverrideHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.MethodOverrideHandler delegate;
  
  public MethodOverrideHandler(io.vertx.ext.web.handler.MethodOverrideHandler delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.web.handler.MethodOverrideHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.reactivex.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Create a X-HTTP-METHOD-OVERRIDE handler with safe downgrade of methods
   * @return the X-HTTP-METHOD-OVERRIDE handler
   */
  public static io.vertx.reactivex.ext.web.handler.MethodOverrideHandler create() { 
    io.vertx.reactivex.ext.web.handler.MethodOverrideHandler ret = io.vertx.reactivex.ext.web.handler.MethodOverrideHandler.newInstance(io.vertx.ext.web.handler.MethodOverrideHandler.create());
    return ret;
  }

  /**
   * Create a X-HTTP-METHOD-OVERRIDE handler
   * @param useSafeDowngrade if set to true, the method overriding will not happen if the overridden method is more idempotent or safer than the overriding method.
   * @return the X-HTTP-METHOD-OVERRIDE handler
   */
  public static io.vertx.reactivex.ext.web.handler.MethodOverrideHandler create(boolean useSafeDowngrade) { 
    io.vertx.reactivex.ext.web.handler.MethodOverrideHandler ret = io.vertx.reactivex.ext.web.handler.MethodOverrideHandler.newInstance(io.vertx.ext.web.handler.MethodOverrideHandler.create(useSafeDowngrade));
    return ret;
  }


  public static  MethodOverrideHandler newInstance(io.vertx.ext.web.handler.MethodOverrideHandler arg) {
    return arg != null ? new MethodOverrideHandler(arg) : null;
  }
}
