/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.handler;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import java.util.Set;
import io.vertx.core.json.JsonObject;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * An auth handler that chains to a sequence of handlers.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.ChainAuthHandler original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.web.handler.ChainAuthHandler.class)
public class ChainAuthHandler implements io.vertx.reactivex.ext.web.handler.AuthHandler, io.vertx.core.Handler<io.vertx.reactivex.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChainAuthHandler that = (ChainAuthHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<ChainAuthHandler> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new ChainAuthHandler((io.vertx.ext.web.handler.ChainAuthHandler) obj),
    ChainAuthHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.ChainAuthHandler delegate;
  
  public ChainAuthHandler(io.vertx.ext.web.handler.ChainAuthHandler delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.web.handler.ChainAuthHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.reactivex.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Add a required authority for this auth handler
   * @param authority the authority
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.AuthHandler addAuthority(String authority) { 
    delegate.addAuthority(authority);
    return this;
  }

  /**
   * Add a set of required authorities for this auth handler
   * @param authorities the set of authorities
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.AuthHandler addAuthorities(Set<String> authorities) { 
    delegate.addAuthorities(authorities);
    return this;
  }

  /**
   * Parses the credentials from the request into a JsonObject. The implementation should
   * be able to extract the required info for the auth provider in the format the provider
   * expects.
   * @param context the routing context
   * @param handler the handler to be called once the information is available.
   */
  public void parseCredentials(io.vertx.reactivex.ext.web.RoutingContext context, Handler<AsyncResult<JsonObject>> handler) { 
    delegate.parseCredentials(context.getDelegate(), handler);
  }

  /**
   * Parses the credentials from the request into a JsonObject. The implementation should
   * be able to extract the required info for the auth provider in the format the provider
   * expects.
   * @param context the routing context
   */
  public void parseCredentials(io.vertx.reactivex.ext.web.RoutingContext context) {
    parseCredentials(context, ar -> { });
  }

  /**
   * Parses the credentials from the request into a JsonObject. The implementation should
   * be able to extract the required info for the auth provider in the format the provider
   * expects.
   * @param context the routing context
   * @return 
   */
  public Single<JsonObject> rxParseCredentials(io.vertx.reactivex.ext.web.RoutingContext context) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      parseCredentials(context, handler);
    });
  }

  /**
   * Authorizes the given user against all added authorities.
   * @param user a user.
   * @param handler the handler for the result.
   */
  public void authorize(io.vertx.reactivex.ext.auth.User user, Handler<AsyncResult<Void>> handler) { 
    delegate.authorize(user.getDelegate(), handler);
  }

  /**
   * Authorizes the given user against all added authorities.
   * @param user a user.
   */
  public void authorize(io.vertx.reactivex.ext.auth.User user) {
    authorize(user, ar -> { });
  }

  /**
   * Authorizes the given user against all added authorities.
   * @param user a user.
   * @return 
   */
  public Completable rxAuthorize(io.vertx.reactivex.ext.auth.User user) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      authorize(user, handler);
    });
  }

  public static io.vertx.reactivex.ext.web.handler.ChainAuthHandler create() { 
    io.vertx.reactivex.ext.web.handler.ChainAuthHandler ret = io.vertx.reactivex.ext.web.handler.ChainAuthHandler.newInstance(io.vertx.ext.web.handler.ChainAuthHandler.create());
    return ret;
  }

  /**
   * Appends a auth provider to the chain.
   * @param authHandler auth handler
   * @return self
   */
  public io.vertx.reactivex.ext.web.handler.ChainAuthHandler append(io.vertx.reactivex.ext.web.handler.AuthHandler authHandler) { 
    delegate.append(authHandler.getDelegate());
    return this;
  }

  /**
   * Removes a provider from the chain.
   * @param authHandler provider to remove
   * @return true if provider was removed, false if non existent in the chain.
   */
  public boolean remove(io.vertx.reactivex.ext.web.handler.AuthHandler authHandler) { 
    boolean ret = delegate.remove(authHandler.getDelegate());
    return ret;
  }

  /**
   * Clears the chain.
   */
  public void clear() { 
    delegate.clear();
  }


  public static  ChainAuthHandler newInstance(io.vertx.ext.web.handler.ChainAuthHandler arg) {
    return arg != null ? new ChainAuthHandler(arg) : null;
  }
}
