/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.codec;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.function.Function;

/**
 * A codec for encoding and decoding HTTP bodies.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.codec.BodyCodec original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.web.codec.BodyCodec.class)
public class BodyCodec<T> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BodyCodec that = (BodyCodec) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<BodyCodec> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new BodyCodec((io.vertx.ext.web.codec.BodyCodec) obj),
    BodyCodec::getDelegate
  );

  private final io.vertx.ext.web.codec.BodyCodec<T> delegate;
  public final io.vertx.lang.rx.TypeArg<T> __typeArg_0;
  
  public BodyCodec(io.vertx.ext.web.codec.BodyCodec delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.vertx.lang.rx.TypeArg.unknown();  }

  public BodyCodec(io.vertx.ext.web.codec.BodyCodec delegate, io.vertx.lang.rx.TypeArg<T> typeArg_0) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public io.vertx.ext.web.codec.BodyCodec getDelegate() {
    return delegate;
  }

  /**
   * @return the UTF-8 string codec
   */
  public static io.vertx.reactivex.ext.web.codec.BodyCodec<String> string() { 
    io.vertx.reactivex.ext.web.codec.BodyCodec<String> ret = io.vertx.reactivex.ext.web.codec.BodyCodec.newInstance(io.vertx.ext.web.codec.BodyCodec.string(), io.vertx.lang.rx.TypeArg.unknown());
    return ret;
  }

  /**
   * A codec for strings using a specific <code>encoding</code>.
   * @param encoding the encoding
   * @return the codec
   */
  public static io.vertx.reactivex.ext.web.codec.BodyCodec<String> string(String encoding) { 
    io.vertx.reactivex.ext.web.codec.BodyCodec<String> ret = io.vertx.reactivex.ext.web.codec.BodyCodec.newInstance(io.vertx.ext.web.codec.BodyCodec.string(encoding), io.vertx.lang.rx.TypeArg.unknown());
    return ret;
  }

  /**
   * @return the  codec
   */
  public static io.vertx.reactivex.ext.web.codec.BodyCodec<io.vertx.reactivex.core.buffer.Buffer> buffer() { 
    io.vertx.reactivex.ext.web.codec.BodyCodec<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.codec.BodyCodec.newInstance(io.vertx.ext.web.codec.BodyCodec.buffer(), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
    return ret;
  }

  /**
   * @return the  codec
   */
  public static io.vertx.reactivex.ext.web.codec.BodyCodec<JsonObject> jsonObject() { 
    io.vertx.reactivex.ext.web.codec.BodyCodec<JsonObject> ret = io.vertx.reactivex.ext.web.codec.BodyCodec.newInstance(io.vertx.ext.web.codec.BodyCodec.jsonObject(), io.vertx.lang.rx.TypeArg.unknown());
    return ret;
  }

  /**
   * @return the  codec
   */
  public static io.vertx.reactivex.ext.web.codec.BodyCodec<JsonArray> jsonArray() { 
    io.vertx.reactivex.ext.web.codec.BodyCodec<JsonArray> ret = io.vertx.reactivex.ext.web.codec.BodyCodec.newInstance(io.vertx.ext.web.codec.BodyCodec.jsonArray(), io.vertx.lang.rx.TypeArg.unknown());
    return ret;
  }

  /**
   * Create and return a codec for Java objects encoded using Jackson mapper.
   * @param type 
   * @return a codec for mapping POJO to Json
   */
  public static <U> io.vertx.reactivex.ext.web.codec.BodyCodec<U> json(Class<U> type) { 
    io.vertx.reactivex.ext.web.codec.BodyCodec<U> ret = io.vertx.reactivex.ext.web.codec.BodyCodec.newInstance(io.vertx.ext.web.codec.BodyCodec.json(io.vertx.lang.reactivex.Helper.unwrap(type)), io.vertx.lang.rx.TypeArg.of(type));
    return ret;
  }

  /**
   * @return a codec that simply discards the response
   */
  public static io.vertx.reactivex.ext.web.codec.BodyCodec<Void> none() { 
    io.vertx.reactivex.ext.web.codec.BodyCodec<Void> ret = io.vertx.reactivex.ext.web.codec.BodyCodec.newInstance(io.vertx.ext.web.codec.BodyCodec.none(), io.vertx.lang.rx.TypeArg.unknown());
    return ret;
  }

  /**
   * Create a codec that buffers the entire body and then apply the <code>decode</code> function and returns the result.
   * @param decode the decode function
   * @return the created codec
   */
  public static <T> io.vertx.reactivex.ext.web.codec.BodyCodec<T> create(Function<io.vertx.reactivex.core.buffer.Buffer, T> decode) { 
    io.vertx.reactivex.ext.web.codec.BodyCodec<T> ret = io.vertx.reactivex.ext.web.codec.BodyCodec.newInstance(io.vertx.ext.web.codec.BodyCodec.create(new java.util.function.Function<io.vertx.core.buffer.Buffer,T>() {
      public T apply(io.vertx.core.buffer.Buffer arg) {
        T ret = decode.apply(io.vertx.reactivex.core.buffer.Buffer.newInstance(arg));
        return ret;
      }
    }), io.vertx.lang.rx.TypeArg.unknown());
    return ret;
  }

  /**
   * A body codec that pipes the body to a write stream.
   * <p></p>
   * Same as pipe(stream, true).
   * @param stream the destination stream
   * @return the body codec for a write stream
   */
  public static io.vertx.reactivex.ext.web.codec.BodyCodec<Void> pipe(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.core.buffer.Buffer> stream) { 
    io.vertx.reactivex.ext.web.codec.BodyCodec<Void> ret = io.vertx.reactivex.ext.web.codec.BodyCodec.newInstance(io.vertx.ext.web.codec.BodyCodec.pipe(stream.getDelegate()), io.vertx.lang.rx.TypeArg.unknown());
    return ret;
  }

  /**
   * A body codec that pipes the body to a write stream.
   * @param stream the destination stream
   * @param close whether the destination stream should be closed
   * @return the body codec for a write stream
   */
  public static io.vertx.reactivex.ext.web.codec.BodyCodec<Void> pipe(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.core.buffer.Buffer> stream, boolean close) { 
    io.vertx.reactivex.ext.web.codec.BodyCodec<Void> ret = io.vertx.reactivex.ext.web.codec.BodyCodec.newInstance(io.vertx.ext.web.codec.BodyCodec.pipe(stream.getDelegate(), close), io.vertx.lang.rx.TypeArg.unknown());
    return ret;
  }

  /**
   * A body codec that parse the response as a JSON stream.
   * @param parser the non-null JSON parser to emits the JSON object. The parser must be configured for the stream. Not e that you need to keep a reference on the parser to retrieved the JSON events.
   * @return the body codec for a write stream
   */
  public static io.vertx.reactivex.ext.web.codec.BodyCodec<Void> jsonStream(io.vertx.reactivex.core.parsetools.JsonParser parser) { 
    io.vertx.reactivex.ext.web.codec.BodyCodec<Void> ret = io.vertx.reactivex.ext.web.codec.BodyCodec.newInstance(io.vertx.ext.web.codec.BodyCodec.jsonStream(parser.getDelegate()), io.vertx.lang.rx.TypeArg.unknown());
    return ret;
  }


  public static <T>BodyCodec<T> newInstance(io.vertx.ext.web.codec.BodyCodec arg) {
    return arg != null ? new BodyCodec<T>(arg) : null;
  }

  public static <T>BodyCodec<T> newInstance(io.vertx.ext.web.codec.BodyCodec arg, io.vertx.lang.rx.TypeArg<T> __typeArg_T) {
    return arg != null ? new BodyCodec<T>(arg, __typeArg_T) : null;
  }
}
