/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.client.predicate;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;

/**
 * Represents the outcome of a {@link io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate} applied to an .
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.client.predicate.ResponsePredicateResult original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.web.client.predicate.ResponsePredicateResult.class)
public class ResponsePredicateResult {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ResponsePredicateResult that = (ResponsePredicateResult) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<ResponsePredicateResult> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new ResponsePredicateResult((io.vertx.ext.web.client.predicate.ResponsePredicateResult) obj),
    ResponsePredicateResult::getDelegate
  );

  private final io.vertx.ext.web.client.predicate.ResponsePredicateResult delegate;
  
  public ResponsePredicateResult(io.vertx.ext.web.client.predicate.ResponsePredicateResult delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.web.client.predicate.ResponsePredicateResult getDelegate() {
    return delegate;
  }

  /**
   * @return a successful result
   */
  public static io.vertx.reactivex.ext.web.client.predicate.ResponsePredicateResult success() { 
    io.vertx.reactivex.ext.web.client.predicate.ResponsePredicateResult ret = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicateResult.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicateResult.success());
    return ret;
  }

  /**
   * Creates a failed result.
   * @param message the failure description
   * @return 
   */
  public static io.vertx.reactivex.ext.web.client.predicate.ResponsePredicateResult failure(String message) { 
    io.vertx.reactivex.ext.web.client.predicate.ResponsePredicateResult ret = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicateResult.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicateResult.failure(message));
    return ret;
  }

  /**
   * Whether the result is a success or failure.
   * @return <code>true</code> if the {@link io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate} was applied successfully, false otherwise
   */
  public boolean succeeded() { 
    boolean ret = delegate.succeeded();
    return ret;
  }

  /**
   * The failure message. May be <code>null</code>.
   * @return 
   */
  public String message() { 
    String ret = delegate.message();
    return ret;
  }

  /**
   * The  which has been tested.
   * @return <code>null</code> after the result has been created, or the tested response for converters created with {@link io.vertx.reactivex.ext.web.client.predicate.ErrorConverter#createFullBody}
   */
  public io.vertx.reactivex.ext.web.client.HttpResponse<io.vertx.reactivex.core.buffer.Buffer> response() { 
    io.vertx.reactivex.ext.web.client.HttpResponse<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpResponse.newInstance(delegate.response(), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
    return ret;
  }


  public static  ResponsePredicateResult newInstance(io.vertx.ext.web.client.predicate.ResponsePredicateResult arg) {
    return arg != null ? new ResponsePredicateResult(arg) : null;
  }
}
