/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.client.predicate;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import java.util.List;
import java.util.function.Function;

/**
 * A predicate on .
 * <p>
 * By default, a Vert.x Web Client request ends with an error only if something wrong happens at the network level.
 * In other words, a <code>404 Not Found</code> response, or a response with the wrong content type, are <em>NOT</em> considered as failures.
 * <p>
 * {@link io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate Response predicates} can fail a request when the response does not match some criteria.
 * <p>
 * Custom predicate instances can be used with .
 * <p>
 * As a convenience, a few predicates for common uses cases are predefined. For example:
 * <ul>
 * <li>{@link io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate} to verify that the response has a <code>2xx</code> code, or</li>
 * <li>{@link io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate} to verify that the response body contains JSON data.</li>
 * <li>...</li>
 * </ul>
 * Predefined predicates use the default error converter (discarding the body).
 * <p>
 * However, you can create a new {@link io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate} instance from an existing one using {@link io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate#create} or
 * {@link io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate#create} when the body is required to build the validation failure.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.client.predicate.ResponsePredicate original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.web.client.predicate.ResponsePredicate.class)
public class ResponsePredicate implements java.util.function.Function<io.vertx.reactivex.ext.web.client.HttpResponse<Void>, io.vertx.reactivex.ext.web.client.predicate.ResponsePredicateResult> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ResponsePredicate that = (ResponsePredicate) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  @Override
  public io.vertx.reactivex.ext.web.client.predicate.ResponsePredicateResult apply(io.vertx.reactivex.ext.web.client.HttpResponse<Void> in) {
    io.vertx.ext.web.client.predicate.ResponsePredicateResult ret;
    ret = getDelegate().apply(in.getDelegate());
    java.util.function.Function<io.vertx.ext.web.client.predicate.ResponsePredicateResult, io.vertx.reactivex.ext.web.client.predicate.ResponsePredicateResult> outConv = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicateResult::newInstance;
    return outConv.apply(ret);
  }

  public static final io.vertx.lang.rx.TypeArg<ResponsePredicate> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new ResponsePredicate((io.vertx.ext.web.client.predicate.ResponsePredicate) obj),
    ResponsePredicate::getDelegate
  );

  private final io.vertx.ext.web.client.predicate.ResponsePredicate delegate;
  
  public ResponsePredicate(io.vertx.ext.web.client.predicate.ResponsePredicate delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.web.client.predicate.ResponsePredicate getDelegate() {
    return delegate;
  }

  /**
   * Creates a predicate asserting that the status response code is equal to <code>statusCode</code>.
   * @param statusCode the expected status code
   * @return 
   */
  public static io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate status(int statusCode) { 
    io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate ret = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.status(statusCode));
    return ret;
  }

  /**
   * Creates a predicate asserting that the status response code is in the <code>[min,max[</code> range.
   * @param min the lower (inclusive) accepted status code
   * @param max the highest (exclusive) accepted status code
   * @return 
   */
  public static io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate status(int min, int max) { 
    io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate ret = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.status(min, max));
    return ret;
  }

  /**
   * Creates a predicate validating the response has a <code>content-type</code> header matching the <code>mimeType</code>.
   * @param mimeType the mime type
   * @return 
   */
  public static io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate contentType(String mimeType) { 
    io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate ret = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.contentType(mimeType));
    return ret;
  }

  /**
   * Creates a predicate validating the response has a <code>content-type</code> header matching one of the <code>mimeTypes</code>.
   * @param mimeTypes the list of mime types
   * @return 
   */
  public static io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate contentType(List<String> mimeTypes) { 
    io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate ret = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.contentType(mimeTypes));
    return ret;
  }

  /**
   * Creates a new {@link io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate}. The default error converter will be used (discarding the body).
   * @param test the function to invoke when the response is received
   * @return 
   */
  public static io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate create(Function<io.vertx.reactivex.ext.web.client.HttpResponse<Void>, io.vertx.reactivex.ext.web.client.predicate.ResponsePredicateResult> test) { 
    io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate ret = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.create(new java.util.function.Function<io.vertx.ext.web.client.HttpResponse<java.lang.Void>,io.vertx.ext.web.client.predicate.ResponsePredicateResult>() {
      public io.vertx.ext.web.client.predicate.ResponsePredicateResult apply(io.vertx.ext.web.client.HttpResponse<java.lang.Void> arg) {
        io.vertx.reactivex.ext.web.client.predicate.ResponsePredicateResult ret = test.apply(io.vertx.reactivex.ext.web.client.HttpResponse.newInstance(arg, io.vertx.lang.rx.TypeArg.unknown()));
        return ret.getDelegate();
      }
    }));
    return ret;
  }

  /**
   * Creates a new {@link io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate}, using a custom <code>errorConverter</code>.
   * @param test the function to invoke when the response is received
   * @param errorConverter converts the result of the <code>test</code> function to a {@link java.lang.Throwable}
   * @return 
   */
  public static io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate create(Function<io.vertx.reactivex.ext.web.client.HttpResponse<Void>, io.vertx.reactivex.ext.web.client.predicate.ResponsePredicateResult> test, io.vertx.reactivex.ext.web.client.predicate.ErrorConverter errorConverter) { 
    io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate ret = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.create(new java.util.function.Function<io.vertx.ext.web.client.HttpResponse<java.lang.Void>,io.vertx.ext.web.client.predicate.ResponsePredicateResult>() {
      public io.vertx.ext.web.client.predicate.ResponsePredicateResult apply(io.vertx.ext.web.client.HttpResponse<java.lang.Void> arg) {
        io.vertx.reactivex.ext.web.client.predicate.ResponsePredicateResult ret = test.apply(io.vertx.reactivex.ext.web.client.HttpResponse.newInstance(arg, io.vertx.lang.rx.TypeArg.unknown()));
        return ret.getDelegate();
      }
    }, errorConverter.getDelegate()));
    return ret;
  }

  /**
   * @return the error converter currently used
   */
  public io.vertx.reactivex.ext.web.client.predicate.ErrorConverter errorConverter() { 
    io.vertx.reactivex.ext.web.client.predicate.ErrorConverter ret = io.vertx.reactivex.ext.web.client.predicate.ErrorConverter.newInstance(delegate.errorConverter());
    return ret;
  }

  /**
   * Any 1XX informational response
   */
  public static final ResponsePredicate SC_INFORMATIONAL_RESPONSE = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_INFORMATIONAL_RESPONSE);
  /**
   * 100 Continue
   */
  public static final ResponsePredicate SC_CONTINUE = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_CONTINUE);
  /**
   * 101 Switching Protocols
   */
  public static final ResponsePredicate SC_SWITCHING_PROTOCOLS = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_SWITCHING_PROTOCOLS);
  /**
   * 102 Processing (WebDAV, RFC2518)
   */
  public static final ResponsePredicate SC_PROCESSING = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_PROCESSING);
  /**
   * 103 Early Hints
   */
  public static final ResponsePredicate SC_EARLY_HINTS = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_EARLY_HINTS);
  /**
   * Any 2XX success
   */
  public static final ResponsePredicate SC_SUCCESS = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_SUCCESS);
  /**
   * 200 OK
   */
  public static final ResponsePredicate SC_OK = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_OK);
  /**
   * 201 Created
   */
  public static final ResponsePredicate SC_CREATED = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_CREATED);
  /**
   * 202 Accepted
   */
  public static final ResponsePredicate SC_ACCEPTED = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_ACCEPTED);
  /**
   * 203 Non-Authoritative Information (since HTTP/1.1)
   */
  public static final ResponsePredicate SC_NON_AUTHORITATIVE_INFORMATION = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_NON_AUTHORITATIVE_INFORMATION);
  /**
   * 204 No Content
   */
  public static final ResponsePredicate SC_NO_CONTENT = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_NO_CONTENT);
  /**
   * 205 Reset Content
   */
  public static final ResponsePredicate SC_RESET_CONTENT = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_RESET_CONTENT);
  /**
   * 206 Partial Content
   */
  public static final ResponsePredicate SC_PARTIAL_CONTENT = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_PARTIAL_CONTENT);
  /**
   * 207 Multi-Status (WebDAV, RFC2518)
   */
  public static final ResponsePredicate SC_MULTI_STATUS = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_MULTI_STATUS);
  /**
   * Any 3XX redirection
   */
  public static final ResponsePredicate SC_REDIRECTION = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_REDIRECTION);
  /**
   * 300 Multiple Choices
   */
  public static final ResponsePredicate SC_MULTIPLE_CHOICES = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_MULTIPLE_CHOICES);
  /**
   * 301 Moved Permanently
   */
  public static final ResponsePredicate SC_MOVED_PERMANENTLY = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_MOVED_PERMANENTLY);
  /**
   * 302 Found
   */
  public static final ResponsePredicate SC_FOUND = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_FOUND);
  /**
   * 303 See Other (since HTTP/1.1)
   */
  public static final ResponsePredicate SC_SEE_OTHER = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_SEE_OTHER);
  /**
   * 304 Not Modified
   */
  public static final ResponsePredicate SC_NOT_MODIFIED = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_NOT_MODIFIED);
  /**
   * 305 Use Proxy (since HTTP/1.1)
   */
  public static final ResponsePredicate SC_USE_PROXY = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_USE_PROXY);
  /**
   * 307 Temporary Redirect (since HTTP/1.1)
   */
  public static final ResponsePredicate SC_TEMPORARY_REDIRECT = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_TEMPORARY_REDIRECT);
  /**
   * 308 Permanent Redirect (RFC7538)
   */
  public static final ResponsePredicate SC_PERMANENT_REDIRECT = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_PERMANENT_REDIRECT);
  /**
   * Any 4XX client error
   */
  public static final ResponsePredicate SC_CLIENT_ERRORS = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_CLIENT_ERRORS);
  /**
   * 400 Bad Request
   */
  public static final ResponsePredicate SC_BAD_REQUEST = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_BAD_REQUEST);
  /**
   * 401 Unauthorized
   */
  public static final ResponsePredicate SC_UNAUTHORIZED = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_UNAUTHORIZED);
  /**
   * 402 Payment Required
   */
  public static final ResponsePredicate SC_PAYMENT_REQUIRED = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_PAYMENT_REQUIRED);
  /**
   * 403 Forbidden
   */
  public static final ResponsePredicate SC_FORBIDDEN = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_FORBIDDEN);
  /**
   * 404 Not Found
   */
  public static final ResponsePredicate SC_NOT_FOUND = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_NOT_FOUND);
  /**
   * 405 Method Not Allowed
   */
  public static final ResponsePredicate SC_METHOD_NOT_ALLOWED = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_METHOD_NOT_ALLOWED);
  /**
   * 406 Not Acceptable
   */
  public static final ResponsePredicate SC_NOT_ACCEPTABLE = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_NOT_ACCEPTABLE);
  /**
   * 407 Proxy Authentication Required
   */
  public static final ResponsePredicate SC_PROXY_AUTHENTICATION_REQUIRED = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_PROXY_AUTHENTICATION_REQUIRED);
  /**
   * 408 Request Timeout
   */
  public static final ResponsePredicate SC_REQUEST_TIMEOUT = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_REQUEST_TIMEOUT);
  /**
   * 409 Conflict
   */
  public static final ResponsePredicate SC_CONFLICT = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_CONFLICT);
  /**
   * 410 Gone
   */
  public static final ResponsePredicate SC_GONE = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_GONE);
  /**
   * 411 Length Required
   */
  public static final ResponsePredicate SC_LENGTH_REQUIRED = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_LENGTH_REQUIRED);
  /**
   * 412 Precondition Failed
   */
  public static final ResponsePredicate SC_PRECONDITION_FAILED = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_PRECONDITION_FAILED);
  /**
   * 413 Request Entity Too Large
   */
  public static final ResponsePredicate SC_REQUEST_ENTITY_TOO_LARGE = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_REQUEST_ENTITY_TOO_LARGE);
  /**
   * 414 Request-URI Too Long
   */
  public static final ResponsePredicate SC_REQUEST_URI_TOO_LONG = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_REQUEST_URI_TOO_LONG);
  /**
   * 415 Unsupported Media Type
   */
  public static final ResponsePredicate SC_UNSUPPORTED_MEDIA_TYPE = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_UNSUPPORTED_MEDIA_TYPE);
  /**
   * 416 Requested Range Not Satisfiable
   */
  public static final ResponsePredicate SC_REQUESTED_RANGE_NOT_SATISFIABLE = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_REQUESTED_RANGE_NOT_SATISFIABLE);
  /**
   * 417 Expectation Failed
   */
  public static final ResponsePredicate SC_EXPECTATION_FAILED = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_EXPECTATION_FAILED);
  /**
   * 421 Misdirected Request
   */
  public static final ResponsePredicate SC_MISDIRECTED_REQUEST = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_MISDIRECTED_REQUEST);
  /**
   * 422 Unprocessable Entity (WebDAV, RFC4918)
   */
  public static final ResponsePredicate SC_UNPROCESSABLE_ENTITY = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_UNPROCESSABLE_ENTITY);
  /**
   * 423 Locked (WebDAV, RFC4918)
   */
  public static final ResponsePredicate SC_LOCKED = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_LOCKED);
  /**
   * 424 Failed Dependency (WebDAV, RFC4918)
   */
  public static final ResponsePredicate SC_FAILED_DEPENDENCY = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_FAILED_DEPENDENCY);
  /**
   * 425 Unordered Collection (WebDAV, RFC3648)
   */
  public static final ResponsePredicate SC_UNORDERED_COLLECTION = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_UNORDERED_COLLECTION);
  /**
   * 426 Upgrade Required (RFC2817)
   */
  public static final ResponsePredicate SC_UPGRADE_REQUIRED = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_UPGRADE_REQUIRED);
  /**
   * 428 Precondition Required (RFC6585)
   */
  public static final ResponsePredicate SC_PRECONDITION_REQUIRED = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_PRECONDITION_REQUIRED);
  /**
   * 429 Too Many Requests (RFC6585)
   */
  public static final ResponsePredicate SC_TOO_MANY_REQUESTS = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_TOO_MANY_REQUESTS);
  /**
   * 431 Request Header Fields Too Large (RFC6585)
   */
  public static final ResponsePredicate SC_REQUEST_HEADER_FIELDS_TOO_LARGE = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_REQUEST_HEADER_FIELDS_TOO_LARGE);
  /**
   * Any 5XX server error
   */
  public static final ResponsePredicate SC_SERVER_ERRORS = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_SERVER_ERRORS);
  /**
   * 500 Internal Server Error
   */
  public static final ResponsePredicate SC_INTERNAL_SERVER_ERROR = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_INTERNAL_SERVER_ERROR);
  /**
   * 501 Not Implemented
   */
  public static final ResponsePredicate SC_NOT_IMPLEMENTED = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_NOT_IMPLEMENTED);
  /**
   * 502 Bad Gateway
   */
  public static final ResponsePredicate SC_BAD_GATEWAY = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_BAD_GATEWAY);
  /**
   * 503 Service Unavailable
   */
  public static final ResponsePredicate SC_SERVICE_UNAVAILABLE = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_SERVICE_UNAVAILABLE);
  /**
   * 504 Gateway Timeout
   */
  public static final ResponsePredicate SC_GATEWAY_TIMEOUT = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_GATEWAY_TIMEOUT);
  /**
   * 505 HTTP Version Not Supported
   */
  public static final ResponsePredicate SC_HTTP_VERSION_NOT_SUPPORTED = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_HTTP_VERSION_NOT_SUPPORTED);
  /**
   * 506 Variant Also Negotiates (RFC2295)
   */
  public static final ResponsePredicate SC_VARIANT_ALSO_NEGOTIATES = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_VARIANT_ALSO_NEGOTIATES);
  /**
   * 507 Insufficient Storage (WebDAV, RFC4918)
   */
  public static final ResponsePredicate SC_INSUFFICIENT_STORAGE = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_INSUFFICIENT_STORAGE);
  /**
   * 510 Not Extended (RFC2774)
   */
  public static final ResponsePredicate SC_NOT_EXTENDED = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_NOT_EXTENDED);
  /**
   * 511 Network Authentication Required (RFC6585)
   */
  public static final ResponsePredicate SC_NETWORK_AUTHENTICATION_REQUIRED = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.SC_NETWORK_AUTHENTICATION_REQUIRED);
  /**
   * Creates a predicate validating the response <code>content-type</code> is <code>application/json</code>.
   */
  public static final ResponsePredicate JSON = io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate.JSON);

  public static  ResponsePredicate newInstance(io.vertx.ext.web.client.predicate.ResponsePredicate arg) {
    return arg != null ? new ResponsePredicate(arg) : null;
  }
}
