/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.client.predicate;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import java.util.function.Function;

/**
 * Converts a {@link io.vertx.reactivex.ext.web.client.predicate.ResponsePredicateResult} to a <code>Throwable</code> describing the error.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.client.predicate.ErrorConverter original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.web.client.predicate.ErrorConverter.class)
public class ErrorConverter {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ErrorConverter that = (ErrorConverter) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<ErrorConverter> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new ErrorConverter((io.vertx.ext.web.client.predicate.ErrorConverter) obj),
    ErrorConverter::getDelegate
  );

  private final io.vertx.ext.web.client.predicate.ErrorConverter delegate;
  
  public ErrorConverter(io.vertx.ext.web.client.predicate.ErrorConverter delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.web.client.predicate.ErrorConverter getDelegate() {
    return delegate;
  }

  /**
   * Creates a full {@link io.vertx.reactivex.ext.web.client.predicate.ErrorConverter}, that will passed a predicate result with the response body.
   *
   * <p>The <code>converter</code> function will be invoked <em>after</em> the HTTP response body is received.
   * @param converter a function creating a {@link java.lang.Throwable} from a {@link io.vertx.reactivex.ext.web.client.predicate.ResponsePredicateResult}
   * @return 
   */
  public static io.vertx.reactivex.ext.web.client.predicate.ErrorConverter create(Function<io.vertx.reactivex.ext.web.client.predicate.ResponsePredicateResult, Throwable> converter) { 
    io.vertx.reactivex.ext.web.client.predicate.ErrorConverter ret = io.vertx.reactivex.ext.web.client.predicate.ErrorConverter.newInstance(io.vertx.ext.web.client.predicate.ErrorConverter.create(new java.util.function.Function<io.vertx.ext.web.client.predicate.ResponsePredicateResult,java.lang.Throwable>() {
      public java.lang.Throwable apply(io.vertx.ext.web.client.predicate.ResponsePredicateResult arg) {
        Throwable ret = converter.apply(io.vertx.reactivex.ext.web.client.predicate.ResponsePredicateResult.newInstance(arg));
        return ret;
      }
    }));
    return ret;
  }

  /**
   * Creates a full {@link io.vertx.reactivex.ext.web.client.predicate.ErrorConverter}, that will passed a predicate result with the response body.
   *
   * <p>The <code>converter</code> function will be invoked <em>after</em> the HTTP response body is received.
   * @param converter a function creating a {@link java.lang.Throwable} from a {@link io.vertx.reactivex.ext.web.client.predicate.ResponsePredicateResult}
   * @return 
   */
  public static io.vertx.reactivex.ext.web.client.predicate.ErrorConverter createFullBody(Function<io.vertx.reactivex.ext.web.client.predicate.ResponsePredicateResult, Throwable> converter) { 
    io.vertx.reactivex.ext.web.client.predicate.ErrorConverter ret = io.vertx.reactivex.ext.web.client.predicate.ErrorConverter.newInstance(io.vertx.ext.web.client.predicate.ErrorConverter.createFullBody(new java.util.function.Function<io.vertx.ext.web.client.predicate.ResponsePredicateResult,java.lang.Throwable>() {
      public java.lang.Throwable apply(io.vertx.ext.web.client.predicate.ResponsePredicateResult arg) {
        Throwable ret = converter.apply(io.vertx.reactivex.ext.web.client.predicate.ResponsePredicateResult.newInstance(arg));
        return ret;
      }
    }));
    return ret;
  }

  public Throwable apply(io.vertx.reactivex.ext.web.client.predicate.ResponsePredicateResult result) { 
    Throwable ret = delegate.apply(result.getDelegate());
    return ret;
  }

  /**
   * @return <code>true</code> when the converter wants to process the request body.
   */
  public boolean requiresBody() { 
    boolean ret = delegate.requiresBody();
    return ret;
  }

  public static final ErrorConverter DEFAULT_CONVERTER = io.vertx.reactivex.ext.web.client.predicate.ErrorConverter.newInstance(io.vertx.ext.web.client.predicate.ErrorConverter.DEFAULT_CONVERTER);

  public static  ErrorConverter newInstance(io.vertx.ext.web.client.predicate.ErrorConverter arg) {
    return arg != null ? new ErrorConverter(arg) : null;
  }
}
