/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.client;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;

/**
 * An asynchronous HTTP / HTTP/2 client called <code>WebClient</code>.
 * <p>
 * The web client makes easy to do HTTP request/response interactions with a web server, and provides advanced
 * features like:
 * <ul>
 *   <li>Json body encoding / decoding</li>
 *   <li>request/response pumping</li>
 *   <li>error handling</li>
 * </ul>
 * <p>
 * The web client does not deprecate the , it is actually based on it and therefore inherits
 * its configuration and great features like pooling. The <code>HttpClient</code> should be used when fine grained control over the HTTP
 * requests/response is necessary.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.client.WebClient original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.web.client.WebClient.class)
public class WebClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    WebClient that = (WebClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<WebClient> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new WebClient((io.vertx.ext.web.client.WebClient) obj),
    WebClient::getDelegate
  );

  private final io.vertx.ext.web.client.WebClient delegate;
  
  public WebClient(io.vertx.ext.web.client.WebClient delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.web.client.WebClient getDelegate() {
    return delegate;
  }

  /**
   * Create a web client using the provided <code>vertx</code> instance and default options.
   * @param vertx the vertx instance
   * @return the created web client
   */
  public static io.vertx.reactivex.ext.web.client.WebClient create(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.ext.web.client.WebClient ret = io.vertx.reactivex.ext.web.client.WebClient.newInstance(io.vertx.ext.web.client.WebClient.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create a web client using the provided <code>vertx</code> instance.
   * @param vertx the vertx instance
   * @param options the Web Client options
   * @return the created web client
   */
  public static io.vertx.reactivex.ext.web.client.WebClient create(io.vertx.reactivex.core.Vertx vertx, WebClientOptions options) { 
    io.vertx.reactivex.ext.web.client.WebClient ret = io.vertx.reactivex.ext.web.client.WebClient.newInstance(io.vertx.ext.web.client.WebClient.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Wrap an <code>httpClient</code> with a web client and default options.
   * @param httpClient the  to wrap
   * @return the web client
   */
  public static io.vertx.reactivex.ext.web.client.WebClient wrap(io.vertx.reactivex.core.http.HttpClient httpClient) { 
    io.vertx.reactivex.ext.web.client.WebClient ret = io.vertx.reactivex.ext.web.client.WebClient.newInstance(io.vertx.ext.web.client.WebClient.wrap(httpClient.getDelegate()));
    return ret;
  }

  /**
   * Wrap an <code>httpClient</code> with a web client and default options.
   * <p>
   * Only the specific web client portion of the <code>options</code> is used, the {@link io.vertx.core.http.HttpClientOptions}
   * of the <code>httpClient</code> is reused.
   * @param httpClient the  to wrap
   * @param options the Web Client options
   * @return the web client
   */
  public static io.vertx.reactivex.ext.web.client.WebClient wrap(io.vertx.reactivex.core.http.HttpClient httpClient, WebClientOptions options) { 
    io.vertx.reactivex.ext.web.client.WebClient ret = io.vertx.reactivex.ext.web.client.WebClient.newInstance(io.vertx.ext.web.client.WebClient.wrap(httpClient.getDelegate(), options));
    return ret;
  }

  /**
   * Create an HTTP request to send to the server at the specified host and port.
   * @param method the HTTP method
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> request(HttpMethod method, int port, String host, String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance(delegate.request(method, port, host, requestURI), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.WebClient#request} using the <code>serverAddress</code> parameter to connect to the
   * server instead of the <code>port</code> and <code>host</code> parameters.
   * <p>
   * The request host header will still be created from the <code>port</code> and <code>host</code> parameters.
   * <p>
   * Use  to connect to a unix domain socket server.
   * @param method 
   * @param serverAddress 
   * @param port 
   * @param host 
   * @param requestURI 
   * @return 
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> request(HttpMethod method, io.vertx.reactivex.core.net.SocketAddress serverAddress, int port, String host, String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance(delegate.request(method, serverAddress.getDelegate(), port, host, requestURI), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
    return ret;
  }

  /**
   * Create an HTTP request to send to the server at the specified host and default port.
   * @param method the HTTP method
   * @param host the host
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> request(HttpMethod method, String host, String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance(delegate.request(method, host, requestURI), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.WebClient#request} using the <code>serverAddress</code> parameter to connect to the
   * server instead of the default port and <code>host</code> parameter.
   * <p>
   * The request host header will still be created from the default port and <code>host</code> parameter.
   * <p>
   * Use  to connect to a unix domain socket server.
   * @param method 
   * @param serverAddress 
   * @param host 
   * @param requestURI 
   * @return 
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> request(HttpMethod method, io.vertx.reactivex.core.net.SocketAddress serverAddress, String host, String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance(delegate.request(method, serverAddress.getDelegate(), host, requestURI), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
    return ret;
  }

  /**
   * Create an HTTP request to send to the server at the default host and port.
   * @param method the HTTP method
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> request(HttpMethod method, String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance(delegate.request(method, requestURI), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.WebClient#request} using the <code>serverAddress</code> parameter to connect to the
   * server instead of the default port and default host.
   * <p>
   * The request host header will still be created from the default port and default host.
   * <p>
   * Use  to connect to a unix domain socket server.
   * @param method 
   * @param serverAddress 
   * @param requestURI 
   * @return 
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> request(HttpMethod method, io.vertx.reactivex.core.net.SocketAddress serverAddress, String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance(delegate.request(method, serverAddress.getDelegate(), requestURI), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
    return ret;
  }

  /**
   * Create an HTTP request to send to the server at the specified host and port.
   * @param method the HTTP method
   * @param options the request options
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> request(HttpMethod method, RequestOptions options) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance(delegate.request(method, options), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.WebClient#request} using the <code>serverAddress</code> parameter to connect to the
   * server instead of the <code>options</code> parameter.
   * <p>
   * The request host header will still be created from the <code>options</code> parameter.
   * <p>
   * Use  to connect to a unix domain socket server.
   * @param method 
   * @param serverAddress 
   * @param options 
   * @return 
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> request(HttpMethod method, io.vertx.reactivex.core.net.SocketAddress serverAddress, RequestOptions options) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance(delegate.request(method, serverAddress.getDelegate(), options), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
    return ret;
  }

  /**
   * Create an HTTP request to send to the server using an absolute URI
   * @param method the HTTP method
   * @param absoluteURI the absolute URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> requestAbs(HttpMethod method, String absoluteURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance(delegate.requestAbs(method, absoluteURI), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.WebClient#requestAbs} using the <code>serverAddress</code> parameter to connect to the
   * server instead of the <code>absoluteURI</code> parameter.
   * <p>
   * The request host header will still be created from the <code>absoluteURI</code> parameter.
   * <p>
   * Use  to connect to a unix domain socket server.
   * @param method 
   * @param serverAddress 
   * @param absoluteURI 
   * @return 
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> requestAbs(HttpMethod method, io.vertx.reactivex.core.net.SocketAddress serverAddress, String absoluteURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance(delegate.requestAbs(method, serverAddress.getDelegate(), absoluteURI), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
    return ret;
  }

  /**
   * Create an HTTP GET request to send to the server at the default host and port.
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> get(String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance(delegate.get(requestURI), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
    return ret;
  }

  /**
   * Create an HTTP GET request to send to the server at the specified host and port.
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> get(int port, String host, String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance(delegate.get(port, host, requestURI), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
    return ret;
  }

  /**
   * Create an HTTP GET request to send to the server at the specified host and default port.
   * @param host the host
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> get(String host, String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance(delegate.get(host, requestURI), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
    return ret;
  }

  /**
   * Create an HTTP GET request to send to the server using an absolute URI, specifying a response handler to receive
   * the response
   * @param absoluteURI the absolute URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> getAbs(String absoluteURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance(delegate.getAbs(absoluteURI), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
    return ret;
  }

  /**
   * Create an HTTP POST request to send to the server at the default host and port.
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> post(String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance(delegate.post(requestURI), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
    return ret;
  }

  /**
   * Create an HTTP POST request to send to the server at the specified host and port.
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> post(int port, String host, String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance(delegate.post(port, host, requestURI), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
    return ret;
  }

  /**
   * Create an HTTP POST request to send to the server at the specified host and default port.
   * @param host the host
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> post(String host, String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance(delegate.post(host, requestURI), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
    return ret;
  }

  /**
   * Create an HTTP POST request to send to the server using an absolute URI, specifying a response handler to receive
   * the response
   * @param absoluteURI the absolute URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> postAbs(String absoluteURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance(delegate.postAbs(absoluteURI), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
    return ret;
  }

  /**
   * Create an HTTP PUT request to send to the server at the default host and port.
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> put(String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance(delegate.put(requestURI), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
    return ret;
  }

  /**
   * Create an HTTP PUT request to send to the server at the specified host and port.
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> put(int port, String host, String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance(delegate.put(port, host, requestURI), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
    return ret;
  }

  /**
   * Create an HTTP PUT request to send to the server at the specified host and default port.
   * @param host the host
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> put(String host, String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance(delegate.put(host, requestURI), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
    return ret;
  }

  /**
   * Create an HTTP PUT request to send to the server using an absolute URI, specifying a response handler to receive
   * the response
   * @param absoluteURI the absolute URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> putAbs(String absoluteURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance(delegate.putAbs(absoluteURI), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
    return ret;
  }

  /**
   * Create an HTTP DELETE request to send to the server at the default host and port.
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> delete(String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance(delegate.delete(requestURI), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
    return ret;
  }

  /**
   * Create an HTTP DELETE request to send to the server at the specified host and port.
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> delete(int port, String host, String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance(delegate.delete(port, host, requestURI), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
    return ret;
  }

  /**
   * Create an HTTP DELETE request to send to the server at the specified host and default port.
   * @param host the host
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> delete(String host, String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance(delegate.delete(host, requestURI), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
    return ret;
  }

  /**
   * Create an HTTP DELETE request to send to the server using an absolute URI, specifying a response handler to receive
   * the response
   * @param absoluteURI the absolute URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> deleteAbs(String absoluteURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance(delegate.deleteAbs(absoluteURI), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
    return ret;
  }

  /**
   * Create an HTTP PATCH request to send to the server at the default host and port.
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> patch(String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance(delegate.patch(requestURI), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
    return ret;
  }

  /**
   * Create an HTTP PATCH request to send to the server at the specified host and port.
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> patch(int port, String host, String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance(delegate.patch(port, host, requestURI), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
    return ret;
  }

  /**
   * Create an HTTP PATCH request to send to the server at the specified host and default port.
   * @param host the host
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> patch(String host, String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance(delegate.patch(host, requestURI), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
    return ret;
  }

  /**
   * Create an HTTP PATCH request to send to the server using an absolute URI, specifying a response handler to receive
   * the response
   * @param absoluteURI the absolute URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> patchAbs(String absoluteURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance(delegate.patchAbs(absoluteURI), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
    return ret;
  }

  /**
   * Create an HTTP HEAD request to send to the server at the default host and port.
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> head(String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance(delegate.head(requestURI), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
    return ret;
  }

  /**
   * Create an HTTP HEAD request to send to the server at the specified host and port.
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> head(int port, String host, String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance(delegate.head(port, host, requestURI), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
    return ret;
  }

  /**
   * Create an HTTP HEAD request to send to the server at the specified host and default port.
   * @param host the host
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> head(String host, String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance(delegate.head(host, requestURI), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
    return ret;
  }

  /**
   * Create an HTTP HEAD request to send to the server using an absolute URI, specifying a response handler to receive
   * the response
   * @param absoluteURI the absolute URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> headAbs(String absoluteURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance(delegate.headAbs(absoluteURI), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
    return ret;
  }

  /**
   * Create a request with a custom HTTP method to send to the server at the default host and port.
   * @param customHttpMethod custom HTTP Method
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> raw(String customHttpMethod, String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance(delegate.raw(customHttpMethod, requestURI), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
    return ret;
  }

  /**
   * Create a request with a custom HTTP method to send to the server at the specified host and port.
   * @param customHttpMethod custom HTTP Method
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> raw(String customHttpMethod, int port, String host, String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance(delegate.raw(customHttpMethod, port, host, requestURI), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
    return ret;
  }

  /**
   * Create a request with a custom HTTP method  to send to the server at the specified host and default port.
   * @param customHttpMethod custom HTTP Method
   * @param host the host
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> raw(String customHttpMethod, String host, String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance(delegate.raw(customHttpMethod, host, requestURI), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
    return ret;
  }

  /**
   * Create a request with a custom HTTP method  to send to the server using an absolute URI, specifying a response handler to receive
   * the response
   * @param customHttpMethod custom HTTP Method
   * @param absoluteURI the absolute URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> rawAbs(String customHttpMethod, String absoluteURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance(delegate.rawAbs(customHttpMethod, absoluteURI), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
    return ret;
  }

  /**
   * Close the client. Closing will close down any pooled connections.
   * Clients should always be closed after use.
   */
  public void close() { 
    delegate.close();
  }


  public static  WebClient newInstance(io.vertx.ext.web.client.WebClient arg) {
    return arg != null ? new WebClient(arg) : null;
  }
}
