/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.api.contract;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;

/**
 * Base interface for HTTP request validation with API specification
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.api.contract.HTTPOperationRequestValidationHandler original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.web.api.contract.HTTPOperationRequestValidationHandler.class)
public interface HTTPOperationRequestValidationHandler extends io.vertx.reactivex.ext.web.api.validation.ValidationHandler, io.vertx.core.Handler<io.vertx.reactivex.ext.web.RoutingContext> {

  io.vertx.ext.web.api.contract.HTTPOperationRequestValidationHandler getDelegate();

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.reactivex.ext.web.RoutingContext event);

  /**
   * Function that parse the operation specification and generate validation rules
   */
  public void parseOperationSpec();


  public static  HTTPOperationRequestValidationHandler newInstance(io.vertx.ext.web.api.contract.HTTPOperationRequestValidationHandler arg) {
    return arg != null ? new HTTPOperationRequestValidationHandlerImpl(arg) : null;
  }
}

class HTTPOperationRequestValidationHandlerImpl implements HTTPOperationRequestValidationHandler {
  private final io.vertx.ext.web.api.contract.HTTPOperationRequestValidationHandler delegate;
  
  public HTTPOperationRequestValidationHandlerImpl(io.vertx.ext.web.api.contract.HTTPOperationRequestValidationHandler delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.web.api.contract.HTTPOperationRequestValidationHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.reactivex.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Function that parse the operation specification and generate validation rules
   */
  public void parseOperationSpec() { 
    delegate.parseOperationSpec();
  }

}
