/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import java.util.List;
import io.vertx.core.http.HttpMethod;
import java.util.Set;
import io.vertx.core.Handler;

/**
 * A route is a holder for a set of criteria which determine whether an HTTP request or failure should be routed
 * to a handler.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.Route original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.web.Route.class)
public class Route {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Route that = (Route) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<Route> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new Route((io.vertx.ext.web.Route) obj),
    Route::getDelegate
  );

  private final io.vertx.ext.web.Route delegate;
  
  public Route(io.vertx.ext.web.Route delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.web.Route getDelegate() {
    return delegate;
  }

  /**
   * Add an HTTP method for this route. By default a route will match all HTTP methods. If any are specified then the route
   * will only match any of the specified methods
   * @param method the HTTP method to add
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.Route method(HttpMethod method) { 
    delegate.method(method);
    return this;
  }

  /**
   * Set the path prefix for this route. If set then this route will only match request URI paths which start with this
   * path prefix. Only a single path or path regex can be set for a route.
   * @param path the path prefix
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.Route path(String path) { 
    delegate.path(path);
    return this;
  }

  /**
   * Set the path prefix as a regular expression. If set then this route will only match request URI paths, the beginning
   * of which match the regex. Only a single path or path regex can be set for a route.
   * @param path the path regex
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.Route pathRegex(String path) { 
    delegate.pathRegex(path);
    return this;
  }

  /**
   * Add a content type produced by this route. Used for content based routing.
   * @param contentType the content type
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.Route produces(String contentType) { 
    delegate.produces(contentType);
    return this;
  }

  /**
   * Add a content type consumed by this route. Used for content based routing.
   * @param contentType the content type
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.Route consumes(String contentType) { 
    delegate.consumes(contentType);
    return this;
  }

  /**
   * Specify the order for this route. The router tests routes in that order.
   * @param order the order
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.Route order(int order) { 
    delegate.order(order);
    return this;
  }

  /**
   * Specify this is the last route for the router.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.Route last() { 
    delegate.last();
    return this;
  }

  /**
   * Append a request handler to the route handlers list. The router routes requests to handlers depending on whether the various
   * criteria such as method, path, etc match. When method, path, etc are the same for different routes, You should add multiple
   * handlers to the same route object rather than creating two different routes objects with one handler for route
   * @param requestHandler the request handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.Route handler(Handler<io.vertx.reactivex.ext.web.RoutingContext> requestHandler) { 
    delegate.handler(new Handler<io.vertx.ext.web.RoutingContext>() {
      public void handle(io.vertx.ext.web.RoutingContext event) {
        requestHandler.handle(io.vertx.reactivex.ext.web.RoutingContext.newInstance(event));
      }
    });
    return this;
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.Route#blockingHandler} called with ordered = true
   * @param requestHandler 
   * @return 
   */
  public io.vertx.reactivex.ext.web.Route blockingHandler(Handler<io.vertx.reactivex.ext.web.RoutingContext> requestHandler) { 
    delegate.blockingHandler(new Handler<io.vertx.ext.web.RoutingContext>() {
      public void handle(io.vertx.ext.web.RoutingContext event) {
        requestHandler.handle(io.vertx.reactivex.ext.web.RoutingContext.newInstance(event));
      }
    });
    return this;
  }

  /**
   * Specify a blocking request handler for the route.
   * This method works just like {@link io.vertx.reactivex.ext.web.Route#handler} excepted that it will run the blocking handler on a worker thread
   * so that it won't block the event loop. Note that it's safe to call context.next() from the
   * blocking handler as it will be executed on the event loop context (and not on the worker thread.
   *
   * If the blocking handler is ordered it means that any blocking handlers for the same context are never executed
   * concurrently but always in the order they were called. The default value of ordered is true. If you do not want this
   * behaviour and don't mind if your blocking handlers are executed in parallel you can set ordered to false.
   * @param requestHandler the blocking request handler
   * @param ordered if true handlers are executed in sequence, otherwise are run in parallel
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.Route blockingHandler(Handler<io.vertx.reactivex.ext.web.RoutingContext> requestHandler, boolean ordered) { 
    delegate.blockingHandler(new Handler<io.vertx.ext.web.RoutingContext>() {
      public void handle(io.vertx.ext.web.RoutingContext event) {
        requestHandler.handle(io.vertx.reactivex.ext.web.RoutingContext.newInstance(event));
      }
    }, ordered);
    return this;
  }

  /**
   * Append a failure handler to the route failure handlers list. The router routes failures to failurehandlers depending on whether the various
   * criteria such as method, path, etc match. When method, path, etc are the same for different routes, You should add multiple
   * failure handlers to the same route object rather than creating two different routes objects with one failure handler for route
   * @param failureHandler the request handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.Route failureHandler(Handler<io.vertx.reactivex.ext.web.RoutingContext> failureHandler) { 
    delegate.failureHandler(new Handler<io.vertx.ext.web.RoutingContext>() {
      public void handle(io.vertx.ext.web.RoutingContext event) {
        failureHandler.handle(io.vertx.reactivex.ext.web.RoutingContext.newInstance(event));
      }
    });
    return this;
  }

  /**
   * Remove this route from the router
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.Route remove() { 
    delegate.remove();
    return this;
  }

  /**
   * Disable this route. While disabled the router will not route any requests or failures to it.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.Route disable() { 
    delegate.disable();
    return this;
  }

  /**
   * Enable this route.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.Route enable() { 
    delegate.enable();
    return this;
  }

  /**
   * If true then the normalised request path will be used when routing (e.g. removing duplicate /)
   * Default is true
   * @param useNormalisedPath use normalised path for routing?
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.Route useNormalisedPath(boolean useNormalisedPath) { 
    delegate.useNormalisedPath(useNormalisedPath);
    return this;
  }

  /**
   * @return the path prefix (if any) for this route
   */
  public String getPath() { 
    String ret = delegate.getPath();
    return ret;
  }

  /**
   * @return the http methods accepted by this route
   */
  public Set<HttpMethod> methods() { 
    Set<HttpMethod> ret = delegate.methods();
    return ret;
  }

  /**
   * When you add a new route with a regular expression, you can add named capture groups for parameters. <br/>
   * However, if you need more complex parameters names (like "param_name"), you can add parameters names with
   * this function. You have to name capture groups in regex with names: "p0", "p1", "p2", ... <br/>
   * <br/>
   * For example: If you declare route with regex \/(?<p0>[a-z]*)\/(?<p1>[a-z]*) and group names ["param_a", "param-b"]
   * for uri /hello/world you receive inside pathParams() the parameter param_a = "hello"
   * @param groups group names
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.Route setRegexGroupsNames(List<String> groups) { 
    delegate.setRegexGroupsNames(groups);
    return this;
  }


  public static  Route newInstance(io.vertx.ext.web.Route arg) {
    return arg != null ? new Route(arg) : null;
  }
}
