/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.sql;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.ext.sql.SQLOptions;
import io.vertx.ext.sql.TransactionIsolation;
import io.vertx.core.json.JsonArray;
import java.util.List;
import io.vertx.ext.sql.UpdateResult;
import java.io.Closeable;
import io.vertx.ext.sql.ResultSet;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Represents a connection to a SQL database
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.sql.SQLConnection original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.sql.SQLConnection.class)
public class SQLConnection implements io.vertx.reactivex.ext.sql.SQLOperations {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SQLConnection that = (SQLConnection) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<SQLConnection> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new SQLConnection((io.vertx.ext.sql.SQLConnection) obj),
    SQLConnection::getDelegate
  );

  private final io.vertx.ext.sql.SQLConnection delegate;
  
  public SQLConnection(io.vertx.ext.sql.SQLConnection delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.sql.SQLConnection getDelegate() {
    return delegate;
  }

  /**
   * Execute a one shot SQL statement that returns a single SQL row. This method will reduce the boilerplate code by
   * getting a connection from the pool (this object) and return it back after the execution. Only the first result
   * from the result set is returned.
   * @param sql the statement to execute
   * @param handler the result handler
   * @return self
   */
  public io.vertx.reactivex.ext.sql.SQLOperations querySingle(String sql, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.querySingle(sql, handler);
    return this;
  }

  /**
   * Execute a one shot SQL statement that returns a single SQL row. This method will reduce the boilerplate code by
   * getting a connection from the pool (this object) and return it back after the execution. Only the first result
   * from the result set is returned.
   * @param sql the statement to execute
   * @return self
   */
  public io.vertx.reactivex.ext.sql.SQLOperations querySingle(String sql) {
    return 
querySingle(sql, ar -> { });
  }

  /**
   * Execute a one shot SQL statement that returns a single SQL row. This method will reduce the boilerplate code by
   * getting a connection from the pool (this object) and return it back after the execution. Only the first result
   * from the result set is returned.
   * @param sql the statement to execute
   * @return self
   */
  public Maybe<JsonArray> rxQuerySingle(String sql) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      querySingle(sql, handler);
    });
  }

  /**
   * Execute a one shot SQL statement with arguments that returns a single SQL row. This method will reduce the
   * boilerplate code by getting a connection from the pool (this object) and return it back after the execution.
   * Only the first result from the result set is returned.
   * @param sql the statement to execute
   * @param arguments the arguments
   * @param handler the result handler
   * @return self
   */
  public io.vertx.reactivex.ext.sql.SQLOperations querySingleWithParams(String sql, JsonArray arguments, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.querySingleWithParams(sql, arguments, handler);
    return this;
  }

  /**
   * Execute a one shot SQL statement with arguments that returns a single SQL row. This method will reduce the
   * boilerplate code by getting a connection from the pool (this object) and return it back after the execution.
   * Only the first result from the result set is returned.
   * @param sql the statement to execute
   * @param arguments the arguments
   * @return self
   */
  public io.vertx.reactivex.ext.sql.SQLOperations querySingleWithParams(String sql, JsonArray arguments) {
    return 
querySingleWithParams(sql, arguments, ar -> { });
  }

  /**
   * Execute a one shot SQL statement with arguments that returns a single SQL row. This method will reduce the
   * boilerplate code by getting a connection from the pool (this object) and return it back after the execution.
   * Only the first result from the result set is returned.
   * @param sql the statement to execute
   * @param arguments the arguments
   * @return self
   */
  public Maybe<JsonArray> rxQuerySingleWithParams(String sql, JsonArray arguments) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      querySingleWithParams(sql, arguments, handler);
    });
  }

  /**
   * Sets the desired options to be applied to the current connection when statements are executed.
   *
   * The options are not applied globally but applicable to the current connection. For example changing the transaction
   * isolation level will only affect statements run on this connection and not future or current connections acquired
   * from the connection pool.
   *
   * This method is not async in nature since the apply will only happen at the moment a query is run.
   * @param options the options to modify the unwrapped connection.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLConnection setOptions(SQLOptions options) { 
    delegate.setOptions(options);
    return this;
  }

  /**
   * Sets the auto commit flag for this connection. True by default.
   * @param autoCommit the autoCommit flag, true by default.
   * @param resultHandler the handler which is called once this operation completes.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLConnection setAutoCommit(boolean autoCommit, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.setAutoCommit(autoCommit, resultHandler);
    return this;
  }

  /**
   * Sets the auto commit flag for this connection. True by default.
   * @param autoCommit the autoCommit flag, true by default.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLConnection setAutoCommit(boolean autoCommit) {
    return 
setAutoCommit(autoCommit, ar -> { });
  }

  /**
   * Sets the auto commit flag for this connection. True by default.
   * @param autoCommit the autoCommit flag, true by default.
   * @return 
   */
  public Completable rxSetAutoCommit(boolean autoCommit) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      setAutoCommit(autoCommit, handler);
    });
  }

  /**
   * Executes the given SQL statement
   * @param sql the SQL to execute. For example <code>CREATE TABLE IF EXISTS table ...</code>
   * @param resultHandler the handler which is called once this operation completes.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLConnection execute(String sql, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.execute(sql, resultHandler);
    return this;
  }

  /**
   * Executes the given SQL statement
   * @param sql the SQL to execute. For example <code>CREATE TABLE IF EXISTS table ...</code>
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLConnection execute(String sql) {
    return 
execute(sql, ar -> { });
  }

  /**
   * Executes the given SQL statement
   * @param sql the SQL to execute. For example <code>CREATE TABLE IF EXISTS table ...</code>
   * @return 
   */
  public Completable rxExecute(String sql) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      execute(sql, handler);
    });
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param resultHandler the handler which is called once the operation completes. It will return a <code>ResultSet</code>.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLConnection query(String sql, Handler<AsyncResult<ResultSet>> resultHandler) { 
    delegate.query(sql, resultHandler);
    return this;
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLConnection query(String sql) {
    return 
query(sql, ar -> { });
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return 
   */
  public Single<ResultSet> rxQuery(String sql) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      query(sql, handler);
    });
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param handler the handler which is called once the operation completes. It will return a <code>SQLRowStream</code>.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLConnection queryStream(String sql, Handler<AsyncResult<io.vertx.reactivex.ext.sql.SQLRowStream>> handler) { 
    delegate.queryStream(sql, new Handler<AsyncResult<io.vertx.ext.sql.SQLRowStream>>() {
      public void handle(AsyncResult<io.vertx.ext.sql.SQLRowStream> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.ext.sql.SQLRowStream.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLConnection queryStream(String sql) {
    return 
queryStream(sql, ar -> { });
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return 
   */
  public Single<io.vertx.reactivex.ext.sql.SQLRowStream> rxQueryStream(String sql) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      queryStream(sql, handler);
    });
  }

  /**
   * Executes the given SQL <code>SELECT</code> prepared statement which returns the results of the query.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @param resultHandler the handler which is called once the operation completes. It will return a <code>ResultSet</code>.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLConnection queryWithParams(String sql, JsonArray params, Handler<AsyncResult<ResultSet>> resultHandler) { 
    delegate.queryWithParams(sql, params, resultHandler);
    return this;
  }

  /**
   * Executes the given SQL <code>SELECT</code> prepared statement which returns the results of the query.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLConnection queryWithParams(String sql, JsonArray params) {
    return 
queryWithParams(sql, params, ar -> { });
  }

  /**
   * Executes the given SQL <code>SELECT</code> prepared statement which returns the results of the query.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @return 
   */
  public Single<ResultSet> rxQueryWithParams(String sql, JsonArray params) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      queryWithParams(sql, params, handler);
    });
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @param handler the handler which is called once the operation completes. It will return a <code>SQLRowStream</code>.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLConnection queryStreamWithParams(String sql, JsonArray params, Handler<AsyncResult<io.vertx.reactivex.ext.sql.SQLRowStream>> handler) { 
    delegate.queryStreamWithParams(sql, params, new Handler<AsyncResult<io.vertx.ext.sql.SQLRowStream>>() {
      public void handle(AsyncResult<io.vertx.ext.sql.SQLRowStream> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.ext.sql.SQLRowStream.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLConnection queryStreamWithParams(String sql, JsonArray params) {
    return 
queryStreamWithParams(sql, params, ar -> { });
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @return 
   */
  public Single<io.vertx.reactivex.ext.sql.SQLRowStream> rxQueryStreamWithParams(String sql, JsonArray params) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      queryStreamWithParams(sql, params, handler);
    });
  }

  /**
   * Executes the given SQL statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
   * statement.
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @param resultHandler the handler which is called once the operation completes.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLConnection update(String sql, Handler<AsyncResult<UpdateResult>> resultHandler) { 
    delegate.update(sql, resultHandler);
    return this;
  }

  /**
   * Executes the given SQL statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
   * statement.
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLConnection update(String sql) {
    return 
update(sql, ar -> { });
  }

  /**
   * Executes the given SQL statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
   * statement.
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @return 
   */
  public Single<UpdateResult> rxUpdate(String sql) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      update(sql, handler);
    });
  }

  /**
   * Executes the given prepared statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
   * statement with the given parameters
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @param params these are the parameters to fill the statement.
   * @param resultHandler the handler which is called once the operation completes.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLConnection updateWithParams(String sql, JsonArray params, Handler<AsyncResult<UpdateResult>> resultHandler) { 
    delegate.updateWithParams(sql, params, resultHandler);
    return this;
  }

  /**
   * Executes the given prepared statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
   * statement with the given parameters
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @param params these are the parameters to fill the statement.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLConnection updateWithParams(String sql, JsonArray params) {
    return 
updateWithParams(sql, params, ar -> { });
  }

  /**
   * Executes the given prepared statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
   * statement with the given parameters
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @param params these are the parameters to fill the statement.
   * @return 
   */
  public Single<UpdateResult> rxUpdateWithParams(String sql, JsonArray params) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      updateWithParams(sql, params, handler);
    });
  }

  /**
   * Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
   * @param sql the SQL to execute. For example <code>{call getEmpName}</code>.
   * @param resultHandler the handler which is called once the operation completes. It will return a <code>ResultSet</code>.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLConnection call(String sql, Handler<AsyncResult<ResultSet>> resultHandler) { 
    delegate.call(sql, resultHandler);
    return this;
  }

  /**
   * Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
   * @param sql the SQL to execute. For example <code>{call getEmpName}</code>.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLConnection call(String sql) {
    return 
call(sql, ar -> { });
  }

  /**
   * Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
   * @param sql the SQL to execute. For example <code>{call getEmpName}</code>.
   * @return 
   */
  public Single<ResultSet> rxCall(String sql) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      call(sql, handler);
    });
  }

  /**
   * Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
   *
   * The index of params and outputs are important for both arrays, for example when dealing with a prodecure that
   * takes the first 2 arguments as input values and the 3 arg as an output then the arrays should be like:
   *
   * <pre>
   *   params = [VALUE1, VALUE2, null]
   *   outputs = [null, null, "VARCHAR"]
   * </pre>
   * @param sql the SQL to execute. For example <code>{call getEmpName (?, ?)}</code>.
   * @param params these are the parameters to fill the statement.
   * @param outputs these are the outputs to fill the statement.
   * @param resultHandler the handler which is called once the operation completes. It will return a <code>ResultSet</code>.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLConnection callWithParams(String sql, JsonArray params, JsonArray outputs, Handler<AsyncResult<ResultSet>> resultHandler) { 
    delegate.callWithParams(sql, params, outputs, resultHandler);
    return this;
  }

  /**
   * Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
   *
   * The index of params and outputs are important for both arrays, for example when dealing with a prodecure that
   * takes the first 2 arguments as input values and the 3 arg as an output then the arrays should be like:
   *
   * <pre>
   *   params = [VALUE1, VALUE2, null]
   *   outputs = [null, null, "VARCHAR"]
   * </pre>
   * @param sql the SQL to execute. For example <code>{call getEmpName (?, ?)}</code>.
   * @param params these are the parameters to fill the statement.
   * @param outputs these are the outputs to fill the statement.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLConnection callWithParams(String sql, JsonArray params, JsonArray outputs) {
    return 
callWithParams(sql, params, outputs, ar -> { });
  }

  /**
   * Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
   *
   * The index of params and outputs are important for both arrays, for example when dealing with a prodecure that
   * takes the first 2 arguments as input values and the 3 arg as an output then the arrays should be like:
   *
   * <pre>
   *   params = [VALUE1, VALUE2, null]
   *   outputs = [null, null, "VARCHAR"]
   * </pre>
   * @param sql the SQL to execute. For example <code>{call getEmpName (?, ?)}</code>.
   * @param params these are the parameters to fill the statement.
   * @param outputs these are the outputs to fill the statement.
   * @return 
   */
  public Single<ResultSet> rxCallWithParams(String sql, JsonArray params, JsonArray outputs) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      callWithParams(sql, params, outputs, handler);
    });
  }

  /**
   * Closes the connection. Important to always close the connection when you are done so it's returned to the pool.
   * @param handler the handler called when this operation completes.
   */
  public void close(Handler<AsyncResult<Void>> handler) { 
    delegate.close(handler);
  }

  /**
   * Closes the connection. Important to always close the connection when you are done so it's returned to the pool.
   * @return 
   */
  public Completable rxClose() { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      close(handler);
    });
  }

  /**
   * Closes the connection. Important to always close the connection when you are done so it's returned to the pool.
   */
  public void close() { 
    delegate.close();
  }

  /**
   * Commits all changes made since the previous commit/rollback.
   * @param handler the handler called when this operation completes.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLConnection commit(Handler<AsyncResult<Void>> handler) { 
    delegate.commit(handler);
    return this;
  }

  /**
   * Commits all changes made since the previous commit/rollback.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLConnection commit() {
    return 
commit(ar -> { });
  }

  /**
   * Commits all changes made since the previous commit/rollback.
   * @return 
   */
  public Completable rxCommit() { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      commit(handler);
    });
  }

  /**
   * Rolls back all changes made since the previous commit/rollback.
   * @param handler the handler called when this operation completes.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLConnection rollback(Handler<AsyncResult<Void>> handler) { 
    delegate.rollback(handler);
    return this;
  }

  /**
   * Rolls back all changes made since the previous commit/rollback.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLConnection rollback() {
    return 
rollback(ar -> { });
  }

  /**
   * Rolls back all changes made since the previous commit/rollback.
   * @return 
   */
  public Completable rxRollback() { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      rollback(handler);
    });
  }

  /**
   * Sets a connection wide query timeout.
   *
   * It can be over written at any time and becomes active on the next query call.
   * @param timeoutInSeconds the max amount of seconds the query can take to execute.
   * @return 
   */
  @Deprecated()
  public io.vertx.reactivex.ext.sql.SQLConnection setQueryTimeout(int timeoutInSeconds) { 
    delegate.setQueryTimeout(timeoutInSeconds);
    return this;
  }

  /**
   * Batch simple SQL strings and execute the batch where the async result contains a array of Integers.
   * @param sqlStatements sql statement
   * @param handler the result handler
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLConnection batch(List<String> sqlStatements, Handler<AsyncResult<List<Integer>>> handler) { 
    delegate.batch(sqlStatements, handler);
    return this;
  }

  /**
   * Batch simple SQL strings and execute the batch where the async result contains a array of Integers.
   * @param sqlStatements sql statement
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLConnection batch(List<String> sqlStatements) {
    return 
batch(sqlStatements, ar -> { });
  }

  /**
   * Batch simple SQL strings and execute the batch where the async result contains a array of Integers.
   * @param sqlStatements sql statement
   * @return 
   */
  public Single<List<Integer>> rxBatch(List<String> sqlStatements) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      batch(sqlStatements, handler);
    });
  }

  /**
   * Batch a prepared statement with all entries from the args list. Each entry is a batch.
   * The operation completes with the execution of the batch where the async result contains a array of Integers.
   * @param sqlStatement sql statement
   * @param args the prepared statement arguments
   * @param handler the result handler
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLConnection batchWithParams(String sqlStatement, List<JsonArray> args, Handler<AsyncResult<List<Integer>>> handler) { 
    delegate.batchWithParams(sqlStatement, args, handler);
    return this;
  }

  /**
   * Batch a prepared statement with all entries from the args list. Each entry is a batch.
   * The operation completes with the execution of the batch where the async result contains a array of Integers.
   * @param sqlStatement sql statement
   * @param args the prepared statement arguments
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLConnection batchWithParams(String sqlStatement, List<JsonArray> args) {
    return 
batchWithParams(sqlStatement, args, ar -> { });
  }

  /**
   * Batch a prepared statement with all entries from the args list. Each entry is a batch.
   * The operation completes with the execution of the batch where the async result contains a array of Integers.
   * @param sqlStatement sql statement
   * @param args the prepared statement arguments
   * @return 
   */
  public Single<List<Integer>> rxBatchWithParams(String sqlStatement, List<JsonArray> args) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      batchWithParams(sqlStatement, args, handler);
    });
  }

  /**
   * Batch a callable statement with all entries from the args list. Each entry is a batch.
   * The size of the lists inArgs and outArgs MUST be the equal.
   * The operation completes with the execution of the batch where the async result contains a array of Integers.
   * @param sqlStatement sql statement
   * @param inArgs the callable statement input arguments
   * @param outArgs the callable statement output arguments
   * @param handler the result handler
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLConnection batchCallableWithParams(String sqlStatement, List<JsonArray> inArgs, List<JsonArray> outArgs, Handler<AsyncResult<List<Integer>>> handler) { 
    delegate.batchCallableWithParams(sqlStatement, inArgs, outArgs, handler);
    return this;
  }

  /**
   * Batch a callable statement with all entries from the args list. Each entry is a batch.
   * The size of the lists inArgs and outArgs MUST be the equal.
   * The operation completes with the execution of the batch where the async result contains a array of Integers.
   * @param sqlStatement sql statement
   * @param inArgs the callable statement input arguments
   * @param outArgs the callable statement output arguments
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLConnection batchCallableWithParams(String sqlStatement, List<JsonArray> inArgs, List<JsonArray> outArgs) {
    return 
batchCallableWithParams(sqlStatement, inArgs, outArgs, ar -> { });
  }

  /**
   * Batch a callable statement with all entries from the args list. Each entry is a batch.
   * The size of the lists inArgs and outArgs MUST be the equal.
   * The operation completes with the execution of the batch where the async result contains a array of Integers.
   * @param sqlStatement sql statement
   * @param inArgs the callable statement input arguments
   * @param outArgs the callable statement output arguments
   * @return 
   */
  public Single<List<Integer>> rxBatchCallableWithParams(String sqlStatement, List<JsonArray> inArgs, List<JsonArray> outArgs) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      batchCallableWithParams(sqlStatement, inArgs, outArgs, handler);
    });
  }

  /**
   * Attempts to change the transaction isolation level for this Connection object to the one given.
   *
   * The constants defined in the interface Connection are the possible transaction isolation levels.
   * @param isolation the level of isolation
   * @param handler the handler called when this operation completes.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLConnection setTransactionIsolation(TransactionIsolation isolation, Handler<AsyncResult<Void>> handler) { 
    delegate.setTransactionIsolation(isolation, handler);
    return this;
  }

  /**
   * Attempts to change the transaction isolation level for this Connection object to the one given.
   *
   * The constants defined in the interface Connection are the possible transaction isolation levels.
   * @param isolation the level of isolation
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLConnection setTransactionIsolation(TransactionIsolation isolation) {
    return 
setTransactionIsolation(isolation, ar -> { });
  }

  /**
   * Attempts to change the transaction isolation level for this Connection object to the one given.
   *
   * The constants defined in the interface Connection are the possible transaction isolation levels.
   * @param isolation the level of isolation
   * @return 
   */
  public Completable rxSetTransactionIsolation(TransactionIsolation isolation) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      setTransactionIsolation(isolation, handler);
    });
  }

  /**
   * Attempts to return the transaction isolation level for this Connection object to the one given.
   * @param handler the handler called when this operation completes.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLConnection getTransactionIsolation(Handler<AsyncResult<TransactionIsolation>> handler) { 
    delegate.getTransactionIsolation(handler);
    return this;
  }

  /**
   * Attempts to return the transaction isolation level for this Connection object to the one given.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLConnection getTransactionIsolation() {
    return 
getTransactionIsolation(ar -> { });
  }

  /**
   * Attempts to return the transaction isolation level for this Connection object to the one given.
   * @return 
   */
  public Single<TransactionIsolation> rxGetTransactionIsolation() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      getTransactionIsolation(handler);
    });
  }


  public static  SQLConnection newInstance(io.vertx.ext.sql.SQLConnection arg) {
    return arg != null ? new SQLConnection(arg) : null;
  }
}
