/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.mail;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.json.JsonObject;

/**
 * Represent a mail attachment that can be used in a MailMessage.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.mail.MailAttachment original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.mail.MailAttachment.class)
public class MailAttachment {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MailAttachment that = (MailAttachment) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<MailAttachment> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new MailAttachment((io.vertx.ext.mail.MailAttachment) obj),
    MailAttachment::getDelegate
  );

  private final io.vertx.ext.mail.MailAttachment delegate;
  
  public MailAttachment(io.vertx.ext.mail.MailAttachment delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.mail.MailAttachment getDelegate() {
    return delegate;
  }

  /**
   * construct an empty MailAttachment object that can be filled with the
   * setters
   * @return 
   */
  public static io.vertx.reactivex.ext.mail.MailAttachment create() { 
    io.vertx.reactivex.ext.mail.MailAttachment ret = io.vertx.reactivex.ext.mail.MailAttachment.newInstance(io.vertx.ext.mail.MailAttachment.create());
    return ret;
  }

  /**
   * create a MailAttachment object from a JsonObject representation
   * @param json object to be copied
   * @return 
   */
  public static io.vertx.reactivex.ext.mail.MailAttachment create(JsonObject json) { 
    io.vertx.reactivex.ext.mail.MailAttachment ret = io.vertx.reactivex.ext.mail.MailAttachment.newInstance(io.vertx.ext.mail.MailAttachment.create(json));
    return ret;
  }

  /**
   * create a copy of a MailAttachment object
   * @param other object to be copied
   * @return 
   */
  public static io.vertx.reactivex.ext.mail.MailAttachment create(io.vertx.reactivex.ext.mail.MailAttachment other) { 
    io.vertx.reactivex.ext.mail.MailAttachment ret = io.vertx.reactivex.ext.mail.MailAttachment.newInstance(io.vertx.ext.mail.MailAttachment.create(other.getDelegate()));
    return ret;
  }

  /**
   * get the data
   * @return the data
   */
  public io.vertx.reactivex.core.buffer.Buffer getData() { 
    io.vertx.reactivex.core.buffer.Buffer ret = io.vertx.reactivex.core.buffer.Buffer.newInstance(delegate.getData());
    return ret;
  }

  /**
   * set the data
   * @param data Buffer of bytes to be used at attachment
   * @return this to be able to use it fluently
   */
  public io.vertx.reactivex.ext.mail.MailAttachment setData(io.vertx.reactivex.core.buffer.Buffer data) { 
    delegate.setData(data.getDelegate());
    return this;
  }

  /**
   * get the name
   * @return the name
   */
  public String getName() { 
    String ret = delegate.getName();
    return ret;
  }

  /**
   * set the name
   * @param name name of the attachment file
   * @return this to be able to use it fluently <p> name is the descriptive filename that will be put into the mail i.e. usually a local filename without path this can be set to "" to omit the filename attribute
   */
  public io.vertx.reactivex.ext.mail.MailAttachment setName(String name) { 
    delegate.setName(name);
    return this;
  }

  /**
   * get the Content-Type
   * @return the contentType
   */
  public String getContentType() { 
    String ret = delegate.getContentType();
    return ret;
  }

  /**
   * set the Content-Type
   * @param contentType the contentType
   * @return this to be able to use it fluently
   */
  public io.vertx.reactivex.ext.mail.MailAttachment setContentType(String contentType) { 
    delegate.setContentType(contentType);
    return this;
  }

  /**
   * get the disposition field
   * @return the disposition
   */
  public String getDisposition() { 
    String ret = delegate.getDisposition();
    return ret;
  }

  /**
   * set the disposition field to be used in the attachment
   * @param disposition the disposition
   * @return this to be able to use it fluently
   */
  public io.vertx.reactivex.ext.mail.MailAttachment setDisposition(String disposition) { 
    delegate.setDisposition(disposition);
    return this;
  }

  /**
   * get the description field
   * @return the description
   */
  public String getDescription() { 
    String ret = delegate.getDescription();
    return ret;
  }

  /**
   * set the description field to be used in the attachment
   * @param description the description
   * @return this to be able to use it fluently
   */
  public io.vertx.reactivex.ext.mail.MailAttachment setDescription(String description) { 
    delegate.setDescription(description);
    return this;
  }

  /**
   * get the Content-ID field
   * @return the content id
   */
  public String getContentId() { 
    String ret = delegate.getContentId();
    return ret;
  }

  /**
   * set the Content-ID field to be used in the attachment
   * @param contentId the content id
   * @return this to be able to use it fluently
   */
  public io.vertx.reactivex.ext.mail.MailAttachment setContentId(String contentId) { 
    delegate.setContentId(contentId);
    return this;
  }

  /**
   * Add an header to this attachment.
   * @param key the header key
   * @param value the header value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.mail.MailAttachment addHeader(String key, String value) { 
    delegate.addHeader(key, value);
    return this;
  }

  /**
   * Get the headers to be added for this attachment.
   * @return the headers
   */
  public io.vertx.reactivex.core.MultiMap getHeaders() { 
    io.vertx.reactivex.core.MultiMap ret = io.vertx.reactivex.core.MultiMap.newInstance(delegate.getHeaders());
    return ret;
  }

  /**
   * Set the headers to be added for this attachment.
   * @param headers the headers to be added
   * @return this to be able to use it fluently
   */
  public io.vertx.reactivex.ext.mail.MailAttachment setHeaders(io.vertx.reactivex.core.MultiMap headers) { 
    delegate.setHeaders(headers.getDelegate());
    return this;
  }

  /**
   * convert this object to JSON representation
   * @return the JSON object
   */
  public JsonObject toJson() { 
    JsonObject ret = delegate.toJson();
    return ret;
  }


  public static  MailAttachment newInstance(io.vertx.ext.mail.MailAttachment arg) {
    return arg != null ? new MailAttachment(arg) : null;
  }
}
