/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth.oauth2.providers;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.ext.auth.oauth2.OAuth2ClientOptions;

/**
 * Simplified factory to create an  for Salesforce.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.oauth2.providers.SalesforceAuth original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.auth.oauth2.providers.SalesforceAuth.class)
public class SalesforceAuth extends io.vertx.reactivex.ext.auth.oauth2.providers.OpenIDConnectAuth {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SalesforceAuth that = (SalesforceAuth) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<SalesforceAuth> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new SalesforceAuth((io.vertx.ext.auth.oauth2.providers.SalesforceAuth) obj),
    SalesforceAuth::getDelegate
  );

  private final io.vertx.ext.auth.oauth2.providers.SalesforceAuth delegate;
  
  public SalesforceAuth(io.vertx.ext.auth.oauth2.providers.SalesforceAuth delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public io.vertx.ext.auth.oauth2.providers.SalesforceAuth getDelegate() {
    return delegate;
  }

  /**
   * Create a OAuth2Auth provider for Salesforce
   * @param vertx 
   * @param clientId the client id given to you by Salesforce
   * @param clientSecret the client secret given to you by Salesforce
   * @return 
   */
  public static io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth create(io.vertx.reactivex.core.Vertx vertx, String clientId, String clientSecret) { 
    io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth ret = io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.providers.SalesforceAuth.create(vertx.getDelegate(), clientId, clientSecret));
    return ret;
  }

  /**
   * Create a OAuth2Auth provider for Salesforce
   * @param vertx 
   * @param clientId the client id given to you by Salesforce
   * @param clientSecret the client secret given to you by Salesforce
   * @param httpClientOptions custom http client options
   * @return 
   */
  public static io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth create(io.vertx.reactivex.core.Vertx vertx, String clientId, String clientSecret, HttpClientOptions httpClientOptions) { 
    io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth ret = io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.providers.SalesforceAuth.create(vertx.getDelegate(), clientId, clientSecret, httpClientOptions));
    return ret;
  }

  /**
   * Create a OAuth2Auth provider for OpenID Connect Discovery. The discovery will use the default site in the
   * configuration options and attempt to load the well known descriptor. If a site is provided (for example when
   * running on a custom instance) that site will be used to do the lookup.
   * <p>
   * If the discovered config includes a json web key url, it will be also fetched and the JWKs will be loaded
   * into the OAuth provider so tokens can be decoded.
   * @param vertx the vertx instance
   * @param config the initial config
   * @param handler the instantiated Oauth2 provider instance handler
   */
  public static void discover(io.vertx.reactivex.core.Vertx vertx, OAuth2ClientOptions config, Handler<AsyncResult<io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth>> handler) { 
    io.vertx.ext.auth.oauth2.providers.SalesforceAuth.discover(vertx.getDelegate(), config, new Handler<AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Auth>>() {
      public void handle(AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Auth> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Create a OAuth2Auth provider for OpenID Connect Discovery. The discovery will use the default site in the
   * configuration options and attempt to load the well known descriptor. If a site is provided (for example when
   * running on a custom instance) that site will be used to do the lookup.
   * <p>
   * If the discovered config includes a json web key url, it will be also fetched and the JWKs will be loaded
   * into the OAuth provider so tokens can be decoded.
   * @param vertx the vertx instance
   * @param config the initial config
   */
  public static void discover(io.vertx.reactivex.core.Vertx vertx, OAuth2ClientOptions config) {
    discover(vertx, config, ar -> { });
  }

  /**
   * Create a OAuth2Auth provider for OpenID Connect Discovery. The discovery will use the default site in the
   * configuration options and attempt to load the well known descriptor. If a site is provided (for example when
   * running on a custom instance) that site will be used to do the lookup.
   * <p>
   * If the discovered config includes a json web key url, it will be also fetched and the JWKs will be loaded
   * into the OAuth provider so tokens can be decoded.
   * @param vertx the vertx instance
   * @param config the initial config
   * @return 
   */
  public static Single<io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth> rxDiscover(io.vertx.reactivex.core.Vertx vertx, OAuth2ClientOptions config) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      discover(vertx, config, handler);
    });
  }


  public static  SalesforceAuth newInstance(io.vertx.ext.auth.oauth2.providers.SalesforceAuth arg) {
    return arg != null ? new SalesforceAuth(arg) : null;
  }
}
