/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.shareddata;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Shared data allows you to share data safely between different parts of your application in a safe way.
 * <p>
 * Shared data provides:
 * <ul>
 *   <li>synchronous shared maps (local)</li>
 *   <li>asynchronous maps (local or cluster-wide)</li>
 *   <li>asynchronous locks (local or cluster-wide)</li>
 *   <li>asynchronous counters (local or cluster-wide)</li>
 * </ul>
 * <p>
 * <p>
 *   <strong>WARNING</strong>: In clustered mode, asynchronous maps/locks/counters rely on distributed data structures provided by the cluster manager.
 *   Beware that the latency relative to asynchronous maps/locks/counters operations can be much higher in clustered than in local mode.
 * </p>
 * Please see the documentation for more information.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.shareddata.SharedData original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.core.shareddata.SharedData.class)
public class SharedData {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SharedData that = (SharedData) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<SharedData> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new SharedData((io.vertx.core.shareddata.SharedData) obj),
    SharedData::getDelegate
  );

  private final io.vertx.core.shareddata.SharedData delegate;
  
  public SharedData(io.vertx.core.shareddata.SharedData delegate) {
    this.delegate = delegate;
  }

  public io.vertx.core.shareddata.SharedData getDelegate() {
    return delegate;
  }

  /**
   * Get the cluster wide map with the specified name. The map is accessible to all nodes in the cluster and data
   * put into the map from any node is visible to to any other node.
   * @param name the name of the map
   * @param resultHandler the map will be returned asynchronously in this handler
   */
  public <K, V> void getClusterWideMap(String name, Handler<AsyncResult<io.vertx.reactivex.core.shareddata.AsyncMap<K, V>>> resultHandler) { 
    delegate.getClusterWideMap(name, new Handler<AsyncResult<io.vertx.core.shareddata.AsyncMap<K,V>>>() {
      public void handle(AsyncResult<io.vertx.core.shareddata.AsyncMap<K,V>> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.core.shareddata.AsyncMap.newInstance(ar.result(), io.vertx.lang.rx.TypeArg.unknown(), io.vertx.lang.rx.TypeArg.unknown())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Get the cluster wide map with the specified name. The map is accessible to all nodes in the cluster and data
   * put into the map from any node is visible to to any other node.
   * @param name the name of the map
   */
  public <K, V> void getClusterWideMap(String name) {
    getClusterWideMap(name, ar -> { });
  }

  /**
   * Get the cluster wide map with the specified name. The map is accessible to all nodes in the cluster and data
   * put into the map from any node is visible to to any other node.
   * @param name the name of the map
   * @return 
   */
  public <K, V> Single<io.vertx.reactivex.core.shareddata.AsyncMap<K, V>> rxGetClusterWideMap(String name) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      getClusterWideMap(name, handler);
    });
  }

  /**
   * Get the {@link io.vertx.reactivex.core.shareddata.AsyncMap} with the specified name. When clustered, the map is accessible to all nodes in the cluster
   * and data put into the map from any node is visible to to any other node.
   * <p>
   *   <strong>WARNING</strong>: In clustered mode, asynchronous shared maps rely on distributed data structures provided by the cluster manager.
   *   Beware that the latency relative to asynchronous shared maps operations can be much higher in clustered than in local mode.
   * </p>
   * @param name the name of the map
   * @param resultHandler the map will be returned asynchronously in this handler
   */
  public <K, V> void getAsyncMap(String name, Handler<AsyncResult<io.vertx.reactivex.core.shareddata.AsyncMap<K, V>>> resultHandler) { 
    delegate.getAsyncMap(name, new Handler<AsyncResult<io.vertx.core.shareddata.AsyncMap<K,V>>>() {
      public void handle(AsyncResult<io.vertx.core.shareddata.AsyncMap<K,V>> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.core.shareddata.AsyncMap.newInstance(ar.result(), io.vertx.lang.rx.TypeArg.unknown(), io.vertx.lang.rx.TypeArg.unknown())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Get the {@link io.vertx.reactivex.core.shareddata.AsyncMap} with the specified name. When clustered, the map is accessible to all nodes in the cluster
   * and data put into the map from any node is visible to to any other node.
   * <p>
   *   <strong>WARNING</strong>: In clustered mode, asynchronous shared maps rely on distributed data structures provided by the cluster manager.
   *   Beware that the latency relative to asynchronous shared maps operations can be much higher in clustered than in local mode.
   * </p>
   * @param name the name of the map
   */
  public <K, V> void getAsyncMap(String name) {
    getAsyncMap(name, ar -> { });
  }

  /**
   * Get the {@link io.vertx.reactivex.core.shareddata.AsyncMap} with the specified name. When clustered, the map is accessible to all nodes in the cluster
   * and data put into the map from any node is visible to to any other node.
   * <p>
   *   <strong>WARNING</strong>: In clustered mode, asynchronous shared maps rely on distributed data structures provided by the cluster manager.
   *   Beware that the latency relative to asynchronous shared maps operations can be much higher in clustered than in local mode.
   * </p>
   * @param name the name of the map
   * @return 
   */
  public <K, V> Single<io.vertx.reactivex.core.shareddata.AsyncMap<K, V>> rxGetAsyncMap(String name) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      getAsyncMap(name, handler);
    });
  }

  /**
   * Get the {@link io.vertx.reactivex.core.shareddata.AsyncMap} with the specified name.
   * <p>
   * When clustered, the map is <b>NOT</b> accessible to all nodes in the cluster.
   * Only the instance which created the map can put and retrieve data from this map.
   * @param name the name of the map
   * @param resultHandler the map will be returned asynchronously in this handler
   */
  public <K, V> void getLocalAsyncMap(String name, Handler<AsyncResult<io.vertx.reactivex.core.shareddata.AsyncMap<K, V>>> resultHandler) { 
    delegate.getLocalAsyncMap(name, new Handler<AsyncResult<io.vertx.core.shareddata.AsyncMap<K,V>>>() {
      public void handle(AsyncResult<io.vertx.core.shareddata.AsyncMap<K,V>> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.core.shareddata.AsyncMap.newInstance(ar.result(), io.vertx.lang.rx.TypeArg.unknown(), io.vertx.lang.rx.TypeArg.unknown())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Get the {@link io.vertx.reactivex.core.shareddata.AsyncMap} with the specified name.
   * <p>
   * When clustered, the map is <b>NOT</b> accessible to all nodes in the cluster.
   * Only the instance which created the map can put and retrieve data from this map.
   * @param name the name of the map
   */
  public <K, V> void getLocalAsyncMap(String name) {
    getLocalAsyncMap(name, ar -> { });
  }

  /**
   * Get the {@link io.vertx.reactivex.core.shareddata.AsyncMap} with the specified name.
   * <p>
   * When clustered, the map is <b>NOT</b> accessible to all nodes in the cluster.
   * Only the instance which created the map can put and retrieve data from this map.
   * @param name the name of the map
   * @return 
   */
  public <K, V> Single<io.vertx.reactivex.core.shareddata.AsyncMap<K, V>> rxGetLocalAsyncMap(String name) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      getLocalAsyncMap(name, handler);
    });
  }

  /**
   * Get an asynchronous lock with the specified name. The lock will be passed to the handler when it is available.
   * <p>
   *   In general lock acquision is unordered, so that sequential attempts to acquire a lock,
   *   even from a single thread, can happen in non-sequential order.
   * </p>
   * @param name the name of the lock
   * @param resultHandler the handler
   */
  public void getLock(String name, Handler<AsyncResult<io.vertx.reactivex.core.shareddata.Lock>> resultHandler) { 
    delegate.getLock(name, new Handler<AsyncResult<io.vertx.core.shareddata.Lock>>() {
      public void handle(AsyncResult<io.vertx.core.shareddata.Lock> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.core.shareddata.Lock.newInstance(ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Get an asynchronous lock with the specified name. The lock will be passed to the handler when it is available.
   * <p>
   *   In general lock acquision is unordered, so that sequential attempts to acquire a lock,
   *   even from a single thread, can happen in non-sequential order.
   * </p>
   * @param name the name of the lock
   */
  public void getLock(String name) {
    getLock(name, ar -> { });
  }

  /**
   * Get an asynchronous lock with the specified name. The lock will be passed to the handler when it is available.
   * <p>
   *   In general lock acquision is unordered, so that sequential attempts to acquire a lock,
   *   even from a single thread, can happen in non-sequential order.
   * </p>
   * @param name the name of the lock
   * @return 
   */
  public Single<io.vertx.reactivex.core.shareddata.Lock> rxGetLock(String name) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      getLock(name, handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.core.shareddata.SharedData#getLock} but specifying a timeout. If the lock is not obtained within the timeout
   * a failure will be sent to the handler.
   * <p>
   *   In general lock acquision is unordered, so that sequential attempts to acquire a lock,
   *   even from a single thread, can happen in non-sequential order.
   * </p>
   * @param name the name of the lock
   * @param timeout the timeout in ms
   * @param resultHandler the handler
   */
  public void getLockWithTimeout(String name, long timeout, Handler<AsyncResult<io.vertx.reactivex.core.shareddata.Lock>> resultHandler) { 
    delegate.getLockWithTimeout(name, timeout, new Handler<AsyncResult<io.vertx.core.shareddata.Lock>>() {
      public void handle(AsyncResult<io.vertx.core.shareddata.Lock> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.core.shareddata.Lock.newInstance(ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Like {@link io.vertx.reactivex.core.shareddata.SharedData#getLock} but specifying a timeout. If the lock is not obtained within the timeout
   * a failure will be sent to the handler.
   * <p>
   *   In general lock acquision is unordered, so that sequential attempts to acquire a lock,
   *   even from a single thread, can happen in non-sequential order.
   * </p>
   * @param name the name of the lock
   * @param timeout the timeout in ms
   */
  public void getLockWithTimeout(String name, long timeout) {
    getLockWithTimeout(name, timeout, ar -> { });
  }

  /**
   * Like {@link io.vertx.reactivex.core.shareddata.SharedData#getLock} but specifying a timeout. If the lock is not obtained within the timeout
   * a failure will be sent to the handler.
   * <p>
   *   In general lock acquision is unordered, so that sequential attempts to acquire a lock,
   *   even from a single thread, can happen in non-sequential order.
   * </p>
   * @param name the name of the lock
   * @param timeout the timeout in ms
   * @return 
   */
  public Single<io.vertx.reactivex.core.shareddata.Lock> rxGetLockWithTimeout(String name, long timeout) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      getLockWithTimeout(name, timeout, handler);
    });
  }

  /**
   * Get an asynchronous local lock with the specified name. The lock will be passed to the handler when it is available.
   * <p>
   *   In general lock acquision is unordered, so that sequential attempts to acquire a lock,
   *   even from a single thread, can happen in non-sequential order.
   * </p>
   * @param name the name of the lock
   * @param resultHandler the handler
   */
  public void getLocalLock(String name, Handler<AsyncResult<io.vertx.reactivex.core.shareddata.Lock>> resultHandler) { 
    delegate.getLocalLock(name, new Handler<AsyncResult<io.vertx.core.shareddata.Lock>>() {
      public void handle(AsyncResult<io.vertx.core.shareddata.Lock> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.core.shareddata.Lock.newInstance(ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Get an asynchronous local lock with the specified name. The lock will be passed to the handler when it is available.
   * <p>
   *   In general lock acquision is unordered, so that sequential attempts to acquire a lock,
   *   even from a single thread, can happen in non-sequential order.
   * </p>
   * @param name the name of the lock
   */
  public void getLocalLock(String name) {
    getLocalLock(name, ar -> { });
  }

  /**
   * Get an asynchronous local lock with the specified name. The lock will be passed to the handler when it is available.
   * <p>
   *   In general lock acquision is unordered, so that sequential attempts to acquire a lock,
   *   even from a single thread, can happen in non-sequential order.
   * </p>
   * @param name the name of the lock
   * @return 
   */
  public Single<io.vertx.reactivex.core.shareddata.Lock> rxGetLocalLock(String name) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      getLocalLock(name, handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.core.shareddata.SharedData#getLocalLock} but specifying a timeout. If the lock is not obtained within the timeout
   * a failure will be sent to the handler.
   * <p>
   *   In general lock acquision is unordered, so that sequential attempts to acquire a lock,
   *   even from a single thread, can happen in non-sequential order.
   * </p>
   * @param name the name of the lock
   * @param timeout the timeout in ms
   * @param resultHandler the handler
   */
  public void getLocalLockWithTimeout(String name, long timeout, Handler<AsyncResult<io.vertx.reactivex.core.shareddata.Lock>> resultHandler) { 
    delegate.getLocalLockWithTimeout(name, timeout, new Handler<AsyncResult<io.vertx.core.shareddata.Lock>>() {
      public void handle(AsyncResult<io.vertx.core.shareddata.Lock> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.core.shareddata.Lock.newInstance(ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Like {@link io.vertx.reactivex.core.shareddata.SharedData#getLocalLock} but specifying a timeout. If the lock is not obtained within the timeout
   * a failure will be sent to the handler.
   * <p>
   *   In general lock acquision is unordered, so that sequential attempts to acquire a lock,
   *   even from a single thread, can happen in non-sequential order.
   * </p>
   * @param name the name of the lock
   * @param timeout the timeout in ms
   */
  public void getLocalLockWithTimeout(String name, long timeout) {
    getLocalLockWithTimeout(name, timeout, ar -> { });
  }

  /**
   * Like {@link io.vertx.reactivex.core.shareddata.SharedData#getLocalLock} but specifying a timeout. If the lock is not obtained within the timeout
   * a failure will be sent to the handler.
   * <p>
   *   In general lock acquision is unordered, so that sequential attempts to acquire a lock,
   *   even from a single thread, can happen in non-sequential order.
   * </p>
   * @param name the name of the lock
   * @param timeout the timeout in ms
   * @return 
   */
  public Single<io.vertx.reactivex.core.shareddata.Lock> rxGetLocalLockWithTimeout(String name, long timeout) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      getLocalLockWithTimeout(name, timeout, handler);
    });
  }

  /**
   * Get an asynchronous counter. The counter will be passed to the handler.
   * @param name the name of the counter.
   * @param resultHandler the handler
   */
  public void getCounter(String name, Handler<AsyncResult<io.vertx.reactivex.core.shareddata.Counter>> resultHandler) { 
    delegate.getCounter(name, new Handler<AsyncResult<io.vertx.core.shareddata.Counter>>() {
      public void handle(AsyncResult<io.vertx.core.shareddata.Counter> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.core.shareddata.Counter.newInstance(ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Get an asynchronous counter. The counter will be passed to the handler.
   * @param name the name of the counter.
   */
  public void getCounter(String name) {
    getCounter(name, ar -> { });
  }

  /**
   * Get an asynchronous counter. The counter will be passed to the handler.
   * @param name the name of the counter.
   * @return 
   */
  public Single<io.vertx.reactivex.core.shareddata.Counter> rxGetCounter(String name) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      getCounter(name, handler);
    });
  }

  /**
   * Get an asynchronous local counter. The counter will be passed to the handler.
   * @param name the name of the counter.
   * @param resultHandler the handler
   */
  public void getLocalCounter(String name, Handler<AsyncResult<io.vertx.reactivex.core.shareddata.Counter>> resultHandler) { 
    delegate.getLocalCounter(name, new Handler<AsyncResult<io.vertx.core.shareddata.Counter>>() {
      public void handle(AsyncResult<io.vertx.core.shareddata.Counter> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.core.shareddata.Counter.newInstance(ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Get an asynchronous local counter. The counter will be passed to the handler.
   * @param name the name of the counter.
   */
  public void getLocalCounter(String name) {
    getLocalCounter(name, ar -> { });
  }

  /**
   * Get an asynchronous local counter. The counter will be passed to the handler.
   * @param name the name of the counter.
   * @return 
   */
  public Single<io.vertx.reactivex.core.shareddata.Counter> rxGetLocalCounter(String name) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      getLocalCounter(name, handler);
    });
  }

  /**
   * Return a <code>LocalMap</code> with the specific <code>name</code>.
   * @param name the name of the map
   * @return the msp
   */
  public <K, V> io.vertx.reactivex.core.shareddata.LocalMap<K, V> getLocalMap(String name) { 
    io.vertx.reactivex.core.shareddata.LocalMap<K, V> ret = io.vertx.reactivex.core.shareddata.LocalMap.newInstance(delegate.getLocalMap(name), io.vertx.lang.rx.TypeArg.unknown(), io.vertx.lang.rx.TypeArg.unknown());
    return ret;
  }


  public static  SharedData newInstance(io.vertx.core.shareddata.SharedData arg) {
    return arg != null ? new SharedData(arg) : null;
  }
}
