/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.http;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Represents an file upload from an HTML FORM.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.HttpServerFileUpload original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.core.http.HttpServerFileUpload.class)
public class HttpServerFileUpload implements io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.buffer.Buffer> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HttpServerFileUpload that = (HttpServerFileUpload) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<HttpServerFileUpload> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new HttpServerFileUpload((io.vertx.core.http.HttpServerFileUpload) obj),
    HttpServerFileUpload::getDelegate
  );

  private final io.vertx.core.http.HttpServerFileUpload delegate;
  
  public HttpServerFileUpload(io.vertx.core.http.HttpServerFileUpload delegate) {
    this.delegate = delegate;
  }

  public io.vertx.core.http.HttpServerFileUpload getDelegate() {
    return delegate;
  }

  private io.reactivex.Observable<io.vertx.reactivex.core.buffer.Buffer> observable;
  private io.reactivex.Flowable<io.vertx.reactivex.core.buffer.Buffer> flowable;

  public synchronized io.reactivex.Observable<io.vertx.reactivex.core.buffer.Buffer> toObservable() {
    if (observable == null) {
      java.util.function.Function<io.vertx.core.buffer.Buffer, io.vertx.reactivex.core.buffer.Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::newInstance;
      observable = io.vertx.reactivex.ObservableHelper.toObservable(delegate, conv);
    }
    return observable;
  }

  public synchronized io.reactivex.Flowable<io.vertx.reactivex.core.buffer.Buffer> toFlowable() {
    if (flowable == null) {
      java.util.function.Function<io.vertx.core.buffer.Buffer, io.vertx.reactivex.core.buffer.Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::newInstance;
      flowable = io.vertx.reactivex.FlowableHelper.toFlowable(delegate, conv);
    }
    return flowable;
  }

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.reactivex.core.streams.Pipe<io.vertx.reactivex.core.buffer.Buffer> pipe() { 
    io.vertx.reactivex.core.streams.Pipe<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.core.streams.Pipe.newInstance(delegate.pipe(), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  public void pipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.core.buffer.Buffer> dst, Handler<AsyncResult<Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   */
  public void pipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.core.buffer.Buffer> dst) {
    pipeTo(dst, ar -> { });
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public Completable rxPipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.core.buffer.Buffer> dst) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      pipeTo(dst, handler);
    });
  }

  public io.vertx.reactivex.core.http.HttpServerFileUpload exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.reactivex.core.http.HttpServerFileUpload handler(Handler<io.vertx.reactivex.core.buffer.Buffer> handler) { 
    delegate.handler(new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        handler.handle(io.vertx.reactivex.core.buffer.Buffer.newInstance(event));
      }
    });
    return this;
  }

  public io.vertx.reactivex.core.http.HttpServerFileUpload endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.reactivex.core.http.HttpServerFileUpload pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.reactivex.core.http.HttpServerFileUpload resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.reactivex.core.http.HttpServerFileUpload fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  /**
   * Stream the content of this upload to the given file on storage.
   * @param filename the name of the file
   * @return 
   */
  public io.vertx.reactivex.core.http.HttpServerFileUpload streamToFileSystem(String filename) { 
    delegate.streamToFileSystem(filename);
    return this;
  }

  /**
   * @return the filename which was used when upload the file.
   */
  public String filename() { 
    String ret = delegate.filename();
    return ret;
  }

  /**
   * @return the name of the attribute
   */
  public String name() { 
    String ret = delegate.name();
    return ret;
  }

  /**
   * @return the content type for the upload
   */
  public String contentType() { 
    String ret = delegate.contentType();
    return ret;
  }

  /**
   * @return the contentTransferEncoding for the upload
   */
  public String contentTransferEncoding() { 
    String ret = delegate.contentTransferEncoding();
    return ret;
  }

  /**
   * @return the charset for the upload
   */
  public String charset() { 
    String ret = delegate.charset();
    return ret;
  }

  /**
   * The size of the upload may not be available until it is all read.
   * Check {@link io.vertx.reactivex.core.http.HttpServerFileUpload#isSizeAvailable} to determine this
   * @return the size of the upload (in bytes)
   */
  public long size() { 
    long ret = delegate.size();
    return ret;
  }

  /**
   * @return <code>true</code> if the size of the upload can be retrieved via {@link io.vertx.reactivex.core.http.HttpServerFileUpload#size}.
   */
  public boolean isSizeAvailable() { 
    boolean ret = delegate.isSizeAvailable();
    return ret;
  }

  /**
   * @return the async uploaded file when {@link io.vertx.reactivex.core.http.HttpServerFileUpload#streamToFileSystem} has been used
   */
  public io.vertx.reactivex.core.file.AsyncFile file() { 
    io.vertx.reactivex.core.file.AsyncFile ret = io.vertx.reactivex.core.file.AsyncFile.newInstance(delegate.file());
    return ret;
  }


  public static  HttpServerFileUpload newInstance(io.vertx.core.http.HttpServerFileUpload arg) {
    return arg != null ? new HttpServerFileUpload(arg) : null;
  }
}
