/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.eventbus;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Represents a stream of message that can be written to.
 * <p>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.eventbus.MessageProducer original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.core.eventbus.MessageProducer.class)
public class MessageProducer<T> implements io.vertx.reactivex.core.streams.WriteStream<T> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MessageProducer that = (MessageProducer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<MessageProducer> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new MessageProducer((io.vertx.core.eventbus.MessageProducer) obj),
    MessageProducer::getDelegate
  );

  private final io.vertx.core.eventbus.MessageProducer<T> delegate;
  public final io.vertx.lang.rx.TypeArg<T> __typeArg_0;
  
  public MessageProducer(io.vertx.core.eventbus.MessageProducer delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.vertx.lang.rx.TypeArg.unknown();  }

  public MessageProducer(io.vertx.core.eventbus.MessageProducer delegate, io.vertx.lang.rx.TypeArg<T> typeArg_0) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public io.vertx.core.eventbus.MessageProducer getDelegate() {
    return delegate;
  }

  private io.vertx.reactivex.WriteStreamObserver<T> observer;
  private io.vertx.reactivex.WriteStreamSubscriber<T> subscriber;

  public synchronized io.vertx.reactivex.WriteStreamObserver<T> toObserver() {
    if (observer == null) {
      java.util.function.Function<T, T> conv = (java.util.function.Function<T, T>) __typeArg_0.unwrap;
      observer = io.vertx.reactivex.RxHelper.toObserver(getDelegate(), conv);
    }
    return observer;
  }

  public synchronized io.vertx.reactivex.WriteStreamSubscriber<T> toSubscriber() {
    if (subscriber == null) {
      java.util.function.Function<T, T> conv = (java.util.function.Function<T, T>) __typeArg_0.unwrap;
      subscriber = io.vertx.reactivex.RxHelper.toSubscriber(getDelegate(), conv);
    }
    return subscriber;
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @param handler 
   */
  public void write(T data, Handler<AsyncResult<Void>> handler) { 
    delegate.write(__typeArg_0.<T>unwrap(data), handler);
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   */
  public void write(T data) {
    write(data, ar -> { });
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public Completable rxWrite(T data) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      write(data, handler);
    });
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @param handler 
   */
  public void end(T data, Handler<AsyncResult<Void>> handler) { 
    delegate.end(__typeArg_0.<T>unwrap(data), handler);
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   */
  public void end(T data) {
    end(data, ar -> { });
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public Completable rxEnd(T data) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      end(data, handler);
    });
  }

  /**
   * This will return <code>true</code> if there are more bytes in the write queue than the value set using {@link io.vertx.reactivex.core.eventbus.MessageProducer#setWriteQueueMaxSize}
   * @return true if write queue is full
   */
  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  public io.vertx.reactivex.core.eventbus.MessageProducer<T> exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.reactivex.core.eventbus.MessageProducer<T> setWriteQueueMaxSize(int maxSize) { 
    delegate.setWriteQueueMaxSize(maxSize);
    return this;
  }

  public io.vertx.reactivex.core.eventbus.MessageProducer<T> drainHandler(Handler<Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

  /**
   * Update the delivery options of this producer.
   * @param options the new options
   * @return this producer object
   */
  public io.vertx.reactivex.core.eventbus.MessageProducer<T> deliveryOptions(DeliveryOptions options) { 
    delegate.deliveryOptions(options);
    return this;
  }

  /**
   * @return The address to which the producer produces messages.
   */
  public String address() { 
    String ret = delegate.address();
    return ret;
  }

  /**
   * Closes the producer, calls {@link io.vertx.reactivex.core.eventbus.MessageProducer#close}
   * @param handler 
   */
  public void end(Handler<AsyncResult<Void>> handler) { 
    delegate.end(handler);
  }

  /**
   * Closes the producer, calls {@link io.vertx.reactivex.core.eventbus.MessageProducer#close}
   */
  public void end() {
    end(ar -> { });
  }

  /**
   * Closes the producer, calls {@link io.vertx.reactivex.core.eventbus.MessageProducer#close}
   * @return 
   */
  public Completable rxEnd() { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      end(handler);
    });
  }

  /**
   * Same as {@link io.vertx.reactivex.core.eventbus.MessageProducer#close} but with an <code>handler</code> called when the operation completes
   * @param handler 
   */
  public void close(Handler<AsyncResult<Void>> handler) { 
    delegate.close(handler);
  }

  /**
   * Same as {@link io.vertx.reactivex.core.eventbus.MessageProducer#close} but with an <code>handler</code> called when the operation completes
   */
  public void close() {
    close(ar -> { });
  }

  /**
   * Same as {@link io.vertx.reactivex.core.eventbus.MessageProducer#close} but with an <code>handler</code> called when the operation completes
   * @return 
   */
  public Completable rxClose() { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      close(handler);
    });
  }

  public static final int DEFAULT_WRITE_QUEUE_MAX_SIZE = io.vertx.core.eventbus.MessageProducer.DEFAULT_WRITE_QUEUE_MAX_SIZE;

  public static <T>MessageProducer<T> newInstance(io.vertx.core.eventbus.MessageProducer arg) {
    return arg != null ? new MessageProducer<T>(arg) : null;
  }

  public static <T>MessageProducer<T> newInstance(io.vertx.core.eventbus.MessageProducer arg, io.vertx.lang.rx.TypeArg<T> __typeArg_T) {
    return arg != null ? new MessageProducer<T>(arg, __typeArg_T) : null;
  }
}
