/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.cassandra;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import java.util.List;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.ColumnDefinitions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * It is like {@link com.datastax.driver.core.ResultSet}, but adapted for Vert.x.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.cassandra.ResultSet original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.cassandra.ResultSet.class)
public class ResultSet {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ResultSet that = (ResultSet) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<ResultSet> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new ResultSet((io.vertx.cassandra.ResultSet) obj),
    ResultSet::getDelegate
  );

  private final io.vertx.cassandra.ResultSet delegate;
  
  public ResultSet(io.vertx.cassandra.ResultSet delegate) {
    this.delegate = delegate;
  }

  public io.vertx.cassandra.ResultSet getDelegate() {
    return delegate;
  }

  /**
   * @return 
   */
  public boolean isExhausted() { 
    boolean ret = delegate.isExhausted();
    return ret;
  }

  /**
   * @return 
   */
  public boolean isFullyFetched() { 
    boolean ret = delegate.isFullyFetched();
    return ret;
  }

  /**
   * @return 
   */
  public int getAvailableWithoutFetching() { 
    int ret = delegate.getAvailableWithoutFetching();
    return ret;
  }

  /**
   * @param handler handler called when result is fetched
   * @return 
   */
  public io.vertx.reactivex.cassandra.ResultSet fetchMoreResults(Handler<AsyncResult<Void>> handler) { 
    delegate.fetchMoreResults(handler);
    return this;
  }

  /**
   * @return 
   */
  public io.vertx.reactivex.cassandra.ResultSet fetchMoreResults() {
    return 
fetchMoreResults(ar -> { });
  }

  /**
   * @return 
   */
  public Completable rxFetchMoreResults() { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      fetchMoreResults(handler);
    });
  }

  /**
   * @return 
   */
  public boolean wasApplied() { 
    boolean ret = delegate.wasApplied();
    return ret;
  }

  /**
   * The method should <strong>not</strong> be used concurrently with others like {@link io.vertx.reactivex.cassandra.ResultSet#several} or {@link io.vertx.reactivex.cassandra.ResultSet#all}.
   * This may lead to unexpected result.
   * @param handler handler called when one row is fetched
   * @return 
   */
  public io.vertx.reactivex.cassandra.ResultSet one(Handler<AsyncResult<Row>> handler) { 
    delegate.one(handler);
    return this;
  }

  /**
   * The method should <strong>not</strong> be used concurrently with others like {@link io.vertx.reactivex.cassandra.ResultSet#several} or {@link io.vertx.reactivex.cassandra.ResultSet#all}.
   * This may lead to unexpected result.
   * @return 
   */
  public io.vertx.reactivex.cassandra.ResultSet one() {
    return 
one(ar -> { });
  }

  /**
   * The method should <strong>not</strong> be used concurrently with others like {@link io.vertx.reactivex.cassandra.ResultSet#several} or {@link io.vertx.reactivex.cassandra.ResultSet#all}.
   * This may lead to unexpected result.
   * @return 
   */
  public Maybe<Row> rxOne() { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      one(handler);
    });
  }

  /**
   * Fetch a specific amount of rows and notify via a handler.
   * <p>
   * If remaining amount of rows in a result set is less than desired amount of rows to fetch,
   * the <code>handler</code> will be called with a successful result encompassing just the remaining rows.
   *
   * <p>
   * The method should <strong>not</strong> be used concurrently with others like {@link io.vertx.reactivex.cassandra.ResultSet#one} or {@link io.vertx.reactivex.cassandra.ResultSet#all}.
   * This may lead to unexpected result.
   * @param amount the amount
   * @param handler the handler
   * @return 
   */
  public io.vertx.reactivex.cassandra.ResultSet several(int amount, Handler<AsyncResult<List<Row>>> handler) { 
    delegate.several(amount, handler);
    return this;
  }

  /**
   * Fetch a specific amount of rows and notify via a handler.
   * <p>
   * If remaining amount of rows in a result set is less than desired amount of rows to fetch,
   * the <code>handler</code> will be called with a successful result encompassing just the remaining rows.
   *
   * <p>
   * The method should <strong>not</strong> be used concurrently with others like {@link io.vertx.reactivex.cassandra.ResultSet#one} or {@link io.vertx.reactivex.cassandra.ResultSet#all}.
   * This may lead to unexpected result.
   * @param amount the amount
   * @return 
   */
  public io.vertx.reactivex.cassandra.ResultSet several(int amount) {
    return 
several(amount, ar -> { });
  }

  /**
   * Fetch a specific amount of rows and notify via a handler.
   * <p>
   * If remaining amount of rows in a result set is less than desired amount of rows to fetch,
   * the <code>handler</code> will be called with a successful result encompassing just the remaining rows.
   *
   * <p>
   * The method should <strong>not</strong> be used concurrently with others like {@link io.vertx.reactivex.cassandra.ResultSet#one} or {@link io.vertx.reactivex.cassandra.ResultSet#all}.
   * This may lead to unexpected result.
   * @param amount the amount
   * @return 
   */
  public Single<List<Row>> rxSeveral(int amount) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      several(amount, handler);
    });
  }

  /**
   * The method should <strong>not</strong> be used concurrently with others like {@link io.vertx.reactivex.cassandra.ResultSet#several} or {@link io.vertx.reactivex.cassandra.ResultSet#one}.
   * This may lead to unexpected result.
   * @param handler handler called when all the rows is fetched
   * @return 
   */
  public io.vertx.reactivex.cassandra.ResultSet all(Handler<AsyncResult<List<Row>>> handler) { 
    delegate.all(handler);
    return this;
  }

  /**
   * The method should <strong>not</strong> be used concurrently with others like {@link io.vertx.reactivex.cassandra.ResultSet#several} or {@link io.vertx.reactivex.cassandra.ResultSet#one}.
   * This may lead to unexpected result.
   * @return 
   */
  public io.vertx.reactivex.cassandra.ResultSet all() {
    return 
all(ar -> { });
  }

  /**
   * The method should <strong>not</strong> be used concurrently with others like {@link io.vertx.reactivex.cassandra.ResultSet#several} or {@link io.vertx.reactivex.cassandra.ResultSet#one}.
   * This may lead to unexpected result.
   * @return 
   */
  public Single<List<Row>> rxAll() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      all(handler);
    });
  }

  /**
   * @return 
   */
  public ColumnDefinitions getColumnDefinitions() { 
    ColumnDefinitions ret = delegate.getColumnDefinitions();
    return ret;
  }


  public static  ResultSet newInstance(io.vertx.cassandra.ResultSet arg) {
    return arg != null ? new ResultSet(arg) : null;
  }
}
